/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CFRuleRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.aggregates.CFRecordsAggregate;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFConditionalFormattingRule;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ConditionalFormatting;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ConditionalFormattingRule;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.HSSFCellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.Region;

public final class HSSFConditionalFormatting
implements ConditionalFormatting {
    private final HSSFWorkbook _workbook;
    private final CFRecordsAggregate cfAggregate;

    HSSFConditionalFormatting(HSSFWorkbook workbook, CFRecordsAggregate cfAggregate) {
        if (workbook == null) {
            throw new IllegalArgumentException("workbook must not be null");
        }
        if (cfAggregate == null) {
            throw new IllegalArgumentException("cfAggregate must not be null");
        }
        this._workbook = workbook;
        this.cfAggregate = cfAggregate;
    }

    CFRecordsAggregate getCFRecordsAggregate() {
        return this.cfAggregate;
    }

    public Region[] getFormattingRegions() {
        HSSFCellRangeAddress[] cellRanges = this.getFormattingRanges();
        return Region.convertCellRangesToRegions(cellRanges);
    }

    @Override
    public HSSFCellRangeAddress[] getFormattingRanges() {
        return this.cfAggregate.getHeader().getCellRanges();
    }

    public void setRule(int idx, HSSFConditionalFormattingRule cfRule) {
        this.cfAggregate.setRule(idx, cfRule.getCfRuleRecord());
    }

    @Override
    public void setRule(int idx, ConditionalFormattingRule cfRule) {
        this.setRule(idx, (HSSFConditionalFormattingRule)cfRule);
    }

    public void addRule(HSSFConditionalFormattingRule cfRule) {
        this.cfAggregate.addRule(cfRule.getCfRuleRecord());
    }

    @Override
    public void addRule(ConditionalFormattingRule cfRule) {
        this.addRule((HSSFConditionalFormattingRule)cfRule);
    }

    @Override
    public HSSFConditionalFormattingRule getRule(int idx) {
        CFRuleRecord ruleRecord = this.cfAggregate.getRule(idx);
        return new HSSFConditionalFormattingRule(this._workbook, ruleRecord);
    }

    @Override
    public int getNumberOfRules() {
        return this.cfAggregate.getNumberOfRules();
    }

    public String toString() {
        return this.cfAggregate.toString();
    }
}

