/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Area3DPtg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.AreaPtgBase;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.ptg.Ptg;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.BOFRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.DimensionsRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EOFRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.FooterRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.HCenterRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.HeaderRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.PrintSetupRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ProtectRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordBase;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.SCLRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.UnknownRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.VCenterRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.AreaFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.AxisLineFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.AxisOptionsRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.AxisParentRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.AxisRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.AxisUsedRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.BarRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.BeginRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.CategorySeriesAxisRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.ChartFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.ChartRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.ChartTitleFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.DataFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.DataLabelExtensionRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.DefaultDataLabelTextPropertiesRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.EndRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.FontBasisRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.FontIndexRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.FrameRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.LegendRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.LineFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.LinkedDataRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.ObjectLinkRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.PlotAreaRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.PlotGrowthRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.SeriesIndexRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.SeriesRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.SeriesTextRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.SeriesToChartGroupRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.SheetPropertiesRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.TextRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.TickRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.UnitsRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart.ValueRangeRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.util.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.CellRangeAddressBase;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HSSFChart
extends HSSFSimpleShape {
    public static final short OBJECT_TYPE_CHART = 5;
    private HSSFSheet sheet;
    private ChartRecord chartRecord;
    private LegendRecord legendRecord;
    private ChartTitleFormatRecord chartTitleFormat;
    private Map<SeriesTextRecord, Record> chartSeriesText = new HashMap<SeriesTextRecord, Record>();
    private AreaFormatRecord seriesBackgroundColorFormat;
    private AreaFormatRecord marginColorFormat;
    private List<ValueRangeRecord> valueRanges = new ArrayList<ValueRangeRecord>();
    private HSSFChartType type = HSSFChartType.Unknown;
    private List<HSSFSeries> series = new ArrayList<HSSFSeries>();

    public HSSFChart(AWorkbook workbook, EscherContainerRecord escherContainer, HSSFShape parent, HSSFAnchor anchor) {
        super(escherContainer, parent, anchor);
        if (escherContainer != null && workbook != null) {
            this.processLineWidth();
            this.processLine(escherContainer, workbook);
            this.processSimpleBackground(escherContainer, workbook);
            this.processRotationAndFlip(escherContainer);
        }
        this.setShapeType(5);
    }

    public List<ValueRangeRecord> getValueRangeRecord() {
        return this.valueRanges;
    }

    public void createBarChart(HSSFWorkbook workbook, HSSFSheet sheet) {
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(this.createMSDrawingObjectRecord());
        records.add(this.createOBJRecord());
        records.add(this.createBOFRecord());
        records.add(new HeaderRecord(""));
        records.add(new FooterRecord(""));
        records.add(this.createHCenterRecord());
        records.add(this.createVCenterRecord());
        records.add(this.createPrintSetupRecord());
        records.add(this.createFontBasisRecord1());
        records.add(this.createFontBasisRecord2());
        records.add(new ProtectRecord(false));
        records.add(this.createUnitsRecord());
        records.add(this.createChartRecord(0, 0, 30434904, 19031616));
        records.add(this.createBeginRecord());
        records.add(this.createSCLRecord((short)1, (short)1));
        records.add(this.createPlotGrowthRecord(65536, 65536));
        records.add(this.createFrameRecord1());
        records.add(this.createBeginRecord());
        records.add(this.createLineFormatRecord(true));
        records.add(this.createAreaFormatRecord1());
        records.add(this.createEndRecord());
        records.add(this.createSeriesRecord());
        records.add(this.createBeginRecord());
        records.add(this.createTitleLinkedDataRecord());
        records.add(this.createValuesLinkedDataRecord());
        records.add(this.createCategoriesLinkedDataRecord());
        records.add(this.createDataFormatRecord());
        records.add(this.createSeriesToChartGroupRecord());
        records.add(this.createEndRecord());
        records.add(this.createSheetPropsRecord());
        records.add(this.createDefaultTextRecord((short)2));
        records.add(this.createAllTextRecord());
        records.add(this.createBeginRecord());
        records.add(this.createFontIndexRecord(5));
        records.add(this.createDirectLinkRecord());
        records.add(this.createEndRecord());
        records.add(this.createDefaultTextRecord((short)3));
        records.add(this.createUnknownTextRecord());
        records.add(this.createBeginRecord());
        records.add(this.createFontIndexRecord(6));
        records.add(this.createDirectLinkRecord());
        records.add(this.createEndRecord());
        records.add(this.createAxisUsedRecord((short)1));
        this.createAxisRecords(records);
        records.add(this.createEndRecord());
        records.add(this.createDimensionsRecord());
        records.add(this.createSeriesIndexRecord(2));
        records.add(this.createSeriesIndexRecord(1));
        records.add(this.createSeriesIndexRecord(3));
        records.add(EOFRecord.instance);
        sheet.insertChartRecords(records);
        workbook.insertChartRecord();
    }

    private static int convetRecordsToSeriesByPostion(List<Record> records, HSSFChart chart, int seriesStart) {
        if (seriesStart >= records.size() || records.get(seriesStart).getSid() != 4099) {
            return -1;
        }
        HSSFChart hSSFChart = chart;
        Objects.requireNonNull(hSSFChart);
        HSSFSeries series = hSSFChart.new HSSFSeries((SeriesRecord)records.get(seriesStart));
        chart.series.add(series);
        int start = seriesStart + 1;
        if (records.get(start) instanceof BeginRecord) {
            int beginReocrdsCount = 1;
            ++start;
            while (start <= records.size() && beginReocrdsCount > 0) {
                Record r = records.get(start);
                if (r instanceof LinkedDataRecord) {
                    LinkedDataRecord linkedDataRecord = (LinkedDataRecord)r;
                    if (chart.series.size() > 0) {
                        series = chart.series.get(chart.series.size() - 1);
                        series.insertData(linkedDataRecord);
                    }
                } else if (r instanceof SeriesTextRecord) {
                    SeriesTextRecord str = (SeriesTextRecord)r;
                    if (chart.series.size() > 0) {
                        series = chart.series.get(chart.series.size() - 1);
                        series.seriesTitleText = str;
                    }
                } else if (r.getSid() == 4106) {
                    AreaFormatRecord areaFormatRecord = (AreaFormatRecord)r;
                    series = chart.series.get(chart.series.size() - 1);
                    series.setAreaFormat(areaFormatRecord);
                } else if (r instanceof BeginRecord) {
                    ++beginReocrdsCount;
                } else if (r instanceof EndRecord) {
                    --beginReocrdsCount;
                }
                ++start;
            }
        }
        return start - 1;
    }

    private static int convetRecordsToText(List<Record> records, HSSFChart chart, int seriesStart) {
        if (seriesStart >= records.size() || records.get(seriesStart).getSid() != 4133) {
            return -1;
        }
        TextRecord txtRecord = (TextRecord)records.get(seriesStart);
        SeriesTextRecord str = null;
        ObjectLinkRecord objLinkRecord = null;
        int start = seriesStart + 1;
        if (records.get(start) instanceof BeginRecord) {
            int beginReocrdsCount = 1;
            ++start;
            while (start <= records.size() && beginReocrdsCount > 0) {
                Record r = records.get(start);
                if (r instanceof SeriesTextRecord) {
                    str = (SeriesTextRecord)records.get(start);
                } else if (r instanceof ObjectLinkRecord) {
                    objLinkRecord = (ObjectLinkRecord)r;
                } else if (r instanceof BeginRecord) {
                    ++beginReocrdsCount;
                } else if (r instanceof EndRecord) {
                    --beginReocrdsCount;
                }
                ++start;
            }
        }
        if (txtRecord.getWidth() > 0 && txtRecord.getHeight() > 0 && objLinkRecord != null && chart.series.size() > 0) {
            if (str != null) {
                chart.chartSeriesText.put(str, objLinkRecord);
            } else if (chart.series.size() > chart.chartSeriesText.size()) {
                chart.chartSeriesText.put(chart.series.get(chart.chartSeriesText.size()).getSeriesTextRecord(), objLinkRecord);
            }
        }
        return start - 1;
    }

    public static void convertRecordsToChart(List<Record> records, HSSFChart chart) {
        if (chart == null || records == null) {
            return;
        }
        int size = records.size();
        block0: for (int index = 0; index < size; ++index) {
            Record r = records.get(index);
            if (r instanceof ChartRecord) {
                chart.setChartRecord((ChartRecord)r);
                continue;
            }
            if (r instanceof LegendRecord) {
                chart.legendRecord = (LegendRecord)r;
                continue;
            }
            if (r.getSid() == 4106) {
                if (chart.getSeries().length == 0) {
                    chart.marginColorFormat = (AreaFormatRecord)r;
                    continue;
                }
                chart.seriesBackgroundColorFormat = (AreaFormatRecord)r;
                continue;
            }
            if (r instanceof SeriesRecord) {
                index = HSSFChart.convetRecordsToSeriesByPostion(records, chart, index);
                continue;
            }
            if (r instanceof TextRecord) {
                index = HSSFChart.convetRecordsToText(records, chart, index);
                continue;
            }
            if (r instanceof DataLabelExtensionRecord) {
                chart.series.get(chart.series.size() - 1).setDataLabelExtensionRecord((DataLabelExtensionRecord)r);
                continue;
            }
            if (r instanceof ChartTitleFormatRecord) {
                chart.chartTitleFormat = (ChartTitleFormatRecord)r;
                continue;
            }
            if (r instanceof ValueRangeRecord) {
                chart.valueRanges.add((ValueRangeRecord)r);
                continue;
            }
            if (r.getSid() == 4161 || !(r instanceof Record) || chart == null) continue;
            Record record = r;
            for (HSSFChartType type : HSSFChartType.values()) {
                if (type == HSSFChartType.Unknown || record.getSid() != type.getSid()) continue;
                chart.type = type;
                continue block0;
            }
        }
    }

    public static HSSFChart[] getSheetCharts(HSSFSheet sheet) {
        ArrayList<HSSFChart> charts = new ArrayList<HSSFChart>();
        HSSFChart lastChart = null;
        HSSFSeries lastSeries = null;
        List<RecordBase> records = sheet.getSheet().getRecords();
        block0: for (RecordBase r : records) {
            if (r instanceof ChartRecord) {
                lastSeries = null;
                lastChart = new HSSFChart(null, null, null, null);
                lastChart.setChartRecord((ChartRecord)r);
                charts.add(lastChart);
                continue;
            }
            if (r instanceof LegendRecord) {
                lastChart.legendRecord = (LegendRecord)r;
                continue;
            }
            if (r instanceof SeriesRecord) {
                HSSFChart hSSFChart = lastChart;
                Objects.requireNonNull(hSSFChart);
                HSSFSeries series = hSSFChart.new HSSFSeries((SeriesRecord)r);
                lastChart.series.add(series);
                lastSeries = series;
                continue;
            }
            if (r instanceof ChartTitleFormatRecord) {
                lastChart.chartTitleFormat = (ChartTitleFormatRecord)r;
                continue;
            }
            if (r instanceof SeriesTextRecord) {
                SeriesTextRecord str = (SeriesTextRecord)r;
                if (lastChart.legendRecord != null || lastChart.series.size() <= 0) continue;
                HSSFSeries series = lastChart.series.get(lastChart.series.size() - 1);
                series.seriesTitleText = str;
                continue;
            }
            if (r instanceof LinkedDataRecord) {
                LinkedDataRecord linkedDataRecord = (LinkedDataRecord)r;
                if (lastSeries == null) continue;
                lastSeries.insertData(linkedDataRecord);
                continue;
            }
            if (r instanceof ValueRangeRecord) {
                lastChart.valueRanges.add((ValueRangeRecord)r);
                continue;
            }
            if (!(r instanceof Record) || lastChart == null) continue;
            Record record = (Record)r;
            for (HSSFChartType type : HSSFChartType.values()) {
                if (type == HSSFChartType.Unknown || record.getSid() != type.getSid()) continue;
                lastChart.type = type;
                continue block0;
            }
        }
        return charts.toArray(new HSSFChart[charts.size()]);
    }

    public int getChartX() {
        return this.chartRecord.getX();
    }

    public int getChartY() {
        return this.chartRecord.getY();
    }

    public int getChartWidth() {
        return this.chartRecord.getWidth();
    }

    public int getChartHeight() {
        return this.chartRecord.getHeight();
    }

    public void setChartX(int x) {
        this.chartRecord.setX(x);
    }

    public void setChartY(int y) {
        this.chartRecord.setY(y);
    }

    public void setChartWidth(int width) {
        this.chartRecord.setWidth(width);
    }

    public void setChartHeight(int height) {
        this.chartRecord.setHeight(height);
    }

    public void setChartRecord(ChartRecord chartRecord) {
        this.chartRecord = chartRecord;
    }

    public ChartRecord getChartRecord() {
        return this.chartRecord;
    }

    public LegendRecord getLegendRecord() {
        return this.legendRecord;
    }

    public ChartTitleFormatRecord getChartTitleFormat() {
        return this.chartTitleFormat;
    }

    public HSSFSeries[] getSeries() {
        return this.series.toArray(new HSSFSeries[this.series.size()]);
    }

    public void setValueRange(int axisIndex, Double minimum, Double maximum, Double majorUnit, Double minorUnit) {
        ValueRangeRecord valueRange = this.valueRanges.get(axisIndex);
        if (valueRange == null) {
            return;
        }
        if (minimum != null) {
            valueRange.setAutomaticMinimum(minimum.isNaN());
            valueRange.setMinimumAxisValue(minimum);
        }
        if (maximum != null) {
            valueRange.setAutomaticMaximum(maximum.isNaN());
            valueRange.setMaximumAxisValue(maximum);
        }
        if (majorUnit != null) {
            valueRange.setAutomaticMajor(majorUnit.isNaN());
            valueRange.setMajorIncrement(majorUnit);
        }
        if (minorUnit != null) {
            valueRange.setAutomaticMinor(minorUnit.isNaN());
            valueRange.setMinorIncrement(minorUnit);
        }
    }

    public Map<SeriesTextRecord, Record> getSeriesText() {
        return this.chartSeriesText;
    }

    public AreaFormatRecord getMarginColorFormat() {
        return this.marginColorFormat;
    }

    public AreaFormatRecord getSeriesBackgroundColorFormat() {
        return this.seriesBackgroundColorFormat;
    }

    private SeriesIndexRecord createSeriesIndexRecord(int index) {
        SeriesIndexRecord r = new SeriesIndexRecord();
        r.setIndex((short)index);
        return r;
    }

    private DimensionsRecord createDimensionsRecord() {
        DimensionsRecord r = new DimensionsRecord();
        r.setFirstRow(0);
        r.setLastRow(31);
        r.setFirstCol((short)0);
        r.setLastCol((short)1);
        return r;
    }

    private HCenterRecord createHCenterRecord() {
        HCenterRecord r = new HCenterRecord();
        r.setHCenter(false);
        return r;
    }

    private VCenterRecord createVCenterRecord() {
        VCenterRecord r = new VCenterRecord();
        r.setVCenter(false);
        return r;
    }

    private PrintSetupRecord createPrintSetupRecord() {
        PrintSetupRecord r = new PrintSetupRecord();
        r.setPaperSize((short)0);
        r.setScale((short)18);
        r.setPageStart((short)1);
        r.setFitWidth((short)1);
        r.setFitHeight((short)1);
        r.setLeftToRight(false);
        r.setLandscape(false);
        r.setValidSettings(true);
        r.setNoColor(false);
        r.setDraft(false);
        r.setNotes(false);
        r.setNoOrientation(false);
        r.setUsePage(false);
        r.setHResolution((short)0);
        r.setVResolution((short)0);
        r.setHeaderMargin(0.5);
        r.setFooterMargin(0.5);
        r.setCopies((short)15);
        return r;
    }

    private FontBasisRecord createFontBasisRecord1() {
        FontBasisRecord r = new FontBasisRecord();
        r.setXBasis((short)9120);
        r.setYBasis((short)5640);
        r.setHeightBasis((short)200);
        r.setScale((short)0);
        r.setIndexToFontTable((short)5);
        return r;
    }

    private FontBasisRecord createFontBasisRecord2() {
        FontBasisRecord r = this.createFontBasisRecord1();
        r.setIndexToFontTable((short)6);
        return r;
    }

    private BOFRecord createBOFRecord() {
        BOFRecord r = new BOFRecord();
        r.setVersion(600);
        r.setType(20);
        r.setBuild(7422);
        r.setBuildYear(1997);
        r.setHistoryBitMask(16585);
        r.setRequiredVersion(106);
        return r;
    }

    private UnknownRecord createOBJRecord() {
        byte[] data = new byte[]{21, 0, 18, 0, 5, 0, 2, 0, 17, 96, 0, 0, 0, 0, -72, 3, -121, 3, 0, 0, 0, 0, 0, 0, 0, 0};
        return new UnknownRecord(93, data);
    }

    private UnknownRecord createMSDrawingObjectRecord() {
        byte[] data = new byte[]{15, 0, 2, -16, -64, 0, 0, 0, 16, 0, 8, -16, 8, 0, 0, 0, 2, 0, 0, 0, 2, 4, 0, 0, 15, 0, 3, -16, -88, 0, 0, 0, 15, 0, 4, -16, 40, 0, 0, 0, 1, 0, 9, -16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 10, -16, 8, 0, 0, 0, 0, 4, 0, 0, 5, 0, 0, 0, 15, 0, 4, -16, 112, 0, 0, 0, -110, 12, 10, -16, 8, 0, 0, 0, 2, 4, 0, 0, 0, 10, 0, 0, -109, 0, 11, -16, 54, 0, 0, 0, 127, 0, 4, 1, 4, 1, -65, 0, 8, 0, 8, 0, -127, 1, 78, 0, 0, 8, -125, 1, 77, 0, 0, 8, -65, 1, 16, 0, 17, 0, -64, 1, 77, 0, 0, 8, -1, 1, 8, 0, 8, 0, 63, 2, 0, 0, 2, 0, -65, 3, 0, 0, 8, 0, 0, 0, 16, -16, 18, 0, 0, 0, 0, 0, 4, 0, -64, 2, 10, 0, -12, 0, 14, 0, 102, 1, 32, 0, -23, 0, 0, 0, 17, -16, 0, 0, 0, 0};
        return new UnknownRecord(236, data);
    }

    private void createAxisRecords(List<Record> records) {
        records.add(this.createAxisParentRecord());
        records.add(this.createBeginRecord());
        records.add(this.createAxisRecord((short)0));
        records.add(this.createBeginRecord());
        records.add(this.createCategorySeriesAxisRecord());
        records.add(this.createAxisOptionsRecord());
        records.add(this.createTickRecord1());
        records.add(this.createEndRecord());
        records.add(this.createAxisRecord((short)1));
        records.add(this.createBeginRecord());
        records.add(this.createValueRangeRecord());
        records.add(this.createTickRecord2());
        records.add(this.createAxisLineFormatRecord((short)1));
        records.add(this.createLineFormatRecord(false));
        records.add(this.createEndRecord());
        records.add(this.createPlotAreaRecord());
        records.add(this.createFrameRecord2());
        records.add(this.createBeginRecord());
        records.add(this.createLineFormatRecord2());
        records.add(this.createAreaFormatRecord2());
        records.add(this.createEndRecord());
        records.add(this.createChartFormatRecord());
        records.add(this.createBeginRecord());
        records.add(this.createBarRecord());
        records.add(this.createLegendRecord());
        records.add(this.createBeginRecord());
        records.add(this.createTextRecord());
        records.add(this.createBeginRecord());
        records.add(this.createLinkedDataRecord());
        records.add(this.createEndRecord());
        records.add(this.createEndRecord());
        records.add(this.createEndRecord());
        records.add(this.createEndRecord());
    }

    private LinkedDataRecord createLinkedDataRecord() {
        LinkedDataRecord r = new LinkedDataRecord();
        r.setLinkType((byte)0);
        r.setReferenceType((byte)1);
        r.setCustomNumberFormat(false);
        r.setIndexNumberFmtRecord((short)0);
        r.setFormulaOfLink(null);
        return r;
    }

    private TextRecord createTextRecord() {
        TextRecord r = new TextRecord();
        r.setHorizontalAlignment((byte)2);
        r.setVerticalAlignment((byte)2);
        r.setDisplayMode((short)1);
        r.setRgbColor(0);
        r.setX(-37);
        r.setY(-60);
        r.setWidth(0);
        r.setHeight(0);
        r.setAutoColor(true);
        r.setShowKey(false);
        r.setShowValue(false);
        r.setVertical(false);
        r.setAutoGeneratedText(true);
        r.setGenerated(true);
        r.setAutoLabelDeleted(false);
        r.setAutoBackground(true);
        r.setRotation((short)0);
        r.setShowCategoryLabelAsPercentage(false);
        r.setShowValueAsPercentage(false);
        r.setShowBubbleSizes(false);
        r.setShowLabel(false);
        r.setIndexOfColorValue((short)77);
        r.setDataLabelPlacement((short)0);
        r.setTextRotation((short)0);
        return r;
    }

    private LegendRecord createLegendRecord() {
        LegendRecord r = new LegendRecord();
        r.setXAxisUpperLeft(3542);
        r.setYAxisUpperLeft(1566);
        r.setXSize(437);
        r.setYSize(213);
        r.setType((byte)3);
        r.setSpacing((byte)1);
        r.setAutoPosition(true);
        r.setAutoSeries(true);
        r.setAutoXPositioning(true);
        r.setAutoYPositioning(true);
        r.setVertical(true);
        r.setDataTable(false);
        return r;
    }

    private BarRecord createBarRecord() {
        BarRecord r = new BarRecord();
        r.setBarSpace((short)0);
        r.setCategorySpace((short)150);
        r.setHorizontal(false);
        r.setStacked(false);
        r.setDisplayAsPercentage(false);
        r.setShadow(false);
        return r;
    }

    private ChartFormatRecord createChartFormatRecord() {
        ChartFormatRecord r = new ChartFormatRecord();
        r.setXPosition(0);
        r.setYPosition(0);
        r.setWidth(0);
        r.setHeight(0);
        r.setVaryDisplayPattern(false);
        return r;
    }

    private PlotAreaRecord createPlotAreaRecord() {
        PlotAreaRecord r = new PlotAreaRecord();
        return r;
    }

    private AxisLineFormatRecord createAxisLineFormatRecord(short format) {
        AxisLineFormatRecord r = new AxisLineFormatRecord();
        r.setAxisType(format);
        return r;
    }

    private ValueRangeRecord createValueRangeRecord() {
        ValueRangeRecord r = new ValueRangeRecord();
        r.setMinimumAxisValue(0.0);
        r.setMaximumAxisValue(0.0);
        r.setMajorIncrement(0.0);
        r.setMinorIncrement(0.0);
        r.setCategoryAxisCross(0.0);
        r.setAutomaticMinimum(true);
        r.setAutomaticMaximum(true);
        r.setAutomaticMajor(true);
        r.setAutomaticMinor(true);
        r.setAutomaticCategoryCrossing(true);
        r.setLogarithmicScale(false);
        r.setValuesInReverse(false);
        r.setCrossCategoryAxisAtMaximum(false);
        r.setReserved(true);
        return r;
    }

    private TickRecord createTickRecord1() {
        TickRecord r = new TickRecord();
        r.setMajorTickType((byte)2);
        r.setMinorTickType((byte)0);
        r.setLabelPosition((byte)3);
        r.setBackground((byte)1);
        r.setLabelColorRgb(0);
        r.setZero1(0);
        r.setZero2(0);
        r.setZero3((short)45);
        r.setAutorotate(true);
        r.setAutoTextBackground(true);
        r.setRotation((short)0);
        r.setAutorotate(true);
        r.setTickColor((short)77);
        return r;
    }

    private TickRecord createTickRecord2() {
        TickRecord r = this.createTickRecord1();
        r.setZero3((short)0);
        return r;
    }

    private AxisOptionsRecord createAxisOptionsRecord() {
        AxisOptionsRecord r = new AxisOptionsRecord();
        r.setMinimumCategory((short)-28644);
        r.setMaximumCategory((short)-28715);
        r.setMajorUnitValue((short)2);
        r.setMajorUnit((short)0);
        r.setMinorUnitValue((short)1);
        r.setMinorUnit((short)0);
        r.setBaseUnit((short)0);
        r.setCrossingPoint((short)-28644);
        r.setDefaultMinimum(true);
        r.setDefaultMaximum(true);
        r.setDefaultMajor(true);
        r.setDefaultMinorUnit(true);
        r.setIsDate(true);
        r.setDefaultBase(true);
        r.setDefaultCross(true);
        r.setDefaultDateSettings(true);
        return r;
    }

    private CategorySeriesAxisRecord createCategorySeriesAxisRecord() {
        CategorySeriesAxisRecord r = new CategorySeriesAxisRecord();
        r.setCrossingPoint((short)1);
        r.setLabelFrequency((short)1);
        r.setTickMarkFrequency((short)1);
        r.setValueAxisCrossing(true);
        r.setCrossesFarRight(false);
        r.setReversed(false);
        return r;
    }

    private AxisRecord createAxisRecord(short axisType) {
        AxisRecord r = new AxisRecord();
        r.setAxisType(axisType);
        return r;
    }

    private AxisParentRecord createAxisParentRecord() {
        AxisParentRecord r = new AxisParentRecord();
        r.setAxisType((short)0);
        r.setX(479);
        r.setY(221);
        r.setWidth(2995);
        r.setHeight(2902);
        return r;
    }

    private AxisUsedRecord createAxisUsedRecord(short numAxis) {
        AxisUsedRecord r = new AxisUsedRecord();
        r.setNumAxis(numAxis);
        return r;
    }

    private LinkedDataRecord createDirectLinkRecord() {
        LinkedDataRecord r = new LinkedDataRecord();
        r.setLinkType((byte)0);
        r.setReferenceType((byte)1);
        r.setCustomNumberFormat(false);
        r.setIndexNumberFmtRecord((short)0);
        r.setFormulaOfLink(null);
        return r;
    }

    private FontIndexRecord createFontIndexRecord(int index) {
        FontIndexRecord r = new FontIndexRecord();
        r.setFontIndex((short)index);
        return r;
    }

    private TextRecord createAllTextRecord() {
        TextRecord r = new TextRecord();
        r.setHorizontalAlignment((byte)2);
        r.setVerticalAlignment((byte)2);
        r.setDisplayMode((short)1);
        r.setRgbColor(0);
        r.setX(-37);
        r.setY(-60);
        r.setWidth(0);
        r.setHeight(0);
        r.setAutoColor(true);
        r.setShowKey(false);
        r.setShowValue(true);
        r.setVertical(false);
        r.setAutoGeneratedText(true);
        r.setGenerated(true);
        r.setAutoLabelDeleted(false);
        r.setAutoBackground(true);
        r.setRotation((short)0);
        r.setShowCategoryLabelAsPercentage(false);
        r.setShowValueAsPercentage(false);
        r.setShowBubbleSizes(false);
        r.setShowLabel(false);
        r.setIndexOfColorValue((short)77);
        r.setDataLabelPlacement((short)0);
        r.setTextRotation((short)0);
        return r;
    }

    private TextRecord createUnknownTextRecord() {
        TextRecord r = new TextRecord();
        r.setHorizontalAlignment((byte)2);
        r.setVerticalAlignment((byte)2);
        r.setDisplayMode((short)1);
        r.setRgbColor(0);
        r.setX(-37);
        r.setY(-60);
        r.setWidth(0);
        r.setHeight(0);
        r.setAutoColor(true);
        r.setShowKey(false);
        r.setShowValue(false);
        r.setVertical(false);
        r.setAutoGeneratedText(true);
        r.setGenerated(true);
        r.setAutoLabelDeleted(false);
        r.setAutoBackground(true);
        r.setRotation((short)0);
        r.setShowCategoryLabelAsPercentage(false);
        r.setShowValueAsPercentage(false);
        r.setShowBubbleSizes(false);
        r.setShowLabel(false);
        r.setIndexOfColorValue((short)77);
        r.setDataLabelPlacement((short)11088);
        r.setTextRotation((short)0);
        return r;
    }

    private DefaultDataLabelTextPropertiesRecord createDefaultTextRecord(short categoryDataType) {
        DefaultDataLabelTextPropertiesRecord r = new DefaultDataLabelTextPropertiesRecord();
        r.setCategoryDataType(categoryDataType);
        return r;
    }

    private SheetPropertiesRecord createSheetPropsRecord() {
        SheetPropertiesRecord r = new SheetPropertiesRecord();
        r.setChartTypeManuallyFormatted(false);
        r.setPlotVisibleOnly(true);
        r.setDoNotSizeWithWindow(false);
        r.setDefaultPlotDimensions(true);
        r.setAutoPlotArea(false);
        return r;
    }

    private SeriesToChartGroupRecord createSeriesToChartGroupRecord() {
        return new SeriesToChartGroupRecord();
    }

    private DataFormatRecord createDataFormatRecord() {
        DataFormatRecord r = new DataFormatRecord();
        r.setPointNumber((short)-1);
        r.setSeriesIndex((short)0);
        r.setSeriesNumber((short)0);
        r.setUseExcel4Colors(false);
        return r;
    }

    private LinkedDataRecord createCategoriesLinkedDataRecord() {
        LinkedDataRecord r = new LinkedDataRecord();
        r.setLinkType((byte)2);
        r.setReferenceType((byte)2);
        r.setCustomNumberFormat(false);
        r.setIndexNumberFmtRecord((short)0);
        Area3DPtg p = new Area3DPtg(0, 31, 1, 1, false, false, false, false, 0);
        r.setFormulaOfLink(new Ptg[]{p});
        return r;
    }

    private LinkedDataRecord createValuesLinkedDataRecord() {
        LinkedDataRecord r = new LinkedDataRecord();
        r.setLinkType((byte)1);
        r.setReferenceType((byte)2);
        r.setCustomNumberFormat(false);
        r.setIndexNumberFmtRecord((short)0);
        Area3DPtg p = new Area3DPtg(0, 31, 0, 0, false, false, false, false, 0);
        r.setFormulaOfLink(new Ptg[]{p});
        return r;
    }

    private LinkedDataRecord createTitleLinkedDataRecord() {
        LinkedDataRecord r = new LinkedDataRecord();
        r.setLinkType((byte)0);
        r.setReferenceType((byte)1);
        r.setCustomNumberFormat(false);
        r.setIndexNumberFmtRecord((short)0);
        r.setFormulaOfLink(null);
        return r;
    }

    private SeriesRecord createSeriesRecord() {
        SeriesRecord r = new SeriesRecord();
        r.setCategoryDataType((short)1);
        r.setValuesDataType((short)1);
        r.setNumCategories((short)32);
        r.setNumValues((short)31);
        r.setBubbleSeriesType((short)1);
        r.setNumBubbleValues((short)0);
        return r;
    }

    private EndRecord createEndRecord() {
        return new EndRecord();
    }

    private AreaFormatRecord createAreaFormatRecord1() {
        AreaFormatRecord r = new AreaFormatRecord();
        r.setForegroundColor(0xFFFFFF);
        r.setBackgroundColor(0);
        r.setPattern((short)1);
        r.setAutomatic(true);
        r.setInvert(false);
        r.setForecolorIndex((short)78);
        r.setBackcolorIndex((short)77);
        return r;
    }

    private AreaFormatRecord createAreaFormatRecord2() {
        AreaFormatRecord r = new AreaFormatRecord();
        r.setForegroundColor(0xC0C0C0);
        r.setBackgroundColor(0);
        r.setPattern((short)1);
        r.setAutomatic(false);
        r.setInvert(false);
        r.setForecolorIndex((short)22);
        r.setBackcolorIndex((short)79);
        return r;
    }

    private LineFormatRecord createLineFormatRecord(boolean drawTicks) {
        LineFormatRecord r = new LineFormatRecord();
        r.setLineColor(0);
        r.setLinePattern((short)0);
        r.setWeight((short)-1);
        r.setAuto(true);
        r.setDrawTicks(drawTicks);
        r.setColourPaletteIndex((short)77);
        return r;
    }

    private LineFormatRecord createLineFormatRecord2() {
        LineFormatRecord r = new LineFormatRecord();
        r.setLineColor(0x808080);
        r.setLinePattern((short)0);
        r.setWeight((short)0);
        r.setAuto(false);
        r.setDrawTicks(false);
        r.setUnknown(false);
        r.setColourPaletteIndex((short)23);
        return r;
    }

    private FrameRecord createFrameRecord1() {
        FrameRecord r = new FrameRecord();
        r.setBorderType((short)0);
        r.setAutoSize(false);
        r.setAutoPosition(true);
        return r;
    }

    private FrameRecord createFrameRecord2() {
        FrameRecord r = new FrameRecord();
        r.setBorderType((short)0);
        r.setAutoSize(true);
        r.setAutoPosition(true);
        return r;
    }

    private PlotGrowthRecord createPlotGrowthRecord(int horizScale, int vertScale) {
        PlotGrowthRecord r = new PlotGrowthRecord();
        r.setHorizontalScale(horizScale);
        r.setVerticalScale(vertScale);
        return r;
    }

    private SCLRecord createSCLRecord(short numerator, short denominator) {
        SCLRecord r = new SCLRecord();
        r.setDenominator(denominator);
        r.setNumerator(numerator);
        return r;
    }

    private BeginRecord createBeginRecord() {
        return new BeginRecord();
    }

    private ChartRecord createChartRecord(int x, int y, int width, int height) {
        ChartRecord r = new ChartRecord();
        r.setX(x);
        r.setY(y);
        r.setWidth(width);
        r.setHeight(height);
        return r;
    }

    private UnitsRecord createUnitsRecord() {
        UnitsRecord r = new UnitsRecord();
        r.setUnits((short)0);
        return r;
    }

    public HSSFSeries createSeries() throws Exception {
        ArrayList<RecordBase> seriesTemplate = new ArrayList<RecordBase>();
        boolean seriesTemplateFilled = false;
        int idx = 0;
        int deep = 0;
        int chartRecordIdx = -1;
        int chartDeep = -1;
        int lastSeriesDeep = -1;
        int endSeriesRecordIdx = -1;
        int seriesIdx = 0;
        List<RecordBase> records = this.sheet.getSheet().getRecords();
        for (RecordBase record : records) {
            ++idx;
            if (record instanceof BeginRecord) {
                ++deep;
            } else if (record instanceof EndRecord) {
                if (lastSeriesDeep == --deep) {
                    lastSeriesDeep = -1;
                    endSeriesRecordIdx = idx;
                    if (!seriesTemplateFilled) {
                        seriesTemplate.add(record);
                        seriesTemplateFilled = true;
                    }
                }
                if (chartDeep == deep) break;
            }
            if (record instanceof ChartRecord) {
                if (record == this.chartRecord) {
                    chartRecordIdx = idx;
                    chartDeep = deep;
                }
            } else if (record instanceof SeriesRecord && chartRecordIdx != -1) {
                ++seriesIdx;
                lastSeriesDeep = deep;
            }
            if (lastSeriesDeep == -1 || seriesTemplateFilled) continue;
            seriesTemplate.add(record);
        }
        if (endSeriesRecordIdx == -1) {
            return null;
        }
        idx = endSeriesRecordIdx + 1;
        HSSFSeries newSeries = null;
        ArrayList<BeginRecord> clonedRecords = new ArrayList<BeginRecord>();
        for (RecordBase recordBase : seriesTemplate) {
            Record newRecord = null;
            if (recordBase instanceof BeginRecord) {
                newRecord = new BeginRecord();
            } else if (recordBase instanceof EndRecord) {
                newRecord = new EndRecord();
            } else if (recordBase instanceof SeriesRecord) {
                SeriesRecord seriesRecord = (SeriesRecord)((SeriesRecord)recordBase).clone();
                newSeries = new HSSFSeries(seriesRecord);
                newRecord = seriesRecord;
            } else if (recordBase instanceof LinkedDataRecord) {
                LinkedDataRecord linkedDataRecord = (LinkedDataRecord)((LinkedDataRecord)recordBase).clone();
                if (newSeries != null) {
                    newSeries.insertData(linkedDataRecord);
                }
                newRecord = linkedDataRecord;
            } else if (recordBase instanceof DataFormatRecord) {
                DataFormatRecord dataFormatRecord = (DataFormatRecord)((DataFormatRecord)recordBase).clone();
                dataFormatRecord.setSeriesIndex((short)seriesIdx);
                dataFormatRecord.setSeriesNumber((short)seriesIdx);
                newRecord = dataFormatRecord;
            } else if (recordBase instanceof SeriesTextRecord) {
                SeriesTextRecord seriesTextRecord = (SeriesTextRecord)((SeriesTextRecord)recordBase).clone();
                if (newSeries != null) {
                    newSeries.setSeriesTitleText(seriesTextRecord);
                }
                newRecord = seriesTextRecord;
            } else if (recordBase instanceof Record) {
                newRecord = (Record)((Record)recordBase).clone();
            }
            if (newRecord == null) continue;
            clonedRecords.add((BeginRecord)newRecord);
        }
        if (newSeries == null) {
            return null;
        }
        for (RecordBase recordBase : clonedRecords) {
            records.add(idx++, recordBase);
        }
        return newSeries;
    }

    public void removeSeries(HSSFSeries series) {
        this.series.remove(series);
    }

    public HSSFChartType getType() {
        return this.type;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum HSSFChartType {
        Area{

            @Override
            public short getSid() {
                return 4122;
            }
        }
        ,
        Bar{

            @Override
            public short getSid() {
                return 4119;
            }
        }
        ,
        Line{

            @Override
            public short getSid() {
                return 4120;
            }
        }
        ,
        Pie{

            @Override
            public short getSid() {
                return 4121;
            }
        }
        ,
        Scatter{

            @Override
            public short getSid() {
                return 4123;
            }
        }
        ,
        Unknown{

            @Override
            public short getSid() {
                return 0;
            }
        };


        public abstract short getSid();
    }

    public class HSSFSeries {
        private SeriesRecord series;
        private SeriesTextRecord seriesTitleText;
        private LinkedDataRecord dataName;
        private LinkedDataRecord dataValues;
        private LinkedDataRecord dataCategoryLabels;
        private LinkedDataRecord dataSecondaryCategoryLabels;
        private AreaFormatRecord areaFormatRecord;
        private TextRecord textRecord;
        private DataLabelExtensionRecord dleRec;

        HSSFSeries(SeriesRecord series) {
            this.series = series;
        }

        void insertData(LinkedDataRecord data) {
            switch (data.getLinkType()) {
                case 0: {
                    this.dataName = data;
                    break;
                }
                case 1: {
                    this.dataValues = data;
                    break;
                }
                case 2: {
                    this.dataCategoryLabels = data;
                    break;
                }
                case 3: {
                    this.dataSecondaryCategoryLabels = data;
                }
            }
        }

        public TextRecord getTextRecord() {
            return this.textRecord;
        }

        public void setTextRecord(TextRecord textRecord) {
            this.textRecord = textRecord;
        }

        public DataLabelExtensionRecord getDataLabelExtensionRecord() {
            return this.dleRec;
        }

        public void setDataLabelExtensionRecord(DataLabelExtensionRecord dleRec) {
            this.dleRec = dleRec;
        }

        void setSeriesTitleText(SeriesTextRecord seriesTitleText) {
            this.seriesTitleText = seriesTitleText;
        }

        public short getNumValues() {
            return this.series.getNumValues();
        }

        public short getValueType() {
            return this.series.getValuesDataType();
        }

        public String getSeriesTitle() {
            if (this.seriesTitleText != null) {
                return this.seriesTitleText.getText();
            }
            return null;
        }

        public SeriesTextRecord getSeriesTextRecord() {
            return this.seriesTitleText;
        }

        public void setSeriesTitle(String title) {
            if (this.seriesTitleText == null) {
                throw new IllegalStateException("No series title found to change");
            }
            this.seriesTitleText.setText(title);
        }

        public LinkedDataRecord getDataName() {
            return this.dataName;
        }

        public LinkedDataRecord getDataValues() {
            return this.dataValues;
        }

        public LinkedDataRecord getDataCategoryLabels() {
            return this.dataCategoryLabels;
        }

        public LinkedDataRecord getDataSecondaryCategoryLabels() {
            return this.dataSecondaryCategoryLabels;
        }

        public void setAreaFormat(AreaFormatRecord areaFormatRecord) {
            this.areaFormatRecord = areaFormatRecord;
        }

        public AreaFormatRecord getAreaFormat() {
            return this.areaFormatRecord;
        }

        public SeriesRecord getSeries() {
            return this.series;
        }

        private CellRangeAddressBase getCellRange(LinkedDataRecord linkedDataRecord) {
            if (linkedDataRecord == null) {
                return null;
            }
            int firstRow = 0;
            int lastRow = 0;
            int firstCol = 0;
            int lastCol = 0;
            for (Ptg ptg : linkedDataRecord.getFormulaOfLink()) {
                if (!(ptg instanceof AreaPtgBase)) continue;
                AreaPtgBase areaPtg = (AreaPtgBase)ptg;
                firstRow = areaPtg.getFirstRow();
                lastRow = areaPtg.getLastRow();
                firstCol = areaPtg.getFirstColumn();
                lastCol = areaPtg.getLastColumn();
            }
            return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        }

        public CellRangeAddressBase getValuesCellRange() {
            return this.getCellRange(this.dataValues);
        }

        public CellRangeAddressBase getCategoryLabelsCellRange() {
            return this.getCellRange(this.dataCategoryLabels);
        }

        private Integer setVerticalCellRange(LinkedDataRecord linkedDataRecord, CellRangeAddressBase range) {
            if (linkedDataRecord == null) {
                return null;
            }
            ArrayList<AreaPtgBase> ptgList = new ArrayList<AreaPtgBase>();
            int rowCount = range.getLastRow() - range.getFirstRow() + 1;
            int colCount = range.getLastColumn() - range.getFirstColumn() + 1;
            for (Ptg ptg : linkedDataRecord.getFormulaOfLink()) {
                if (!(ptg instanceof AreaPtgBase)) continue;
                AreaPtgBase areaPtg = (AreaPtgBase)ptg;
                areaPtg.setFirstRow(range.getFirstRow());
                areaPtg.setLastRow(range.getLastRow());
                areaPtg.setFirstColumn(range.getFirstColumn());
                areaPtg.setLastColumn(range.getLastColumn());
                ptgList.add(areaPtg);
            }
            linkedDataRecord.setFormulaOfLink(ptgList.toArray(new Ptg[ptgList.size()]));
            return rowCount * colCount;
        }

        public void setValuesCellRange(CellRangeAddressBase range) {
            Integer count = this.setVerticalCellRange(this.dataValues, range);
            if (count == null) {
                return;
            }
            this.series.setNumValues((short)count.intValue());
        }

        public void setCategoryLabelsCellRange(CellRangeAddressBase range) {
            Integer count = this.setVerticalCellRange(this.dataCategoryLabels, range);
            if (count == null) {
                return;
            }
            this.series.setNumCategories((short)count.intValue());
        }
    }
}

