/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.crypto;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.BiffHeaderInput;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.crypto.Biff8EncryptionKey;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.crypto.Biff8RC4;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianInput;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianInputStream;
import java.io.InputStream;

public final class Biff8DecryptingStream
implements BiffHeaderInput,
LittleEndianInput {
    private final LittleEndianInput _le;
    private final Biff8RC4 _rc4;

    public Biff8DecryptingStream(InputStream in, int initialOffset, Biff8EncryptionKey key) {
        this._rc4 = new Biff8RC4(initialOffset, key);
        this._le = in instanceof LittleEndianInput ? (LittleEndianInput)((Object)in) : new LittleEndianInputStream(in);
    }

    @Override
    public int available() {
        return this._le.available();
    }

    @Override
    public int readRecordSID() {
        int sid = this._le.readUShort();
        this._rc4.skipTwoBytes();
        this._rc4.startRecord(sid);
        return sid;
    }

    @Override
    public int readDataSize() {
        int dataSize = this._le.readUShort();
        this._rc4.skipTwoBytes();
        return dataSize;
    }

    @Override
    public double readDouble() {
        long valueLongBits = this.readLong();
        double result = Double.longBitsToDouble(valueLongBits);
        if (Double.isNaN(result)) {
            throw new RuntimeException("Did not expect to read NaN");
        }
        return result;
    }

    @Override
    public void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) {
        this._le.readFully(buf, off, len);
        this._rc4.xor(buf, off, len);
    }

    @Override
    public int readUByte() {
        return this._rc4.xorByte(this._le.readUByte());
    }

    @Override
    public byte readByte() {
        return (byte)this._rc4.xorByte(this._le.readUByte());
    }

    @Override
    public int readUShort() {
        return this._rc4.xorShort(this._le.readUShort());
    }

    @Override
    public short readShort() {
        return (short)this._rc4.xorShort(this._le.readUShort());
    }

    @Override
    public int readInt() {
        return this._rc4.xorInt(this._le.readInt());
    }

    @Override
    public long readLong() {
        return this._rc4.xorLong(this._le.readLong());
    }
}

