/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBoolProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRGBProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.ComboboxShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.CommentShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.ConvertAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.PolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.SimpleFilledShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.TextboxShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ObjRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFComment;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPolygon;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFTextbox;

public abstract class AbstractShape {
    public static AbstractShape createShape(HSSFShape hssfShape, int shapeId) {
        AbstractShape shape;
        if (hssfShape instanceof HSSFComment) {
            shape = new CommentShape((HSSFComment)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFTextbox) {
            shape = new TextboxShape((HSSFTextbox)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFPolygon) {
            shape = new PolygonShape((HSSFPolygon)hssfShape, shapeId);
        } else if (hssfShape instanceof HSSFSimpleShape) {
            HSSFSimpleShape simpleShape = (HSSFSimpleShape)hssfShape;
            switch (simpleShape.getShapeType()) {
                case 8: {
                    shape = new PictureShape(simpleShape, shapeId);
                    break;
                }
                case 1: {
                    shape = new LineShape(simpleShape, shapeId);
                    break;
                }
                case 2: 
                case 3: {
                    shape = new SimpleFilledShape(simpleShape, shapeId);
                    break;
                }
                case 20: {
                    shape = new ComboboxShape(simpleShape, shapeId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Do not know how to handle this type of shape");
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown shape type");
        }
        EscherSpRecord sp = (EscherSpRecord)((AbstractShape)shape).getSpContainer().getChildById((short)-4086);
        if (hssfShape.getParent() != null) {
            sp.setFlags(sp.getFlags() | 2);
        }
        return shape;
    }

    protected AbstractShape() {
    }

    public abstract EscherContainerRecord getSpContainer();

    public abstract ObjRecord getObjRecord();

    protected EscherRecord createAnchor(HSSFAnchor userAnchor) {
        return ConvertAnchor.createAnchor(userAnchor);
    }

    protected int addStandardOptions(HSSFShape shape, EscherOptRecord opt) {
        opt.addEscherProperty(new EscherBoolProperty(191, 524288));
        if (shape.isNoFill()) {
            opt.addEscherProperty(new EscherBoolProperty(447, 0x110000));
        } else {
            opt.addEscherProperty(new EscherBoolProperty(447, 65536));
        }
        opt.addEscherProperty(new EscherRGBProperty(385, shape.getFillColor()));
        opt.addEscherProperty(new EscherBoolProperty(959, 524288));
        opt.addEscherProperty(new EscherRGBProperty(448, shape.getLineStyleColor()));
        int options = 5;
        if (shape.getLineWidth() != 9525) {
            opt.addEscherProperty(new EscherSimpleProperty(459, shape.getLineWidth()));
            ++options;
        }
        if (shape.getLineStyle() != 0) {
            opt.addEscherProperty(new EscherSimpleProperty(462, shape.getLineStyle()));
            opt.addEscherProperty(new EscherSimpleProperty(471, 0));
            if (shape.getLineStyle() == -1) {
                opt.addEscherProperty(new EscherBoolProperty(511, 524288));
            } else {
                opt.addEscherProperty(new EscherBoolProperty(511, 524296));
            }
            options += 3;
        }
        opt.sortProperties();
        return options;
    }

    int getCmoObjectId(int shapeId) {
        return shapeId - 1024;
    }
}

