/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.FunctionMetadata;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.FunctionMetadataRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class FunctionDataBuilder {
    private int _maxFunctionIndex = -1;
    private final Map _functionDataByName;
    private final Map _functionDataByIndex;
    private final Set _mutatingFunctionIndexes;

    public FunctionDataBuilder(int sizeEstimate) {
        this._functionDataByName = new HashMap(sizeEstimate * 3 / 2);
        this._functionDataByIndex = new HashMap(sizeEstimate * 3 / 2);
        this._mutatingFunctionIndexes = new HashSet();
    }

    public void add(int functionIndex, String functionName, int minParams, int maxParams, byte returnClassCode, byte[] parameterClassCodes, boolean hasFootnote) {
        FunctionMetadata prevFM;
        FunctionMetadata fm = new FunctionMetadata(functionIndex, functionName, minParams, maxParams, returnClassCode, parameterClassCodes);
        Integer indexKey = functionIndex;
        if (functionIndex > this._maxFunctionIndex) {
            this._maxFunctionIndex = functionIndex;
        }
        if ((prevFM = (FunctionMetadata)this._functionDataByName.get(functionName)) != null) {
            if (!hasFootnote || !this._mutatingFunctionIndexes.contains(indexKey)) {
                throw new RuntimeException("Multiple entries for function name '" + functionName + "'");
            }
            this._functionDataByIndex.remove(prevFM.getIndex());
        }
        if ((prevFM = (FunctionMetadata)this._functionDataByIndex.get(indexKey)) != null) {
            if (!hasFootnote || !this._mutatingFunctionIndexes.contains(indexKey)) {
                throw new RuntimeException("Multiple entries for function index (" + functionIndex + ")");
            }
            this._functionDataByName.remove(prevFM.getName());
        }
        if (hasFootnote) {
            this._mutatingFunctionIndexes.add(indexKey);
        }
        this._functionDataByIndex.put(indexKey, fm);
        this._functionDataByName.put(functionName, fm);
    }

    public FunctionMetadataRegistry build() {
        FunctionMetadata[] jumbledArray = new FunctionMetadata[this._functionDataByName.size()];
        this._functionDataByName.values().toArray(jumbledArray);
        FunctionMetadata[] fdIndexArray = new FunctionMetadata[this._maxFunctionIndex + 1];
        for (int i = 0; i < jumbledArray.length; ++i) {
            FunctionMetadata fd;
            fdIndexArray[fd.getIndex()] = fd = jumbledArray[i];
        }
        return new FunctionMetadataRegistry(fdIndexArray, this._functionDataByName);
    }
}

