/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.AreaEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.RefEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Fixed2ArgFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Function;

public final class RangeEval
extends Fixed2ArgFunction {
    public static final Function instance = new RangeEval();

    private RangeEval() {
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        try {
            AreaEval reA = RangeEval.evaluateRef(arg0);
            AreaEval reB = RangeEval.evaluateRef(arg1);
            return RangeEval.resolveRange(reA, reB);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private static AreaEval resolveRange(AreaEval aeA, AreaEval aeB) {
        int aeAfr = aeA.getFirstRow();
        int aeAfc = aeA.getFirstColumn();
        int top = Math.min(aeAfr, aeB.getFirstRow());
        int bottom = Math.max(aeA.getLastRow(), aeB.getLastRow());
        int left = Math.min(aeAfc, aeB.getFirstColumn());
        int right = Math.max(aeA.getLastColumn(), aeB.getLastColumn());
        return aeA.offset(top - aeAfr, bottom - aeAfr, left - aeAfc, right - aeAfc);
    }

    private static AreaEval evaluateRef(ValueEval arg) throws EvaluationException {
        if (arg instanceof AreaEval) {
            return (AreaEval)arg;
        }
        if (arg instanceof RefEval) {
            return ((RefEval)arg).offset(0, 0, 0, 0);
        }
        if (arg instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)arg);
        }
        throw new IllegalArgumentException("Unexpected ref arg class (" + arg.getClass().getName() + ")");
    }
}

