/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.eventusermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.eventusermodel.AbortableHSSFListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.eventusermodel.HSSFListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.eventusermodel.HSSFUserException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HSSFRequest {
    private final Map<Short, List<HSSFListener>> _records = new HashMap<Short, List<HSSFListener>>(50);

    public void addListener(HSSFListener lsnr, short sid) {
        List<HSSFListener> list = this._records.get(sid);
        if (list == null) {
            list = new ArrayList<HSSFListener>(1);
            this._records.put(sid, list);
        }
        list.add(lsnr);
    }

    public void addListenerForAllRecords(HSSFListener lsnr) {
        short[] rectypes = RecordFactory.getAllKnownRecordSIDs();
        for (int k = 0; k < rectypes.length; ++k) {
            this.addListener(lsnr, rectypes[k]);
        }
    }

    protected short processRecord(Record rec) throws HSSFUserException {
        List<HSSFListener> obj = this._records.get(rec.getSid());
        short userCode = 0;
        if (obj != null) {
            List<HSSFListener> listeners = obj;
            for (int k = 0; k < listeners.size(); ++k) {
                HSSFListener listener;
                HSSFListener listenObj = listeners.get(k);
                if (listenObj instanceof AbortableHSSFListener) {
                    listener = (AbortableHSSFListener)listenObj;
                    userCode = ((AbortableHSSFListener)listener).abortableProcessRecord(rec);
                    if (userCode == 0) continue;
                    break;
                }
                listener = listenObj;
                listener.processRecord(rec);
            }
        }
        return userCode;
    }
}

