/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PositionDependentRecordAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.Hashtable;

public class SlideShowSlideInfoAtom
extends PositionDependentRecordAtom {
    private byte[] _header;
    private static long _type = 1017L;
    private int slideTime;
    private int soundIdRef;
    private byte effectDirection;
    private byte effectType;
    private boolean fManualAdvance;
    private boolean reserved1;
    private boolean fHidden;
    private boolean reserved2;
    private boolean fSound;
    private boolean reserved3;
    private boolean fLoopSound;
    private boolean reserved4;
    private boolean fStopSound;
    private boolean reserved5;
    private boolean fAutoAdvance;
    private boolean reserved6;
    private boolean fCursorVisible;
    private byte reserved7;
    private byte speed;
    private byte[] unused;

    protected SlideShowSlideInfoAtom(byte[] source, int start, int len) {
        if (len < 24) {
            len = 24;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this.slideTime = LittleEndian.getInt(source, start + 8);
        this.soundIdRef = LittleEndian.getInt(source, start + 12);
        this.effectDirection = source[start + 16];
        this.effectType = source[start + 17];
        this.speed = source[start + 20];
    }

    public boolean isValidateTransition() {
        switch (this.effectType) {
            case 0: {
                return this.effectDirection >= 0 && this.effectDirection <= 1;
            }
            case 1: {
                return true;
            }
            case 2: 
            case 3: {
                return this.effectDirection >= 0 && this.effectDirection <= 1;
            }
            case 4: {
                return this.effectDirection >= 0 && this.effectDirection <= 7;
            }
            case 5: {
                return this.effectDirection == 0;
            }
            case 6: {
                return this.effectDirection == 0;
            }
            case 7: {
                return this.effectDirection >= 0 && this.effectDirection <= 7;
            }
            case 8: {
                return this.effectDirection >= 0 && this.effectDirection <= 1;
            }
            case 9: {
                return this.effectDirection >= 4 && this.effectDirection <= 7;
            }
            case 10: {
                return this.effectDirection >= 0 && this.effectDirection <= 3;
            }
            case 11: {
                return this.effectDirection >= 0 && this.effectDirection <= 1;
            }
            case 13: {
                return this.effectDirection >= 0 && this.effectDirection <= 3;
            }
            case 17: 
            case 18: 
            case 19: {
                return this.effectDirection == 0;
            }
            case 20: {
                return this.effectDirection >= 0 && this.effectDirection <= 3;
            }
            case 21: {
                return this.effectDirection >= 0 && this.effectDirection <= 1;
            }
            case 22: 
            case 23: {
                return this.effectDirection == 0;
            }
            case 26: {
                return this.effectDirection >= 1 && this.effectDirection <= 4 || this.effectDirection == 8;
            }
            case 27: {
                return this.effectDirection == 0;
            }
        }
        return false;
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void updateOtherRecordReferences(Hashtable<Integer, Integer> oldToNewReferencesLookup) {
    }

    @Override
    public void dispose() {
        this._header = null;
    }
}

