/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBSERecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherComplexProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.HSLFException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.SimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.PictureData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.SlideShow;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class Picture
extends SimpleShape {
    public static final int EMF = 2;
    public static final int WMF = 3;
    public static final int PICT = 4;
    public static final int JPEG = 5;
    public static final int PNG = 6;
    public static final byte DIB = 7;

    public Picture(int idx) {
        this(idx, null);
    }

    public Picture(int idx, Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(idx, parent instanceof ShapeGroup);
    }

    protected Picture(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public int getPictureIndex() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 260);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        this._escherContainer = super.createSpContainer(isChild);
        this._escherContainer.setOptions((short)15);
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        spRecord.setOptions((short)1202);
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        Picture.setEscherProperty(opt, (short)127, 0x800080);
        Picture.setEscherProperty(opt, (short)16644, idx);
        return this._escherContainer;
    }

    public void setDefaultSize() {
    }

    public PictureData getPictureData() {
        SlideShow ppt = this.getSheet().getSlideShow();
        PictureData[] pict = ppt.getPictureData();
        EscherBSERecord bse = this.getEscherBSERecord();
        if (bse != null) {
            for (int i = 0; i < pict.length; ++i) {
                if (pict[i].getOffset() != bse.getOffset()) continue;
                return pict[i];
            }
        }
        return null;
    }

    public EscherOptRecord getEscherOptRecord() {
        return (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
    }

    protected EscherBSERecord getEscherBSERecord() {
        SlideShow ppt = this.getSheet().getSlideShow();
        Document doc = ppt.getDocumentRecord();
        EscherContainerRecord dggContainer = doc.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord bstore = (EscherContainerRecord)ShapeKit.getEscherChild(dggContainer, -4095);
        if (bstore == null) {
            return null;
        }
        List<EscherRecord> lst = bstore.getChildRecords();
        int idx = this.getPictureIndex();
        if (idx == 0) {
            return null;
        }
        return (EscherBSERecord)lst.get(idx - 1);
    }

    public String getPictureName() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherComplexProperty prop = (EscherComplexProperty)ShapeKit.getEscherProperty(opt, 261);
        String name = null;
        if (prop != null) {
            try {
                name = new String(prop.getComplexData(), "UTF-16LE");
                int idx = name.indexOf(0);
                return idx == -1 ? name : name.substring(0, idx);
            }
            catch (UnsupportedEncodingException e) {
                throw new HSLFException(e);
            }
        }
        return name;
    }

    public void setPictureName(String name) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        try {
            byte[] data = (name + '\u0000').getBytes("UTF-16LE");
            EscherComplexProperty prop = new EscherComplexProperty(261, false, data);
            opt.addEscherProperty(prop);
        }
        catch (UnsupportedEncodingException e) {
            throw new HSLFException(e);
        }
    }

    @Override
    protected void afterInsert(Sheet sh) {
        super.afterInsert(sh);
        EscherBSERecord bse = this.getEscherBSERecord();
        bse.setRef(bse.getRef() + 1);
        Rectangle anchor = this.getAnchor();
        if (anchor.equals(new Rectangle())) {
            this.setDefaultSize();
        }
    }
}

