/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.blip.Metafile;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.HSLFException;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.InflaterInputStream;

public final class WMF
extends Metafile {
    @Override
    public byte[] getData() {
        try {
            int count;
            byte[] rawdata = this.getRawData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(rawdata);
            ((InputStream)is).skip(8L);
            Metafile.Header header = new Metafile.Header();
            header.read(rawdata, 16);
            ((InputStream)is).skip(header.getSize() + 16);
            InflaterInputStream inflater = new InflaterInputStream(is);
            byte[] chunk = new byte[4096];
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
            }
            inflater.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    @Override
    public void setData(byte[] data) throws IOException {
        int pos = 0;
        AldusHeader aldus = new AldusHeader();
        aldus.read(data, pos);
        byte[] compressed = this.compress(data, pos += aldus.getSize(), data.length - pos);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length - aldus.getSize();
        header.bounds = new Rectangle((short)aldus.left, (short)aldus.top, (short)aldus.right - (short)aldus.left, (short)aldus.bottom - (short)aldus.top);
        int coeff = 1219200 / aldus.inch;
        header.size = new Dimension(header.bounds.width * coeff, header.bounds.height * coeff);
        header.zipsize = compressed.length;
        byte[] checksum = WMF.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public int getSignature() {
        return 8544;
    }

    public class AldusHeader {
        public static final int APMHEADER_KEY = -1698247209;
        public int handle;
        public int left;
        public int top;
        public int right;
        public int bottom;
        public int inch = 72;
        public int reserved;
        public int checksum;

        public void read(byte[] data, int offset) {
            int pos = offset;
            int key = LittleEndian.getInt(data, pos);
            pos += 4;
            if (key != -1698247209) {
                throw new HSLFException("Not a valid WMF file");
            }
            this.handle = LittleEndian.getUShort(data, pos);
            this.left = LittleEndian.getUShort(data, pos += 2);
            this.top = LittleEndian.getUShort(data, pos += 2);
            this.right = LittleEndian.getUShort(data, pos += 2);
            this.bottom = LittleEndian.getUShort(data, pos += 2);
            this.inch = LittleEndian.getUShort(data, pos += 2);
            this.reserved = LittleEndian.getInt(data, pos += 2);
            this.checksum = LittleEndian.getShort(data, pos += 4);
            pos += 2;
            if (this.checksum != this.getChecksum()) {
                // empty if block
            }
        }

        public int getChecksum() {
            int checksum = 0;
            checksum ^= 0xCDD7;
            checksum ^= 0xFFFF9AC6;
            checksum ^= this.left;
            checksum ^= this.top;
            checksum ^= this.right;
            checksum ^= this.bottom;
            return checksum ^= this.inch;
        }

        public void write(OutputStream out) throws IOException {
            byte[] header = new byte[22];
            int pos = 0;
            LittleEndian.putInt(header, pos, -1698247209);
            LittleEndian.putUShort(header, pos += 4, 0);
            LittleEndian.putUShort(header, pos += 2, this.left);
            LittleEndian.putUShort(header, pos += 2, this.top);
            LittleEndian.putUShort(header, pos += 2, this.right);
            LittleEndian.putUShort(header, pos += 2, this.bottom);
            LittleEndian.putUShort(header, pos += 2, this.inch);
            LittleEndian.putInt(header, pos += 2, 0);
            this.checksum = this.getChecksum();
            LittleEndian.putUShort(header, pos += 4, this.checksum);
            out.write(header);
        }

        public int getSize() {
            return 22;
        }
    }
}

