/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage;

public class LittleEndian {
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int DOUBLE_SIZE = 8;

    public static short getShort(byte[] data, int offset) {
        int b0 = data[offset] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        return (short)((b1 << 8) + (b0 << 0));
    }

    public static int getUShort(byte[] data, int offset) {
        int b0 = data[offset] & 0xFF;
        int b1 = data[offset + 1] & 0xFF;
        return (b1 << 8) + (b0 << 0);
    }

    public static short getShort(byte[] data) {
        return LittleEndian.getShort(data, 0);
    }

    public static int getUShort(byte[] data) {
        return LittleEndian.getUShort(data, 0);
    }

    public static int getInt(byte[] data, int offset) {
        int i = offset;
        int b0 = data[i++] & 0xFF;
        int b1 = data[i++] & 0xFF;
        int b2 = data[i++] & 0xFF;
        int b3 = data[i++] & 0xFF;
        return (b3 << 24) + (b2 << 16) + (b1 << 8) + (b0 << 0);
    }

    public static int getInt(byte[] data) {
        return LittleEndian.getInt(data, 0);
    }

    public static long getUInt(byte[] data, int offset) {
        long retNum = LittleEndian.getInt(data, offset);
        return retNum & 0xFFFFFFFFL;
    }

    public static long getUInt(byte[] data) {
        return LittleEndian.getUInt(data, 0);
    }

    public static long getLong(byte[] data, int offset) {
        long result = 0L;
        for (int j = offset + 8 - 1; j >= offset; --j) {
            result <<= 8;
            result |= (long)(0xFF & data[j]);
        }
        return result;
    }
}

