/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem;

import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.BlockSize;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.CFBConstants;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.Property;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.BlockAllocationTableReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.BlockList;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.HeaderBlock;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.RawDataBlock;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CFBFileSystem {
    private BlockSize bigBlockSize = CFBConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;
    private boolean isGetThumbnail;
    private Property root;
    private HeaderBlock headerBlock;

    public CFBFileSystem(InputStream stream) throws IOException {
        this(stream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CFBFileSystem(InputStream stream, boolean isGetThumbnail) throws IOException {
        BlockList rawDataBlockList;
        this.isGetThumbnail = isGetThumbnail;
        try {
            this.headerBlock = new HeaderBlock(stream);
            this.bigBlockSize = this.headerBlock.getBigBlockSize();
            rawDataBlockList = new BlockList(stream, this.bigBlockSize);
        }
        finally {
            stream.close();
        }
        new BlockAllocationTableReader(this.headerBlock.getBigBlockSize(), this.headerBlock.getBATCount(), this.headerBlock.getBATArray(), this.headerBlock.getXBATCount(), this.headerBlock.getXBATIndex(), rawDataBlockList);
        ArrayList<Property> properties = new ArrayList<Property>();
        this.readProperties(rawDataBlockList.fetchBlocks(this.headerBlock.getPropertyStart(), -1), rawDataBlockList, properties);
        this.createPropertyTree(this.root, properties);
        BlockList smallBlockList = this.readSmallRawDataBlock(rawDataBlockList);
        this.readPrepertiesRawData(smallBlockList, rawDataBlockList, this.root);
    }

    private void createPropertyTree(Property directory, List<Property> properties) {
        int index = directory.getChildPropertyIndex();
        if (index < 0) {
            return;
        }
        Stack<Property> children = new Stack<Property>();
        children.push(properties.get(index));
        while (!children.isEmpty()) {
            Property property = (Property)children.pop();
            directory.addChildProperty(property);
            if (property.isDirectory()) {
                this.createPropertyTree(property, properties);
            }
            if ((index = property.getPreviousPropertyIndex()) >= 0) {
                children.push(properties.get(index));
            }
            if ((index = property.getNextPropertyIndex()) < 0) continue;
            children.push(properties.get(index));
        }
    }

    private void readProperties(RawDataBlock[] propertyBlocks, BlockList rawBlockList, List<Property> properties) throws IOException {
        for (int j = 0; j < propertyBlocks.length; ++j) {
            byte[] data = propertyBlocks[j].getData();
            int property_count = data.length / 128;
            int offset = 0;
            for (int k = 0; k < property_count; ++k) {
                switch (data[offset + 66]) {
                    case 1: {
                        properties.add(new Property(properties.size(), data, offset));
                        break;
                    }
                    case 2: {
                        properties.add(new Property(properties.size(), data, offset));
                        break;
                    }
                    case 5: {
                        this.root = new Property(properties.size(), data, offset);
                        properties.add(this.root);
                    }
                }
                offset += 128;
            }
        }
    }

    private BlockList readSmallRawDataBlock(BlockList rawDataBlockList) throws IOException {
        int block_size = 64;
        RawDataBlock[] smallRawDataBlocks = rawDataBlockList.fetchBlocks(this.root.getStartBlock(), -1);
        int _blocks_per_big_block = this.headerBlock.getBigBlockSize().getBigBlockSize() / block_size;
        ArrayList<RawDataBlock> sdbs = new ArrayList<RawDataBlock>();
        for (int j = 0; j < smallRawDataBlocks.length; ++j) {
            byte[] data = smallRawDataBlocks[j].getData();
            for (int k = 0; k < _blocks_per_big_block; ++k) {
                byte[] smallData = new byte[block_size];
                System.arraycopy(data, k * block_size, smallData, 0, block_size);
                sdbs.add(new RawDataBlock(smallData));
            }
        }
        BlockList smallBlockList = new BlockList(sdbs.toArray(new RawDataBlock[sdbs.size()]));
        new BlockAllocationTableReader(this.bigBlockSize, rawDataBlockList.fetchBlocks(this.headerBlock.getSBATStart(), -1), smallBlockList);
        return smallBlockList;
    }

    private void readPrepertiesRawData(BlockList smallBlockList, BlockList rawBlockList, Property directory) throws IOException {
        for (Property property : directory.properties.values()) {
            if (property.isDocument()) {
                this.getPropertyRawData(property, smallBlockList, rawBlockList);
                continue;
            }
            if (!property.isDirectory()) continue;
            this.readPrepertiesRawData(smallBlockList, rawBlockList, property);
        }
    }

    private void getPropertyRawData(Property property, BlockList smallBlockList, BlockList rawBlockList) throws IOException {
        String name = property.getName();
        int startBlock = property.getStartBlock();
        RawDataBlock[] blocks = property.shouldUseSmallBlocks() ? smallBlockList.fetchBlocks(startBlock, this.headerBlock.getPropertyStart()) : rawBlockList.fetchBlocks(startBlock, this.headerBlock.getPropertyStart());
        if (blocks == null || blocks.length == 0) {
            return;
        }
        if (name.equals("Pictures") || name.endsWith("WorkBook") || name.equals("PowerPoint Document") || name.endsWith("Ole") || name.endsWith("ObjInfo") || name.endsWith("ComObj") || name.endsWith("EPRINT")) {
            property.setBlocks(blocks);
            return;
        }
        int bSize = blocks[0].getData().length;
        byte[] b = new byte[blocks.length * bSize];
        int offset = 0;
        for (int i = 0; i < blocks.length; ++i) {
            System.arraycopy(blocks[i].getData(), 0, b, offset, bSize);
            offset += bSize;
        }
        property.setDocumentRawData(b);
    }

    public byte[] getPropertyRawData(String propertyName) {
        Property p = this.getProperty(propertyName);
        if (p != null) {
            return p.getDocumentRawData();
        }
        return null;
    }

    public Property getProperty(String propertyName) {
        return this.root.getChlidProperty(propertyName);
    }

    public void dispose() {
        if (this.headerBlock != null) {
            this.headerBlock.dispose();
            this.headerBlock = null;
        }
        if (this.root != null) {
            this.root.dispose();
        }
    }
}

