/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.doc;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractReader;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.WPDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TXTReader
extends AbstractReader {
    private long offset;
    private String filePath;
    private String encoding;
    private IDocument wpdoc;

    public TXTReader(IControl control, String filePath, String encoding) {
        this.control = control;
        this.filePath = filePath;
        this.encoding = encoding;
    }

    public boolean authenticate(String password) {
        if (this.encoding != null) {
            return true;
        }
        this.encoding = password;
        if (this.encoding != null) {
            try {
                this.control.actionEvent(0, this.getModel());
                return true;
            }
            catch (Throwable e) {
                this.control.getSysKit().getErrorKit().writerLog(e);
            }
        }
        return false;
    }

    @Override
    public Object getModel() throws Exception {
        if (this.wpdoc != null) {
            return this.wpdoc;
        }
        this.wpdoc = new WPDocument();
        if (this.encoding != null) {
            this.readFile();
        }
        return this.wpdoc;
    }

    public void readFile() throws Exception {
        String line;
        SectionElement secElem = new SectionElement();
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageWidth(attr, 11906);
        AttrManage.instance().setPageHeight(attr, 16838);
        AttrManage.instance().setPageMarginLeft(attr, 1800);
        AttrManage.instance().setPageMarginRight(attr, 1800);
        AttrManage.instance().setPageMarginTop(attr, 1440);
        AttrManage.instance().setPageMarginBottom(attr, 1440);
        secElem.setStartOffset(this.offset);
        File file = new File(this.filePath);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
        block0: while (!((line = br.readLine()) == null && this.offset != 0L || this.abortReader)) {
            line = line == null ? "\n" : line.concat("\n");
            int len = (line = line.replace('\t', ' ')).length();
            if (len > 500) {
                int end = 200;
                int start = 0;
                while (end <= len) {
                    String str = line.substring(start, end).concat("\n");
                    ParagraphElement paraElem = new ParagraphElement();
                    paraElem.setStartOffset(this.offset);
                    LeafElement leafElem = new LeafElement(str);
                    leafElem.setStartOffset(this.offset);
                    this.offset += (long)str.length();
                    leafElem.setEndOffset(this.offset);
                    paraElem.appendLeaf(leafElem);
                    paraElem.setEndOffset(this.offset);
                    this.wpdoc.appendParagraph(paraElem, 0L);
                    if (end == len) continue block0;
                    start = end;
                    if ((end += 100) <= len) continue;
                    end = len;
                }
                continue;
            }
            ParagraphElement paraElem = new ParagraphElement();
            paraElem.setStartOffset(this.offset);
            LeafElement leafElem = new LeafElement(line);
            leafElem.setStartOffset(this.offset);
            this.offset += (long)line.length();
            leafElem.setEndOffset(this.offset);
            paraElem.appendLeaf(leafElem);
            paraElem.setEndOffset(this.offset);
            this.wpdoc.appendParagraph(paraElem, 0L);
        }
        br.close();
        secElem.setEndOffset(this.offset);
        this.wpdoc.appendSection(secElem);
    }

    @Override
    public boolean searchContent(File file, String key) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((line = br.readLine()) != null) {
            if (line.indexOf(key) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.isReaderFinish()) {
            this.wpdoc = null;
            this.filePath = null;
            this.control = null;
        }
    }
}

