/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ddf;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSerializationListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

public final class UnknownEscherRecord
extends EscherRecord {
    private static final byte[] NO_BYTES = new byte[0];
    private byte[] thedata = NO_BYTES;
    private List<EscherRecord> _childRecords = new ArrayList<EscherRecord>();

    @Override
    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int avaliable;
        int bytesRemaining = this.readHeader(data, offset);
        if (bytesRemaining > (avaliable = data.length - (offset + 8))) {
            bytesRemaining = avaliable;
        }
        if (this.isContainerRecord()) {
            int bytesWritten = 0;
            this.thedata = new byte[0];
            offset += 8;
            bytesWritten += 8;
            while (bytesRemaining > 0) {
                EscherRecord child = recordFactory.createRecord(data, offset);
                int childBytesWritten = child.fillFields(data, offset, recordFactory);
                bytesWritten += childBytesWritten;
                offset += childBytesWritten;
                bytesRemaining -= childBytesWritten;
                this.getChildRecords().add(child);
            }
            return bytesWritten;
        }
        this.thedata = new byte[bytesRemaining];
        System.arraycopy(data, offset + 8, this.thedata, 0, bytesRemaining);
        return bytesRemaining + 8;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = this.thedata.length;
        for (EscherRecord r : this._childRecords) {
            remainingBytes += r.getRecordSize();
        }
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        System.arraycopy(this.thedata, 0, data, offset + 8, this.thedata.length);
        int pos = offset + 8 + this.thedata.length;
        for (EscherRecord r : this._childRecords) {
            pos += r.serialize(pos, data, listener);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public byte[] getData() {
        return this.thedata;
    }

    @Override
    public int getRecordSize() {
        return 8 + this.thedata.length;
    }

    @Override
    public List<EscherRecord> getChildRecords() {
        return this._childRecords;
    }

    @Override
    public void setChildRecords(List<EscherRecord> childRecords) {
        this._childRecords = childRecords;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public String getRecordName() {
        return "Unknown 0x" + HexDump.toHex(this.getRecordId());
    }

    public String toString() {
        StringBuffer children = new StringBuffer();
        if (this.getChildRecords().size() > 0) {
            children.append("  children: \n");
            for (EscherRecord record : this._childRecords) {
                children.append(record.toString());
                children.append('\n');
            }
        }
        String theDumpHex = HexDump.toHex(this.thedata, 32);
        return this.getClass().getName() + ":" + '\n' + "  isContainer: " + this.isContainerRecord() + '\n' + "  options: 0x" + HexDump.toHex(this.getOptions()) + '\n' + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + '\n' + "  numchildren: " + this.getChildRecords().size() + '\n' + theDumpHex + children.toString();
    }

    public void addChildRecord(EscherRecord childRecord) {
        this.getChildRecords().add(childRecord);
    }

    @Override
    public void dispose() {
        if (this._childRecords != null) {
            for (EscherRecord er : this._childRecords) {
                er.dispose();
            }
            this._childRecords.clear();
            this._childRecords = null;
        }
    }
}

