/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ddf;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSerializationListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.NullEscherSerializationListener;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

public abstract class EscherRecord {
    private short _options;
    private short _recordId;

    protected int fillFields(byte[] data, EscherRecordFactory f) {
        return this.fillFields(data, 0, f);
    }

    public abstract int fillFields(byte[] var1, int var2, EscherRecordFactory var3);

    public abstract void dispose();

    public int readHeader(byte[] data, int offset) {
        EscherRecordHeader header = EscherRecordHeader.readHeader(data, offset);
        this._options = header.getOptions();
        this._recordId = header.getRecordId();
        return header.getRemainingBytes();
    }

    public boolean isContainerRecord() {
        return (this._options & 0xF) == 15;
    }

    public short getOptions() {
        return this._options;
    }

    public void setOptions(short options) {
        this._options = options;
    }

    public byte[] serialize() {
        byte[] retval = new byte[this.getRecordSize()];
        this.serialize(0, retval);
        return retval;
    }

    public int serialize(int offset, byte[] data) {
        return this.serialize(offset, data, new NullEscherSerializationListener());
    }

    public abstract int serialize(int var1, byte[] var2, EscherSerializationListener var3);

    public abstract int getRecordSize();

    public short getRecordId() {
        return this._recordId;
    }

    public void setRecordId(short recordId) {
        this._recordId = recordId;
    }

    public List<EscherRecord> getChildRecords() {
        return Collections.emptyList();
    }

    public void setChildRecords(List<EscherRecord> childRecords) {
        throw new UnsupportedOperationException("This record does not support child records.");
    }

    public Object clone() {
        throw new RuntimeException("The class " + this.getClass().getName() + " needs to define a clone method");
    }

    public EscherRecord getChild(int index) {
        return this.getChildRecords().get(index);
    }

    public void display(PrintWriter w, int indent) {
        for (int i = 0; i < indent * 4; ++i) {
            w.print(' ');
        }
        w.println(this.getRecordName());
    }

    public abstract String getRecordName();

    public short getInstance() {
        return (short)(this._options >> 4);
    }

    static class EscherRecordHeader {
        private short options;
        private short recordId;
        private int remainingBytes;

        private EscherRecordHeader() {
        }

        public static EscherRecordHeader readHeader(byte[] data, int offset) {
            EscherRecordHeader header = new EscherRecordHeader();
            header.options = LittleEndian.getShort(data, offset);
            header.recordId = LittleEndian.getShort(data, offset + 2);
            header.remainingBytes = LittleEndian.getInt(data, offset + 4);
            return header;
        }

        public short getOptions() {
            return this.options;
        }

        public short getRecordId() {
            return this.recordId;
        }

        public int getRemainingBytes() {
            return this.remainingBytes;
        }

        public String toString() {
            return "EscherRecordHeader{options=" + this.options + ", recordId=" + this.recordId + ", remainingBytes=" + this.remainingBytes + "}";
        }
    }
}

