/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ddf;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherArrayProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBoolProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherComplexProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperties;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRGBProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherShapePathProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

public final class EscherPropertyFactory {
    public List<EscherProperty> createProperties(byte[] data, int offset, short numProperties) {
        ArrayList<EscherProperty> results = new ArrayList<EscherProperty>();
        int pos = offset;
        for (int i = 0; i < numProperties; ++i) {
            short propId = LittleEndian.getShort(data, pos);
            int propData = LittleEndian.getInt(data, pos + 2);
            short propNumber = (short)(propId & 0x3FFF);
            boolean isComplex = (propId & Short.MIN_VALUE) != 0;
            boolean isBlipId = (propId & 0x4000) != 0;
            byte propertyType = EscherProperties.getPropertyType(propNumber);
            if (propertyType == 1) {
                results.add(new EscherBoolProperty(propId, propData));
            } else if (propertyType == 2) {
                results.add(new EscherRGBProperty(propId, propData));
            } else if (propertyType == 3) {
                results.add(new EscherShapePathProperty(propId, propData));
            } else if (!isComplex) {
                results.add(new EscherSimpleProperty(propId, propData));
            } else if (propertyType == 5) {
                results.add(new EscherArrayProperty(propId, new byte[propData]));
            } else {
                results.add(new EscherComplexProperty(propId, new byte[propData]));
            }
            pos += 6;
        }
        for (EscherProperty p : results) {
            if (!(p instanceof EscherComplexProperty)) continue;
            if (p instanceof EscherArrayProperty) {
                pos += ((EscherArrayProperty)p).setArrayData(data, pos);
                continue;
            }
            byte[] complexData = ((EscherComplexProperty)p).getComplexData();
            System.arraycopy(data, pos, complexData, 0, complexData.length);
            pos += complexData.length;
        }
        return results;
    }
}

