/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.LineArrowPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.Arrow;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.AbstractEscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherArrayProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherComplexProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTertiaryOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ColorSchemeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.StringUtil;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class ShapeKit {
    public static final int EMU_PER_INCH = 914400;
    public static final int EMU_PER_POINT = 12700;
    public static final int EMU_PER_CENTIMETER = 360000;
    public static final int DefaultMargin_Twip = 72;
    public static final float DefaultMargin_Pixel = 4.8f;
    public static final int MASTER_DPI = 576;
    public static final byte[] SEGMENTINFO_MOVETO = new byte[]{0, 64};
    public static final byte[] SEGMENTINFO_LINETO = new byte[]{0, -84};
    public static final byte[] SEGMENTINFO_LINETO2 = new byte[]{0, -80};
    public static final byte[] SEGMENTINFO_ESCAPE = new byte[]{1, 0};
    public static final byte[] SEGMENTINFO_ESCAPE1 = new byte[]{3, 0};
    public static final byte[] SEGMENTINFO_ESCAPE2 = new byte[]{1, 32};
    public static final byte[] SEGMENTINFO_CUBICTO = new byte[]{0, -83};
    public static final byte[] SEGMENTINFO_CUBICTO1 = new byte[]{0, -81};
    public static final byte[] SEGMENTINFO_CUBICTO2 = new byte[]{0, -77};
    public static final byte[] SEGMENTINFO_CLOSE = new byte[]{1, 96};
    public static final byte[] SEGMENTINFO_END = new byte[]{0, -128};

    public static EscherRecord getEscherChild(EscherContainerRecord owner, int recordId) {
        Iterator<EscherRecord> iterator = owner.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord.getRecordId() != recordId) continue;
            return escherRecord;
        }
        return null;
    }

    public static EscherProperty getEscherProperty(AbstractEscherOptRecord opt, int propId) {
        if (opt != null) {
            for (EscherProperty prop : opt.getEscherProperties()) {
                if (prop.getPropertyNumber() != propId) continue;
                return prop;
            }
        }
        return null;
    }

    public static int getEscherProperty(EscherContainerRecord escherContainer, short propId, int defaultValue) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, (int)propId)) != null) {
            return prop.getPropertyValue();
        }
        return defaultValue;
    }

    public static int getEscherProperty(EscherContainerRecord escherContainer, short propId) {
        return ShapeKit.getEscherProperty(escherContainer, propId, 0);
    }

    public static int getShapeType(EscherContainerRecord escherContainer) {
        EscherSpRecord spRecord = (EscherSpRecord)escherContainer.getChildById((short)-4086);
        if (spRecord != null) {
            return spRecord.getOptions() >> 4;
        }
        return -1;
    }

    public static int getShapeId(EscherContainerRecord escherContainer) {
        EscherSpRecord spRecord = (EscherSpRecord)escherContainer.getChildById((short)-4086);
        return spRecord == null ? 0 : spRecord.getShapeId();
    }

    public static int getMasterShapeID(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 769)) != null) {
            return prop.getPropertyValue();
        }
        return 0;
    }

    public static boolean isHidden(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 959)) != null) {
            return prop.getPropertyValue() == 131074;
        }
        return false;
    }

    public static boolean hasLine(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 511);
        if (prop != null) {
            return (prop.getPropertyValue() & 0xFF) != 0;
        }
        return true;
    }

    public static int getLineWidth(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 459);
        int width = prop == null ? 1 : prop.getPropertyValue() / 9525;
        return width;
    }

    public static int getLineDashing(EscherContainerRecord _escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(_escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 462);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public static int getStartArrowType(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 464)) != null) {
            return prop.getPropertyValue();
        }
        return 0;
    }

    public static int getStartArrowWidth(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 466)) != null) {
            return prop.getPropertyValue();
        }
        return 1;
    }

    public static int getStartArrowLength(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 467)) != null) {
            return prop.getPropertyValue();
        }
        return 1;
    }

    public static ArrowPathAndTail getStartArrowPathAndTail(EscherContainerRecord _escherContainer, Rectangle rect) {
        EscherArrayProperty segmentsProp;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(_escherContainer, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16709);
        if (verticesProp == null) {
            verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 325);
        }
        if ((segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16710)) == null) {
            segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 326);
        }
        if (verticesProp == null) {
            return null;
        }
        if (segmentsProp == null) {
            return null;
        }
        float w = 0.0f;
        float h = 0.0f;
        EscherSimpleProperty rightProp = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 322);
        EscherSimpleProperty bottomProp = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 323);
        if (rightProp != null) {
            w = rightProp.getPropertyValue();
        }
        if (bottomProp != null) {
            h = bottomProp.getPropertyValue();
        }
        Matrix m = new Matrix();
        if (w > 0.0f && h > 0.0f) {
            m.postScale((float)rect.width / w, (float)rect.height / h);
        }
        ArrowPathAndTail arrowPathAndTail = null;
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 464);
        if (prop != null && prop.getPropertyValue() > 0) {
            Arrow arrow = new Arrow((byte)prop.getPropertyValue(), ShapeKit.getStartArrowWidth(_escherContainer), ShapeKit.getStartArrowLength(_escherContainer));
            int lineWidth = Math.round((float)ShapeKit.getLineWidth(_escherContainer) * 1.3333334f);
            int numPoints = verticesProp.getNumberOfElementsInArray();
            int numSegments = segmentsProp.getNumberOfElementsInArray();
            float p0X = 0.0f;
            float p0Y = 0.0f;
            byte[] p = verticesProp.getElement(0);
            if (p.length == 8) {
                p0X = LittleEndian.getInt(p, 0);
                p0Y = LittleEndian.getInt(p, 4);
            } else {
                p0X = LittleEndian.getShort(p, 0);
                p0Y = LittleEndian.getShort(p, 2);
            }
            byte[] elem = segmentsProp.getElement(1);
            if (Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO1) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE2)) {
                if (4 <= numPoints) {
                    byte[] p1 = verticesProp.getElement(1);
                    byte[] p2 = verticesProp.getElement(2);
                    byte[] p3 = verticesProp.getElement(3);
                    float x1 = 0.0f;
                    float y1 = 0.0f;
                    float x2 = 0.0f;
                    float y2 = 0.0f;
                    float x3 = 0.0f;
                    float y3 = 0.0f;
                    if (p1.length == 8 && p2.length == 8 && p3.length == 8) {
                        x1 = LittleEndian.getInt(p1, 0);
                        y1 = LittleEndian.getInt(p1, 4);
                        x2 = LittleEndian.getInt(p2, 0);
                        y2 = LittleEndian.getInt(p2, 4);
                        x3 = LittleEndian.getInt(p3, 0);
                        y3 = LittleEndian.getInt(p3, 4);
                    } else {
                        x1 = LittleEndian.getShort(p1, 0);
                        y1 = LittleEndian.getShort(p1, 2);
                        x2 = LittleEndian.getShort(p2, 0);
                        y2 = LittleEndian.getShort(p2, 2);
                        x3 = LittleEndian.getShort(p3, 0);
                        y3 = LittleEndian.getShort(p3, 2);
                    }
                    arrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(x3, y3, x2, y2, x1, y1, p0X, p0Y, arrow, (int)((float)lineWidth * w / (float)rect.width));
                }
            } else if ((Arrays.equals(elem, SEGMENTINFO_LINETO) || Arrays.equals(elem, SEGMENTINFO_LINETO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE) || Arrays.equals(elem, SEGMENTINFO_ESCAPE1)) && 2 <= numPoints) {
                float y;
                float x;
                p = verticesProp.getElement(1);
                if (p.length == 8) {
                    x = LittleEndian.getInt(p, 0);
                    y = LittleEndian.getInt(p, 4);
                } else {
                    x = LittleEndian.getShort(p, 0);
                    y = LittleEndian.getShort(p, 2);
                }
                arrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(x, y, p0X, p0Y, arrow, (int)((float)lineWidth * w / (float)rect.width));
            }
        }
        if (arrowPathAndTail != null && arrowPathAndTail.getArrowPath() != null) {
            arrowPathAndTail.getArrowPath().transform(m);
        }
        return arrowPathAndTail;
    }

    public static int getEndArrowType(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 465)) != null && prop.getPropertyValue() > 0) {
            return prop.getPropertyValue();
        }
        return 0;
    }

    public static int getEndArrowWidth(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 468)) != null) {
            return prop.getPropertyValue();
        }
        return 1;
    }

    public static int getEndArrowLength(EscherContainerRecord escherContainer) {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 469)) != null) {
            return prop.getPropertyValue();
        }
        return 1;
    }

    private static int getRealSegmentsCount(EscherArrayProperty verticesProp, EscherArrayProperty segmentsProp) {
        int numPoints = verticesProp.getNumberOfElementsInArray();
        int numSegments = segmentsProp.getNumberOfElementsInArray();
        int realSegments = 0;
        int j = 0;
        for (int i = 0; i < numSegments && j < numPoints; ++i) {
            byte[] elem = segmentsProp.getElement(i);
            if (Arrays.equals(elem, SEGMENTINFO_MOVETO)) {
                ++j;
                continue;
            }
            if (Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO1) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE2)) {
                if (j + 3 > numPoints) continue;
                j += 3;
                ++realSegments;
                continue;
            }
            if (!Arrays.equals(elem, SEGMENTINFO_LINETO) && !Arrays.equals(elem, SEGMENTINFO_LINETO2) && !Arrays.equals(elem, SEGMENTINFO_ESCAPE) && !Arrays.equals(elem, SEGMENTINFO_ESCAPE1) || j + 1 > numPoints) continue;
            ++j;
            ++realSegments;
        }
        return realSegments + 1;
    }

    public static ArrowPathAndTail getEndArrowPathAndTail(EscherContainerRecord _escherContainer, Rectangle rect) {
        EscherArrayProperty segmentsProp;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(_escherContainer, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16709);
        if (verticesProp == null) {
            verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 325);
        }
        if ((segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16710)) == null) {
            segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 326);
        }
        if (verticesProp == null) {
            return null;
        }
        if (segmentsProp == null) {
            return null;
        }
        float w = 0.0f;
        float h = 0.0f;
        EscherSimpleProperty rightProp = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 322);
        EscherSimpleProperty bottomProp = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 323);
        if (rightProp != null) {
            w = rightProp.getPropertyValue();
        }
        if (bottomProp != null) {
            h = bottomProp.getPropertyValue();
        }
        Matrix m = new Matrix();
        if (w > 0.0f && h > 0.0f) {
            m.postScale((float)rect.width / w, (float)rect.height / h);
        }
        ArrowPathAndTail arrowPathAndTail = null;
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 465);
        if (prop != null && prop.getPropertyValue() > 0) {
            int i;
            Arrow arrow = new Arrow((byte)prop.getPropertyValue(), ShapeKit.getEndArrowWidth(_escherContainer), ShapeKit.getEndArrowLength(_escherContainer));
            int lineWidth = Math.round((float)ShapeKit.getLineWidth(_escherContainer) * 1.3333334f);
            int numPoints = verticesProp.getNumberOfElementsInArray();
            int numSegments = segmentsProp.getNumberOfElementsInArray();
            int j = 0;
            for (i = 0; i < numSegments && j < numPoints; ++i) {
                byte[] elem = segmentsProp.getElement(i);
                if (Arrays.equals(elem, SEGMENTINFO_MOVETO)) {
                    ++j;
                    continue;
                }
                if (Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO1) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE2)) {
                    if (j + 3 > numPoints) continue;
                    j += 3;
                    continue;
                }
                if (!Arrays.equals(elem, SEGMENTINFO_LINETO) && !Arrays.equals(elem, SEGMENTINFO_LINETO2) && !Arrays.equals(elem, SEGMENTINFO_ESCAPE) && !Arrays.equals(elem, SEGMENTINFO_ESCAPE1) || j + 1 > numPoints) continue;
                ++j;
            }
            byte[] elem = segmentsProp.getElement(i);
            while ((Arrays.equals(elem, SEGMENTINFO_CLOSE) || Arrays.equals(elem, SEGMENTINFO_END)) && i > 0) {
                elem = segmentsProp.getElement(i--);
            }
            if (Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO1) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE2)) {
                p0 = verticesProp.getElement(numPoints - 4);
                byte[] p1 = verticesProp.getElement(numPoints - 3);
                byte[] p2 = verticesProp.getElement(numPoints - 2);
                byte[] p3 = verticesProp.getElement(numPoints - 1);
                float x0 = 0.0f;
                float y0 = 0.0f;
                float x1 = 0.0f;
                float y1 = 0.0f;
                float x2 = 0.0f;
                float y2 = 0.0f;
                float x3 = 0.0f;
                float y3 = 0.0f;
                if (p0.length == 8 && p1.length == 8 && p2.length == 8 && p3.length == 8) {
                    x0 = LittleEndian.getInt(p0, 0);
                    y0 = LittleEndian.getInt(p0, 4);
                    x1 = LittleEndian.getInt(p1, 0);
                    y1 = LittleEndian.getInt(p1, 4);
                    x2 = LittleEndian.getInt(p2, 0);
                    y2 = LittleEndian.getInt(p2, 4);
                    x3 = LittleEndian.getInt(p3, 0);
                    y3 = LittleEndian.getInt(p3, 4);
                } else {
                    x0 = LittleEndian.getShort(p0, 0);
                    y0 = LittleEndian.getShort(p0, 2);
                    x1 = LittleEndian.getShort(p1, 0);
                    y1 = LittleEndian.getShort(p1, 2);
                    x2 = LittleEndian.getShort(p2, 0);
                    y2 = LittleEndian.getShort(p2, 2);
                    x3 = LittleEndian.getShort(p3, 0);
                    y3 = LittleEndian.getShort(p3, 2);
                }
                arrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(x0, y0, x1, y1, x2, y2, x3, y3, arrow, (int)((float)lineWidth * w / (float)rect.width));
            } else if (Arrays.equals(elem, SEGMENTINFO_MOVETO) || Arrays.equals(elem, SEGMENTINFO_LINETO) || Arrays.equals(elem, SEGMENTINFO_LINETO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE) || Arrays.equals(elem, SEGMENTINFO_ESCAPE1)) {
                p0 = verticesProp.getElement(numPoints - 2);
                byte[] p1 = verticesProp.getElement(numPoints - 1);
                float x0 = 0.0f;
                float y0 = 0.0f;
                float x1 = 0.0f;
                float y1 = 0.0f;
                if (p0.length == 8 && p1.length == 8) {
                    x0 = LittleEndian.getInt(p0, 0);
                    y0 = LittleEndian.getInt(p0, 4);
                    x1 = LittleEndian.getInt(p1, 0);
                    y1 = LittleEndian.getInt(p1, 4);
                } else {
                    x0 = LittleEndian.getShort(p0, 0);
                    y0 = LittleEndian.getShort(p0, 2);
                    x1 = LittleEndian.getShort(p1, 0);
                    y1 = LittleEndian.getShort(p1, 2);
                }
                arrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(x0, y0, x1, y1, arrow, (int)((float)lineWidth * w / (float)rect.width));
            }
        }
        if (arrowPathAndTail != null && arrowPathAndTail.getArrowPath() != null) {
            arrowPathAndTail.getArrowPath().transform(m);
        }
        return arrowPathAndTail;
    }

    public static boolean hasBackgroundFill(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p2 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 447);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        return (p2val & 0x10) != 0;
    }

    public static int getFillType(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 384);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public static int getFillAngle(EscherContainerRecord escherContainer) {
        int angle = 0;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 395);
        if (prop != null) {
            angle = (prop.getPropertyValue() >> 16) % 360;
        }
        return angle;
    }

    public static int getFillFocus(EscherContainerRecord escherContainer) {
        int focus = 0;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 396);
        if (prop != null) {
            focus = prop.getPropertyValue();
        }
        return focus;
    }

    public static boolean isShaderPreset(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 406);
        return prop != null && prop.getPropertyValue() > 0;
    }

    public static int[] getShaderColors(EscherContainerRecord escherContainer) {
        if (ShapeKit.isShaderPreset(escherContainer)) {
            int p2val;
            EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
            EscherArrayProperty shaderColorsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 407);
            EscherSimpleProperty p2 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 447);
            int n = p2val = p2 == null ? 0 : p2.getPropertyValue();
            if (shaderColorsProp != null) {
                int numberOfElements = shaderColorsProp.getNumberOfElementsInArray();
                int[] colors = new int[numberOfElements];
                for (int i = 0; i < numberOfElements; ++i) {
                    byte[] gradienStops = shaderColorsProp.getElement(i);
                    if (gradienStops.length != 8) continue;
                    colors[i] = (p2val & 0x10) == 0 ? -1 : ColorUtil.rgb(gradienStops[0], gradienStops[1], gradienStops[2]);
                }
                return colors;
            }
        }
        return null;
    }

    public static float[] getShaderPositions(EscherContainerRecord escherContainer) {
        EscherOptRecord opt;
        EscherArrayProperty shaderColorsProp;
        if (ShapeKit.isShaderPreset(escherContainer) && (shaderColorsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085), 407)) != null) {
            int numberOfElements = shaderColorsProp.getNumberOfElementsInArray();
            float[] positions = new float[numberOfElements];
            for (int i = 0; i < numberOfElements; ++i) {
                byte[] gradienStops = shaderColorsProp.getElement(i);
                if (gradienStops.length != 8) continue;
                positions[i] = (float)LittleEndian.getInt(gradienStops, 4) / 65536.0f;
            }
            return positions;
        }
        return null;
    }

    public static Color getFillbackColor(EscherContainerRecord escherContainer, Object obj, int type) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p1 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 387);
        EscherSimpleProperty p2 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 447);
        EscherSimpleProperty p3 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 388);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        int alpha = p3 == null ? 255 : p3.getPropertyValue() >> 8 & 0xFF;
        Color clr = null;
        if (p1 != null && ((p2val & 0x10) != 0 || p2val == 0)) {
            clr = new Color(ShapeKit.getColorByIndex(obj, p1.getPropertyValue(), type, false), alpha);
        } else if (p2val == 0 && type == 1) {
            clr = new Color(255, 255, 255);
        }
        return clr;
    }

    public static int getRadialGradientPositionType(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty toLeft = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 397);
        EscherSimpleProperty toTop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 398);
        EscherSimpleProperty toRight = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 399);
        EscherSimpleProperty toBottom = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 400);
        if (toLeft != null && toLeft.getPropertyValue() == 65536 && toRight != null && toRight.getPropertyValue() == 65536 && toTop != null && toTop.getPropertyValue() == 65536 && toBottom != null && toBottom.getPropertyValue() == 65536) {
            return 3;
        }
        if (toLeft != null && toLeft.getPropertyValue() == 32768 && toRight != null && toRight.getPropertyValue() == 32768 && toTop != null && toTop.getPropertyValue() == 32768 && toBottom != null && toBottom.getPropertyValue() == 32768) {
            return 4;
        }
        if (toLeft != null && toLeft.getPropertyValue() == 65536 && toRight != null && toRight.getPropertyValue() == 65536) {
            return 1;
        }
        if (toTop != null && toTop.getPropertyValue() == 65536 && toBottom != null && toBottom.getPropertyValue() == 65536) {
            return 2;
        }
        return 0;
    }

    public static int getRotation(EscherContainerRecord escherContainer) {
        int rot = ShapeKit.getEscherProperty(escherContainer, (short)4);
        return (rot >> 16) % 360;
    }

    public static boolean getFlipHorizontal(EscherContainerRecord escherContainer) {
        EscherSpRecord spRecord = (EscherSpRecord)escherContainer.getChildById((short)-4086);
        return (spRecord.getFlags() & 0x40) != 0;
    }

    public static boolean getFlipVertical(EscherContainerRecord escherContainer) {
        EscherSpRecord spRecord = (EscherSpRecord)escherContainer.getChildById((short)-4086);
        return (spRecord.getFlags() & 0x80) != 0;
    }

    public static Float[] getAdjustmentValue(EscherContainerRecord escherContainer) {
        Float[] adjusts = null;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        if (opt != null) {
            int i;
            int maxIndex = 0;
            HashMap<Integer, Integer> indexAdjusts = new HashMap<Integer, Integer>();
            EscherSimpleProperty prop = null;
            for (i = 0; i < 10; ++i) {
                prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 327 + i);
                if (prop == null) continue;
                indexAdjusts.put(i, prop.getPropertyValue());
                if (i <= maxIndex) continue;
                maxIndex = i;
            }
            if (indexAdjusts.size() > 0) {
                adjusts = new Float[maxIndex + 1];
                for (i = 0; i <= maxIndex; ++i) {
                    Integer value = (Integer)indexAdjusts.get(i);
                    if (value == null) continue;
                    adjusts[i] = Float.valueOf((float)value.intValue() / 21600.0f);
                }
            }
        }
        return adjusts;
    }

    public static Path[] getFreeformPath(EscherContainerRecord escherContainer, Rectangle rect, PointF startArrowTailCenter, byte startArrowType, PointF endArrowTailCenter, byte endArrowType) {
        EscherArrayProperty segmentsProp;
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        opt.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16709);
        if (verticesProp == null) {
            verticesProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 325);
        }
        if ((segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 16710)) == null) {
            segmentsProp = (EscherArrayProperty)ShapeKit.getEscherProperty(opt, 326);
        }
        if (verticesProp == null) {
            return null;
        }
        if (segmentsProp == null) {
            return null;
        }
        float w = 0.0f;
        float h = 0.0f;
        EscherSimpleProperty rightProp = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 322);
        EscherSimpleProperty bottomProp = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 323);
        if (rightProp != null && rightProp.getPropertyValue() == 1000 && bottomProp != null && bottomProp.getPropertyValue() == 1000) {
            float a1 = 0.0f;
            float a3 = 0.0f;
            EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 327);
            if (prop != null) {
                a1 = (float)prop.getPropertyValue() / 1000.0f;
            }
            if ((prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 329)) != null) {
                a3 = (float)prop.getPropertyValue() / 1000.0f;
            }
            ArrayList<Path> paths = new ArrayList<Path>();
            Path path = new Path();
            path.moveTo(0.0f, 0.0f);
            path.lineTo((float)rect.width, 0.0f);
            path.lineTo((float)rect.width, (float)rect.height * a3);
            path.lineTo((float)rect.width * a1, (float)rect.height * a3);
            path.lineTo((float)rect.width * a1, (float)rect.height);
            path.lineTo(0.0f, (float)rect.height);
            path.close();
            paths.add(path);
            return paths.toArray(new Path[paths.size()]);
        }
        if (rightProp != null) {
            w = rightProp.getPropertyValue();
        }
        if (bottomProp != null) {
            h = bottomProp.getPropertyValue();
        }
        Matrix m = new Matrix();
        if (w > 0.0f && h > 0.0f) {
            m.postScale((float)rect.width / w, (float)rect.height / h);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        Path path = null;
        int numPoints = verticesProp.getNumberOfElementsInArray();
        int numSegments = segmentsProp.getNumberOfElementsInArray();
        path = new Path();
        int j = 0;
        for (int i = 0; i < numSegments && j <= numPoints; ++i) {
            int y3;
            int x3;
            int y2;
            int x2;
            int y1;
            int x1;
            byte[] p1;
            byte[] p;
            byte[] elem = segmentsProp.getElement(i);
            if (j == 0 && startArrowTailCenter != null) {
                if (Arrays.equals(elem, SEGMENTINFO_MOVETO)) {
                    if ((p = verticesProp.getElement(j++)).length == 8) {
                        x = LittleEndian.getInt(p, 0);
                        y = LittleEndian.getInt(p, 4);
                        startArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(x, y, startArrowTailCenter.x, startArrowTailCenter.y, startArrowType);
                    } else {
                        x = LittleEndian.getShort(p, 0);
                        y = LittleEndian.getShort(p, 2);
                        startArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(x, y, startArrowTailCenter.x, startArrowTailCenter.y, startArrowType);
                    }
                    path.moveTo(startArrowTailCenter.x, startArrowTailCenter.y);
                    continue;
                }
            } else if (endArrowTailCenter != null) {
                if ((Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO1) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE2)) && j == numPoints - 3) {
                    if (j + 3 <= numPoints) {
                        p1 = verticesProp.getElement(j++);
                        byte[] p2 = verticesProp.getElement(j++);
                        byte[] p3 = verticesProp.getElement(j++);
                        if (p1.length == 8 && p2.length == 8 && p3.length == 8) {
                            x1 = LittleEndian.getInt(p1, 0);
                            y1 = LittleEndian.getInt(p1, 4);
                            x2 = LittleEndian.getInt(p2, 0);
                            y2 = LittleEndian.getInt(p2, 4);
                            x3 = LittleEndian.getInt(p3, 0);
                            y3 = LittleEndian.getInt(p3, 4);
                            endArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(x3, y3, endArrowTailCenter.x, endArrowTailCenter.y, endArrowType);
                            if (path != null) {
                                path.cubicTo((float)x1, (float)y1, (float)x2, (float)y2, endArrowTailCenter.x, endArrowTailCenter.y);
                                continue;
                            }
                        } else {
                            x1 = LittleEndian.getShort(p1, 0);
                            y1 = LittleEndian.getShort(p1, 2);
                            x2 = LittleEndian.getShort(p2, 0);
                            y2 = LittleEndian.getShort(p2, 2);
                            x3 = LittleEndian.getShort(p3, 0);
                            y3 = LittleEndian.getShort(p3, 2);
                            endArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(x3, y3, endArrowTailCenter.x, endArrowTailCenter.y, endArrowType);
                            if (path != null) {
                                path.cubicTo((float)x1, (float)y1, (float)x2, (float)y2, endArrowTailCenter.x, endArrowTailCenter.y);
                                continue;
                            }
                        }
                    }
                } else if ((Arrays.equals(elem, SEGMENTINFO_LINETO) || Arrays.equals(elem, SEGMENTINFO_LINETO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE) || Arrays.equals(elem, SEGMENTINFO_ESCAPE1)) && j == numPoints - 1 && j + 1 <= numPoints) {
                    if ((p = verticesProp.getElement(j++)).length == 8) {
                        int x = LittleEndian.getInt(p, 0);
                        int y = LittleEndian.getInt(p, 4);
                        endArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(x, y, endArrowTailCenter.x, endArrowTailCenter.y, endArrowType);
                        if (path != null) {
                            path.lineTo(endArrowTailCenter.x, endArrowTailCenter.y);
                            continue;
                        }
                    } else {
                        short x = LittleEndian.getShort(p, 0);
                        short y = LittleEndian.getShort(p, 2);
                        endArrowTailCenter = LineArrowPathBuilder.getReferencedPosition(x, y, endArrowTailCenter.x, endArrowTailCenter.y, endArrowType);
                        if (path != null) {
                            path.lineTo(endArrowTailCenter.x, endArrowTailCenter.y);
                            continue;
                        }
                    }
                }
            }
            if (Arrays.equals(elem, SEGMENTINFO_MOVETO)) {
                int y;
                int x;
                if ((p = verticesProp.getElement(j++)).length == 8) {
                    x = LittleEndian.getInt(p, 0);
                    y = LittleEndian.getInt(p, 4);
                    path.moveTo((float)x, (float)y);
                    continue;
                }
                x = LittleEndian.getShort(p, 0);
                y = LittleEndian.getShort(p, 2);
                path.moveTo((float)x, (float)y);
                continue;
            }
            if (Arrays.equals(elem, SEGMENTINFO_CUBICTO) || Arrays.equals(elem, SEGMENTINFO_CUBICTO1) || Arrays.equals(elem, SEGMENTINFO_CUBICTO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE2)) {
                if (j + 3 > numPoints) continue;
                p1 = verticesProp.getElement(j++);
                byte[] p2 = verticesProp.getElement(j++);
                byte[] p3 = verticesProp.getElement(j++);
                if (p1.length == 8 && p2.length == 8 && p3.length == 8) {
                    x1 = LittleEndian.getInt(p1, 0);
                    y1 = LittleEndian.getInt(p1, 4);
                    x2 = LittleEndian.getInt(p2, 0);
                    y2 = LittleEndian.getInt(p2, 4);
                    x3 = LittleEndian.getInt(p3, 0);
                    y3 = LittleEndian.getInt(p3, 4);
                    if (path == null) continue;
                    path.cubicTo((float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3);
                    continue;
                }
                x1 = LittleEndian.getShort(p1, 0);
                y1 = LittleEndian.getShort(p1, 2);
                x2 = LittleEndian.getShort(p2, 0);
                y2 = LittleEndian.getShort(p2, 2);
                x3 = LittleEndian.getShort(p3, 0);
                y3 = LittleEndian.getShort(p3, 2);
                if (path == null) continue;
                path.cubicTo((float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3);
                continue;
            }
            if (Arrays.equals(elem, SEGMENTINFO_LINETO) || Arrays.equals(elem, SEGMENTINFO_LINETO2) || Arrays.equals(elem, SEGMENTINFO_ESCAPE) || Arrays.equals(elem, SEGMENTINFO_ESCAPE1)) {
                int y;
                int x;
                if (j + 1 > numPoints) continue;
                if ((p = verticesProp.getElement(j++)).length == 8) {
                    x = LittleEndian.getInt(p, 0);
                    y = LittleEndian.getInt(p, 4);
                    if (path == null) continue;
                    path.lineTo((float)x, (float)y);
                    continue;
                }
                x = LittleEndian.getShort(p, 0);
                y = LittleEndian.getShort(p, 2);
                if (path == null) continue;
                path.lineTo((float)x, (float)y);
                continue;
            }
            if (Arrays.equals(elem, SEGMENTINFO_CLOSE)) {
                if (path == null) continue;
                path.close();
                continue;
            }
            if (!Arrays.equals(elem, SEGMENTINFO_END)) continue;
        }
        if (path != null) {
            if (Math.abs(w) < 1.0f || Math.abs(h) < 1.0f) {
                RectF pathBounds = new RectF();
                path.computeBounds(pathBounds, false);
                m.postScale((float)rect.width / pathBounds.width(), (float)rect.height / pathBounds.height());
            }
            path.transform(m);
            paths.add(path);
        }
        return paths.toArray(new Path[paths.size()]);
    }

    public static int getColorByIndex(Object obj, int rgb, int type, boolean lineColor) {
        if (rgb >= 0x100001F0) {
            if (type == 2) {
                return -1;
            }
            return -16777216;
        }
        if (rgb >= 0x8000000) {
            int index = rgb % 0x8000000;
            if (type == 2) {
                Sheet sheet = (Sheet)obj;
                if (sheet != null && index >= 0 && index <= 7) {
                    ColorSchemeAtom ca = sheet.getColorScheme();
                    if (ca != null) {
                        index = ca.getColor(index);
                    }
                    if (index <= 0xFFFFFF) {
                        int r = index & 0xFF;
                        int g = (index & 0xFF00) >> 8;
                        int b = (index & 0xFF0000) >> 16;
                        rgb = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
                    }
                }
            } else if (type == 1) {
                if (rgb <= 134217793) {
                    AWorkbook workbook;
                    if (index >= 64) {
                        index = index % 64 + 8;
                    }
                    if ((workbook = (AWorkbook)obj) != null) {
                        rgb = workbook.getColor(index, lineColor);
                    }
                } else {
                    rgb = lineColor ? -16777216 : -1;
                }
            } else {
                switch (index) {
                    case 1: {
                        rgb = -16777216;
                        break;
                    }
                    case 2: {
                        rgb = -16776961;
                        break;
                    }
                    case 3: {
                        rgb = -16711681;
                        break;
                    }
                    case 4: {
                        rgb = -16711936;
                        break;
                    }
                    case 5: {
                        rgb = -65281;
                        break;
                    }
                    case 6: {
                        rgb = -65536;
                        break;
                    }
                    case 7: {
                        rgb = -256;
                        break;
                    }
                    case 8: {
                        rgb = -1;
                        break;
                    }
                    case 9: {
                        rgb = -16776961;
                        break;
                    }
                    case 10: {
                        rgb = -12303292;
                        break;
                    }
                    case 11: {
                        rgb = -16711936;
                        break;
                    }
                    case 12: {
                        rgb = -65281;
                        break;
                    }
                    case 13: {
                        rgb = -65536;
                        break;
                    }
                    case 14: {
                        rgb = -256;
                        break;
                    }
                    case 15: {
                        rgb = -7829368;
                        break;
                    }
                    case 16: {
                        rgb = -3355444;
                        break;
                    }
                }
            }
        } else if (rgb <= 0xFFFFFF) {
            int r = rgb & 0xFF;
            int g = (rgb & 0xFF00) >> 8;
            int b = (rgb & 0xFF0000) >> 16;
            rgb = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        }
        return rgb;
    }

    public static Color getLineColor(EscherContainerRecord escherContainer, Object obj, int type) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p1 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 448);
        EscherSimpleProperty p2 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 511);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        Color clr = null;
        if ((p2val & 8) != 0) {
            clr = p1 != null ? new Color(ShapeKit.getColorByIndex(obj, p1.getPropertyValue(), type, true)) : new Color(0, 0, 0);
        } else if (type != 2) {
            int rgb;
            if (p1 == null && type != 0) {
                return clr;
            }
            int n = rgb = p1 == null ? 0 : p1.getPropertyValue();
            if (rgb >= 0x8000000) {
                rgb = ShapeKit.getColorByIndex(obj, rgb % 0x8000000, type, true);
            }
            Color tmp = new Color(rgb, true);
            clr = new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
        }
        return clr;
    }

    public static Color getForegroundColor(EscherContainerRecord escherContainer, Object obj, int type) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p1 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 385);
        EscherSimpleProperty p2 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 447);
        EscherSimpleProperty p3 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 386);
        EscherComplexProperty p4 = (EscherComplexProperty)ShapeKit.getEscherProperty(opt, 261);
        int p2val = p2 == null ? 0 : p2.getPropertyValue();
        int alpha = p3 == null ? 255 : p3.getPropertyValue() * 255 / 65536;
        Color clr = null;
        if (p1 != null && ((p2val & 0x10) != 0 || p2val == 0)) {
            clr = new Color(ShapeKit.getColorByIndex(obj, p1.getPropertyValue(), type, false), alpha);
        } else if ((p2val & 0x10) != 0 && p4 == null) {
            clr = new Color(255, 255, 255, alpha);
        }
        return clr;
    }

    public static boolean getGroupFlipHorizontal(EscherContainerRecord escherContainer) {
        EscherSpRecord spRecord;
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)escherContainer.getChild(0);
        if (groupInfoContainer != null && (spRecord = (EscherSpRecord)groupInfoContainer.getChildById((short)-4086)) != null) {
            return (spRecord.getFlags() & 0x40) != 0;
        }
        return false;
    }

    public static boolean getGroupFlipVertical(EscherContainerRecord escherContainer) {
        EscherSpRecord spRecord;
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)escherContainer.getChild(0);
        if (groupInfoContainer != null && (spRecord = (EscherSpRecord)groupInfoContainer.getChildById((short)-4086)) != null) {
            return (spRecord.getFlags() & 0x80) != 0;
        }
        return false;
    }

    public static int getGroupRotation(EscherContainerRecord escherContainer) {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)escherContainer.getChild(0);
        if (groupInfoContainer != null) {
            int rot = ShapeKit.getEscherProperty(groupInfoContainer, (short)4);
            return (rot >> 16) % 360;
        }
        return 0;
    }

    public static int getPosition_H(EscherContainerRecord escherContainer) {
        EscherTertiaryOptRecord opt = (EscherTertiaryOptRecord)ShapeKit.getEscherChild(escherContainer, -3806);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 911);
        if (p != null) {
            return p.getPropertyValue();
        }
        return 0;
    }

    public static int getPositionRelTo_H(EscherContainerRecord escherContainer) {
        EscherTertiaryOptRecord opt = (EscherTertiaryOptRecord)ShapeKit.getEscherChild(escherContainer, -3806);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 912);
        if (p != null) {
            return p.getPropertyValue();
        }
        return 2;
    }

    public static int getPosition_V(EscherContainerRecord escherContainer) {
        EscherTertiaryOptRecord opt = (EscherTertiaryOptRecord)ShapeKit.getEscherChild(escherContainer, -3806);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 913);
        if (p != null) {
            return p.getPropertyValue();
        }
        return 0;
    }

    public static int getPositionRelTo_V(EscherContainerRecord escherContainer) {
        EscherTertiaryOptRecord opt = (EscherTertiaryOptRecord)ShapeKit.getEscherChild(escherContainer, -3806);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 914);
        if (p != null) {
            return p.getPropertyValue();
        }
        return 2;
    }

    public static String getShapeName(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherComplexProperty complexProp = (EscherComplexProperty)ShapeKit.getEscherProperty(opt, 896);
        if (complexProp != null) {
            return StringUtil.getFromUnicodeLE(complexProp.getComplexData());
        }
        return null;
    }

    public static boolean isTextboxWrapLine(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 133);
        if (p != null) {
            return p.getPropertyValue() != 2;
        }
        return true;
    }

    public static float getTextboxMarginLeft(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 129);
        if (p != null) {
            return (float)p.getPropertyValue() / 9525.0f;
        }
        return 9.6f;
    }

    public static float getTextboxMarginTop(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 130);
        if (p != null) {
            return (float)p.getPropertyValue() / 9525.0f;
        }
        return 4.8f;
    }

    public static float getTextboxMarginRight(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 131);
        if (p != null) {
            return (float)p.getPropertyValue() / 9525.0f;
        }
        return 9.6f;
    }

    public static float getTextboxMarginBottom(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherSimpleProperty p = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 132);
        if (p != null) {
            return (float)p.getPropertyValue() / 9525.0f;
        }
        return 4.8f;
    }

    public static String getUnicodeGeoText(EscherContainerRecord escherContainer) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        EscherComplexProperty complexProp = (EscherComplexProperty)ShapeKit.getEscherProperty(opt, 192);
        if (complexProp != null) {
            return StringUtil.getFromUnicodeLE(complexProp.getComplexData());
        }
        return null;
    }
}

