/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.shape;

import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableCell;

public class TableShape
extends AbstractShape {
    private TableCell[] cells;
    private int rowCnt;
    private int colCnt;
    private boolean shape07 = true;
    private boolean firstRow = false;
    private boolean lastRow = false;
    private boolean firstCol = false;
    private boolean lastCol = false;
    private boolean bandRow = false;
    private boolean bandCol = false;

    public TableShape(int numrows, int numcols) {
        if (numrows < 1) {
            throw new IllegalArgumentException("The number of rows must be greater than 1");
        }
        if (numcols < 1) {
            throw new IllegalArgumentException("The number of columns must be greater than 1");
        }
        this.rowCnt = numrows;
        this.colCnt = numcols;
        this.cells = new TableCell[numrows * numcols];
    }

    @Override
    public short getType() {
        return 6;
    }

    public TableCell getCell(int index) {
        if (index >= this.cells.length) {
            return null;
        }
        return this.cells[index];
    }

    public void addCell(int index, TableCell tableCell) {
        this.cells[index] = tableCell;
    }

    public int getCellCount() {
        return this.cells.length;
    }

    public void setTable07(boolean shape07) {
        this.shape07 = shape07;
    }

    public boolean isTable07() {
        return this.shape07;
    }

    public boolean isFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(boolean firstRow) {
        this.firstRow = firstRow;
    }

    public boolean isLastRow() {
        return this.lastRow;
    }

    public void setLastRow(boolean lastRow) {
        this.lastRow = lastRow;
    }

    public boolean isFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(boolean firstCol) {
        this.firstCol = firstCol;
    }

    public boolean isLastCol() {
        return this.lastCol;
    }

    public void setLastCol(boolean lastCol) {
        this.lastCol = lastCol;
    }

    public boolean isBandRow() {
        return this.bandRow;
    }

    public void setBandRow(boolean bandRow) {
        this.bandRow = bandRow;
    }

    public boolean isBandCol() {
        return this.bandCol;
    }

    public void setBandCol(boolean bandCol) {
        this.bandCol = bandCol;
    }

    public int getRowCount() {
        return this.rowCnt;
    }

    public void setRowCount(int rowCnt) {
        this.rowCnt = rowCnt;
    }

    public int getColumnCount() {
        return this.colCnt;
    }

    public void setColumnCount(int colCnt) {
        this.colCnt = colCnt;
    }

    @Override
    public void dispose() {
        if (this.cells != null) {
            for (int i = 0; i < this.cells.length; ++i) {
                TableCell cell = this.cells[i];
                if (cell == null) continue;
                cell.dispose();
            }
            this.cells = null;
        }
    }
}

