/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class AChart
extends AbstractShape {
    private int picIndex = -1;
    private AbstractChart chart;

    @Override
    public short getType() {
        return 5;
    }

    public void setAChart(AbstractChart chart) {
        this.chart = chart;
    }

    public AbstractChart getAChart() {
        return this.chart;
    }

    private void saveChartToPicture(IControl iControl) {
        Bitmap bitmap = null;
        try {
            int zoomRate = (int)((float)this.rect.width * this.getAChart().getZoomRate());
            int zoomRate2 = (int)((float)this.rect.height * this.getAChart().getZoomRate());
            bitmap = Bitmap.createBitmap((int)zoomRate, (int)zoomRate2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            this.chart.draw(canvas, iControl, 0, 0, zoomRate, zoomRate2, PaintKit.instance().getPaint());
            canvas.restore();
            Picture picture = new Picture();
            File file = new File(iControl.getSysKit().getPictureManage().getPicTempPath() + File.separator + String.valueOf(System.currentTimeMillis()) + ".tmp");
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
            bitmap.recycle();
            fileOutputStream.close();
            picture.setTempFilePath(file.getAbsolutePath());
            this.picIndex = iControl.getSysKit().getPictureManage().addPicture(picture);
        }
        catch (Exception e) {
            if (bitmap != null) {
                bitmap.recycle();
            }
            iControl.getSysKit().getErrorKit().writerLog(e);
        }
    }

    public int getDrawingPicture(IControl control) {
        if (this.picIndex == -1) {
            this.saveChartToPicture(control);
        }
        return this.picIndex;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.chart = null;
    }
}

