/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.picture;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureCroppedInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectUtil;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.FileInputStream;
import java.io.InputStream;

public class PictureKit {
    private static final String FAIL = "Fail";
    private static final PictureKit kit = new PictureKit();
    private static int VectorMaxZOOM = 3;
    private static int VectorMaxSize = 0x100000;
    private Paint paint = new Paint();
    private boolean isDrawPictrue = true;

    public static PictureKit instance() {
        return kit;
    }

    private PictureKit() {
        this.paint.setAntiAlias(true);
    }

    public synchronized void drawPicture(Canvas canvas, IControl control, int viewIndex, Picture pic, float x, float y, float zoom, float destWidth, float destHeight, PictureEffectInfo effectInfor) throws OutOfMemoryError {
        this.drawPicture(canvas, control, viewIndex, pic, x, y, zoom, destWidth, destHeight, effectInfor, null);
    }

    private void applyEffect(Paint paint, PictureEffectInfo effectInfor) {
        if (effectInfor != null) {
            ColorMatrix cMatrix = new ColorMatrix();
            if (effectInfor.getBlackWhiteThreshold() != null) {
                cMatrix.set(PictureEffectUtil.getBlackWhiteArray(effectInfor.getBlackWhiteThreshold().floatValue()));
            } else if (effectInfor.isGrayScale() != null && effectInfor.isGrayScale().booleanValue()) {
                cMatrix.set(PictureEffectUtil.getGrayScaleArray());
            }
            Float brightness = effectInfor.getBrightness();
            Float contrast = effectInfor.getContrast();
            if (brightness != null && contrast != null) {
                ColorMatrix cm = new ColorMatrix();
                cm.set(PictureEffectUtil.getBrightAndContrastArray(brightness.intValue(), contrast.floatValue()));
                cMatrix.preConcat(cm);
            } else if (brightness != null) {
                ColorMatrix cm = new ColorMatrix();
                cm.set(PictureEffectUtil.getBrightnessArray(brightness.intValue()));
                cMatrix.preConcat(cm);
            } else if (contrast != null) {
                ColorMatrix cm = new ColorMatrix();
                cm.set(PictureEffectUtil.getContrastArray(contrast.floatValue()));
                cMatrix.preConcat(cm);
            }
            paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(cMatrix));
        }
    }

    public synchronized void drawPicture(Canvas canvas, IControl control, int viewIndex, Picture pic, float x, float y, float zoom, float destWidth, float destHeight, PictureEffectInfo effectInfor, IAnimation animation) throws OutOfMemoryError {
        if (pic != null && pic.getTempFilePath() != null) {
            if (animation != null && animation.getCurrentAnimationInfor().getAlpha() == 0) {
                return;
            }
            String ret = this.drawPicture(canvas, control, viewIndex, pic.getTempFilePath(), pic.getPictureType(), null, x, y, zoom, destWidth, destHeight, effectInfor, animation);
            if (ret != null) {
                if (ret.equalsIgnoreCase(FAIL)) {
                    pic.setTempFilePath(null);
                } else {
                    pic.setPictureType((byte)6);
                    pic.setTempFilePath(ret);
                }
            }
        }
    }

    private boolean drawCropedPicture(Canvas canvas, float x, float y, float destWidth, float destHeight, Bitmap sBitmap, PictureCroppedInfo croppedInfor) {
        if (croppedInfor != null) {
            Rect destCrop = null;
            Rect srcCrop = null;
            int srcWidth = sBitmap.getWidth();
            int srcHeight = sBitmap.getHeight();
            int left = (int)((float)srcWidth * croppedInfor.getLeftOff());
            int top = (int)((float)srcHeight * croppedInfor.getTopOff());
            int right = (int)((float)srcWidth * (1.0f - croppedInfor.getRightOff()));
            int bottom = (int)((float)srcHeight * (1.0f - croppedInfor.getBottomOff()));
            destCrop = new Rect(left, top, right, bottom);
            left = left >= 0 ? left : 0;
            top = top >= 0 ? top : 0;
            right = right >= srcWidth ? srcWidth : right;
            bottom = bottom >= srcHeight ? srcHeight : bottom;
            srcCrop = new Rect(left, top, right, bottom);
            canvas.save();
            Matrix matrix = new Matrix();
            float zoomX = destWidth / (float)destCrop.width();
            float zoomY = destHeight / (float)destCrop.height();
            matrix.postScale(zoomX, zoomY);
            float offX = (float)destCrop.left * zoomX;
            float offY = (float)destCrop.top * zoomY;
            matrix.postTranslate(x - offX, y - offY);
            offX = offX >= 0.0f ? 0.0f : offX;
            offY = offY >= 0.0f ? 0.0f : offY;
            canvas.clipRect(x - offX, y - offY, x - offX + (float)srcCrop.width() * zoomX, y - offY + (float)srcCrop.height() * zoomY);
            canvas.drawBitmap(sBitmap, matrix, this.paint);
            canvas.restore();
        }
        return true;
    }

    private String drawPicture(Canvas canvas, IControl control, int viewIndex, String path, byte imageType, BitmapFactory.Options options, float x, float y, float zoom, float destWidth, float destHeight, PictureEffectInfo effectInfor, IAnimation animation) {
        try {
            Bitmap bmp;
            Bitmap sBitmap = control.getSysKit().getPictureManage().getBitmap(path);
            if (sBitmap == null) {
                if (!this.isDrawPictrue()) {
                    return null;
                }
                if (control.getSysKit().getPictureManage().isConverting(path)) {
                    control.getSysKit().getPictureManage().appendViewIndex(path, viewIndex);
                    return null;
                }
                if (imageType == 3 || imageType == 2) {
                    int h;
                    int w;
                    if (control.isSlideShow()) {
                        control.getSysKit().getAnimationManager().killAnimationTimer();
                    }
                    if ((w = (int)(destWidth / zoom)) * (h = (int)(destHeight / zoom)) < VectorMaxSize) {
                        double z = Math.sqrt(VectorMaxSize / (w * h));
                        if (z > (double)VectorMaxZOOM) {
                            z = VectorMaxZOOM;
                        }
                        w = (int)Math.round((double)w * z);
                        h = (int)Math.round((double)h * z);
                    }
                    String dst = control.getSysKit().getPictureManage().convertVectorgraphToPng(viewIndex, imageType, path, w, h, control.isSlideShow());
                    if (control.isSlideShow()) {
                        control.getSysKit().getAnimationManager().restartAnimationTimer();
                        control.actionEvent(-268435456, null);
                    }
                    return dst;
                }
                try {
                    FileInputStream in = new FileInputStream(path);
                    sBitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)options);
                    if (sBitmap == null) {
                        if (control.isSlideShow()) {
                            control.getSysKit().getAnimationManager().killAnimationTimer();
                        }
                        String dst = null;
                        if (imageType == 5) {
                            dst = control.getSysKit().getPictureManage().convertToPng(viewIndex, path, "jpeg", control.isSlideShow());
                        } else if (imageType == 6) {
                            dst = control.getSysKit().getPictureManage().convertToPng(viewIndex, path, "png", control.isSlideShow());
                        }
                        if (control.isSlideShow()) {
                            control.getSysKit().getAnimationManager().restartAnimationTimer();
                            control.actionEvent(-268435456, null);
                        }
                        return dst;
                    }
                }
                catch (Exception e) {
                    return FAIL;
                }
                if (sBitmap == null) {
                    return FAIL;
                }
                control.getSysKit().getPictureManage().addBitmap(path, sBitmap);
            }
            if (animation != null) {
                ShapeAnimation shapeAnim = animation.getShapeAnimation();
                int paraBegin = shapeAnim.getParagraphBegin();
                int paraEnd = shapeAnim.getParagraphEnd();
                if (paraBegin == -2 && paraEnd == -2 || paraBegin == -1 && paraEnd == -1) {
                    int a = animation.getCurrentAnimationInfor().getAlpha();
                    this.paint.setAlpha(a);
                    float rate = (float)a / 255.0f * 0.5f;
                    float centerX = x + destWidth / 2.0f;
                    float centerY = y + destHeight / 2.0f;
                    x = centerX - destWidth * rate;
                    y = centerY - destHeight * rate;
                    destWidth *= rate * 2.0f;
                    destHeight *= rate * 2.0f;
                }
            }
            boolean isTransparentBMP = false;
            if (effectInfor != null && effectInfor.getTransparentColor() != null && (bmp = this.createTransparentBitmapFromBitmap(sBitmap, effectInfor.getTransparentColor())) != null) {
                sBitmap = bmp;
                isTransparentBMP = true;
            }
            if (effectInfor != null && effectInfor.getAlpha() != null) {
                this.paint.setAlpha(effectInfor.getAlpha().intValue());
            }
            this.applyEffect(this.paint, effectInfor);
            this.paint.setAntiAlias(true);
            this.paint.setFilterBitmap(true);
            if (effectInfor == null || effectInfor.getPictureCroppedInfor() == null) {
                Matrix matrix = new Matrix();
                matrix.postScale(destWidth / (float)sBitmap.getWidth(), destHeight / (float)sBitmap.getHeight());
                matrix.postTranslate(x, y);
                canvas.drawBitmap(sBitmap, matrix, this.paint);
            } else {
                this.drawCropedPicture(canvas, x, y, destWidth, destHeight, sBitmap, effectInfor.getPictureCroppedInfor());
            }
            this.paint.reset();
            if (isTransparentBMP) {
                sBitmap.recycle();
            }
            return null;
        }
        catch (OutOfMemoryError e) {
            if (control.getSysKit().getPictureManage().hasBitmap()) {
                control.getSysKit().getPictureManage().clearBitmap();
                return this.drawPicture(canvas, control, viewIndex, path, imageType, options, x, y, zoom, destWidth, destHeight, effectInfor, animation);
            }
            if (options == null) {
                options = new BitmapFactory.Options();
                options.inSampleSize = 2;
            } else {
                options.inSampleSize *= 2;
            }
            return this.drawPicture(canvas, control, viewIndex, path, imageType, options, x, y, zoom, destWidth, destHeight, effectInfor, animation);
        }
        catch (Exception e) {
            return FAIL;
        }
    }

    public Bitmap createTransparentBitmapFromBitmap(Bitmap bitmap, int replaceThisColor) {
        if (bitmap != null) {
            int diff = 10;
            int picw = bitmap.getWidth();
            int pich = bitmap.getHeight();
            int[] pix = new int[picw * pich];
            bitmap.getPixels(pix, 0, picw, 0, 0, picw, pich);
            for (int y = 0; y < pich; ++y) {
                for (int x = 0; x < picw; ++x) {
                    int index = y * picw + x;
                    int r = pix[index] >> 16 & 0xFF;
                    int g = pix[index] >> 8 & 0xFF;
                    int b = pix[index] & 0xFF;
                    int tr = replaceThisColor >> 16 & 0xFF;
                    int tg = replaceThisColor >> 8 & 0xFF;
                    int tb = replaceThisColor & 0xFF;
                    if (Math.abs(tr - r) > 10 || Math.abs(tg - g) > 10 || Math.abs(tb - b) > 10) continue;
                    pix[index] = 0;
                }
            }
            return Bitmap.createBitmap((int[])pix, (int)picw, (int)pich, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        }
        return null;
    }

    public void drawPicture(Canvas canvas, IControl control, Bitmap bitmap, float x, float y, boolean zoom, float destWidth, float destHeight) {
        try {
            if (bitmap == null) {
                return;
            }
            Matrix matrix = new Matrix();
            matrix.postScale(destWidth / (float)bitmap.getWidth(), destHeight / (float)bitmap.getHeight());
            matrix.postTranslate(x, y);
            canvas.drawBitmap(bitmap, matrix, this.paint);
        }
        catch (OutOfMemoryError e) {
            control.getSysKit().getErrorKit().writerLog(e);
        }
    }

    public boolean isVectorPicture(Picture pic) {
        byte imageType;
        return pic != null && ((imageType = pic.getPictureType()) == 3 || imageType == 2);
    }

    public boolean isDrawPictrue() {
        return this.isDrawPictrue;
    }

    public void setDrawPictrue(boolean isDrawPictrue) {
        this.isDrawPictrue = isDrawPictrue;
    }
}

