/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;

public class BannerPathBuilder {
    private static Matrix sm = new Matrix();
    private static RectF tempRect = new RectF();
    private static List<ExtendPath> pathExList = new ArrayList<ExtendPath>(2);
    private static final int PICTURECOLOR = -1890233003;
    private static final float TINT = -0.3f;

    public static List<ExtendPath> getFlagExtendPath(AutoShape shape, Rect rect) {
        pathExList.clear();
        switch (shape.getShapeType()) {
            case 54: {
                return BannerPathBuilder.getRibbon2Path(shape, rect);
            }
            case 53: {
                return BannerPathBuilder.getRibbonPath(shape, rect);
            }
            case 108: {
                return BannerPathBuilder.getEllipseRibbon2Path(shape, rect);
            }
            case 107: {
                return BannerPathBuilder.getEllipseRibbonPath(shape, rect);
            }
            case 97: {
                return BannerPathBuilder.getVerticalScrollPath(shape, rect);
            }
            case 98: {
                return BannerPathBuilder.getHorizontalScrollPath(shape, rect);
            }
            case 64: {
                return BannerPathBuilder.getWavePath(shape, rect);
            }
            case 188: {
                return BannerPathBuilder.getDoubleWavePath(shape, rect);
            }
            case 244: {
                return BannerPathBuilder.getLeftRightRibbon(shape, rect);
            }
        }
        return null;
    }

    private static List<ExtendPath> getRibbon2Path(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int width = rect.width();
        int height = rect.height();
        int curleS = width / 8;
        int adj1 = 0;
        int adj2 = 0;
        if (shape.isAutoShape07()) {
            if (values != null && values.length == 2) {
                adj1 = Math.round((float)height * values[0].floatValue());
                adj2 = Math.round((float)(width / 2) * values[1].floatValue());
            } else {
                adj1 = Math.round((float)height * 0.16667f);
                adj2 = Math.round((float)(width / 2) * 0.5f);
            }
        } else if (values != null && values.length >= 1) {
            adj2 = values[0] != null ? Math.round((float)width * (0.5f - values[0].floatValue())) : Math.round((float)width * 0.25f);
            adj1 = values.length >= 2 && values[1] != null ? Math.round((float)height * (1.0f - values[1].floatValue())) : Math.round((float)height * 0.125f);
        } else {
            adj1 = Math.round((float)height * 0.125f);
            adj2 = Math.round((float)width * 0.25f);
        }
        float a = curleS / 4;
        float b = adj1 / 4;
        ExtendPath pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        Path path = new Path();
        path.moveTo((float)rect.left, (float)(rect.top + adj1));
        path.lineTo((float)(rect.left + curleS), (float)(rect.bottom - (height - adj1) / 2));
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - adj2) + a * 3.0f, (float)rect.bottom);
        tempRect.set((float)(rect.centerX() - adj2) + a * 2.0f, (float)rect.bottom - b * 2.0f, (float)(rect.centerX() - adj2 + curleS), (float)rect.bottom);
        path.arcTo(tempRect, 90.0f, -180.0f);
        path.lineTo((float)(rect.centerX() - adj2) + a, (float)rect.bottom - b * 2.0f);
        tempRect.set((float)(rect.centerX() - adj2), (float)rect.bottom - b * 4.0f, (float)(rect.centerX() - adj2) + a * 2.0f, (float)rect.bottom - b * 2.0f);
        path.arcTo(tempRect, 90.0f, 90.0f);
        path.lineTo((float)(rect.centerX() - adj2), (float)(rect.top + adj1));
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.right, (float)(rect.top + adj1));
        path.lineTo((float)(rect.right - curleS), (float)(rect.bottom - (height - adj1) / 2));
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)(rect.centerX() + adj2) - a * 3.0f, (float)rect.bottom);
        tempRect.set((float)(rect.centerX() + adj2) - a * 4.0f, (float)rect.bottom - b * 2.0f, (float)(rect.centerX() + adj2) - 2.0f * a, (float)rect.bottom);
        path.arcTo(tempRect, 90.0f, 180.0f);
        path.lineTo((float)(rect.centerX() + adj2) - a, (float)rect.bottom - b * 2.0f);
        tempRect.set((float)(rect.centerX() + adj2) - 2.0f * a, (float)rect.bottom - b * 4.0f, (float)(rect.centerX() + adj2), (float)rect.bottom - b * 2.0f);
        path.arcTo(tempRect, 90.0f, -90.0f);
        path.lineTo((float)(rect.centerX() + adj2), (float)(rect.top + adj1));
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.centerX() - adj2), (float)rect.top + b);
        tempRect.set((float)(rect.centerX() - adj2), (float)rect.top, (float)(rect.centerX() - adj2) + 2.0f * a, (float)rect.top + b * 2.0f);
        path.arcTo(tempRect, 180.0f, 90.0f);
        path.lineTo((float)(rect.centerX() + adj2) - a, (float)rect.top);
        tempRect.set((float)(rect.centerX() + adj2) - a * 2.0f, (float)rect.top, (float)(rect.centerX() + adj2), (float)rect.top + b * 2.0f);
        path.arcTo(tempRect, 270.0f, 90.0f);
        path.lineTo((float)(rect.centerX() + adj2), (float)rect.bottom - b * 3.0f);
        tempRect.set((float)(rect.centerX() + adj2) - a * 2.0f, (float)rect.bottom - b * 4.0f, (float)(rect.centerX() + adj2), (float)rect.bottom - b * 2.0f);
        path.arcTo(tempRect, 0.0f, -90.0f);
        path.lineTo((float)(rect.centerX() - adj2) + a, (float)rect.bottom - b * 4.0f);
        tempRect.set((float)(rect.centerX() - adj2), (float)rect.bottom - b * 4.0f, (float)(rect.centerX() - adj2) + 2.0f * a, (float)rect.bottom - b * 2.0f);
        path.arcTo(tempRect, 270.0f, -90.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.centerX() - adj2 + curleS), (float)rect.bottom - b * 4.0f);
        path.lineTo((float)(rect.centerX() - adj2) + a, (float)rect.bottom - b * 4.0f);
        tempRect.set((float)(rect.centerX() - adj2), (float)rect.bottom - b * 4.0f, (float)(rect.centerX() - adj2) + a * 2.0f, (float)rect.bottom - b * 2.0f);
        path.arcTo(tempRect, 270.0f, -180.0f);
        path.lineTo((float)(rect.centerX() - adj2) + a * 3.0f, (float)rect.bottom - b * 2.0f);
        tempRect.set((float)(rect.centerX() - adj2) + a * 2.0f, (float)rect.bottom - b * 2.0f, (float)(rect.centerX() - adj2) + a * 4.0f, (float)rect.bottom);
        path.arcTo(tempRect, 270.0f, 90.0f);
        path.close();
        BackgroundAndFill fill = new BackgroundAndFill();
        fill.setFillType((byte)0);
        BackgroundAndFill shapeFill = shape.getBackgroundAndFill();
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExtend.setPath(path);
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.centerX() + adj2 - curleS), (float)rect.bottom - b * 4.0f);
        path.lineTo((float)(rect.centerX() + adj2) - a, (float)rect.bottom - b * 4.0f);
        tempRect.set((float)(rect.centerX() + adj2) - a * 2.0f, (float)rect.bottom - b * 4.0f, (float)(rect.centerX() + adj2), (float)rect.bottom - b * 2.0f);
        path.arcTo(tempRect, 270.0f, 180.0f);
        path.lineTo((float)(rect.centerX() + adj2) - a * 3.0f, (float)rect.bottom - b * 2.0f);
        tempRect.set((float)(rect.centerX() + adj2) - a * 4.0f, (float)rect.bottom - b * 2.0f, (float)(rect.centerX() + adj2) - a * 2.0f, (float)rect.bottom);
        path.arcTo(tempRect, 270.0f, -90.0f);
        path.close();
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExtend.setPath(path);
        pathExList.add(pathExtend);
        return pathExList;
    }

    private static List<ExtendPath> getRibbonPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int width = rect.width();
        int height = rect.height();
        int curleS = width / 8;
        float adj1 = 0.0f;
        float adj2 = 0.0f;
        if (shape.isAutoShape07()) {
            if (values != null && values.length == 2) {
                adj1 = Math.round((float)height * values[0].floatValue());
                adj2 = Math.round((float)(width / 2) * values[1].floatValue());
            } else {
                adj1 = Math.round((float)height * 0.16667f);
                adj2 = Math.round((float)(width / 2) * 0.5f);
            }
        } else if (values != null && values.length >= 1) {
            adj2 = values[0] != null ? (float)Math.round((float)width * (0.5f - values[0].floatValue())) : (float)Math.round((float)width * 0.25f);
            adj1 = values.length >= 2 && values[1] != null ? (float)Math.round((float)height * values[1].floatValue()) : (float)Math.round((float)height * 0.125f);
        } else {
            adj1 = Math.round((float)height * 0.125f);
            adj2 = Math.round((float)width * 0.25f);
        }
        float a = curleS / 4;
        float b = adj1 / 4.0f;
        ExtendPath pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        Path path = new Path();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)(rect.left + curleS), (float)rect.top + ((float)height - adj1) / 2.0f);
        path.lineTo((float)rect.left, (float)rect.top + ((float)height - adj1));
        path.lineTo((float)rect.centerX() - adj2, (float)rect.top + ((float)height - adj1));
        tempRect.set((float)rect.centerX() - adj2, (float)rect.top + b * 2.0f, (float)rect.centerX() - adj2 + a * 2.0f, (float)rect.top + b * 4.0f);
        path.arcTo(tempRect, 180.0f, 90.0f);
        path.lineTo((float)rect.centerX() - adj2 + a * 3.0f, (float)rect.top + b * 2.0f);
        tempRect.set((float)rect.centerX() - adj2 + a * 2.0f, (float)rect.top, (float)rect.centerX() - adj2 + a * 4.0f, (float)rect.top + b * 2.0f);
        path.arcTo(tempRect, 90.0f, -180.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.centerX() - adj2 + a, (float)rect.bottom);
        tempRect.set((float)rect.centerX() - adj2, (float)rect.bottom - b * 2.0f, (float)rect.centerX() - adj2 + a * 2.0f, (float)rect.bottom);
        path.arcTo(tempRect, 90.0f, 90.0f);
        path.lineTo((float)rect.centerX() - adj2, (float)rect.top + b * 3.0f);
        tempRect.set((float)rect.centerX() - adj2, (float)rect.top + b * 2.0f, (float)rect.centerX() - adj2 + a * 2.0f, (float)rect.top + b * 4.0f);
        path.arcTo(tempRect, 180.0f, -90.0f);
        path.lineTo((float)rect.centerX() + adj2 - a, (float)rect.top + b * 4.0f);
        tempRect.set((float)rect.centerX() + adj2 - a * 2.0f, (float)rect.top + b * 2.0f, (float)rect.centerX() + adj2, (float)rect.top + b * 4.0f);
        path.arcTo(tempRect, 90.0f, -90.0f);
        path.lineTo((float)rect.centerX() + adj2, (float)rect.bottom - b);
        tempRect.set((float)rect.centerX() + adj2 - a * 2.0f, (float)rect.bottom - b * 2.0f, (float)rect.centerX() + adj2, (float)rect.bottom);
        path.arcTo(tempRect, 0.0f, 90.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.right, (float)rect.top);
        path.lineTo((float)(rect.right - curleS), (float)rect.top + ((float)height - adj1) / 2.0f);
        path.lineTo((float)rect.right, (float)rect.top + ((float)height - adj1));
        path.lineTo((float)rect.centerX() + adj2, (float)rect.top + ((float)height - adj1));
        tempRect.set((float)rect.centerX() + adj2 - a * 2.0f, (float)rect.top + b * 2.0f, (float)rect.centerX() + adj2, (float)rect.top + b * 4.0f);
        path.arcTo(tempRect, 0.0f, -90.0f);
        path.lineTo((float)rect.centerX() + adj2 - a * 3.0f, (float)rect.top + b * 2.0f);
        tempRect.set((float)rect.centerX() + adj2 - a * 4.0f, (float)rect.top, (float)rect.centerX() + adj2 - a * 2.0f, (float)rect.top + b * 2.0f);
        path.arcTo(tempRect, 90.0f, 180.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.centerX() - adj2 + a, (float)rect.top + b * 4.0f);
        tempRect.set((float)rect.centerX() - adj2, (float)rect.top + b * 2.0f, (float)rect.centerX() - adj2 + a * 2.0f, (float)rect.top + b * 4.0f);
        path.arcTo(tempRect, 90.0f, 180.0f);
        path.lineTo((float)rect.centerX() - adj2 + a * 3.0f, (float)rect.top + b * 2.0f);
        tempRect.set((float)rect.centerX() - adj2 + a * 2.0f, (float)rect.top, (float)rect.centerX() - adj2 + a * 4.0f, (float)rect.top + b * 2.0f);
        path.arcTo(tempRect, 90.0f, -90.0f);
        path.lineTo((float)rect.centerX() - adj2 + (float)curleS, (float)rect.top + b * 4.0f);
        path.close();
        BackgroundAndFill fill = new BackgroundAndFill();
        fill.setFillType((byte)0);
        BackgroundAndFill shapeFill = shape.getBackgroundAndFill();
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExtend.setPath(path);
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.centerX() + adj2 - a, (float)rect.top + b * 4.0f);
        tempRect.set((float)rect.centerX() + adj2 - a * 2.0f, (float)rect.top + b * 2.0f, (float)rect.centerX() + adj2, (float)rect.top + b * 4.0f);
        path.arcTo(tempRect, 90.0f, -180.0f);
        path.lineTo((float)rect.centerX() + adj2 - a * 3.0f, (float)rect.top + b * 2.0f);
        tempRect.set((float)rect.centerX() + adj2 - a * 4.0f, (float)rect.top, (float)rect.centerX() + adj2 - a * 2.0f, (float)rect.top + b * 2.0f);
        path.arcTo(tempRect, 90.0f, 90.0f);
        path.lineTo((float)rect.centerX() + adj2 - (float)curleS, (float)rect.top + b * 4.0f);
        path.close();
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExtend.setPath(path);
        pathExList.add(pathExtend);
        return pathExList;
    }

    private static List<ExtendPath> getEllipseRibbon2Path(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        float len = Math.min(rect.width(), rect.height());
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        float fU = 0.5f;
        if (shape.isAutoShape07()) {
            if (values != null && values.length == 3) {
                if (values[0].floatValue() - values[2].floatValue() > 0.2f) {
                    values[2] = Float.valueOf(values[0].floatValue() - 0.2f);
                }
                if (values[1].floatValue() > 0.75f) {
                    values[1] = Float.valueOf(0.75f);
                }
                fU = 0.5f - values[1].floatValue() / 2.0f;
                adj1 = Math.round(len * values[0].floatValue());
                adj2 = Math.round(len / 2.0f * values[1].floatValue());
                adj3 = Math.round(len * values[2].floatValue());
            } else {
                adj1 = Math.round(len * 0.25f);
                adj2 = Math.round(len / 2.0f * 0.5f);
                adj3 = Math.round(len * 0.125f);
                fU = 0.25f;
            }
        } else if (values != null && values.length >= 1) {
            if (values[0] != null) {
                fU = values[0].floatValue();
                adj2 = Math.round(len * (0.5f - values[0].floatValue()));
            } else {
                fU = 0.25f;
                adj2 = Math.round(len * 0.25f);
            }
            adj1 = values.length >= 2 && values[1] != null ? Math.round(len * (1.0f - values[1].floatValue())) : Math.round(len * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round(len * values[2].floatValue()) : Math.round(len * 0.125f);
        } else {
            fU = 0.25f;
            adj1 = Math.round(len * 0.25f);
            adj2 = Math.round(len / 2.0f * 0.5f);
            adj3 = Math.round(len * 0.125f);
        }
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        if (adj3 >= adj1) {
            List<PointF> ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, adj1, len, adj1, len / 2.0f, 0.0f, 0.5f);
            ExtendPath pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            Path path = new Path();
            path.moveTo(0.0f, (float)adj1);
            path.cubicTo((ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, (float)adj1);
            path.lineTo(len - len * 0.125f, len / 2.0f);
            path.lineTo(len, len);
            path.cubicTo((ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y + len - (float)adj1, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y + len - (float)adj1, 0.0f, len);
            path.lineTo(len * 0.125f, len / 2.0f);
            path.close();
            path.transform(sm);
            path.offset((float)rect.left, (float)rect.top);
            pathExtend.setPath(path);
            pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
            pathExList.add(pathExtend);
        } else {
            List<PointF> ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, adj1, len, adj1, len / 2.0f, adj1 - adj3, 0.5f);
            PointF p1 = BannerPathBuilder.BezierComputePoint(0.0f, adj1, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, adj1, 0.125f);
            PointF p2 = BannerPathBuilder.BezierComputePoint(0.0f, adj1, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, adj1, fU);
            PointF end = BannerPathBuilder.BezierComputePoint(0.0f, adj1, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, adj1, fU + 0.125f);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, adj1, end.x, end.y, p1.x, p1.y, 0.125f / (fU + 0.125f));
            ExtendPath pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            Path path = new Path();
            path.moveTo(0.0f, (float)adj1);
            path.cubicTo(ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y, ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y, end.x, end.y);
            path.lineTo(end.x, end.y + len - (float)adj1);
            path.cubicTo(ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y + len - (float)adj1, ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y + len - (float)adj1, 0.0f, len);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, (len + (float)adj1) / 2.0f, len, (len + (float)adj1) / 2.0f, len / 2.0f, (len + (float)adj1) / 2.0f - (float)adj3, 0.5f);
            PointF notched = BannerPathBuilder.BezierComputePoint(0.0f, (len + (float)adj1) / 2.0f, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, (len + (float)adj1) / 2.0f, 0.125f);
            path.lineTo(notched.x, notched.y);
            path.close();
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(len - end.x, end.y, len, adj1, len - p1.x, p1.y, 1.0f - 0.125f / (fU + 0.125f));
            path.moveTo(len - end.x, end.y);
            path.cubicTo(ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y, ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y, len, (float)adj1);
            path.lineTo(len - notched.x, notched.y);
            path.lineTo(len, len);
            path.cubicTo(ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y + len - (float)adj1, ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y + len - (float)adj1, len - end.x, end.y + len - (float)adj1);
            path.close();
            path.transform(sm);
            path.offset((float)rect.left, (float)rect.top);
            pathExtend.setPath(path);
            pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
            pathExList.add(pathExtend);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, adj3, len, adj3, len / 2.0f, 0.0f, 0.5f);
            p1 = BannerPathBuilder.BezierComputePoint(0.0f, adj3, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, adj3, fU);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(p1.x, p1.y, len - p1.x, p1.y, len / 2.0f, 0.0f, 0.5f);
            pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            path = new Path();
            path.moveTo(p1.x, p1.y);
            path.cubicTo((ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len - p1.x, p1.y);
            path.lineTo(len - p1.x, p1.y + len - (float)adj1);
            path.cubicTo((ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y + len - (float)adj1, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y + len - (float)adj1, p1.x, p1.y + len - (float)adj1);
            path.close();
            path.moveTo(p1.x, p1.y + len - (float)adj1);
            path.lineTo(end.x, end.y + len - (float)adj1);
            path.moveTo(len - p1.x, p1.y + len - (float)adj1);
            path.lineTo(len - end.x, end.y + len - (float)adj1);
            pathExtend.setPath(path);
            path.transform(sm);
            path.offset((float)rect.left, (float)rect.top);
            pathExtend.setPath(path);
            pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
            pathExList.add(pathExtend);
        }
        return pathExList;
    }

    private static List<ExtendPath> getEllipseRibbonPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        float len = Math.min(rect.width(), rect.height());
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        float fU = 0.5f;
        if (shape.isAutoShape07()) {
            if (values != null && values.length == 3) {
                if (values[0].floatValue() - values[2].floatValue() > 0.2f) {
                    values[2] = Float.valueOf(values[0].floatValue() - 0.2f);
                }
                if (values[1].floatValue() > 0.75f) {
                    values[1] = Float.valueOf(0.75f);
                }
                fU = 0.5f - values[1].floatValue() / 2.0f;
                adj1 = Math.round(len * values[0].floatValue());
                adj2 = Math.round(len / 2.0f * values[1].floatValue());
                adj3 = Math.round(len * values[2].floatValue());
            } else {
                adj1 = Math.round(len * 0.25f);
                adj2 = Math.round(len / 2.0f * 0.5f);
                adj3 = Math.round(len * 0.125f);
                fU = 0.25f;
            }
        } else if (values != null && values.length >= 1) {
            if (values[0] != null) {
                fU = values[0].floatValue();
                adj2 = Math.round(len * (0.5f - values[0].floatValue()));
            } else {
                fU = 0.25f;
                adj2 = Math.round(len * 0.25f);
            }
            adj1 = values.length >= 2 && values[1] != null ? Math.round(len * values[1].floatValue()) : Math.round(len * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round(len * (1.0f - values[2].floatValue())) : Math.round(len * 0.125f);
        } else {
            fU = 0.25f;
            adj1 = Math.round(len * 0.25f);
            adj2 = Math.round(len / 2.0f * 0.5f);
            adj3 = Math.round(len * 0.125f);
        }
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        if (adj3 >= adj1) {
            List<PointF> ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, 0.0f, len, 0.0f, len / 2.0f, adj1, 0.5f);
            ExtendPath pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            Path path = new Path();
            path.moveTo(0.0f, 0.0f);
            path.cubicTo((ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, 0.0f);
            path.lineTo(len - len * 0.125f, len / 2.0f);
            path.lineTo(len, len - (float)adj1);
            path.cubicTo((ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y + len - (float)adj1, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y + len - (float)adj1, 0.0f, len - (float)adj1);
            path.lineTo(len * 0.125f, len / 2.0f);
            path.close();
            path.transform(sm);
            path.offset((float)rect.left, (float)rect.top);
            pathExtend.setPath(path);
            pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
            pathExList.add(pathExtend);
        } else {
            List<PointF> ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, 0.0f, len, 0.0f, len / 2.0f, adj3, 0.5f);
            PointF p1 = BannerPathBuilder.BezierComputePoint(0.0f, 0.0f, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, 0.0f, 0.125f);
            PointF p2 = BannerPathBuilder.BezierComputePoint(0.0f, 0.0f, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, 0.0f, fU);
            PointF end = BannerPathBuilder.BezierComputePoint(0.0f, 0.0f, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, 0.0f, fU + 0.125f);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, 0.0f, end.x, end.y, p1.x, p1.y, 0.125f / (fU + 0.125f));
            ExtendPath pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            Path path = new Path();
            path.moveTo(0.0f, 0.0f);
            path.cubicTo(ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y, ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y, end.x, end.y);
            path.lineTo(end.x, end.y + len - (float)adj1);
            path.cubicTo(ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y + len - (float)adj1, ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y + len - (float)adj1, 0.0f, len - (float)adj1);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, (len - (float)adj1) / 2.0f, len, (len - (float)adj1) / 2.0f, len / 2.0f, (len - (float)adj1) / 2.0f + (float)adj3, 0.5f);
            PointF notched = BannerPathBuilder.BezierComputePoint(0.0f, (len - (float)adj1) / 2.0f, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, (len - (float)adj1) / 2.0f, 0.125f);
            path.lineTo(notched.x, notched.y);
            path.close();
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(len - end.x, end.y, len, 0.0f, len - p1.x, p1.y, 1.0f - 0.125f / (fU + 0.125f));
            path.moveTo(len - end.x, end.y);
            path.cubicTo(ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y, ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y, len, 0.0f);
            path.lineTo(len - notched.x, notched.y);
            path.lineTo(len, len - (float)adj1);
            path.cubicTo(ctrlPoints.get((int)1).x, ctrlPoints.get((int)1).y + len - (float)adj1, ctrlPoints.get((int)0).x, ctrlPoints.get((int)0).y + len - (float)adj1, len - end.x, end.y + len - (float)adj1);
            path.close();
            path.transform(sm);
            path.offset((float)rect.left, (float)rect.top);
            pathExtend.setPath(path);
            pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
            pathExList.add(pathExtend);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(0.0f, len - (float)adj3, len, len - (float)adj3, len / 2.0f, len, 0.5f);
            p1 = BannerPathBuilder.BezierComputePoint(0.0f, len - (float)adj3, (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len, len - (float)adj3, fU);
            ctrlPoints = BannerPathBuilder.computeBezierCtrPoint(p1.x, p1.y, len - p1.x, p1.y, len / 2.0f, len, 0.5f);
            pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            path = new Path();
            path.moveTo(p1.x, p1.y);
            path.cubicTo((ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y, (ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y, len - p1.x, p1.y);
            path.lineTo(len - p1.x, p1.y - (len - (float)adj1));
            path.cubicTo((ctrlPoints.get((int)1).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)1).y - (len - (float)adj1), (ctrlPoints.get((int)0).x + len / 2.0f) / 2.0f, ctrlPoints.get((int)0).y - (len - (float)adj1), p1.x, p1.y - (len - (float)adj1));
            path.close();
            path.moveTo(p1.x, p1.y - (len - (float)adj1));
            path.lineTo(end.x, end.y);
            path.moveTo(len - p1.x, p1.y - (len - (float)adj1));
            path.lineTo(len - end.x, end.y);
            pathExtend.setPath(path);
            path.transform(sm);
            path.offset((float)rect.left, (float)rect.top);
            pathExtend.setPath(path);
            pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
            pathExList.add(pathExtend);
        }
        return pathExList;
    }

    private static List<PointF> computeBezierCtrPoint(float startX, float startY, float p1X, float p1Y, float p2X, float p2Y, float endX, float endY) {
        ArrayList<PointF> ctrlPoints = new ArrayList<PointF>(2);
        PointF ctrAdd1 = new PointF();
        PointF ctrAdd2 = new PointF();
        ctrlPoints.add(0, ctrAdd1);
        ctrlPoints.add(1, ctrAdd2);
        ctrAdd1.x = (-5.0f * startX + 18.0f * p1X - 9.0f * p2X + 2.0f * endX) / 6.0f;
        ctrAdd1.y = (-5.0f * startY + 18.0f * p1Y - 9.0f * p2Y + 2.0f * endY) / 6.0f;
        ctrAdd2.x = (2.0f * startX - 9.0f * p1X + 18.0f * p2X - 5.0f * endX) / 6.0f;
        ctrAdd2.y = (2.0f * startY - 9.0f * p1Y + 18.0f * p2Y - 5.0f * endY) / 6.0f;
        return ctrlPoints;
    }

    private static List<PointF> computeBezierCtrPoint(float startX, float startY, float endX, float endY, float pointX, float pointY, float fU) {
        float EPSINON = 1.0E-5f;
        if (fU < 1.0E-5f && (double)fU - 1.0 > (double)1.0E-5f) {
            return null;
        }
        ArrayList<PointF> ctrlPoints = new ArrayList<PointF>(2);
        PointF ctrAdd1 = new PointF();
        PointF ctrAdd2 = new PointF();
        ctrlPoints.add(0, ctrAdd1);
        ctrlPoints.add(1, ctrAdd2);
        float fBlend = fU;
        float f1subu = 1.0f - fBlend;
        float a = 3.0f * fBlend * f1subu * f1subu;
        float b = 3.0f * fBlend * fBlend * f1subu;
        float c = f1subu * f1subu * f1subu;
        float d = fBlend * fBlend * fBlend;
        float s = fU / f1subu;
        float a1 = a + 3.0f * d;
        float c1 = pointX - c * startX - a * startX - b * endX - d * endX;
        if (a1 < 1.0E-5f) {
            return null;
        }
        ctrAdd1.x = c1 / a1 + startX;
        ctrAdd2.x = s * c1 / a1 + endX;
        c1 = pointY - c * startY - a * startY - b * endY - d * endY;
        if (a1 < 1.0E-5f) {
            return null;
        }
        ctrAdd1.y = c1 / a1 + startY;
        ctrAdd2.y = s * c1 / a1 + endY;
        return ctrlPoints;
    }

    private static PointF BezierComputePoint(float startX, float startY, float ctrl1X, float ctrl1Y, float ctrl2X, float ctrl2Y, float endX, float endY, float fU) {
        PointF p = new PointF();
        float f1subu = 1.0f - fU;
        float fBlend = f1subu * f1subu * f1subu;
        p.x = fBlend * startX;
        p.y = fBlend * startY;
        fBlend = 3.0f * fU * f1subu * f1subu;
        p.x += fBlend * ctrl1X;
        p.y += fBlend * ctrl1Y;
        fBlend = 3.0f * fU * fU * f1subu;
        p.x += fBlend * ctrl2X;
        p.y += fBlend * ctrl2Y;
        fBlend = fU * fU * fU;
        p.x += fBlend * endX;
        p.y += fBlend * endY;
        return p;
    }

    private static List<ExtendPath> getVerticalScrollPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int width = rect.width();
        int height = rect.height();
        int len = Math.min(width, height);
        int adj1 = 0;
        adj1 = values != null && values.length == 1 ? Math.round((float)len * values[0].floatValue()) : Math.round((float)len * 0.125f);
        float radius = (float)adj1 / 2.0f;
        ExtendPath pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        Path path = new Path();
        path.moveTo((float)rect.left + radius, (float)rect.bottom);
        tempRect.set((float)rect.left, (float)(rect.bottom - adj1), (float)(rect.left + adj1), (float)rect.bottom);
        path.arcTo(tempRect, 90.0f, -90.0f);
        path.lineTo((float)(rect.left + adj1), (float)rect.top + radius);
        tempRect.set((float)(rect.left + adj1), (float)rect.top, (float)(rect.left + adj1 * 2), (float)(rect.top + adj1));
        path.arcTo(tempRect, 180.0f, 270.0f);
        path.lineTo((float)(rect.right - adj1), (float)(rect.top + adj1));
        path.lineTo((float)(rect.right - adj1), (float)rect.bottom - radius);
        tempRect.set((float)(rect.right - adj1 * 2), (float)(rect.bottom - adj1), (float)(rect.right - adj1), (float)rect.bottom);
        path.arcTo(tempRect, 0.0f, 90.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.left + radius * 3.0f, (float)rect.top);
        tempRect.set((float)(rect.left + adj1), (float)rect.top, (float)(rect.left + adj1 * 2), (float)(rect.top + adj1));
        path.arcTo(tempRect, 270.0f, 180.0f);
        path.lineTo((float)rect.right - radius, (float)(rect.top + adj1));
        tempRect.set((float)(rect.right - adj1), (float)rect.top, (float)rect.right, (float)(rect.top + adj1));
        path.arcTo(tempRect, 90.0f, -180.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.left + adj1), (float)(rect.bottom - adj1));
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom - radius);
        path.lineTo((float)rect.left + radius, (float)rect.bottom - radius);
        tempRect.set((float)rect.left + radius * 0.5f, (float)(rect.bottom - adj1), (float)rect.left + radius * 1.5f, (float)rect.bottom - radius);
        path.arcTo(tempRect, 90.0f, -180.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.left + adj1), (float)rect.bottom - radius);
        tempRect.set((float)rect.left, (float)(rect.bottom - adj1), (float)(rect.left + adj1), (float)rect.bottom);
        path.arcTo(tempRect, 0.0f, 270.0f);
        tempRect.set((float)rect.left + radius * 0.5f, (float)(rect.bottom - adj1), (float)rect.left + radius * 1.5f, (float)rect.bottom - radius);
        path.arcTo(tempRect, 270.0f, 180.0f);
        path.close();
        pathExtend.setPath(path);
        BackgroundAndFill fill = new BackgroundAndFill();
        fill.setFillType((byte)0);
        BackgroundAndFill shapeFill = shape.getBackgroundAndFill();
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.left + adj1 * 2), (float)rect.top + radius);
        tempRect.set((float)(rect.left + adj1), (float)rect.top, (float)(rect.left + adj1 * 2), (float)(rect.top + adj1));
        path.arcTo(tempRect, 0.0f, 90.0f);
        tempRect.set((float)(rect.left + adj1) + radius * 0.5f, (float)rect.top + radius, (float)(rect.left + adj1) + radius * 1.5f, (float)(rect.top + adj1));
        path.arcTo(tempRect, 90.0f, 180.0f);
        path.close();
        pathExtend.setPath(path);
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExList.add(pathExtend);
        return pathExList;
    }

    private static List<ExtendPath> getHorizontalScrollPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int width = rect.width();
        int height = rect.height();
        int len = Math.min(width, height);
        int adj1 = 0;
        adj1 = values != null && values.length == 1 ? Math.round((float)len * values[0].floatValue()) : Math.round((float)len * 0.125f);
        float radius = (float)adj1 / 2.0f;
        ExtendPath pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        Path path = new Path();
        path.moveTo((float)rect.left, (float)rect.top + radius * 3.0f);
        tempRect.set((float)rect.left, (float)(rect.top + adj1), (float)(rect.left + adj1), (float)(rect.top + adj1 * 2));
        path.arcTo(tempRect, 180.0f, -180.0f);
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom - radius);
        tempRect.set((float)rect.left, (float)(rect.bottom - adj1), (float)(rect.left + adj1), (float)rect.bottom);
        path.arcTo(tempRect, 0.0f, 180.0f);
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.left + adj1), (float)rect.top + radius * 3.0f);
        tempRect.set((float)rect.left, (float)(rect.top + adj1), (float)(rect.left + adj1), (float)(rect.top + adj1 * 2));
        path.arcTo(tempRect, 0.0f, 270.0f);
        path.lineTo((float)rect.right - radius, (float)(rect.top + adj1));
        tempRect.set((float)(rect.right - adj1), (float)rect.top, (float)rect.right, (float)(rect.top + adj1));
        path.arcTo(tempRect, 90.0f, -90.0f);
        path.lineTo((float)rect.right, (float)(rect.bottom - adj1) - radius);
        tempRect.set((float)(rect.right - adj1), (float)(rect.bottom - adj1 * 2), (float)rect.right, (float)(rect.bottom - adj1));
        path.arcTo(tempRect, 0.0f, 90.0f);
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj1));
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)(rect.right - adj1), (float)rect.top + radius);
        tempRect.set((float)(rect.right - adj1), (float)rect.top + radius * 0.5f, (float)rect.right - radius, (float)rect.top + radius * 1.5f);
        path.arcTo(tempRect, 180.0f, -180.0f);
        path.lineTo((float)rect.right - radius, (float)(rect.top + adj1));
        path.lineTo((float)(rect.right - adj1), (float)(rect.top + adj1));
        path.close();
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.left + radius, (float)(rect.top + adj1 * 2));
        tempRect.set((float)rect.left, (float)(rect.top + adj1), (float)(rect.left + adj1), (float)(rect.top + adj1 * 2));
        path.arcTo(tempRect, 90.0f, -90.0f);
        tempRect.set((float)rect.left + radius, (float)(rect.top + adj1) + radius * 0.5f, (float)(rect.left + adj1), (float)(rect.top + adj1) + radius * 1.5f);
        path.arcTo(tempRect, 0.0f, -180.0f);
        path.close();
        pathExtend.setPath(path);
        BackgroundAndFill fill = new BackgroundAndFill();
        fill.setFillType((byte)0);
        BackgroundAndFill shapeFill = shape.getBackgroundAndFill();
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExList.add(pathExtend);
        pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        path = new Path();
        path.moveTo((float)rect.right - radius, (float)rect.top + radius);
        tempRect.set((float)(rect.right - adj1), (float)rect.top + radius * 0.5f, (float)rect.right - radius, (float)rect.top + radius * 1.5f);
        path.arcTo(tempRect, 0.0f, 180.0f);
        tempRect.set((float)(rect.right - adj1), (float)rect.top, (float)rect.right, (float)(rect.top + adj1));
        path.arcTo(tempRect, 180.0f, 270.0f);
        path.close();
        pathExtend.setPath(path);
        if (shapeFill != null && shapeFill.getFillType() == 0) {
            fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
        } else {
            fill.setForegroundColor(-1890233003);
        }
        pathExtend.setBackgroundAndFill(fill);
        pathExList.add(pathExtend);
        return pathExList;
    }

    private static List<ExtendPath> getWavePath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int width = rect.width();
        int height = rect.height();
        int adj1 = 0;
        int adj2 = 0;
        if (shape.isAutoShape07()) {
            if (values != null && values.length == 2) {
                adj1 = Math.round((float)height * values[0].floatValue());
                adj2 = Math.round((float)width * values[1].floatValue());
            } else {
                adj1 = Math.round((float)height * 0.125f);
                adj2 = 0;
            }
        } else if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)height * values[0].floatValue()) : Math.round((float)height * 0.125f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)width * (values[1].floatValue() - 0.5f)) : 0;
        } else {
            adj1 = Math.round((float)height * 0.125f);
            adj2 = 0;
        }
        int waveW = width - Math.abs(adj2 * 2);
        int waveH = height - adj1;
        ExtendPath pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        Path path = new Path();
        if (adj2 > 0) {
            path.moveTo((float)rect.left, (float)(rect.top + adj1));
            path.cubicTo((float)rect.left + (float)waveW * 0.3333f, (float)(rect.top + adj1) - (float)adj1 * 3.3333f, (float)rect.left + (float)waveW * 0.6667f, (float)(rect.top + adj1) + (float)adj1 * 3.3333f, (float)(rect.left + waveW), (float)(rect.top + adj1));
            path.lineTo((float)rect.right, (float)(rect.bottom - adj1));
            path.cubicTo((float)rect.right - (float)waveW * 0.333f, (float)(rect.bottom - adj1) + (float)adj1 * 3.3333f, (float)rect.right - (float)waveW * 0.6667f, (float)(rect.bottom - adj1) - (float)adj1 * 3.333f, (float)(rect.right - waveW), (float)(rect.bottom - adj1));
            path.close();
        } else {
            path.moveTo((float)(rect.right - waveW), (float)(rect.top + adj1));
            path.cubicTo((float)rect.right - (float)waveW * 0.6667f, (float)(rect.top + adj1) - (float)adj1 * 3.333f, (float)rect.right - (float)waveW * 0.3333f, (float)(rect.top + adj1) + (float)adj1 * 3.333f, (float)rect.right, (float)(rect.top + adj1));
            path.lineTo((float)(rect.left + waveW), (float)(rect.bottom - adj1));
            path.cubicTo((float)rect.left + (float)waveW * 0.6667f, (float)(rect.bottom - adj1) + (float)adj1 * 3.333f, (float)rect.left + (float)waveW * 0.333f, (float)(rect.bottom - adj1) - (float)adj1 * 3.333f, (float)rect.left, (float)(rect.bottom - adj1));
            path.close();
        }
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        return pathExList;
    }

    private static List<ExtendPath> getDoubleWavePath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int width = rect.width();
        int height = rect.height();
        int adj1 = 0;
        int adj2 = 0;
        if (shape.isAutoShape07()) {
            if (values != null && values.length == 2) {
                adj1 = Math.round((float)height * values[0].floatValue());
                adj2 = Math.round((float)width * values[1].floatValue());
            } else {
                adj1 = Math.round((float)height * 0.125f);
                adj2 = 0;
            }
        } else if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)height * values[0].floatValue()) : Math.round((float)height * 0.125f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)width * (values[1].floatValue() - 0.5f)) : 0;
        } else {
            adj1 = Math.round((float)height * 0.125f);
            adj2 = 0;
        }
        int waveW = (width - Math.abs(adj2 * 2)) / 2;
        ExtendPath pathExtend = new ExtendPath();
        if (shape.hasLine()) {
            pathExtend.setLine(shape.getLine());
            pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
        }
        Path path = new Path();
        if (adj2 > 0) {
            path.moveTo((float)rect.left, (float)(rect.top + adj1));
            path.cubicTo((float)rect.left + (float)waveW * 0.3333f, (float)(rect.top + adj1) - (float)adj1 * 3.333f, (float)rect.left + (float)waveW * 0.6667f, (float)(rect.top + adj1) + (float)adj1 * 3.333f, (float)(rect.left + waveW), (float)(rect.top + adj1));
            path.cubicTo((float)rect.left + (float)waveW * 1.3333f, (float)(rect.top + adj1) - (float)adj1 * 3.333f, (float)rect.left + (float)waveW * 1.6667f, (float)(rect.top + adj1) + (float)adj1 * 3.333f, (float)(rect.left + waveW * 2), (float)(rect.top + adj1));
            path.lineTo((float)rect.right, (float)(rect.bottom - adj1));
            path.cubicTo((float)rect.right - (float)waveW * 0.3333f, (float)(rect.bottom - adj1) + (float)adj1 * 3.333f, (float)rect.right - (float)waveW * 0.6667f, (float)(rect.bottom - adj1) - (float)adj1 * 3.333f, (float)(rect.right - waveW), (float)(rect.bottom - adj1));
            path.cubicTo((float)rect.right - (float)waveW * 1.3333f, (float)(rect.bottom - adj1) + (float)adj1 * 3.333f, (float)rect.right - (float)waveW * 1.6667f, (float)(rect.bottom - adj1) - (float)adj1 * 3.333f, (float)(rect.right - waveW * 2), (float)(rect.bottom - adj1));
            path.close();
        } else {
            path.moveTo((float)(rect.right - waveW * 2), (float)(rect.top + adj1));
            path.cubicTo((float)rect.right - (float)waveW * 1.6667f, (float)(rect.top + adj1) - (float)adj1 * 3.333f, (float)rect.right - (float)waveW * 1.3333f, (float)(rect.top + adj1) + (float)adj1 * 3.333f, (float)(rect.right - waveW), (float)(rect.top + adj1));
            path.cubicTo((float)rect.right - (float)waveW * 0.6667f, (float)(rect.top + adj1) - (float)adj1 * 3.333f, (float)rect.right - (float)waveW * 0.3333f, (float)(rect.top + adj1) + (float)adj1 * 3.333f, (float)rect.right, (float)(rect.top + adj1));
            path.lineTo((float)(rect.left + waveW * 2), (float)(rect.bottom - adj1));
            path.cubicTo((float)rect.left + (float)waveW * 1.6667f, (float)(rect.bottom - adj1) + (float)adj1 * 3.333f, (float)rect.left + (float)waveW * 1.3333f, (float)(rect.bottom - adj1) - (float)adj1 * 3.333f, (float)(rect.left + waveW), (float)(rect.bottom - adj1));
            path.cubicTo((float)rect.left + (float)waveW * 0.6667f, (float)(rect.bottom - adj1) + (float)adj1 * 3.333f, (float)rect.left + (float)waveW * 0.3333f, (float)(rect.bottom - adj1) - (float)adj1 * 3.333f, (float)rect.left, (float)(rect.bottom - adj1));
            path.close();
        }
        pathExtend.setPath(path);
        pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
        pathExList.add(pathExtend);
        return pathExList;
    }

    private static List<ExtendPath> getLeftRightRibbon(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int len = Math.min(rect.width(), rect.height());
        int height = rect.height();
        int adj1 = 0;
        int adj2 = 0;
        int adj3V = 0;
        int adj3H = 0;
        if (shape.isAutoShape07()) {
            if (values != null && values.length == 3) {
                adj1 = Math.round((float)height * values[0].floatValue());
                adj2 = Math.round((float)len * values[1].floatValue());
                adj3H = Math.round((float)rect.width() * values[2].floatValue());
                adj3V = Math.round((float)height * values[2].floatValue());
            } else {
                adj1 = Math.round((float)height * 0.5f);
                adj2 = Math.round((float)len * 0.5f);
                adj3H = Math.round((float)rect.width() * 0.16667f);
                adj3V = Math.round((float)height * 0.16667f);
            }
            int arrowHeight = height - adj3V;
            ExtendPath pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            Path path = new Path();
            path.moveTo((float)rect.left, (float)(rect.top + arrowHeight / 2));
            path.lineTo((float)(rect.left + adj2), (float)rect.top);
            path.lineTo((float)(rect.left + adj2), (float)(rect.top + (arrowHeight - adj1) / 2));
            path.lineTo((float)rect.centerX(), (float)(rect.top + (arrowHeight - adj1) / 2));
            path.arcTo(new RectF((float)(rect.centerX() - adj3H / 4), (float)(rect.top + (arrowHeight - adj1) / 2), (float)(rect.centerX() + adj3H / 4), (float)(rect.top + (arrowHeight - adj1) / 2 + adj3V / 2)), 270.0f, 180.0f);
            path.arcTo(new RectF((float)(rect.centerX() - adj3H / 4), (float)(rect.top + (arrowHeight - adj1) / 2 + adj3V / 2), (float)(rect.centerX() + adj3H / 4), (float)(rect.top + (arrowHeight - adj1) / 2 + adj3V)), 270.0f, -180.0f);
            path.lineTo((float)(rect.right - adj2), (float)(rect.bottom - (arrowHeight - adj1) / 2 - adj1));
            path.lineTo((float)(rect.right - adj2), (float)(rect.bottom - arrowHeight));
            path.lineTo((float)rect.right, (float)(rect.bottom - arrowHeight / 2));
            path.lineTo((float)(rect.right - adj2), (float)rect.bottom);
            path.lineTo((float)(rect.right - adj2), (float)(rect.bottom - (arrowHeight - adj1) / 2));
            path.arcTo(new RectF((float)(rect.centerX() - adj3H / 4), (float)(rect.bottom - (arrowHeight - adj1) / 2 - adj3V / 2), (float)(rect.centerX() + adj3H / 4), (float)(rect.bottom - (arrowHeight - adj1) / 2)), 90.0f, 90.0f);
            path.lineTo((float)(rect.centerX() - adj3H / 4), (float)(rect.top + (arrowHeight - adj1) / 2 + adj1));
            path.lineTo((float)(rect.left + adj2), (float)(rect.top + (arrowHeight - adj1) / 2 + adj1));
            path.lineTo((float)(rect.left + adj2), (float)(rect.top + arrowHeight));
            path.close();
            pathExtend.setPath(path);
            pathExtend.setBackgroundAndFill(shape.getBackgroundAndFill());
            pathExList.add(pathExtend);
            pathExtend = new ExtendPath();
            if (shape.hasLine()) {
                pathExtend.setLine(shape.getLine());
                pathExtend.setBackgroundAndFill(shape.getLine().getBackgroundAndFill());
            }
            path = new Path();
            path.arcTo(new RectF((float)(rect.centerX() - adj3H / 4), (float)(rect.top + (arrowHeight - adj1) / 2 + adj3V / 2), (float)(rect.centerX() + adj3H / 4), (float)(rect.top + (arrowHeight - adj1) / 2 + adj3V)), 270.0f, -180.0f);
            path.close();
            BackgroundAndFill fill = new BackgroundAndFill();
            fill.setFillType((byte)0);
            BackgroundAndFill shapeFill = shape.getBackgroundAndFill();
            if (shapeFill != null && shapeFill.getFillType() == 0) {
                fill.setForegroundColor(ColorUtil.instance().getColorWithTint(shapeFill.getForegroundColor(), -0.3f));
            } else {
                fill.setForegroundColor(-1890233003);
            }
            pathExtend.setBackgroundAndFill(fill);
            pathExtend.setPath(path);
            pathExList.add(pathExtend);
            return pathExList;
        }
        return null;
    }
}

