/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.baseshape;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;

public class BaseShapePathBuilder {
    private static final float TODEGREE_07 = 1.6666666f;
    private static final float TODEGREE_03 = 0.3295496f;
    private static RectF rectF = new RectF();
    private static Path path = new Path();
    private static List<ExtendPath> paths = new ArrayList<ExtendPath>();
    private static Matrix m = new Matrix();

    public static Object getBaseShapePath(AutoShape shape, Rect rect) {
        path.reset();
        paths.clear();
        switch (shape.getShapeType()) {
            case 3: {
                return BaseShapePathBuilder.getEllipsePath(shape, rect);
            }
            case 5: {
                return BaseShapePathBuilder.getTrianglePath(shape, rect);
            }
            case 6: {
                return BaseShapePathBuilder.getRtTrianglePath(shape, rect);
            }
            case 7: {
                return BaseShapePathBuilder.getParallelogramPath(shape, rect);
            }
            case 8: {
                return BaseShapePathBuilder.getTrapezoidPath(shape, rect);
            }
            case 4: {
                return BaseShapePathBuilder.getDiamondPath(shape, rect);
            }
            case 56: {
                return BaseShapePathBuilder.getPentagonPath(shape, rect);
            }
            case 9: {
                return BaseShapePathBuilder.getHexagonPath(shape, rect);
            }
            case 217: {
                return BaseShapePathBuilder.getHeptagonPath(shape, rect);
            }
            case 10: {
                return BaseShapePathBuilder.getOctagonPath(shape, rect);
            }
            case 218: {
                return BaseShapePathBuilder.getDecagonPath(shape, rect);
            }
            case 219: {
                return BaseShapePathBuilder.getDodecagonPath(shape, rect);
            }
            case 220: {
                return BaseShapePathBuilder.getPiePath(shape, rect);
            }
            case 221: {
                return BaseShapePathBuilder.getChordPath(shape, rect);
            }
            case 222: {
                return BaseShapePathBuilder.getTeardropPath(shape, rect);
            }
            case 223: {
                return BaseShapePathBuilder.getFramePath(shape, rect);
            }
            case 224: {
                return BaseShapePathBuilder.getHalfFramePath(shape, rect);
            }
            case 225: {
                return BaseShapePathBuilder.getCornerPath(shape, rect);
            }
            case 226: {
                return BaseShapePathBuilder.getDiagStripePath(shape, rect);
            }
            case 11: {
                return BaseShapePathBuilder.getPlusPath(shape, rect);
            }
            case 21: {
                return BaseShapePathBuilder.getPlaquePath(shape, rect);
            }
            case 22: {
                return BaseShapePathBuilder.getCanPath(shape, rect);
            }
            case 16: {
                return BaseShapePathBuilder.getCubePath(shape, rect);
            }
            case 84: {
                return BaseShapePathBuilder.getBevelPath(shape, rect);
            }
            case 23: {
                return BaseShapePathBuilder.getDonutPath(shape, rect);
            }
            case 57: {
                return BaseShapePathBuilder.getNoSmokingPath(shape, rect);
            }
            case 95: {
                return BaseShapePathBuilder.getBlockArcPath(shape, rect);
            }
            case 65: {
                return BaseShapePathBuilder.getFoldedCornerPath(shape, rect);
            }
            case 96: {
                return BaseShapePathBuilder.getSmileyFacePath(shape, rect);
            }
            case 183: {
                return BaseShapePathBuilder.getSunPath(shape, rect);
            }
            case 74: {
                return BaseShapePathBuilder.getHeartPath(shape, rect);
            }
            case 73: {
                return BaseShapePathBuilder.getLightningBoltPath(shape, rect);
            }
            case 184: {
                return BaseShapePathBuilder.getMoonPath(shape, rect);
            }
            case 234: {
                return BaseShapePathBuilder.getCloudPath(shape, rect);
            }
            case 19: {
                return BaseShapePathBuilder.getArcPath(shape, rect);
            }
            case 185: {
                return BaseShapePathBuilder.getBracketPairPath(shape, rect);
            }
            case 186: {
                return BaseShapePathBuilder.getBracePairPath(shape, rect);
            }
            case 85: {
                return BaseShapePathBuilder.getLeftBracketPath(shape, rect);
            }
            case 86: {
                return BaseShapePathBuilder.getRightBracketPath(shape, rect);
            }
            case 87: {
                return BaseShapePathBuilder.getLeftBracePath(shape, rect);
            }
            case 88: {
                return BaseShapePathBuilder.getRightBracePath(shape, rect);
            }
        }
        return null;
    }

    private static Path getEllipsePath(AutoShape shape, Rect rect) {
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        return path;
    }

    private static Path getTrianglePath(AutoShape shape, Rect rect) {
        float x = (float)rect.width() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)rect.width() * values[0].floatValue();
        }
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getRtTrianglePath(AutoShape shape, Rect rect) {
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getParallelogramPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.width(), rect.height()) * 0.2f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
        } else {
            x = (float)rect.width() * 0.25f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)rect.width() * values[0].floatValue();
            }
        }
        path.reset();
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getTrapezoidPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.width(), rect.height()) * 0.2f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            path.moveTo((float)rect.left + x, (float)rect.top);
            path.lineTo((float)rect.right - x, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.bottom);
            path.lineTo((float)rect.left, (float)rect.bottom);
            path.close();
        } else {
            x = (float)rect.width() * 0.25f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)rect.width() * values[0].floatValue();
            }
            path.moveTo((float)rect.left, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.top);
            path.lineTo((float)rect.right - x, (float)rect.bottom);
            path.lineTo((float)rect.left + x, (float)rect.bottom);
            path.close();
        }
        return path;
    }

    private static Path getDiamondPath(AutoShape shape, Rect rect) {
        path.moveTo(rect.exactCenterX(), (float)rect.top);
        path.lineTo((float)rect.right, rect.exactCenterY());
        path.lineTo(rect.exactCenterX(), (float)rect.bottom);
        path.lineTo((float)rect.left, rect.exactCenterY());
        path.close();
        return path;
    }

    private static Path getPentagonPath(AutoShape shape, Rect rect) {
        float x = (float)rect.width() / 2.0f;
        float y = x * (float)Math.tan(Math.toRadians(36.0));
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + y);
        path.lineTo((float)rect.right - ((float)rect.height() - y) * (float)Math.tan(Math.toRadians(18.0)), (float)rect.bottom);
        path.lineTo((float)rect.left + ((float)rect.height() - y) * (float)Math.tan(Math.toRadians(18.0)), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.top + y);
        path.close();
        return path;
    }

    private static Path getHexagonPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.width(), rect.height()) * 0.25f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
        } else {
            x = (float)rect.width() * 0.25f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)rect.width() * values[0].floatValue();
            }
        }
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top);
        path.lineTo((float)rect.right, rect.exactCenterY());
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.lineTo((float)rect.left, rect.exactCenterY());
        path.close();
        return path;
    }

    private static Path getHeptagonPath(AutoShape shape, Rect rect) {
        float x1 = (float)rect.width() * 0.1f;
        float x2 = (float)rect.width() * 0.275f;
        float y1 = (float)rect.height() * 0.2f;
        float y2 = (float)rect.height() * 0.35f;
        path.reset();
        path.moveTo(rect.exactCenterX(), (float)rect.top);
        path.lineTo((float)rect.right - x1, (float)rect.top + y1);
        path.lineTo((float)rect.right, (float)rect.bottom - y2);
        path.lineTo((float)rect.right - x2, (float)rect.bottom);
        path.lineTo((float)rect.left + x2, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom - y2);
        path.lineTo((float)rect.left + x1, (float)rect.top + y1);
        path.close();
        return path;
    }

    private static Path getOctagonPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.25f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
        }
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.bottom - x);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom - x);
        path.lineTo((float)rect.left, (float)rect.top + x);
        path.close();
        return path;
    }

    private static Path getDecagonPath(AutoShape shape, Rect rect) {
        float x1 = (float)rect.width() * 0.1f;
        float x2 = (float)rect.width() * 0.35f;
        float y = (float)rect.height() * 0.2f;
        path.moveTo((float)rect.left + x2, (float)rect.top);
        path.lineTo((float)rect.right - x2, (float)rect.top);
        path.lineTo((float)rect.right - x1, (float)rect.top + y);
        path.lineTo((float)rect.right, rect.exactCenterY());
        path.lineTo((float)rect.right - x1, (float)rect.bottom - y);
        path.lineTo((float)rect.right - x2, (float)rect.bottom);
        path.lineTo((float)rect.left + x2, (float)rect.bottom);
        path.lineTo((float)rect.left + x1, (float)rect.bottom - y);
        path.lineTo((float)rect.left, rect.exactCenterY());
        path.lineTo((float)rect.left + x1, (float)rect.top + y);
        path.close();
        return path;
    }

    private static Path getDodecagonPath(AutoShape shape, Rect rect) {
        float x1 = (float)rect.width() * 0.133f;
        float x2 = (float)rect.width() * 0.35f;
        float y1 = (float)rect.height() * 0.133f;
        float y2 = (float)rect.height() * 0.35f;
        path.moveTo((float)rect.left + x2, (float)rect.top);
        path.lineTo((float)rect.right - x2, (float)rect.top);
        path.lineTo((float)rect.right - x1, (float)rect.top + y1);
        path.lineTo((float)rect.right, (float)rect.top + y2);
        path.lineTo((float)rect.right, (float)rect.bottom - y2);
        path.lineTo((float)rect.right - x1, (float)rect.bottom - y1);
        path.lineTo((float)rect.right - x2, (float)rect.bottom);
        path.lineTo((float)rect.left + x2, (float)rect.bottom);
        path.lineTo((float)rect.left + x1, (float)rect.bottom - y1);
        path.lineTo((float)rect.left, (float)rect.bottom - y2);
        path.lineTo((float)rect.left, (float)rect.top + y2);
        path.lineTo((float)rect.left + x1, (float)rect.top + y1);
        path.close();
        return path;
    }

    private static Path getPiePath(AutoShape shape, Rect rect) {
        float start = 0.0f;
        float end = 270.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                start = values[0].floatValue() * 1.6666666f;
            }
            if (values[1] != null) {
                end = values[1].floatValue() * 1.6666666f;
            }
        }
        path.moveTo((float)rect.centerX(), (float)rect.centerY());
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, start, (end - start + 360.0f) % 360.0f);
        path.close();
        return path;
    }

    private static Path getChordPath(AutoShape shape, Rect rect) {
        float start = 45.0f;
        float end = 270.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                start = values[0].floatValue() * 10.0f / 6.0f;
            }
            if (values[1] != null) {
                end = values[1].floatValue() * 10.0f / 6.0f;
            }
        }
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, start, end - start);
        path.close();
        return path;
    }

    private static Path getTeardropPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        float y = 0.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)rect.width() / 2.0f * values[0].floatValue();
            y = (float)rect.height() / 2.0f * values[0].floatValue();
        } else {
            x = (float)rect.width() / 2.0f;
            y = (float)rect.height() / 2.0f;
        }
        path.moveTo((float)rect.right, (float)rect.centerY());
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, 0.0f, 270.0f);
        path.quadTo((float)rect.centerX() + x / 2.0f, (float)rect.top, (float)rect.centerX() + x, (float)rect.centerY() - y);
        path.quadTo((float)rect.right, (float)rect.centerY() - y / 2.0f, (float)rect.right, (float)rect.centerY());
        path.close();
        return path;
    }

    private static Path getFramePath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.height(), rect.width()) * 0.1f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
        }
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addRect(rectF, Path.Direction.CW);
        rectF.set((float)rect.left + x, (float)rect.top + x, (float)rect.right - x, (float)rect.bottom - x);
        path.addRect(rectF, Path.Direction.CCW);
        return path;
    }

    private static Path getHalfFramePath(AutoShape shape, Rect rect) {
        float x1 = (float)Math.min(rect.height(), rect.width()) * 0.33333f;
        float y1 = (float)Math.min(rect.height(), rect.width()) * 0.33333f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                y1 = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
            }
            if (values[1] != null) {
                x1 = (float)Math.min(rect.height(), rect.width()) * values[1].floatValue();
            }
        }
        float x2 = y1 * (float)rect.width() / (float)rect.height();
        float y2 = x1 * (float)rect.height() / (float)rect.width();
        path.reset();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right - x2, (float)rect.top + y1);
        path.lineTo((float)rect.left + x1, (float)rect.top + y1);
        path.lineTo((float)rect.left + x1, (float)rect.bottom - y2);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getCornerPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.height(), rect.width()) * 0.5f;
        float y = (float)Math.min(rect.height(), rect.width()) * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 2) {
            if (values[0] != null) {
                y = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
            }
            if (values[1] != null) {
                x = (float)Math.min(rect.height(), rect.width()) * values[1].floatValue();
            }
        }
        y = (float)rect.height() - y;
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.left + x, (float)rect.top + y);
        path.lineTo((float)rect.right, (float)rect.top + y);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getDiagStripePath(AutoShape shape, Rect rect) {
        float y = (float)rect.height() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            y = (float)rect.height() * values[0].floatValue();
        }
        float x = y * (float)rect.width() / (float)rect.height();
        path.moveTo((float)rect.left, (float)rect.top + y);
        path.lineTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getPlusPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.height(), rect.width()) * 0.25f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
        }
        path.moveTo((float)rect.left, (float)rect.top + x);
        path.lineTo((float)rect.left + x, (float)rect.top + x);
        path.lineTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.bottom - x);
        path.lineTo((float)rect.right - x, (float)rect.bottom - x);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.lineTo((float)rect.left + x, (float)rect.bottom);
        path.lineTo((float)rect.left + x, (float)rect.bottom - x);
        path.lineTo((float)rect.left, (float)rect.bottom - x);
        path.close();
        return path;
    }

    private static Path getPlaquePath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.height(), rect.width()) * 0.16f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
        }
        rectF.set((float)rect.right - x, (float)rect.top - x, (float)rect.right + x, (float)rect.top + x);
        path.arcTo(rectF, 180.0f, -90.0f);
        rectF.set((float)rect.right - x, (float)rect.bottom - x, (float)rect.right + x, (float)rect.bottom + x);
        path.arcTo(rectF, 270.0f, -90.0f);
        rectF.set((float)rect.left - x, (float)rect.bottom - x, (float)rect.left + x, (float)rect.bottom + x);
        path.arcTo(rectF, 0.0f, -90.0f);
        rectF.set((float)rect.left - x, (float)rect.top - x, (float)rect.left + x, (float)rect.top + x);
        path.arcTo(rectF, 90.0f, -90.0f);
        path.close();
        return path;
    }

    private static List<ExtendPath> getCanPath(AutoShape shape, Rect rect) {
        BackgroundAndFill fill;
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.height(), rect.width()) * 0.175f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
            }
        } else {
            x = (float)rect.height() * 0.25f;
            if (values != null && values.length > 0 && values[0] != null) {
                x = (float)rect.height() * values[0].floatValue();
            }
        }
        BackgroundAndFill bgFill = fill = shape.getBackgroundAndFill();
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), 0.4));
        }
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.top + x);
        path.addOval(rectF, Path.Direction.CW);
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.arcTo(rectF, 180.0f, -180.0f);
        rectF.set((float)rect.left, (float)rect.bottom - x, (float)rect.right, (float)rect.bottom);
        path.arcTo(rectF, 0.0f, 180.0f);
        path.close();
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getCubePath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.height(), rect.width()) * 0.25f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top + x, (float)rect.right - x, (float)rect.bottom, Path.Direction.CW);
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        BackgroundAndFill bgFill = fill;
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), 0.2));
        }
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo((float)rect.left + x, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top + x);
        path.lineTo((float)rect.left, (float)rect.top + x);
        path.close();
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        paths.add(extendPath);
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), -0.2));
        }
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo((float)rect.right - x, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom - x);
        path.lineTo((float)rect.right - x, (float)rect.bottom);
        path.close();
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setPath(path);
        paths.add(extendPath);
        return paths;
    }

    private static List<ExtendPath> getBevelPath(AutoShape shape, Rect rect) {
        BackgroundAndFill fill;
        float x = (float)Math.min(rect.height(), rect.width()) * 0.125f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
        }
        BackgroundAndFill bgFill = fill = shape.getBackgroundAndFill();
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), 0.2));
        }
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right - x, (float)rect.top + x);
        path.lineTo((float)rect.left + x, (float)rect.top + x);
        path.close();
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setPath(path);
        paths.add(extendPath);
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), -0.4));
        }
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo((float)rect.right - x, (float)rect.top + x);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.right - x, (float)rect.bottom - x);
        path.close();
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setPath(path);
        paths.add(extendPath);
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), -0.2));
        }
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo((float)rect.left + x, (float)rect.bottom - x);
        path.lineTo((float)rect.right - x, (float)rect.bottom - x);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setPath(path);
        paths.add(extendPath);
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), 0.4));
        }
        extendPath = new ExtendPath();
        path = new Path();
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.left + x, (float)rect.top + x);
        path.lineTo((float)rect.left + x, (float)rect.bottom - x);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(bgFill);
        extendPath.setPath(path);
        paths.add(extendPath);
        extendPath = new ExtendPath();
        path = new Path();
        path.addRect((float)rect.left + x, (float)rect.top + x, (float)rect.right - x, (float)rect.bottom - x, Path.Direction.CW);
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(fill);
        extendPath.setPath(path);
        paths.add(extendPath);
        return paths;
    }

    private static Path getDonutPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        float y = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.height(), rect.width()) * 0.25f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)Math.min(rect.height(), rect.width()) * values[0].floatValue();
            }
            y = x;
        } else {
            x = (float)rect.width() * 0.25f;
            y = (float)rect.height() * 0.25f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)rect.width() * values[0].floatValue();
                y = (float)rect.height() * values[0].floatValue();
            }
        }
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        rectF.set((float)rect.left + x, (float)rect.top + y, (float)rect.right - x, (float)rect.bottom - y);
        path.addOval(rectF, Path.Direction.CCW);
        return path;
    }

    private static Path getNoSmokingPath(AutoShape shape, Rect rect) {
        float len = Math.min(rect.width(), rect.height());
        float rate = 0.2f;
        float x = len * 0.2f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            rate = values[0].floatValue();
        }
        x = len * rate;
        rectF.set(0.0f, 0.0f, len, len);
        path.addOval(rectF, Path.Direction.CCW);
        double degree = 45.0;
        if (rate <= 0.25f) {
            rate = rate * 0.5f / (0.5f - rate);
            degree = Math.acos(rate);
        } else {
            degree = 1.0471975511965976 * (double)(0.5f - rate) / 0.25;
        }
        rectF.set(x, x, len - x, len - x);
        path.arcTo(rectF, (float)((5.497787143782138 - degree) / Math.PI * 180.0), (float)(degree * 2.0 / Math.PI * 180.0), true);
        path.close();
        path.arcTo(rectF, (float)((2.356194490192345 - degree) / Math.PI * 180.0), (float)(degree * 2.0 / Math.PI * 180.0), true);
        path.close();
        m.reset();
        m.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(m);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    private static Path getBlockArcPath(AutoShape shape, Rect rect) {
        float start = 180.0f;
        float end = 0.0f;
        float x = (float)Math.min(rect.width(), rect.height()) * 0.25f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            if (values != null && values.length >= 3) {
                if (values[0] != null) {
                    start = values[0].floatValue() * 10.0f / 6.0f;
                }
                if (values[1] != null) {
                    end = values[1].floatValue() * 10.0f / 6.0f;
                }
                if (values[2] != null) {
                    x = (float)Math.min(rect.width(), rect.height()) * values[2].floatValue();
                }
            }
        } else {
            float angle = 90.0f;
            if (values != null && values.length >= 1) {
                angle = values[0] != null ? values[0].floatValue() * 0.3295496f : 0.0f;
                x = values.length >= 2 && values[1] != null ? (float)rect.width() * values[1].floatValue() : (float)rect.width() * 0.25f;
            } else {
                angle = 180.0f;
                x = (float)rect.width() * 0.25f;
            }
            if (angle >= 0.0f) {
                start = angle;
                end = 90.0f + (90.0f - angle);
            } else {
                start = angle + 360.0f;
                end = 360.0f - (start - 180.0f);
            }
        }
        if (end >= start) {
            rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, start, end - start);
            rectF.set((float)rect.left + x, (float)rect.top + x, (float)rect.right - x, (float)rect.bottom - x);
            path.arcTo(rectF, end, start - end);
        } else {
            rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, start, 360.0f + end - start);
            rectF.set((float)rect.left + x, (float)rect.top + x, (float)rect.right - x, (float)rect.bottom - x);
            path.arcTo(rectF, end, start - end - 360.0f);
        }
        path.close();
        return path;
    }

    private static List<ExtendPath> getFoldedCornerPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.width(), rect.height()) * 0.25f;
            if (values != null && values.length >= 1 && values[0] != null) {
                x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
            }
            BackgroundAndFill fill = shape.getBackgroundAndFill();
            ExtendPath extendPath = new ExtendPath();
            Path path = new Path();
            path.moveTo((float)rect.left, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.bottom - x);
            path.lineTo((float)rect.right - x, (float)rect.bottom);
            path.lineTo((float)rect.left, (float)rect.bottom);
            path.close();
            extendPath.setLine(shape.getLine());
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(fill);
            paths.add(extendPath);
            BackgroundAndFill bgFill = fill;
            if (fill != null) {
                bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)0);
                bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), -0.2));
            }
            extendPath = new ExtendPath();
            path = new Path();
            path.moveTo((float)rect.right - x * (float)Math.sin(Math.toRadians(75.0)) * (float)Math.sqrt(6.0) / 3.0f, (float)rect.bottom - x * (float)Math.sin(Math.toRadians(75.0)) * (float)Math.sqrt(6.0) / 3.0f);
            path.lineTo((float)rect.right, (float)rect.bottom - x);
            path.lineTo((float)rect.right - x, (float)rect.bottom);
            path.close();
            extendPath.setLine(shape.getLine());
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        } else {
            float adjust = 0.0f;
            x = (float)Math.min(rect.width(), rect.height()) * 0.125f;
            if (values != null && values.length >= 1) {
                x = (float)Math.min(rect.width(), rect.height()) * (1.0f - values[0].floatValue());
            }
            if (rect.height() > rect.width()) {
                x = (float)((double)x * 1.4286);
                adjust = 0.7f;
            } else {
                adjust = 1.4286f;
            }
            ExtendPath extendPath = new ExtendPath();
            Path path = new Path();
            path.moveTo((float)rect.left, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.top);
            path.lineTo((float)rect.right, (float)rect.bottom - x);
            path.lineTo((float)rect.right - x * adjust, (float)rect.bottom);
            path.lineTo((float)rect.left, (float)rect.bottom);
            path.close();
            BackgroundAndFill fill = shape.getBackgroundAndFill();
            extendPath.setLine(shape.getLine());
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(fill);
            paths.add(extendPath);
            BackgroundAndFill bgFill = fill;
            if (fill != null) {
                bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)0);
                bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), -0.2));
            }
            extendPath = new ExtendPath();
            path = new Path();
            path.moveTo((float)rect.right - x * adjust * (float)Math.sin(Math.toRadians(75.0)) * (float)Math.sqrt(6.0) / 3.0f, (float)rect.bottom - x * (float)Math.sin(Math.toRadians(75.0)) * (float)Math.sqrt(6.0) / 3.0f);
            path.lineTo((float)rect.right, (float)rect.bottom - x);
            path.lineTo((float)rect.right - x * adjust, (float)rect.bottom);
            path.close();
            extendPath.setLine(shape.getLine());
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getSmileyFacePath(AutoShape shape, Rect rect) {
        float x = (float)rect.height() * 0.04653f * 2.0f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1) {
            if (shape.isAutoShape07()) {
                if (values[0] != null) {
                    x = (float)rect.height() * values[0].floatValue() * 2.0f;
                }
            } else if (values[0] != null) {
                x = (float)rect.height() * (values[0].floatValue() - 0.77f) * 2.0f;
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
        path.addOval(rectF, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(fill);
        paths.add(extendPath);
        float left = (float)rect.left + (float)rect.width() / 4.0f;
        float right = (float)rect.right - (float)rect.width() / 4.0f;
        float top = (float)rect.bottom - (float)rect.height() / 4.0f - Math.abs(x);
        float bottom = (float)rect.bottom - (float)rect.height() / 4.0f + Math.abs(x);
        extendPath = new ExtendPath();
        path = new Path();
        rectF.set(left, top, right, bottom);
        if (x >= 0.0f) {
            path.arcTo(rectF, 15.0f, 150.0f);
        } else {
            path.arcTo(rectF, 195.0f, 150.0f);
        }
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(fill);
        paths.add(extendPath);
        BackgroundAndFill bgFill = fill;
        if (fill != null) {
            bgFill = new BackgroundAndFill();
            bgFill.setFillType((byte)0);
            bgFill.setForegroundColor(ColorUtil.instance().getColorWithTint(fill.getForegroundColor(), -0.2));
        }
        left = rect.exactCenterX() - (float)rect.width() / 5.0f;
        right = rect.exactCenterX() - (float)rect.width() / 10.0f;
        top = rect.exactCenterY() - (float)rect.height() / 5.0f;
        bottom = rect.exactCenterY() - (float)rect.height() / 10.0f;
        extendPath = new ExtendPath();
        path = new Path();
        rectF.set(left, top, right, bottom);
        path.addOval(rectF, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(bgFill);
        paths.add(extendPath);
        left = rect.exactCenterX() + (float)rect.width() / 10.0f;
        right = rect.exactCenterX() + (float)rect.width() / 5.0f;
        extendPath = new ExtendPath();
        path = new Path();
        rectF.set(left, top, right, bottom);
        path.addOval(rectF, Path.Direction.CW);
        extendPath.setPath(path);
        extendPath.setLine(shape.getLine());
        extendPath.setBackgroundAndFill(bgFill);
        paths.add(extendPath);
        return paths;
    }

    private static Path getSunPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        float offX = 0.0f;
        float offY = 0.0f;
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                offX = (float)rect.width() * values[0].floatValue();
                offY = (float)rect.height() * values[0].floatValue();
            }
        } else {
            offX = (float)rect.width() * 0.25f;
            offY = (float)rect.height() * 0.25f;
        }
        rectF.set((float)rect.left + offX, (float)rect.top + offY, (float)rect.right - offX, (float)rect.bottom - offY);
        path.addOval(rectF, Path.Direction.CW);
        path.moveTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.centerX() + rect.width() / 14), (float)rect.top + offY * 0.75f);
        path.lineTo((float)(rect.centerX() - rect.width() / 14), (float)rect.top + offY * 0.75f);
        path.close();
        path.moveTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.centerX() - rect.width() / 14), (float)rect.bottom - offY * 0.75f);
        path.lineTo((float)(rect.centerX() + rect.width() / 14), (float)rect.bottom - offY * 0.75f);
        path.close();
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)rect.left + offX * 0.75f, (float)(rect.centerY() - rect.height() / 14));
        path.lineTo((float)rect.left + offX * 0.75f, (float)(rect.centerY() + rect.height() / 14));
        path.close();
        path.moveTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)rect.right - offX * 0.75f, (float)(rect.centerY() + rect.height() / 14));
        path.lineTo((float)rect.right - offX * 0.75f, (float)(rect.centerY() - rect.height() / 14));
        path.close();
        float hx = (float)(Math.sqrt(0.5) * (double)rect.width()) / 2.0f;
        float hy = (float)(Math.sqrt(0.5) * (double)rect.height()) / 2.0f;
        float mx_tail = (float)(Math.sqrt(0.5) * (double)((float)rect.width() - offX * 0.75f * 2.0f)) / 2.0f;
        float my_tail = (float)(Math.sqrt(0.5) * (double)((float)rect.height() - offY * 0.75f * 2.0f)) / 2.0f;
        float offLen = (rect.width() + rect.height()) / 28;
        offX = (float)((double)(offLen * (float)rect.width()) / Math.sqrt(Math.pow(rect.width(), 2.0) + Math.pow(rect.height(), 2.0)));
        offY = (float)((double)(offLen * (float)rect.height()) / Math.sqrt(Math.pow(rect.width(), 2.0) + Math.pow(rect.height(), 2.0)));
        float tailX1 = mx_tail + offX;
        float tailY1 = my_tail - offY;
        float tailX2 = mx_tail - offX;
        float tailY2 = my_tail + offY;
        path.moveTo((float)rect.centerX() + hx, (float)rect.centerY() + hy);
        path.lineTo((float)rect.centerX() + tailX1, (float)rect.centerY() + tailY1);
        path.lineTo((float)rect.centerX() + tailX2, (float)rect.centerY() + tailY2);
        path.close();
        path.moveTo((float)rect.centerX() - hx, (float)rect.centerY() - hy);
        path.lineTo((float)rect.centerX() - tailX1, (float)rect.centerY() - tailY1);
        path.lineTo((float)rect.centerX() - tailX2, (float)rect.centerY() - tailY2);
        path.close();
        path.moveTo((float)rect.centerX() + hx, (float)rect.centerY() - hy);
        path.lineTo((float)rect.centerX() + tailX1, (float)rect.centerY() - tailY1);
        path.lineTo((float)rect.centerX() + tailX2, (float)rect.centerY() - tailY2);
        path.close();
        path.moveTo((float)rect.centerX() - hx, (float)rect.centerY() + hy);
        path.lineTo((float)rect.centerX() - tailX1, (float)rect.centerY() + tailY1);
        path.lineTo((float)rect.centerX() - tailX2, (float)rect.centerY() + tailY2);
        path.close();
        return path;
    }

    private static Path getHeartPath(AutoShape shape, Rect rect) {
        path.moveTo(0.0f, 30.0f);
        path.cubicTo(0.0f, -10.0f, 40.0f, 0.0f, 50.0f, 20.0f);
        path.cubicTo(60.0f, 0.0f, 100.0f, -10.0f, 100.0f, 30.0f);
        path.cubicTo(100.0f, 60.0f, 60.0f, 100.0f, 50.0f, 100.0f);
        path.cubicTo(40.0f, 100.0f, 0.0f, 60.0f, 0.0f, 30.0f);
        path.close();
        m.reset();
        m.postScale((float)rect.width() / 100.0f, (float)rect.height() / 100.0f);
        path.transform(m);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    private static Path getLightningBoltPath(AutoShape shape, Rect rect) {
        float w = rect.width();
        float h = rect.height();
        path.moveTo((float)rect.left + w * 0.4f, (float)rect.top);
        path.lineTo((float)rect.left + w * 0.6f, (float)rect.top + h * 0.2857f);
        path.lineTo((float)rect.left + w * 0.5167f, (float)rect.top + h * 0.3f);
        path.lineTo((float)rect.right - w * 0.23f, (float)rect.bottom - h * 0.44f);
        path.lineTo((float)rect.right - w * 0.3448f, (float)rect.bottom - h * 0.4f);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)rect.left + w * 0.4615f, (float)rect.bottom - h * 0.3167f);
        path.lineTo((float)rect.left + w * 0.5455f, (float)rect.bottom - h * 0.35f);
        path.lineTo((float)rect.left + w * 0.25f, (float)rect.top + h * 0.4545f);
        path.lineTo((float)rect.left + w * 0.35f, (float)rect.top + h * 0.3921f);
        path.lineTo((float)rect.left, (float)rect.top + h * 0.19f);
        path.close();
        return path;
    }

    private static Path getMoonPath(AutoShape shape, Rect rect) {
        float x = (float)rect.width() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)rect.width() * (1.0f - values[0].floatValue());
        }
        rectF.set((float)rect.left, (float)rect.top, (float)(rect.right * 2 - rect.left), (float)rect.bottom);
        path.arcTo(rectF, 90.0f, 180.0f);
        rectF.set((float)rect.right - x, (float)rect.top, (float)rect.right + x, (float)rect.bottom);
        path.arcTo(rectF, 270.0f, -180.0f);
        return path;
    }

    private static Path getCloudPath(AutoShape shape, Rect rect) {
        float len = 468.0f;
        path.reset();
        rectF.set(0.0f, 160.0f, 90.0f, 285.0f);
        path.arcTo(rectF, 120.0f, 148.0f);
        rectF.set(41.0f, 44.0f, 188.0f, 250.0f);
        path.arcTo(rectF, 172.5f, 127.5f);
        rectF.set(140.0f, 14.0f, 264.0f, 220.0f);
        path.arcTo(rectF, 218.0f, 90.0f);
        rectF.set(230.0f, 0.0f, 340.0f, 210.0f);
        path.arcTo(rectF, 219.0f, 92.0f);
        rectF.set(296.0f, 0.0f, 428.0f, 246.0f);
        path.arcTo(rectF, 232.0f, 101.0f);
        rectF.set(342.0f, 60.0f, 454.0f, 214.0f);
        path.arcTo(rectF, 293.0f, 89.0f);
        rectF.set(324.0f, 130.0f, 468.0f, 327.0f);
        path.arcTo(rectF, 319.0f, 119.0f);
        rectF.set(280.0f, 240.0f, 405.0f, 412.0f);
        path.arcTo(rectF, 1.0f, 122.0f);
        rectF.set(168.0f, 274.0f, 312.0f, 468.0f);
        path.arcTo(rectF, 16.0f, 130.0f);
        rectF.set(57.0f, 249.0f, 213.0f, 441.0f);
        path.arcTo(rectF, 56.0f, 74.0f);
        rectF.set(11.0f, 259.0f, 99.0f, 386.0f);
        path.arcTo(rectF, 84.0f, 140.0f);
        path.close();
        m.reset();
        m.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(m);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    private static List<ExtendPath> getArcPath(AutoShape shape, Rect rect) {
        float start = 0.0f;
        float end = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            if (values != null && values.length >= 2) {
                start = values[0].floatValue() * 1.6666666f;
                end = values[1].floatValue() * 1.6666666f;
            } else {
                start = 270.0f;
                end = 0.0f;
            }
        } else {
            if (values != null && values.length >= 1) {
                if (values[0] != null) {
                    start = values[0].floatValue() / 3.0f;
                }
                if (values.length >= 2 && values[1] != null) {
                    end = values[1].floatValue() / 3.0f;
                }
            } else {
                start = 270.0f;
                end = 0.0f;
            }
            if (start < 0.0f) {
                start += 360.0f;
            }
            if (end < 0.0f) {
                end += 360.0f;
            }
        }
        BackgroundAndFill fill = shape.getBackgroundAndFill();
        ExtendPath extendPath = new ExtendPath();
        Path path = new Path();
        if (fill != null) {
            extendPath = new ExtendPath();
            path = new Path();
            path.moveTo(rect.exactCenterX(), rect.exactCenterY());
            rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, start, (end - start + 360.0f) % 360.0f);
            path.close();
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(fill);
            paths.add(extendPath);
        }
        if (shape.hasLine()) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, start, (end - start + 360.0f) % 360.0f);
            extendPath.setPath(path);
            extendPath.setLine(shape.getLine());
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getBracketPairPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        x = values != null && values.length >= 1 && values[0] != null ? (float)Math.min(rect.width(), rect.height()) * values[0].floatValue() : (float)Math.min(rect.width(), rect.height()) * 0.18f;
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        ExtendPath extendPath = null;
        Path path = null;
        if (bgFill != null) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom);
            float[] radii = new float[]{x, x, x, x, x, x, x, x};
            path.addRoundRect(rectF, radii, Path.Direction.CW);
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        }
        if (shape.hasLine()) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.right - x * 2.0f, (float)rect.top, (float)rect.right, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)rect.right - x * 2.0f, (float)rect.bottom - x * 2.0f, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            path.moveTo((float)rect.left + x, (float)rect.bottom);
            rectF.set((float)rect.left, (float)rect.bottom - x * 2.0f, (float)rect.left + x * 2.0f, (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
            rectF.set((float)rect.left, (float)rect.top, (float)rect.left + x * 2.0f, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            extendPath.setPath(path);
            extendPath.setLine(shape.getLine());
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getLeftBracketPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = values != null && values.length >= 1 ? (float)Math.min(rect.width(), rect.height()) * values[0].floatValue() : (float)Math.min(rect.width(), rect.height()) * 0.08f;
        } else if (values != null && values.length >= 1 && values[0] != null) {
            if (values[0] != null) {
                x = (float)rect.height() * values[0].floatValue();
            }
        } else {
            x = (float)rect.height() * 0.08f;
        }
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        ExtendPath extendPath = null;
        Path path = null;
        if (bgFill != null) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.left, (float)rect.bottom - x * 2.0f, (float)(rect.right * 2 - rect.left), (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
            rectF.set((float)rect.left, (float)rect.top, (float)(rect.right * 2 - rect.left), (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            path.close();
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        }
        if (shape.hasLine()) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.left, (float)rect.bottom - x * 2.0f, (float)(rect.right * 2 - rect.left), (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
            rectF.set((float)rect.left, (float)rect.top, (float)(rect.right * 2 - rect.left), (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            extendPath.setPath(path);
            extendPath.setLine(shape.getLine());
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getRightBracketPath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        Float[] values = shape.getAdjustData();
        x = shape.isAutoShape07() ? (values != null && values.length >= 1 && values[0] != null ? (float)Math.min(rect.width(), rect.height()) * values[0].floatValue() : (float)Math.min(rect.width(), rect.height()) * 0.08f) : (values != null && values.length >= 1 && values[0] != null ? (float)rect.height() * values[0].floatValue() : (float)rect.height() * 0.08f);
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        ExtendPath extendPath = null;
        Path path = null;
        if (bgFill != null) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)(rect.left * 2 - rect.right), (float)rect.top, (float)rect.right, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)(rect.left * 2 - rect.right), (float)rect.bottom - x * 2.0f, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            path.close();
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        }
        if (shape.hasLine()) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)(rect.left * 2 - rect.right), (float)rect.top, (float)rect.right, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)(rect.left * 2 - rect.right), (float)rect.bottom - x * 2.0f, (float)rect.right, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            extendPath.setPath(path);
            extendPath.setLine(shape.getLine());
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getBracePairPath(AutoShape shape, Rect rect) {
        float x = (float)Math.min(rect.width(), rect.height()) * 0.08f;
        Float[] values = shape.getAdjustData();
        if (values != null && values.length >= 1 && values[0] != null) {
            x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
        }
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        ExtendPath extendPath = null;
        Path path = null;
        if (bgFill != null) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.right - x * 3.0f, (float)rect.top, (float)rect.right - x, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)rect.right - x, rect.exactCenterY() - x * 2.0f, (float)rect.right + x, rect.exactCenterY());
            path.arcTo(rectF, 180.0f, -90.0f);
            rectF.set((float)rect.right - x, rect.exactCenterY(), (float)rect.right + x, rect.exactCenterY() + x * 2.0f);
            path.arcTo(rectF, 270.0f, -90.0f);
            rectF.set((float)rect.right - x * 3.0f, (float)rect.bottom - x * 2.0f, (float)rect.right - x, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            rectF.set((float)rect.left + x, (float)rect.bottom - x * 2.0f, (float)rect.left + x * 3.0f, (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
            rectF.set((float)rect.left - x, rect.exactCenterY(), (float)rect.left + x, rect.exactCenterY() + x * 2.0f);
            path.arcTo(rectF, 0.0f, -90.0f);
            rectF.set((float)rect.left - x, rect.exactCenterY() - x * 2.0f, (float)rect.left + x, rect.exactCenterY());
            path.arcTo(rectF, 90.0f, -90.0f);
            rectF.set((float)rect.left + x, (float)rect.top, (float)rect.left + x * 3.0f, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            path.close();
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        }
        if (shape.hasLine()) {
            extendPath = new ExtendPath();
            path = new Path();
            path.moveTo((float)rect.right - x * 2.0f, (float)rect.top);
            rectF.set((float)rect.right - x * 3.0f, (float)rect.top, (float)rect.right - x, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)rect.right - x, rect.exactCenterY() - x * 2.0f, (float)rect.right + x, rect.exactCenterY());
            path.arcTo(rectF, 180.0f, -90.0f);
            rectF.set((float)rect.right - x, rect.exactCenterY(), (float)rect.right + x, rect.exactCenterY() + x * 2.0f);
            path.arcTo(rectF, 270.0f, -90.0f);
            rectF.set((float)rect.right - x * 3.0f, (float)rect.bottom - x * 2.0f, (float)rect.right - x, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            path.moveTo((float)rect.left + x * 2.0f, (float)rect.bottom);
            rectF.set((float)rect.left + x, (float)rect.bottom - x * 2.0f, (float)rect.left + x * 3.0f, (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
            rectF.set((float)rect.left - x, rect.exactCenterY(), (float)rect.left + x, rect.exactCenterY() + x * 2.0f);
            path.arcTo(rectF, 0.0f, -90.0f);
            rectF.set((float)rect.left - x, rect.exactCenterY() - x * 2.0f, (float)rect.left + x, rect.exactCenterY());
            path.arcTo(rectF, 90.0f, -90.0f);
            rectF.set((float)rect.left + x, (float)rect.top, (float)rect.left + x * 3.0f, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            extendPath.setPath(path);
            extendPath.setLine(shape.getLine());
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getLeftBracePath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        float y = (float)rect.height() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.width(), rect.height()) * 0.08333f;
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue();
                }
            }
        } else {
            x = (float)rect.height() * 0.08333f;
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)rect.height() * values[0].floatValue();
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue();
                }
            }
        }
        if ((float)rect.top + y + x * 2.0f > (float)rect.bottom) {
            x = ((float)rect.height() - y) / 2.0f;
        }
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        ExtendPath extendPath = null;
        Path path = null;
        if (bgFill != null) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set(rect.exactCenterX(), (float)rect.bottom - x * 2.0f, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.top + y, rect.exactCenterX(), (float)rect.top + y + x * 2.0f);
            path.arcTo(rectF, 0.0f, -90.0f);
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.top + y - x * 2.0f, rect.exactCenterX(), (float)rect.top + y);
            path.arcTo(rectF, 90.0f, -90.0f);
            rectF.set(rect.exactCenterX(), (float)rect.top, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            path.close();
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        }
        if (shape.hasLine()) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set(rect.exactCenterX(), (float)rect.bottom - x * 2.0f, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.bottom);
            path.arcTo(rectF, 90.0f, 90.0f);
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.top + y, rect.exactCenterX(), (float)rect.top + y + x * 2.0f);
            path.arcTo(rectF, 0.0f, -90.0f);
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.top + y - x * 2.0f, rect.exactCenterX(), (float)rect.top + y);
            path.arcTo(rectF, 90.0f, -90.0f);
            rectF.set(rect.exactCenterX(), (float)rect.top, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 180.0f, 90.0f);
            extendPath.setPath(path);
            extendPath.setLine(shape.getLine());
            paths.add(extendPath);
        }
        return paths;
    }

    private static List<ExtendPath> getRightBracePath(AutoShape shape, Rect rect) {
        float x = 0.0f;
        float y = (float)rect.height() * 0.5f;
        Float[] values = shape.getAdjustData();
        if (shape.isAutoShape07()) {
            x = (float)Math.min(rect.width(), rect.height()) * 0.08333f;
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)Math.min(rect.width(), rect.height()) * values[0].floatValue();
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue();
                }
            }
        } else {
            x = (float)rect.height() * 0.08333f;
            if (values != null && values.length >= 2) {
                if (values[0] != null) {
                    x = (float)rect.height() * values[0].floatValue();
                }
                if (values[1] != null) {
                    y = (float)rect.height() * values[1].floatValue();
                }
            }
        }
        if ((float)rect.top + y + x * 2.0f > (float)rect.bottom) {
            x = ((float)rect.height() - y) / 2.0f;
        }
        BackgroundAndFill bgFill = shape.getBackgroundAndFill();
        ExtendPath extendPath = null;
        Path path = null;
        if (bgFill != null) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.top, (float)(rect.right + rect.left) / 2.0f, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)(rect.right + rect.left) / 2.0f, (float)rect.top + y - x * 2.0f, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.top + y);
            path.arcTo(rectF, 180.0f, -90.0f);
            rectF.set((float)(rect.right + rect.left) / 2.0f, (float)rect.top + y, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.top + y + x * 2.0f);
            path.arcTo(rectF, 270.0f, -90.0f);
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.bottom - x * 2.0f, (float)(rect.right + rect.left) / 2.0f, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            path.close();
            extendPath.setPath(path);
            extendPath.setBackgroundAndFill(bgFill);
            paths.add(extendPath);
        }
        if (shape.hasLine()) {
            extendPath = new ExtendPath();
            path = new Path();
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.top, (float)(rect.right + rect.left) / 2.0f, (float)rect.top + x * 2.0f);
            path.arcTo(rectF, 270.0f, 90.0f);
            rectF.set((float)(rect.right + rect.left) / 2.0f, (float)rect.top + y - x * 2.0f, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.top + y);
            path.arcTo(rectF, 180.0f, -90.0f);
            rectF.set((float)(rect.right + rect.left) / 2.0f, (float)rect.top + y, (float)rect.right + (float)rect.width() / 2.0f, (float)rect.top + y + x * 2.0f);
            path.arcTo(rectF, 270.0f, -90.0f);
            rectF.set((float)rect.left - (float)rect.width() / 2.0f, (float)rect.bottom - x * 2.0f, (float)(rect.right + rect.left) / 2.0f, (float)rect.bottom);
            path.arcTo(rectF, 0.0f, 90.0f);
            extendPath.setPath(path);
            extendPath.setLine(shape.getLine());
            paths.add(extendPath);
        }
        return paths;
    }
}

