/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.arrow;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.arrow.ArrowPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import java.util.ArrayList;
import java.util.List;

public class EarlyArrowPathBuilder
extends ArrowPathBuilder {
    private static final float TODEGREE = 0.3295496f;
    private static RectF s_rect = new RectF();
    private static Path path = new Path();

    public static Object getArrowPath(AutoShape shape, Rect rect) {
        path.reset();
        switch (shape.getShapeType()) {
            case 13: {
                return EarlyArrowPathBuilder.getRightArrowPath(shape, rect);
            }
            case 66: {
                return EarlyArrowPathBuilder.getLeftArrowPath(shape, rect);
            }
            case 68: {
                return EarlyArrowPathBuilder.getUpArrowPath(shape, rect);
            }
            case 67: {
                return EarlyArrowPathBuilder.getDownArrowPath(shape, rect);
            }
            case 69: {
                return EarlyArrowPathBuilder.getLeftRightArrowPath(shape, rect);
            }
            case 70: {
                return EarlyArrowPathBuilder.getUpDownArrowPath(shape, rect);
            }
            case 76: {
                return EarlyArrowPathBuilder.getQuadArrowPath(shape, rect);
            }
            case 182: {
                return EarlyArrowPathBuilder.getLeftRightUpArrowPath(shape, rect);
            }
            case 91: {
                return EarlyArrowPathBuilder.getBentArrowPath(shape, rect);
            }
            case 101: {
                return EarlyArrowPathBuilder.getUturnArrowPath(shape, rect);
            }
            case 89: {
                return EarlyArrowPathBuilder.getLeftUpArrowPath(shape, rect);
            }
            case 90: {
                return EarlyArrowPathBuilder.getBentUpArrowPath(shape, rect);
            }
            case 102: {
                return EarlyArrowPathBuilder.getCurvedRightArrowPath(shape, rect);
            }
            case 103: {
                return EarlyArrowPathBuilder.getCurvedLeftArrowPath(shape, rect);
            }
            case 104: {
                return EarlyArrowPathBuilder.getCurvedUpArrowPath(shape, rect);
            }
            case 105: {
                return EarlyArrowPathBuilder.getCurvedDownArrowPath(shape, rect);
            }
            case 93: {
                return EarlyArrowPathBuilder.getStripedRightArrowPath(shape, rect);
            }
            case 94: {
                return EarlyArrowPathBuilder.getNotchedRightArrowPath(shape, rect);
            }
            case 15: {
                return EarlyArrowPathBuilder.getHomePlatePath(shape, rect);
            }
            case 55: {
                return EarlyArrowPathBuilder.getChevronPath(shape, rect);
            }
            case 78: {
                return EarlyArrowPathBuilder.getRightArrowCalloutPath(shape, rect);
            }
            case 77: {
                return EarlyArrowPathBuilder.getLeftArrowCalloutPath(shape, rect);
            }
            case 79: {
                return EarlyArrowPathBuilder.getUpArrowCalloutPath(shape, rect);
            }
            case 80: {
                return EarlyArrowPathBuilder.getDownArrowCalloutPath(shape, rect);
            }
            case 81: {
                return EarlyArrowPathBuilder.getLeftRightArrowCalloutPath(shape, rect);
            }
            case 82: {
                return EarlyArrowPathBuilder.getUpDownArrowCalloutPath(shape, rect);
            }
            case 83: {
                return EarlyArrowPathBuilder.getQuadArrowCalloutPath(shape, rect);
            }
            case 99: {
                return EarlyArrowPathBuilder.getCircularArrowPath(shape, rect);
            }
        }
        return new Path();
    }

    private static Path getRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.75f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.75f);
            adj2 = Math.round((float)rect.height() * 0.25f);
        }
        path.moveTo((float)rect.left, (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)rect.left, (float)(rect.bottom - adj2));
        path.close();
        return path;
    }

    private static Path getLeftArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.25f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.25f);
            adj2 = Math.round((float)rect.height() * 0.25f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2));
        path.lineTo((float)rect.right, (float)(rect.top + adj2));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.height() * values[0].floatValue()) : Math.round((float)rect.height() * 0.25f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.width() * values[1].floatValue()) : Math.round((float)rect.width() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.height() * 0.25f);
            adj2 = Math.round((float)rect.width() * 0.25f);
        }
        path.moveTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj1));
        path.lineTo((float)(rect.right - adj2), (float)(rect.top + adj1));
        path.lineTo((float)(rect.right - adj2), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj2), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj2), (float)(rect.top + adj1));
        path.lineTo((float)rect.left, (float)(rect.top + adj1));
        path.close();
        return path;
    }

    private static Path getDownArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.height() * values[0].floatValue()) : Math.round((float)rect.height() * 0.75f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.width() * values[1].floatValue()) : Math.round((float)rect.width() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.height() * 0.75f);
            adj2 = Math.round((float)rect.width() * 0.25f);
        }
        path.moveTo((float)(rect.left + adj2), (float)rect.top);
        path.lineTo((float)(rect.right - adj2), (float)rect.top);
        path.lineTo((float)(rect.right - adj2), (float)(rect.top + adj1));
        path.lineTo((float)rect.right, (float)(rect.top + adj1));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.top + adj1));
        path.lineTo((float)(rect.left + adj2), (float)(rect.top + adj1));
        path.close();
        return path;
    }

    private static Path getLeftRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.2f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.2f);
            adj2 = Math.round((float)rect.height() * 0.25f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.right - adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.right - adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj1), (float)rect.bottom);
        path.lineTo((float)(rect.right - adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getUpDownArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.25f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.25f);
            adj2 = Math.round((float)rect.height() * 0.25f);
        }
        path.moveTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj2));
        path.lineTo((float)(rect.right - adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.right - adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj2));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2));
        path.lineTo((float)rect.left, (float)(rect.top + adj2));
        path.close();
        return path;
    }

    private static Path getQuadArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adjLR1 = 0;
        int adjLR2 = 0;
        int adjLR3 = 0;
        int adjUD1 = 0;
        int adjUD2 = 0;
        int adjUD3 = 0;
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                adjLR1 = Math.round((float)rect.height() * values[0].floatValue());
                adjUD1 = Math.round((float)rect.width() * values[0].floatValue());
            } else {
                adjLR1 = Math.round((float)rect.height() * 0.3f);
                adjUD1 = Math.round((float)rect.width() * 0.3f);
            }
            if (values.length >= 2 && values[1] != null) {
                adjLR2 = Math.round((float)rect.height() * values[1].floatValue());
                adjUD2 = Math.round((float)rect.width() * values[1].floatValue());
            } else {
                adjLR2 = Math.round((float)rect.height() * 0.4f);
                adjUD2 = Math.round((float)rect.width() * 0.4f);
            }
            if (values.length >= 3 && values[2] != null) {
                adjLR3 = Math.round((float)rect.width() * values[2].floatValue());
                adjUD3 = Math.round((float)rect.height() * values[2].floatValue());
            } else {
                adjLR3 = Math.round((float)rect.width() * 0.2f);
                adjUD3 = Math.round((float)rect.height() * 0.2f);
            }
        } else {
            adjLR1 = Math.round((float)rect.height() * 0.3f);
            adjLR2 = Math.round((float)rect.height() * 0.4f);
            adjLR3 = Math.round((float)rect.width() * 0.2f);
            adjUD1 = Math.round((float)rect.width() * 0.3f);
            adjUD2 = Math.round((float)rect.width() * 0.4f);
            adjUD3 = Math.round((float)rect.height() * 0.2f);
        }
        path.moveTo((float)(rect.left + adjUD2), (float)(rect.bottom - adjLR2));
        path.lineTo((float)(rect.left + adjLR3), (float)(rect.bottom - adjLR2));
        path.lineTo((float)(rect.left + adjLR3), (float)(rect.bottom - adjLR1));
        path.lineTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adjLR3), (float)(rect.top + adjLR1));
        path.lineTo((float)(rect.left + adjLR3), (float)(rect.top + adjLR2));
        path.lineTo((float)(rect.left + adjUD2), (float)(rect.top + adjLR2));
        path.lineTo((float)(rect.left + adjUD2), (float)(rect.top + adjUD3));
        path.lineTo((float)(rect.left + adjUD1), (float)(rect.top + adjUD3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.right - adjUD1), (float)(rect.top + adjUD3));
        path.lineTo((float)(rect.right - adjUD2), (float)(rect.top + adjUD3));
        path.lineTo((float)(rect.right - adjUD2), (float)(rect.top + adjLR2));
        path.lineTo((float)(rect.right - adjLR3), (float)(rect.top + adjLR2));
        path.lineTo((float)(rect.right - adjLR3), (float)(rect.top + adjLR1));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adjLR3), (float)(rect.bottom - adjLR1));
        path.lineTo((float)(rect.right - adjLR3), (float)(rect.bottom - adjLR2));
        path.lineTo((float)(rect.right - adjUD2), (float)(rect.bottom - adjLR2));
        path.lineTo((float)(rect.right - adjUD2), (float)(rect.bottom - adjUD3));
        path.lineTo((float)(rect.right - adjUD1), (float)(rect.bottom - adjUD3));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.left + adjUD1), (float)(rect.bottom - adjUD3));
        path.lineTo((float)(rect.left + adjUD2), (float)(rect.bottom - adjUD3));
        path.close();
        return path;
    }

    private static Path getLeftRightUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adjLR1 = 0;
        int adjLR2 = 0;
        int adjLR3 = 0;
        int adjUD1 = 0;
        int adjUD2 = 0;
        int adjUD3 = 0;
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                adjLR1 = Math.round((float)rect.height() * (0.5f - values[0].floatValue()) * 10.0f / 7.0f);
                adjUD1 = Math.round((float)rect.width() * values[0].floatValue());
            } else {
                adjLR1 = Math.round((float)rect.height() * 0.2f * 10.0f / 7.0f);
                adjUD1 = Math.round((float)rect.width() * 0.3f);
            }
            if (values.length >= 2 && values[1] != null) {
                adjLR2 = Math.round((float)rect.height() * (0.5f - values[1].floatValue()) * 10.0f / 7.0f);
                adjUD2 = Math.round((float)rect.width() * values[1].floatValue());
            } else {
                adjLR2 = Math.round((float)rect.height() * 0.1f * 10.0f / 7.0f);
                adjUD2 = Math.round((float)rect.width() * 0.4f);
            }
            if (values.length >= 3 && values[2] != null) {
                adjLR3 = Math.round((float)rect.width() * values[2].floatValue() * 0.7f);
                adjUD3 = Math.round((float)rect.height() * values[2].floatValue());
            } else {
                adjLR3 = Math.round((float)rect.width() * 0.2f * 0.7f);
                adjUD3 = Math.round((float)rect.height() * 0.2f);
            }
        } else {
            adjLR1 = Math.round((float)rect.height() * 0.2f * 10.0f / 7.0f);
            adjLR2 = Math.round((float)rect.height() * 0.1f * 10.0f / 7.0f);
            adjLR3 = Math.round((float)rect.width() * 0.3f * 0.7f);
            adjUD1 = Math.round((float)rect.width() * 0.3f);
            adjUD2 = Math.round((float)rect.width() * 0.4f);
            adjUD3 = Math.round((float)rect.height() * 0.2f);
        }
        path.moveTo((float)(rect.left + adjLR3), (float)(rect.bottom - adjLR1 + adjLR2));
        path.lineTo((float)(rect.left + adjLR3), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.bottom - adjLR1));
        path.lineTo((float)(rect.left + adjLR3), (float)(rect.bottom - adjLR1 * 2));
        path.lineTo((float)(rect.left + adjLR3), (float)(rect.bottom - adjLR1 - adjLR2));
        path.lineTo((float)(rect.left + adjUD2), (float)(rect.bottom - adjLR1 - adjLR2));
        path.lineTo((float)(rect.left + adjUD2), (float)(rect.top + adjUD3));
        path.lineTo((float)(rect.left + adjUD1), (float)(rect.top + adjUD3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.right - adjUD1), (float)(rect.top + adjUD3));
        path.lineTo((float)(rect.right - adjUD2), (float)(rect.top + adjUD3));
        path.lineTo((float)(rect.right - adjUD2), (float)(rect.bottom - adjLR1 - adjLR2));
        path.lineTo((float)(rect.right - adjLR3), (float)(rect.bottom - adjLR1 - adjLR2));
        path.lineTo((float)(rect.right - adjLR3), (float)(rect.bottom - adjLR1 * 2));
        path.lineTo((float)rect.right, (float)(rect.bottom - adjLR1));
        path.lineTo((float)(rect.right - adjLR3), (float)rect.bottom);
        path.lineTo((float)(rect.right - adjLR3), (float)(rect.bottom - adjLR1 + adjLR2));
        path.close();
        return path;
    }

    private static Path getBentArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.7f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.125f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.7f);
            adj2 = Math.round((float)rect.height() * 0.125f);
        }
        float arrowHeight = (float)rect.height() * 0.57f;
        path.moveTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.top + arrowHeight);
        s_rect.set((float)rect.left, (float)(rect.top + adj2), (float)rect.left + (float)rect.width() * 1.04f, (float)rect.top + arrowHeight + (arrowHeight - (float)adj2));
        path.arcTo(s_rect, 180.0f, 90.0f);
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + arrowHeight / 2.0f);
        path.lineTo((float)(rect.left + adj1), (float)rect.top + arrowHeight);
        path.lineTo((float)(rect.left + adj1), (float)rect.top + arrowHeight / 2.0f + (arrowHeight - (float)(adj2 * 2)) / 2.0f);
        float smallOvalAdj = (arrowHeight - (float)(adj2 * 2)) / (float)rect.height();
        s_rect.set((float)rect.left + (float)rect.width() * smallOvalAdj, (float)rect.top + arrowHeight / 2.0f + (arrowHeight - (float)(adj2 * 2)) / 2.0f, (float)rect.left + (float)rect.width() * (1.14f - smallOvalAdj), (float)rect.top + arrowHeight + arrowHeight - (arrowHeight / 2.0f + (arrowHeight - (float)(adj2 * 2)) / 2.0f));
        path.arcTo(s_rect, 270.0f, -90.0f);
        path.lineTo((float)rect.left + (float)rect.width() * smallOvalAdj, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getUturnArrowPath(AutoShape shape, Rect rect) {
        int width = rect.width();
        int height = rect.height();
        path.moveTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.top + (float)height * 0.38f);
        s_rect.set((float)rect.left, (float)rect.top, (float)rect.right - (float)width * 0.14f, (float)rect.top + (float)height * 0.76f);
        path.arcTo(s_rect, 180.0f, 180.0f);
        path.lineTo((float)rect.right, (float)rect.top + (float)height * 0.38f);
        path.lineTo((float)rect.right - (float)width * 0.28f, (float)rect.top + (float)height * 0.66f);
        path.lineTo((float)rect.right - (float)width * 0.56f, (float)rect.top + (float)height * 0.38f);
        path.lineTo((float)rect.right - (float)width * 0.42000002f, (float)rect.top + (float)height * 0.38f);
        s_rect.set((float)rect.left + (float)width * 0.28f, (float)rect.top + (float)height * 0.28f, (float)rect.right - (float)width * 0.42000002f, (float)rect.top + (float)height * 0.48f);
        path.arcTo(s_rect, 0.0f, -180.0f);
        path.lineTo((float)rect.left + (float)width * 0.28f, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getLeftUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        float upAdj1 = 0.0f;
        float upAdj2 = 0.0f;
        float upAdj3 = 0.0f;
        float downAdj1 = 0.0f;
        float downAdj2 = 0.0f;
        float downAdj3 = 0.0f;
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                upAdj1 = (float)rect.width() * values[0].floatValue();
                downAdj1 = (float)rect.height() * values[0].floatValue();
            } else {
                upAdj1 = Math.round((float)rect.width() * 0.43f);
                downAdj1 = (float)rect.height() * 0.43f;
            }
            if (values.length >= 2 && values[1] != null) {
                upAdj2 = (float)rect.width() * values[1].floatValue();
                downAdj2 = (float)rect.height() * values[1].floatValue();
            } else {
                upAdj2 = Math.round((float)rect.width() * 0.86f);
                downAdj2 = (float)rect.height() * 0.86f;
            }
            if (values.length >= 3 && values[2] != null) {
                upAdj3 = (float)rect.height() * values[2].floatValue();
                downAdj3 = (float)rect.width() * values[2].floatValue();
            } else {
                upAdj3 = Math.round((float)rect.height() * 0.28f);
                downAdj3 = (float)rect.width() * 0.28f;
            }
        } else {
            upAdj1 = Math.round((float)rect.width() * 0.43f);
            upAdj2 = Math.round((float)rect.width() * 0.86f);
            upAdj3 = Math.round((float)rect.height() * 0.28f);
            downAdj1 = (float)rect.height() * 0.43f;
            downAdj2 = (float)rect.height() * 0.86f;
            downAdj3 = (float)rect.width() * 0.28f;
        }
        float arrowHeaderWidth = (float)rect.height() - downAdj1;
        float arrowTailWidth = arrowHeaderWidth - ((float)rect.height() - downAdj2) * 2.0f;
        path.moveTo((float)rect.left + downAdj3, (float)rect.top + downAdj2);
        path.lineTo((float)rect.left + downAdj3, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom - arrowHeaderWidth / 2.0f);
        path.lineTo((float)rect.left + downAdj3, (float)rect.top + downAdj1);
        path.lineTo((float)rect.left + downAdj3, (float)rect.top + downAdj2 - arrowTailWidth);
        arrowHeaderWidth = (float)rect.width() - upAdj1;
        path.lineTo((float)rect.left + upAdj2 - (arrowHeaderWidth - ((float)rect.width() - upAdj2) * 2.0f), (float)rect.top + downAdj2 - arrowTailWidth);
        arrowTailWidth = arrowHeaderWidth - ((float)rect.width() - upAdj2) * 2.0f;
        path.lineTo((float)rect.left + upAdj2 - arrowTailWidth, (float)rect.top + upAdj3);
        path.lineTo((float)rect.left + upAdj1, (float)rect.top + upAdj3);
        path.lineTo((float)rect.right - arrowHeaderWidth / 2.0f, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + upAdj3);
        path.lineTo((float)rect.left + upAdj2, (float)rect.top + upAdj3);
        path.lineTo((float)rect.left + upAdj2, (float)rect.top + downAdj2);
        path.close();
        return path;
    }

    private static Path getBentUpArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        float adj1 = 0.0f;
        float adj2 = 0.0f;
        float adj3 = 0.0f;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? (float)rect.width() * values[0].floatValue() : (float)Math.round((float)rect.width() * 0.43f);
            adj2 = values.length >= 2 && values[1] != null ? (float)rect.width() * values[1].floatValue() : (float)Math.round((float)rect.width() * 0.86f);
            adj3 = values.length >= 3 && values[2] != null ? (float)rect.height() * values[2].floatValue() : (float)Math.round((float)rect.height() * 0.28f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.43f);
            adj2 = Math.round((float)rect.width() * 0.86f);
            adj3 = Math.round((float)rect.height() * 0.28f);
        }
        float arrowHeaderWidth = (float)rect.width() - adj1;
        float arrowTailWidth = arrowHeaderWidth - ((float)rect.width() - adj2) * 2.0f;
        path.moveTo((float)rect.left + adj2 - arrowTailWidth, (float)rect.top + adj3);
        path.lineTo((float)rect.left + adj1, (float)rect.top + adj3);
        path.lineTo((float)rect.right - arrowHeaderWidth / 2.0f, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top + adj3);
        path.lineTo((float)rect.left + adj2, (float)rect.top + adj3);
        path.lineTo((float)rect.left + adj2, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        arrowTailWidth = (float)rect.height() * arrowTailWidth / (float)rect.width();
        path.lineTo((float)rect.left, (float)rect.bottom - arrowTailWidth);
        path.lineTo((float)rect.left + adj2 - (arrowHeaderWidth - ((float)rect.width() - adj2) * 2.0f), (float)rect.bottom - arrowTailWidth);
        path.close();
        return path;
    }

    private static List<Path> getCurvedRightArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        float adj1 = 0.0f;
        float adj2 = 0.0f;
        float adj3 = 0.0f;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? (float)rect.height() * values[0].floatValue() : (float)Math.round((float)rect.height() * 0.6f);
            adj2 = values.length >= 2 && values[1] != null ? (float)rect.height() * values[1].floatValue() : (float)Math.round((float)rect.height() * 0.9f);
            adj3 = values.length >= 3 && values[2] != null ? (float)rect.width() * values[2].floatValue() : (float)Math.round((float)rect.width() * 0.66667f);
        } else {
            adj1 = Math.round((float)rect.height() * 0.6f);
            adj2 = Math.round((float)rect.height() * 0.9f);
            adj3 = Math.round((float)rect.width() * 0.66667f);
        }
        float arrowHeight = (float)rect.height() * 0.4f;
        float d2 = (float)rect.height() - adj1;
        float d1 = arrowHeight - (arrowHeight - (adj2 - adj1)) * 2.0f;
        if (d1 < 0.0f) {
            d1 = 0.0f;
        }
        adj1 = d1;
        adj2 = d2;
        adj3 = (float)rect.width() - adj3;
        float ovalWidth = 2 * rect.width();
        float ovalHeight = (float)rect.bottom - adj2 / 2.0f - adj1 / 2.0f - (float)rect.top;
        path.moveTo((float)rect.right, (float)rect.top);
        s_rect.set((float)rect.left, (float)rect.top, (float)rect.left + ovalWidth, (float)rect.top + ovalHeight);
        path.arcTo(s_rect, 270.0f, -90.0f);
        path.lineTo((float)rect.left, (float)rect.top + ovalHeight / 2.0f + adj1);
        s_rect.set((float)rect.left, (float)rect.top + adj1, (float)rect.left + ovalWidth, (float)rect.top + ovalHeight + adj1);
        path.arcTo(s_rect, 180.0f, 90.0f);
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)rect.left, (float)rect.top + ovalHeight / 2.0f);
        double y = Math.sqrt(Math.pow(ovalHeight / 2.0f, 2.0) * (Math.pow(ovalWidth / 2.0f, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalWidth / 2.0f, 2.0));
        int angle = (int)(Math.atan(y / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)rect.left, (float)rect.top, (float)rect.left + ovalWidth, (float)rect.top + ovalHeight);
        path.arcTo(s_rect, 180.0f, (float)(-angle));
        path.setLastPoint((float)rect.right - adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y));
        path.lineTo((float)rect.right - adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y) + adj1 / 2.0f - adj2 / 2.0f);
        path.lineTo((float)rect.right, (float)rect.bottom - adj2 / 2.0f);
        path.lineTo((float)rect.right - adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y) + adj1 / 2.0f + adj2 / 2.0f);
        path.lineTo((float)rect.right - adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y) + adj1);
        s_rect.set((float)rect.left, (float)rect.top + adj1, (float)rect.left + ovalWidth, (float)rect.top + ovalHeight + adj1);
        path.arcTo(s_rect, (float)(180 - angle), (float)angle);
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static List<Path> getCurvedLeftArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        float adj1 = 0.0f;
        float adj2 = 0.0f;
        float adj3 = 0.0f;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? (float)rect.height() * values[0].floatValue() : (float)Math.round((float)rect.height() * 0.6f);
            adj2 = values.length >= 2 && values[1] != null ? (float)rect.height() * values[1].floatValue() : (float)Math.round((float)rect.height() * 0.9f);
            adj3 = values.length >= 3 && values[2] != null ? (float)rect.width() * values[2].floatValue() : (float)Math.round((float)rect.width() * 0.66667f);
        } else {
            adj1 = Math.round((float)rect.height() * 0.6f);
            adj2 = Math.round((float)rect.height() * 0.9f);
            adj3 = Math.round((float)rect.width() * 0.66667f);
        }
        float arrowHeight = (float)rect.height() * 0.4f;
        float d2 = (float)rect.height() - adj1;
        float d1 = arrowHeight - (arrowHeight - (adj2 - adj1)) * 2.0f;
        if (d1 < 0.0f) {
            d1 = 0.0f;
        }
        adj1 = d1;
        adj2 = d2;
        float ovalWidth = 2 * rect.width();
        float ovalHeight = (float)rect.bottom - adj2 / 2.0f - adj1 / 2.0f - (float)rect.top;
        path.moveTo((float)rect.right, (float)rect.top + ovalHeight / 2.0f);
        double y = Math.sqrt(Math.pow(ovalHeight / 2.0f, 2.0) * (Math.pow(ovalWidth / 2.0f, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalWidth / 2.0f, 2.0));
        int angle = (int)(Math.atan(y / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)rect.right - ovalWidth, (float)rect.top, (float)rect.right, (float)rect.top + ovalHeight);
        path.arcTo(s_rect, 0.0f, (float)angle);
        path.setLastPoint((float)rect.left + adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y));
        path.lineTo((float)rect.left + adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y) + adj1 / 2.0f - adj2 / 2.0f);
        path.lineTo((float)rect.left, (float)rect.bottom - adj2 / 2.0f);
        path.lineTo((float)rect.left + adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y) + adj1 / 2.0f + adj2 / 2.0f);
        path.lineTo((float)rect.left + adj3, (float)rect.top + ovalHeight / 2.0f + (float)((int)y) + adj1);
        s_rect.set((float)rect.right - ovalWidth, (float)rect.top + adj1, (float)rect.right, (float)rect.top + ovalHeight + adj1);
        path.arcTo(s_rect, (float)angle, (float)(-angle));
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)rect.left, (float)rect.top);
        s_rect.set((float)rect.right - ovalWidth, (float)rect.top, (float)rect.right, (float)rect.top + ovalHeight);
        path.arcTo(s_rect, 270.0f, 90.0f);
        path.lineTo((float)rect.right, (float)rect.top + ovalHeight / 2.0f + adj1);
        s_rect.set((float)rect.right - ovalWidth, (float)rect.top + adj1, (float)rect.right, (float)rect.top + ovalHeight + adj1);
        path.arcTo(s_rect, 0.0f, -90.0f);
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static List<Path> getCurvedUpArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        float adj1 = 0.0f;
        float adj2 = 0.0f;
        float adj3 = 0.0f;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? (float)rect.width() * values[0].floatValue() : (float)Math.round((float)rect.width() * 0.6f);
            adj2 = values.length >= 2 && values[1] != null ? (float)rect.width() * values[1].floatValue() : (float)Math.round((float)rect.width() * 0.9f);
            adj3 = values.length >= 3 && values[2] != null ? (float)rect.height() * values[2].floatValue() : (float)Math.round((float)rect.height() * 0.66667f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.6f);
            adj2 = Math.round((float)rect.width() * 0.9f);
            adj3 = Math.round((float)rect.height() * 0.33333f);
        }
        float arrowWidth = (float)rect.width() * 0.4f;
        float d2 = (float)rect.width() - adj1;
        float d1 = arrowWidth - (arrowWidth - (adj2 - adj1)) * 2.0f;
        if (d1 < 0.0f) {
            d1 = 0.0f;
        }
        adj1 = d1;
        adj2 = d2;
        float ovalHalfWidth = ((float)rect.width() - adj2 / 2.0f - adj1 / 2.0f) / 2.0f;
        float ovalHalfHeight = rect.height();
        path.moveTo((float)rect.left + ovalHalfWidth, (float)rect.bottom);
        double x = Math.sqrt(Math.pow(ovalHalfWidth, 2.0) * (Math.pow(ovalHalfHeight, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalHalfHeight, 2.0));
        int angle = (int)(Math.atan(x / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)rect.left, (float)rect.top - ovalHalfHeight, (float)rect.left + ovalHalfWidth * 2.0f, (float)rect.top + ovalHalfHeight);
        path.arcTo(s_rect, 90.0f, (float)(-angle));
        path.setLastPoint((float)rect.left + ovalHalfWidth + (float)x, (float)rect.top + adj3);
        path.lineTo((float)rect.left + ovalHalfWidth + (float)x + adj1 / 2.0f - adj2 / 2.0f, (float)rect.top + adj3);
        path.lineTo((float)rect.right - adj2 / 2.0f, (float)rect.top);
        path.lineTo((float)rect.left + ovalHalfWidth + (float)x + adj1 / 2.0f + adj2 / 2.0f, (float)rect.top + adj3);
        path.lineTo((float)rect.left + ovalHalfWidth + (float)x + adj1, (float)rect.top + adj3);
        s_rect.set((float)rect.left + adj1, (float)rect.top - ovalHalfHeight, (float)rect.left + ovalHalfWidth * 2.0f + adj1, (float)rect.top + ovalHalfHeight);
        path.arcTo(s_rect, (float)(90 - angle), (float)angle);
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)rect.left, (float)rect.top);
        s_rect.set((float)rect.left, (float)rect.top - ovalHalfHeight, (float)rect.left + ovalHalfWidth * 2.0f, (float)rect.top + ovalHalfHeight);
        path.arcTo(s_rect, 180.0f, -90.0f);
        path.lineTo((float)rect.left + ovalHalfWidth + adj1, (float)rect.bottom);
        s_rect.set((float)rect.left + adj1, (float)rect.top - ovalHalfHeight, (float)rect.left + ovalHalfWidth * 2.0f + adj1, (float)rect.top + ovalHalfHeight);
        path.arcTo(s_rect, 90.0f, 90.0f);
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static List<Path> getCurvedDownArrowPath(AutoShape shape, Rect rect) {
        ArrayList<Path> pathList = new ArrayList<Path>(2);
        Float[] values = shape.getAdjustData();
        Path path = new Path();
        float adj1 = 0.0f;
        float adj2 = 0.0f;
        float adj3 = 0.0f;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? (float)rect.width() * values[0].floatValue() : (float)Math.round((float)rect.width() * 0.6f);
            adj2 = values.length >= 2 && values[1] != null ? (float)rect.width() * values[1].floatValue() : (float)Math.round((float)rect.width() * 0.9f);
            adj3 = values.length >= 3 && values[2] != null ? (float)rect.height() * values[2].floatValue() : (float)Math.round((float)rect.height() * 0.66667f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.6f);
            adj2 = Math.round((float)rect.width() * 0.9f);
            adj3 = Math.round((float)rect.height() * 0.666667f);
        }
        float arrowWidth = (float)rect.width() * 0.4f;
        float d2 = (float)rect.width() - adj1;
        float d1 = arrowWidth - (arrowWidth - (adj2 - adj1)) * 2.0f;
        if (d1 < 0.0f) {
            d1 = 0.0f;
        }
        adj1 = d1;
        adj2 = d2;
        adj3 = (float)rect.height() - adj3;
        float ovalHalfWidth = ((float)rect.width() - adj2 / 2.0f - adj1 / 2.0f) / 2.0f;
        float ovalHalfHeight = rect.height();
        path.moveTo((float)rect.left, (float)rect.bottom);
        s_rect.set((float)rect.left, (float)rect.top, (float)rect.left + ovalHalfWidth * 2.0f, (float)rect.top + ovalHalfHeight * 2.0f);
        path.arcTo(s_rect, 180.0f, 90.0f);
        path.lineTo((float)rect.left + ovalHalfWidth + adj1, (float)rect.top);
        s_rect.set((float)rect.left + adj1, (float)rect.top, (float)rect.left + ovalHalfWidth * 2.0f + adj1, (float)rect.top + ovalHalfHeight * 2.0f);
        path.arcTo(s_rect, 270.0f, -90.0f);
        path.close();
        pathList.add(path);
        path = new Path();
        path.moveTo((float)rect.left + ovalHalfWidth, (float)rect.top);
        double x = Math.sqrt(Math.pow(ovalHalfWidth, 2.0) * (Math.pow(ovalHalfHeight, 2.0) - Math.pow(adj3, 2.0)) / Math.pow(ovalHalfHeight, 2.0));
        int angle = (int)(Math.atan(x / (double)adj3) * 180.0 / Math.PI);
        s_rect.set((float)rect.left, (float)rect.top, (float)rect.left + ovalHalfWidth * 2.0f, (float)rect.top + ovalHalfHeight * 2.0f);
        path.arcTo(s_rect, 270.0f, (float)angle);
        path.setLastPoint((float)rect.left + ovalHalfWidth + (float)x, (float)rect.bottom - adj3);
        path.lineTo((float)rect.left + ovalHalfWidth + (float)x + adj1 / 2.0f - adj2 / 2.0f, (float)rect.bottom - adj3);
        path.lineTo((float)rect.right - adj2 / 2.0f, (float)rect.bottom);
        path.lineTo((float)rect.left + ovalHalfWidth + (float)x + adj1 / 2.0f + adj2 / 2.0f, (float)rect.bottom - adj3);
        path.lineTo((float)rect.left + ovalHalfWidth + (float)x + adj1, (float)rect.bottom - adj3);
        s_rect.set((float)rect.left + adj1, (float)rect.top, (float)rect.left + ovalHalfWidth * 2.0f + adj1, (float)rect.top + ovalHalfHeight * 2.0f);
        path.arcTo(s_rect, (float)(270 + angle), (float)(-angle));
        path.close();
        pathList.add(path);
        return pathList;
    }

    private static Path getStripedRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.75f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.75f);
            adj2 = Math.round((float)rect.height() * 0.25f);
        }
        float len = (float)rect.width() * 0.03f;
        path.addRect((float)rect.left, (float)(rect.top + adj2), (float)rect.left + len, (float)(rect.bottom - adj2), Path.Direction.CW);
        path.addRect((float)rect.left + len * 2.0f, (float)(rect.top + adj2), (float)rect.left + len * 4.0f, (float)(rect.bottom - adj2), Path.Direction.CW);
        path.moveTo((float)rect.left + len * 5.0f, (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj2));
        path.lineTo((float)rect.left + len * 5.0f, (float)(rect.bottom - adj2));
        path.close();
        return path;
    }

    private static Path getNotchedRightArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.75f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.75f);
            adj2 = Math.round((float)rect.height() * 0.25f);
        }
        path.moveTo((float)rect.left, (float)(rect.bottom - adj2));
        path.lineTo((float)rect.left + (float)((rect.height() - adj2 * 2) * (rect.width() - adj1)) / (float)rect.height(), (float)rect.centerY());
        path.lineTo((float)rect.left, (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj2));
        path.close();
        return path;
    }

    private static Path getHomePlatePath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        adj1 = values != null && values.length == 1 && values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.75f);
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getChevronPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        adj1 = values != null && values.length == 1 && values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.75f);
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)(rect.left + rect.width() - adj1), (float)rect.centerY());
        path.close();
        return path;
    }

    private static Path getRightArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.67f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round((float)rect.width() * values[2].floatValue()) : Math.round((float)rect.width() * 0.83f);
            adj4 = values.length >= 4 && values[3] != null ? Math.round((float)rect.height() * values[3].floatValue()) : Math.round((float)rect.height() * 0.375f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.67f);
            adj2 = Math.round((float)rect.height() * 0.25f);
            adj3 = Math.round((float)rect.width() * 0.83f);
            adj4 = Math.round((float)rect.height() * 0.375f);
        }
        path.moveTo((float)rect.left, (float)rect.top);
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj4));
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + adj4));
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + adj2));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.lineTo((float)rect.left, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getLeftArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.33f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round((float)rect.width() * values[2].floatValue()) : Math.round((float)rect.width() * 0.17f);
            adj4 = values.length >= 4 && values[3] != null ? Math.round((float)rect.height() * values[3].floatValue()) : Math.round((float)rect.height() * 0.375f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.33f);
            adj2 = Math.round((float)rect.height() * 0.25f);
            adj3 = Math.round((float)rect.width() * 0.17f);
            adj4 = Math.round((float)rect.height() * 0.375f);
        }
        path.moveTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + adj4));
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj4));
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj1), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj2));
        path.close();
        return path;
    }

    private static Path getUpArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.height() * values[0].floatValue()) : Math.round((float)rect.height() * 0.33f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.width() * values[1].floatValue()) : Math.round((float)rect.width() * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round((float)rect.height() * values[2].floatValue()) : Math.round((float)rect.height() * 0.17f);
            adj4 = values.length >= 4 && values[3] != null ? Math.round((float)rect.width() * values[3].floatValue()) : Math.round((float)rect.width() * 0.375f);
        } else {
            adj1 = Math.round((float)rect.height() * 0.33f);
            adj2 = Math.round((float)rect.width() * 0.25f);
            adj3 = Math.round((float)rect.height() * 0.17f);
            adj4 = Math.round((float)rect.width() * 0.375f);
        }
        path.moveTo((float)rect.left, (float)rect.bottom);
        path.lineTo((float)rect.left, (float)(rect.top + adj1));
        path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj1));
        path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj3));
        path.lineTo((float)(rect.left + adj2), (float)(rect.top + adj3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.right - adj2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj4), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj4), (float)(rect.top + adj1));
        path.lineTo((float)rect.right, (float)(rect.top + adj1));
        path.lineTo((float)rect.right, (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getDownArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.height() * values[0].floatValue()) : Math.round((float)rect.height() * 0.67f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.width() * values[1].floatValue()) : Math.round((float)rect.width() * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round((float)rect.height() * values[2].floatValue()) : Math.round((float)rect.height() * 0.83f);
            adj4 = values.length >= 4 && values[3] != null ? Math.round((float)rect.width() * values[3].floatValue()) : Math.round((float)rect.width() * 0.375f);
        } else {
            adj1 = Math.round((float)rect.height() * 0.67f);
            adj2 = Math.round((float)rect.width() * 0.25f);
            adj3 = Math.round((float)rect.height() * 0.83f);
            adj4 = Math.round((float)rect.width() * 0.375f);
        }
        path.moveTo((float)rect.left, (float)(rect.top + adj1));
        path.lineTo((float)rect.left, (float)rect.top);
        path.lineTo((float)rect.right, (float)rect.top);
        path.lineTo((float)rect.right, (float)(rect.top + adj1));
        path.lineTo((float)(rect.right - adj4), (float)(rect.top + adj1));
        path.lineTo((float)(rect.right - adj4), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj2), (float)(rect.top + adj3));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj3));
        path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj1));
        path.close();
        return path;
    }

    private static Path getLeftRightArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.width() * values[0].floatValue()) : Math.round((float)rect.width() * 0.35f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.height() * values[1].floatValue()) : Math.round((float)rect.height() * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round((float)rect.width() * values[2].floatValue()) : Math.round((float)rect.width() * 0.13f);
            adj4 = values.length >= 4 && values[3] != null ? Math.round((float)rect.height() * values[3].floatValue()) : Math.round((float)rect.height() * 0.375f);
        } else {
            adj1 = Math.round((float)rect.width() * 0.35f);
            adj2 = Math.round((float)rect.height() * 0.25f);
            adj3 = Math.round((float)rect.width() * 0.13f);
            adj4 = Math.round((float)rect.height() * 0.375f);
        }
        path.moveTo((float)(rect.left + adj1), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.left + adj3), (float)(rect.bottom - adj2));
        path.lineTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + adj2));
        path.lineTo((float)(rect.left + adj3), (float)(rect.top + adj4));
        path.lineTo((float)(rect.left + adj1), (float)(rect.top + adj4));
        path.lineTo((float)(rect.left + adj1), (float)rect.top);
        path.lineTo((float)(rect.right - adj1), (float)rect.top);
        path.lineTo((float)(rect.right - adj1), (float)(rect.top + adj4));
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + adj4));
        path.lineTo((float)(rect.right - adj3), (float)(rect.top + adj2));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - adj3), (float)(rect.bottom - adj2));
        path.lineTo((float)(rect.right - adj3), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.right - adj1), (float)(rect.bottom - adj4));
        path.lineTo((float)(rect.right - adj1), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj1), (float)rect.bottom);
        path.close();
        return path;
    }

    private static Path getUpDownArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int adj1 = 0;
        int adj2 = 0;
        int adj3 = 0;
        int adj4 = 0;
        if (values != null && values.length >= 1) {
            adj1 = values[0] != null ? Math.round((float)rect.height() * values[0].floatValue()) : Math.round((float)rect.height() * 0.25f);
            adj2 = values.length >= 2 && values[1] != null ? Math.round((float)rect.width() * values[1].floatValue()) : Math.round((float)rect.width() * 0.25f);
            adj3 = values.length >= 3 && values[2] != null ? Math.round((float)rect.height() * values[2].floatValue()) : Math.round((float)rect.height() * 0.125f);
            adj4 = values.length >= 4 && values[3] != null ? Math.round((float)rect.width() * values[3].floatValue()) : Math.round((float)rect.width() * 0.375f);
        } else {
            adj1 = Math.round((float)rect.height() * 0.25f);
            adj2 = Math.round((float)rect.width() * 0.25f);
            adj3 = Math.round((float)rect.height() * 0.125f);
            adj4 = Math.round((float)rect.width() * 0.375f);
        }
        path.moveTo((float)rect.left, (float)(rect.top + adj1));
        path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj1));
        path.lineTo((float)(rect.left + adj4), (float)(rect.top + adj3));
        path.lineTo((float)(rect.left + adj2), (float)(rect.top + adj3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.right - adj2), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj4), (float)(rect.top + adj3));
        path.lineTo((float)(rect.right - adj4), (float)(rect.top + adj1));
        path.lineTo((float)rect.right, (float)(rect.top + adj1));
        path.lineTo((float)rect.right, (float)(rect.bottom - adj1));
        path.lineTo((float)(rect.right - adj4), (float)(rect.bottom - adj1));
        path.lineTo((float)(rect.right - adj4), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.right - adj2), (float)(rect.bottom - adj3));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.left + adj2), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.left + adj4), (float)(rect.bottom - adj3));
        path.lineTo((float)(rect.left + adj4), (float)(rect.bottom - adj1));
        path.lineTo((float)rect.left, (float)(rect.bottom - adj1));
        path.close();
        return path;
    }

    private static Path getQuadArrowCalloutPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        int lrAdj1 = 0;
        int lrAdj2 = 0;
        int lrAdj3 = 0;
        int lrAdj4 = 0;
        int udAdj1 = 0;
        int udAdj2 = 0;
        int udAdj3 = 0;
        int udAdj4 = 0;
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                lrAdj1 = Math.round((float)rect.width() * values[0].floatValue());
                udAdj1 = Math.round((float)rect.height() * values[0].floatValue());
            } else {
                lrAdj1 = Math.round((float)rect.width() * 0.25f);
                udAdj1 = Math.round((float)rect.height() * 0.25f);
            }
            if (values.length >= 2 && values[1] != null) {
                lrAdj2 = Math.round((float)rect.height() * values[1].floatValue());
                udAdj2 = Math.round((float)rect.width() * values[1].floatValue());
            } else {
                lrAdj2 = Math.round((float)rect.height() * 0.375f);
                udAdj2 = Math.round((float)rect.width() * 0.375f);
            }
            if (values.length >= 3 && values[2] != null) {
                lrAdj3 = Math.round((float)rect.width() * values[2].floatValue());
                udAdj3 = Math.round((float)rect.height() * values[2].floatValue());
            } else {
                lrAdj3 = Math.round((float)rect.width() * 0.125f);
                udAdj3 = Math.round((float)rect.height() * 0.125f);
            }
            if (values.length >= 4 && values[3] != null) {
                lrAdj4 = Math.round((float)rect.height() * values[3].floatValue());
                udAdj4 = Math.round((float)rect.width() * values[3].floatValue());
            } else {
                lrAdj4 = Math.round((float)rect.height() * 0.45f);
                udAdj4 = Math.round((float)rect.width() * 0.45f);
            }
        } else {
            lrAdj1 = Math.round((float)rect.width() * 0.25f);
            lrAdj2 = Math.round((float)rect.height() * 0.375f);
            lrAdj3 = Math.round((float)rect.width() * 0.125f);
            lrAdj4 = Math.round((float)rect.height() * 0.45f);
            udAdj1 = Math.round((float)rect.height() * 0.25f);
            udAdj2 = Math.round((float)rect.width() * 0.375f);
            udAdj3 = Math.round((float)rect.height() * 0.125f);
            udAdj4 = Math.round((float)rect.width() * 0.45f);
        }
        path.moveTo((float)(rect.left + lrAdj1), (float)(rect.bottom - lrAdj4));
        path.lineTo((float)(rect.left + lrAdj3), (float)(rect.bottom - lrAdj4));
        path.lineTo((float)(rect.left + lrAdj3), (float)(rect.bottom - lrAdj2));
        path.lineTo((float)rect.left, (float)rect.centerY());
        path.lineTo((float)(rect.left + lrAdj3), (float)(rect.top + lrAdj2));
        path.lineTo((float)(rect.left + lrAdj3), (float)(rect.top + lrAdj4));
        path.lineTo((float)(rect.left + lrAdj1), (float)(rect.top + lrAdj4));
        path.lineTo((float)(rect.left + lrAdj1), (float)(rect.top + udAdj1));
        path.lineTo((float)(rect.left + udAdj4), (float)(rect.top + udAdj1));
        path.lineTo((float)(rect.left + udAdj4), (float)(rect.top + udAdj3));
        path.lineTo((float)(rect.left + udAdj2), (float)(rect.top + udAdj3));
        path.lineTo((float)rect.centerX(), (float)rect.top);
        path.lineTo((float)(rect.right - udAdj2), (float)(rect.top + udAdj3));
        path.lineTo((float)(rect.right - udAdj4), (float)(rect.top + udAdj3));
        path.lineTo((float)(rect.right - udAdj4), (float)(rect.top + udAdj1));
        path.lineTo((float)(rect.right - lrAdj1), (float)(rect.top + udAdj1));
        path.lineTo((float)(rect.right - lrAdj1), (float)(rect.top + lrAdj4));
        path.lineTo((float)(rect.right - lrAdj3), (float)(rect.top + lrAdj4));
        path.lineTo((float)(rect.right - lrAdj3), (float)(rect.top + lrAdj2));
        path.lineTo((float)rect.right, (float)rect.centerY());
        path.lineTo((float)(rect.right - lrAdj3), (float)(rect.bottom - lrAdj2));
        path.lineTo((float)(rect.right - lrAdj3), (float)(rect.bottom - lrAdj4));
        path.lineTo((float)(rect.right - lrAdj1), (float)(rect.bottom - lrAdj4));
        path.lineTo((float)(rect.right - lrAdj1), (float)(rect.bottom - udAdj1));
        path.lineTo((float)(rect.right - udAdj4), (float)(rect.bottom - udAdj1));
        path.lineTo((float)(rect.right - udAdj4), (float)(rect.bottom - udAdj3));
        path.lineTo((float)(rect.right - udAdj2), (float)(rect.bottom - udAdj3));
        path.lineTo((float)rect.centerX(), (float)rect.bottom);
        path.lineTo((float)(rect.left + udAdj2), (float)(rect.bottom - udAdj3));
        path.lineTo((float)(rect.left + udAdj4), (float)(rect.bottom - udAdj3));
        path.lineTo((float)(rect.left + udAdj4), (float)(rect.bottom - udAdj1));
        path.lineTo((float)(rect.left + lrAdj1), (float)(rect.bottom - udAdj1));
        path.close();
        return path;
    }

    private static Path getCircularArrowPath(AutoShape shape, Rect rect) {
        Float[] values = shape.getAdjustData();
        float adj1 = 0.0f;
        float adj2 = 0.0f;
        float adj3 = 0.0f;
        int len = 100;
        if (values != null && values.length >= 1) {
            if (values[0] != null) {
                adj1 = values[0].floatValue() * 0.3295496f;
                if (adj1 < 0.0f) {
                    adj1 += 360.0f;
                }
            } else {
                adj1 = 180.0f;
            }
            if (values.length >= 2 && values[1] != null) {
                adj2 = values[1].floatValue() * 0.3295496f;
                if (adj2 < 0.0f) {
                    adj2 += 360.0f;
                }
            } else {
                adj2 = 0.0f;
            }
            adj3 = values.length >= 3 && values[2] != null ? values[2].floatValue() * (float)len : (float)len * 0.25f;
        } else {
            adj1 = 180.0f;
            adj2 = 0.0f;
            adj3 = (float)len * 0.25f;
        }
        float outerRadius = len / 2;
        path.moveTo((float)((double)outerRadius * Math.cos((double)adj1 * Math.PI / 180.0)), (float)((double)outerRadius * Math.sin((double)adj1 * Math.PI / 180.0)));
        s_rect.set(-outerRadius, -outerRadius, outerRadius, outerRadius);
        path.arcTo(s_rect, adj1, (adj2 - adj1 + 360.0f) % 360.0f);
        path.lineTo((float)((double)(outerRadius + (float)len * 0.125f) * Math.cos((double)adj2 * Math.PI / 180.0)), (float)((double)(outerRadius + (float)len * 0.125f) * Math.sin((double)adj2 * Math.PI / 180.0)));
        path.lineTo((float)((double)((outerRadius + adj3) * 0.5f) * Math.cos((double)(adj2 + 30.0f) * Math.PI / 180.0)), (float)((double)((outerRadius + adj3) * 0.5f) * Math.sin((double)(adj2 + 30.0f) * Math.PI / 180.0)));
        path.lineTo((float)((double)(adj3 - (float)len * 0.125f) * Math.cos((double)adj2 * Math.PI / 180.0)), (float)((double)(adj3 - (float)len * 0.125f) * Math.sin((double)adj2 * Math.PI / 180.0)));
        s_rect.set(-adj3, -adj3, adj3, adj3);
        path.arcTo(s_rect, adj2, -(adj2 - adj1 + 360.0f) % 360.0f);
        path.close();
        Matrix m = new Matrix();
        m.postScale((float)rect.width() / 100.0f, (float)rect.height() / 100.0f);
        path.transform(m);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }
}

