/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.widgets.mricheditor.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.widgets.mricheditor.ActionType;
import com.ahmadullahpk.alldocumentreader.widgets.mricheditor.RichEditorAction;

public class ActionImageView
extends AppCompatImageView {
    private ActionType mActionType;
    private RichEditorAction mRichEditorAction;
    private Context mContext;
    private boolean enabled = true;
    private boolean activated = true;
    private int enabledColor;
    private int disabledColor;
    private int activatedColor;
    private int deactivatedColor;

    public ActionImageView(Context context) {
        this(context, null);
    }

    public ActionImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ActionImageView);
        this.mActionType = ActionType.fromInteger(ta.getInteger(R.styleable.ActionImageView_actionType, 0));
        ta.recycle();
    }

    public ActionType getActionType() {
        return this.mActionType;
    }

    public void setActionType(ActionType mActionType) {
        this.mActionType = mActionType;
    }

    public RichEditorAction getRichEditorAction() {
        return this.mRichEditorAction;
    }

    public void setRichEditorAction(RichEditorAction mRichEditorAction) {
        this.mRichEditorAction = mRichEditorAction;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void command() {
        switch (this.mActionType) {
            case BOLD: {
                this.mRichEditorAction.bold();
                break;
            }
            case ITALIC: {
                this.mRichEditorAction.italic();
                break;
            }
            case UNDERLINE: {
                this.mRichEditorAction.underline();
                break;
            }
            case SUBSCRIPT: {
                this.mRichEditorAction.subscript();
                break;
            }
            case SUPERSCRIPT: {
                this.mRichEditorAction.superscript();
                break;
            }
            case STRIKETHROUGH: {
                this.mRichEditorAction.strikethrough();
                break;
            }
            case NORMAL: {
                this.mRichEditorAction.formatPara();
                break;
            }
            case H1: {
                this.mRichEditorAction.formatH1();
                break;
            }
            case H2: {
                this.mRichEditorAction.formatH2();
                break;
            }
            case H3: {
                this.mRichEditorAction.formatH3();
                break;
            }
            case H4: {
                this.mRichEditorAction.formatH4();
                break;
            }
            case H5: {
                this.mRichEditorAction.formatH5();
                break;
            }
            case H6: {
                this.mRichEditorAction.formatH6();
                break;
            }
            case JUSTIFY_LEFT: {
                this.mRichEditorAction.justifyLeft();
                break;
            }
            case JUSTIFY_CENTER: {
                this.mRichEditorAction.justifyCenter();
                break;
            }
            case JUSTIFY_RIGHT: {
                this.mRichEditorAction.justifyRight();
                break;
            }
            case JUSTIFY_FULL: {
                this.mRichEditorAction.justifyFull();
                break;
            }
            case ORDERED: {
                this.mRichEditorAction.insertOrderedList();
                break;
            }
            case UNORDERED: {
                this.mRichEditorAction.insertUnorderedList();
                break;
            }
            case INDENT: {
                this.mRichEditorAction.indent();
                break;
            }
            case OUTDENT: {
                this.mRichEditorAction.outdent();
                break;
            }
            case LINE: {
                this.mRichEditorAction.insertHorizontalRule();
                break;
            }
            case BLOCK_QUOTE: {
                this.mRichEditorAction.formatBlockquote();
                break;
            }
            case BLOCK_CODE: {
                this.mRichEditorAction.formatBlockCode();
                break;
            }
            case CODE_VIEW: {
                this.mRichEditorAction.codeView();
                break;
            }
        }
    }

    public void command(String value) {
        switch (this.mActionType) {
            case FAMILY: {
                break;
            }
            case SIZE: {
                break;
            }
            case LINE_HEIGHT: {
                break;
            }
            case FORE_COLOR: {
                break;
            }
            case BACK_COLOR: {
                break;
            }
            case IMAGE: {
                break;
            }
            case LINK: {
                break;
            }
            case TABLE: {
                break;
            }
        }
    }

    public void resetStatus() {
    }

    public int getEnabledColor() {
        return this.enabledColor;
    }

    public void setEnabledColor(int enabledColor) {
        this.enabledColor = enabledColor;
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
    }

    public int getActivatedColor() {
        return this.activatedColor;
    }

    public void setActivatedColor(int activatedColor) {
        this.activatedColor = activatedColor;
    }

    public int getDeactivatedColor() {
        return this.deactivatedColor;
    }

    public void setDeactivatedColor(int deactivatedColor) {
        this.deactivatedColor = deactivatedColor;
    }

    public void notifyFontStyleChange(final ActionType type, final String value) {
        this.post(new Runnable(){

            @Override
            public void run() {
                switch (type) {
                    case BOLD: 
                    case ITALIC: 
                    case UNDERLINE: 
                    case SUBSCRIPT: 
                    case SUPERSCRIPT: 
                    case STRIKETHROUGH: 
                    case NORMAL: 
                    case H1: 
                    case H2: 
                    case H3: 
                    case H4: 
                    case H5: 
                    case H6: 
                    case JUSTIFY_LEFT: 
                    case JUSTIFY_CENTER: 
                    case JUSTIFY_RIGHT: 
                    case JUSTIFY_FULL: 
                    case ORDERED: 
                    case UNORDERED: {
                        ActionImageView.this.setColorFilter(ContextCompat.getColor((Context)ActionImageView.this.mContext, (int)(Boolean.parseBoolean(value) ? ActionImageView.this.getActivatedColor() : ActionImageView.this.getDeactivatedColor())));
                        break;
                    }
                }
            }
        });
    }
}

