/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.util;

import androidx.annotation.RequiresApi;
import com.ahmadullahpk.alldocumentreader.util.RtfElementGroup;
import com.ahmadullahpk.alldocumentreader.util.RtfElementSymbol;
import com.ahmadullahpk.alldocumentreader.util.RtfParseException;
import com.ahmadullahpk.alldocumentreader.util.RtfText;
import com.ahmadullahpk.alldocumentreader.util.RtfWordControl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

public class RtfReader {
    private String rtf;
    private int pos;
    private int len;
    private char tchar;
    private RtfElementGroup group;
    public RtfElementGroup root = null;

    protected void getChar() {
        if (this.pos < this.rtf.length()) {
            this.tchar = this.rtf.charAt(this.pos++);
        }
    }

    protected int hexdec(String s) {
        return Integer.parseInt(s, 16);
    }

    protected boolean isDigit() {
        return this.tchar >= '0' && this.tchar <= '9';
    }

    protected boolean isLetter() {
        if (this.tchar >= 'A' && this.tchar <= 'Z') {
            return true;
        }
        return this.tchar >= 'a' && this.tchar <= 'z';
    }

    protected void parseStartGroup() {
        RtfElementGroup newGroup = new RtfElementGroup();
        if (this.group != null) {
            newGroup.parent = this.group;
        }
        if (this.root == null) {
            this.group = newGroup;
            this.root = newGroup;
        } else {
            this.group.children.add(newGroup);
            this.group = newGroup;
        }
    }

    protected void parseEndGroup() {
        this.group = this.group.parent;
    }

    protected void parseControlWord() {
        this.getChar();
        String word = "";
        while (this.isLetter()) {
            word = word + this.tchar;
            this.getChar();
        }
        int parameter = -1;
        boolean negative = false;
        if (this.tchar == '-') {
            this.getChar();
            negative = true;
        }
        while (this.isDigit()) {
            if (parameter == -1) {
                parameter = 0;
            }
            parameter = parameter * 10 + Integer.parseInt(this.tchar + "");
            this.getChar();
        }
        if (parameter == -1) {
            parameter = 1;
        }
        if (negative) {
            parameter = -parameter;
        }
        if (word.equals("u")) {
            if (this.tchar == ' ') {
                this.getChar();
            }
            if (this.tchar == '\\' && this.rtf.charAt(this.pos) == '\'') {
                this.pos += 3;
            }
            if (negative) {
                parameter += 65536;
            }
        } else if (this.tchar != ' ') {
            --this.pos;
        }
        RtfWordControl rtfWord = new RtfWordControl();
        rtfWord.word = word;
        rtfWord.parameter = parameter;
        this.group.children.add(rtfWord);
    }

    protected void parseControlSymbol() {
        this.getChar();
        char symbol = this.tchar;
        int parameter = 0;
        if (symbol == '\'') {
            this.getChar();
            String firstChar = this.tchar + "";
            this.getChar();
            String secondChar = this.tchar + "";
            parameter = this.hexdec(firstChar + secondChar);
        }
        RtfElementSymbol rtfSymbol = new RtfElementSymbol();
        rtfSymbol.symbol = symbol;
        rtfSymbol.parameter = parameter;
        this.group.children.add(rtfSymbol);
    }

    protected void parseControl() {
        this.getChar();
        --this.pos;
        if (this.isLetter()) {
            this.parseControlWord();
        } else {
            this.parseControlSymbol();
        }
    }

    protected void parseText() throws RtfParseException {
        String text = "";
        boolean terminate = false;
        do {
            terminate = false;
            if (this.tchar == '\\') {
                this.getChar();
                switch (this.tchar) {
                    case '\\': 
                    case '{': 
                    case '}': {
                        break;
                    }
                    default: {
                        this.pos -= 2;
                        terminate = true;
                        break;
                    }
                }
            } else if (this.tchar == '{' || this.tchar == '}') {
                --this.pos;
                terminate = true;
            }
            if (terminate) continue;
            text = text + this.tchar;
            this.getChar();
        } while (!terminate && this.pos < this.len);
        RtfText rtfText = new RtfText();
        rtfText.text = text;
        if (this.group == null) {
            throw new RtfParseException("Invalid RTF file.");
        }
        this.group.children.add(rtfText);
    }

    @RequiresApi(api=24)
    public void parse(File rtfFile) throws RtfParseException {
        try (FileInputStream fis = new FileInputStream(rtfFile);){
            this.parse(fis);
        }
        catch (IOException e) {
            throw new RtfParseException(e.getMessage());
        }
    }

    @RequiresApi(api=24)
    public void parse(InputStream rtfStream) throws RtfParseException {
        String rtfSource = new BufferedReader(new InputStreamReader(rtfStream)).lines().collect(Collectors.joining("\n"));
        this.parse(rtfSource);
    }

    public void parse(String rtfSource) throws RtfParseException {
        this.rtf = rtfSource;
        this.pos = 0;
        this.len = this.rtf.length();
        this.group = null;
        this.root = null;
        block5: while (this.pos < this.len) {
            this.getChar();
            if (this.tchar == '\n' || this.tchar == '\r') continue;
            switch (this.tchar) {
                case '{': {
                    this.parseStartGroup();
                    continue block5;
                }
                case '}': {
                    this.parseEndGroup();
                    continue block5;
                }
                case '\\': {
                    this.parseControl();
                    continue block5;
                }
            }
            this.parseText();
        }
    }
}

