/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.sql.language;

import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.sql.Query;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.language.CompletedTrigger;
import com.raizlabs.android.dbflow.sql.language.SQLOperator;
import com.raizlabs.android.dbflow.sql.language.Trigger;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;

public class TriggerMethod<TModel>
implements Query {
    public static final String DELETE = "DELETE";
    public static final String INSERT = "INSERT";
    public static final String UPDATE = "UPDATE";
    final Trigger trigger;
    private IProperty[] properties;
    private final String methodName;
    Class<TModel> onTable;
    boolean forEachRow = false;
    private SQLOperator whenCondition;

    TriggerMethod(Trigger trigger, String methodName, Class<TModel> onTable, IProperty ... properties) {
        this.trigger = trigger;
        this.methodName = methodName;
        this.onTable = onTable;
        if (properties != null && properties.length > 0 && properties[0] != null) {
            if (!methodName.equals(UPDATE)) {
                throw new IllegalArgumentException("An Trigger OF can only be used with an UPDATE method");
            }
            this.properties = properties;
        }
    }

    @NonNull
    public TriggerMethod<TModel> forEachRow() {
        this.forEachRow = true;
        return this;
    }

    @NonNull
    public TriggerMethod<TModel> when(@NonNull SQLOperator condition) {
        this.whenCondition = condition;
        return this;
    }

    @NonNull
    public CompletedTrigger<TModel> begin(@NonNull Query triggerLogicQuery) {
        return new CompletedTrigger(this, triggerLogicQuery);
    }

    public String getQuery() {
        QueryBuilder queryBuilder = new QueryBuilder((Object)this.trigger.getQuery()).append((Object)this.methodName);
        if (this.properties != null && this.properties.length > 0) {
            queryBuilder.appendSpaceSeparated((Object)"OF").appendArray((Object[])this.properties);
        }
        queryBuilder.appendSpaceSeparated((Object)"ON").append((Object)FlowManager.getTableName(this.onTable));
        if (this.forEachRow) {
            queryBuilder.appendSpaceSeparated((Object)"FOR EACH ROW");
        }
        if (this.whenCondition != null) {
            queryBuilder.append((Object)" WHEN ");
            this.whenCondition.appendConditionToQuery(queryBuilder);
            queryBuilder.appendSpace();
        }
        queryBuilder.appendSpace();
        return queryBuilder.getQuery();
    }
}

