/*
 * Decompiled with CFR 0.152.
 */
package com.raizlabs.android.dbflow.structure.database;

import android.database.sqlite.SQLiteException;
import android.support.annotation.NonNull;
import com.raizlabs.android.dbflow.config.DatabaseDefinition;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.NaturalOrderComparator;
import com.raizlabs.android.dbflow.sql.QueryBuilder;
import com.raizlabs.android.dbflow.sql.migration.Migration;
import com.raizlabs.android.dbflow.structure.ModelAdapter;
import com.raizlabs.android.dbflow.structure.ModelViewAdapter;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseDatabaseHelper {
    public static final String MIGRATION_PATH = "migrations";
    private final DatabaseDefinition databaseDefinition;

    public BaseDatabaseHelper(@NonNull DatabaseDefinition databaseDefinition) {
        this.databaseDefinition = databaseDefinition;
    }

    @NonNull
    public DatabaseDefinition getDatabaseDefinition() {
        return this.databaseDefinition;
    }

    public void onCreate(@NonNull DatabaseWrapper db) {
        this.checkForeignKeySupport(db);
        this.executeCreations(db);
        this.executeMigrations(db, -1, db.getVersion());
    }

    public void onUpgrade(@NonNull DatabaseWrapper db, int oldVersion, int newVersion) {
        this.checkForeignKeySupport(db);
        this.executeCreations(db);
        this.executeMigrations(db, oldVersion, newVersion);
    }

    public void onOpen(@NonNull DatabaseWrapper db) {
        this.checkForeignKeySupport(db);
    }

    public void onDowngrade(@NonNull DatabaseWrapper db, int oldVersion, int newVersion) {
        this.checkForeignKeySupport(db);
    }

    protected void checkForeignKeySupport(@NonNull DatabaseWrapper database) {
        if (this.databaseDefinition.isForeignKeysSupported()) {
            database.execSQL("PRAGMA foreign_keys=ON;");
            FlowLog.log(FlowLog.Level.I, "Foreign Keys supported. Enabling foreign key features.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCreations(@NonNull DatabaseWrapper database) {
        try {
            database.beginTransaction();
            List<ModelAdapter> modelAdapters = this.databaseDefinition.getModelAdapters();
            for (ModelAdapter modelAdapter : modelAdapters) {
                try {
                    database.execSQL(modelAdapter.getCreationQuery());
                }
                catch (SQLiteException e) {
                    FlowLog.logError(e);
                }
            }
            List<ModelViewAdapter> modelViews = this.databaseDefinition.getModelViewAdapters();
            for (ModelViewAdapter modelView : modelViews) {
                QueryBuilder queryBuilder = new QueryBuilder().append((Object)"CREATE VIEW IF NOT EXISTS").appendSpaceSeparated((Object)modelView.getViewName()).append((Object)"AS ").append((Object)modelView.getCreationQuery());
                try {
                    database.execSQL(queryBuilder.getQuery());
                }
                catch (SQLiteException e) {
                    FlowLog.logError(e);
                }
            }
            database.setTransactionSuccessful();
        }
        finally {
            database.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeMigrations(@NonNull DatabaseWrapper db, int oldVersion, int newVersion) {
        try {
            List<String> files = Arrays.asList(FlowManager.getContext().getAssets().list("migrations/" + this.databaseDefinition.getDatabaseName()));
            Collections.sort(files, new NaturalOrderComparator());
            HashMap<Integer, ArrayList<String>> migrationFileMap = new HashMap<Integer, ArrayList<String>>();
            for (String file : files) {
                try {
                    Integer version = Integer.valueOf(file.replace(".sql", ""));
                    ArrayList<String> fileList = (ArrayList<String>)migrationFileMap.get(version);
                    if (fileList == null) {
                        fileList = new ArrayList<String>();
                        migrationFileMap.put(version, fileList);
                    }
                    fileList.add(file);
                }
                catch (NumberFormatException e) {
                    FlowLog.log(FlowLog.Level.W, "Skipping invalidly named file: " + file, e);
                }
            }
            Map<Integer, List<Migration>> migrationMap = this.databaseDefinition.getMigrations();
            int curVersion = oldVersion + 1;
            try {
                db.beginTransaction();
                for (int i = curVersion; i <= newVersion; ++i) {
                    List<Migration> migrationsList;
                    List migrationFiles = (List)migrationFileMap.get(i);
                    if (migrationFiles != null) {
                        for (String migrationFile : migrationFiles) {
                            this.executeSqlScript(db, migrationFile);
                            FlowLog.log(FlowLog.Level.I, migrationFile + " executed successfully.");
                        }
                    }
                    if ((migrationsList = migrationMap.get(i)) == null) continue;
                    for (Migration migration : migrationsList) {
                        migration.onPreMigrate();
                        migration.migrate(db);
                        migration.onPostMigrate();
                        FlowLog.log(FlowLog.Level.I, migration.getClass() + " executed successfully.");
                    }
                }
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }
        catch (IOException e) {
            FlowLog.log(FlowLog.Level.E, "Failed to execute migrations.", e);
        }
    }

    private void executeSqlScript(@NonNull DatabaseWrapper db, @NonNull String file) {
        try {
            String line;
            InputStream input = FlowManager.getContext().getAssets().open("migrations/" + this.getDatabaseDefinition().getDatabaseName() + "/" + file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String querySuffix = ";";
            String queryCommentPrefix = "--";
            StringBuffer query = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                boolean isEndOfQuery = line.endsWith(querySuffix);
                if (line.startsWith(queryCommentPrefix)) continue;
                if (isEndOfQuery) {
                    line = line.substring(0, line.length() - querySuffix.length());
                }
                query.append(" ").append(line);
                if (!isEndOfQuery) continue;
                db.execSQL(query.toString());
                query = new StringBuffer();
            }
            String queryString = query.toString();
            if (queryString.trim().length() > 0) {
                db.execSQL(queryString);
            }
        }
        catch (IOException e) {
            FlowLog.log(FlowLog.Level.E, "Failed to execute " + file, e);
        }
    }
}

