/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.jni;

import io.agora.rtm.jni.AgoraRtmServiceJNI;
import io.agora.rtm.jni.ILocalCallInvitation;
import io.agora.rtm.jni.IRemoteCallInvitation;

public class IRtmCallManager {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IRtmCallManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IRtmCallManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    public int sendLocalInvitation(ILocalCallInvitation invitation) {
        return AgoraRtmServiceJNI.IRtmCallManager_sendLocalInvitation(this.swigCPtr, this, ILocalCallInvitation.getCPtr(invitation), invitation);
    }

    public int acceptRemoteInvitation(IRemoteCallInvitation invitation) {
        return AgoraRtmServiceJNI.IRtmCallManager_acceptRemoteInvitation(this.swigCPtr, this, IRemoteCallInvitation.getCPtr(invitation), invitation);
    }

    public int refuseRemoteInvitation(IRemoteCallInvitation invitation) {
        return AgoraRtmServiceJNI.IRtmCallManager_refuseRemoteInvitation(this.swigCPtr, this, IRemoteCallInvitation.getCPtr(invitation), invitation);
    }

    public int cancelLocalInvitation(ILocalCallInvitation invitation) {
        return AgoraRtmServiceJNI.IRtmCallManager_cancelLocalInvitation(this.swigCPtr, this, ILocalCallInvitation.getCPtr(invitation), invitation);
    }

    public ILocalCallInvitation createLocalCallInvitation(String calleeId) {
        long cPtr = AgoraRtmServiceJNI.IRtmCallManager_createLocalCallInvitation(this.swigCPtr, this, calleeId);
        return cPtr == 0L ? null : new ILocalCallInvitation(cPtr, true);
    }

    public void release() {
        AgoraRtmServiceJNI.IRtmCallManager_release(this.swigCPtr, this);
    }
}

