/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import io.agora.common.Logging;
import io.agora.rtm.internal.ConnectionChangeBroadcastReceiver;
import io.agora.rtm.internal.Connectivity;
import io.agora.rtm.internal.RtmClientMessage;
import io.agora.rtm.jni.AgoraRtmServiceJNI;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;

class CommonUtility {
    public static final int EVT_PHONE_STATE_CHANGED = 22;
    private static final String TAG = CommonUtility.class.getSimpleName();
    private WeakReference<Context> mContext;
    private static WeakReference<Application> mApplication;
    private volatile boolean mAccessible = false;
    private AgoraPhoneStateListener mPhoneStateListener = null;
    private ConnectionChangeBroadcastReceiver mConnectionBroadcastReceiver = null;
    private int mMobileType = -1;
    private int batteryPercentage = 255;
    private int mOrientation = -1;
    private boolean mLocalVideoEnabled = false;
    private static final int VIDEO_SOURCE_TYPE_NULL = 0;
    private static final int VIDEO_SOURCE_TYPE_DEFAULT = 1;
    private static final int VIDEO_SOURCE_TYPE_CUSTOMIZED = 2;
    private static final int VIDEO_SOURCE_TYPE_EXTERNAL_DEPRECATED = 3;
    private int mVideoSourceType = 1;
    private static final String PREFIX_URI = "content://";
    private String localIpv4 = null;
    private String localIpv6 = null;
    private boolean shouldGetIp = true;

    public CommonUtility(Context context) {
        this.mContext = new WeakReference<Context>(context);
        try {
            this.mPhoneStateListener = new AgoraPhoneStateListener();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 288);
        }
        catch (Exception e) {
            Logging.e(TAG, "Unable to create PhoneStateListener, ", e);
        }
        this.monitorConnectionEvent(true);
        this.mAccessible = true;
        Logging.i(TAG, "[init] done!");
    }

    public void destroy() {
        this.mAccessible = false;
        Context context = (Context)this.mContext.get();
        if (this.mPhoneStateListener != null && context != null) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            telephonyManager.listen((PhoneStateListener)this.mPhoneStateListener, 0);
            this.mPhoneStateListener = null;
        }
        this.monitorConnectionEvent(false);
        this.mContext.clear();
        Logging.i(TAG, "[destroy] done!");
    }

    public int getNetworkType() {
        Context context = (Context)this.mContext.get();
        if (context == null || !this.mAccessible) {
            return -1;
        }
        if (CommonUtility.checkAccessNetworkState(context)) {
            return Connectivity.getNetworkType(context);
        }
        return -1;
    }

    public byte[] getNetworkInfo() {
        Context context = (Context)this.mContext.get();
        if (context == null || !this.mAccessible) {
            return null;
        }
        RtmClientMessage.MediaNetworkInfo ni = this.doGetNetworkInfo(context);
        if (ni != null) {
            return ni.marshall();
        }
        return null;
    }

    public void notifyNetworkChange() {
        Context context = (Context)this.mContext.get();
        if (context == null || !this.mAccessible) {
            return;
        }
        this.shouldGetIp = true;
        byte[] networkInfo = this.getNetworkInfo();
        if (networkInfo == null || !this.mAccessible) {
            return;
        }
        AgoraRtmServiceJNI.nativeNotifyNetworkChange(networkInfo);
    }

    public int getAndroidVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean canGetDefaultContext() {
        boolean r = false;
        if (Looper.myLooper() == Looper.getMainLooper() || Build.VERSION.SDK_INT >= 18) {
            r = true;
        }
        return r;
    }

    public static String getAppPrivateStorageDir(Context context) {
        File file;
        if ("mounted".equals(Environment.getExternalStorageState()) && (file = context.getExternalFilesDir(null)) != null) {
            return file.getAbsolutePath();
        }
        return context.getFilesDir().getAbsolutePath();
    }

    private static String getAndroidID(Context context) {
        return "";
    }

    public static String[] getLocalHostList() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<String> ips = new ArrayList<String>();
            for (NetworkInterface intf : interfaces) {
                if (intf.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = CommonUtility.inetAddressToIpAddress(addr, true);
                    if (ip == null) continue;
                    ips.add(ip);
                }
            }
            if (!ips.isEmpty()) {
                String[] addresses = new String[ips.size()];
                int i = 0;
                Iterator iterator = ips.iterator();
                while (iterator.hasNext()) {
                    String ip;
                    addresses[i] = ip = (String)iterator.next();
                    ++i;
                }
                return addresses;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getLocalHost(boolean is_ipv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                if (intf.getName().startsWith("usb")) continue;
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String ip = CommonUtility.inetAddressToIpAddress(addr, is_ipv4);
                    if (ip == null || ip.isEmpty()) continue;
                    return ip;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    private boolean isSimulatorProperty() {
        int suspectCount = 0;
        String hardware = "";
        String arch = "";
        String baseBandVersion = "";
        String buildFlavor = "";
        String productBoard = "";
        String boardPlatform = "";
        String manufacturer = Build.MANUFACTURER;
        try {
            hardware = CommonUtility.getSystemProperty("ro.hardware");
            if (null == hardware || hardware.toLowerCase().equals("intel")) {
                ++suspectCount;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "get property hardware fail.");
        }
        Logging.i(TAG, "hardware = " + hardware + ", suspectCount = " + suspectCount);
        try {
            arch = System.getProperty("os.arch");
            if (null == arch || arch.toLowerCase().equals("i686") && !manufacturer.toLowerCase().contains("asus")) {
                Logging.i(TAG, "arch = " + arch + ", suspectCount = " + ++suspectCount);
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "get property arch fail.");
        }
        if (Build.VERSION.SDK_INT > 28) {
            if (hardware.toLowerCase().contains("ttvm")) {
                suspectCount += 10;
            } else if (hardware.toLowerCase().contains("nox")) {
                suspectCount += 10;
            }
            try {
                buildFlavor = CommonUtility.getSystemProperty("ro.build.flavor");
                if (null == buildFlavor || buildFlavor.contains("vbox") || buildFlavor.contains("sdk_gphone")) {
                    Logging.i(TAG, "buildFlavor = " + buildFlavor + ", suspectCount = " + ++suspectCount);
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property buildFlavor fail.");
            }
            try {
                productBoard = CommonUtility.getSystemProperty("ro.product.board");
                if (null == productBoard || productBoard.contains("android") | productBoard.contains("goldfish")) {
                    Logging.i(TAG, "productBoard = " + productBoard + ", suspectCount = " + ++suspectCount);
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property productBoard fail.");
            }
            try {
                boardPlatform = CommonUtility.getSystemProperty("ro.board.platform");
                if (null == boardPlatform || boardPlatform.contains("android")) {
                    Logging.i(TAG, "boardPlatform = " + boardPlatform + ", suspectCount = " + ++suspectCount);
                }
            }
            catch (Exception e) {
                Logging.e(TAG, "get property boardPlatform fail.");
            }
        }
        return suspectCount > 0;
    }

    private static String getSystemProperty(String name) throws Exception {
        Class<?> systemPropertyClazz = Class.forName("android.os.SystemProperties");
        return (String)systemPropertyClazz.getMethod("get", String.class).invoke(systemPropertyClazz, name);
    }

    public void monitorConnectionEvent(boolean monitor) {
        if (monitor) {
            if (this.mConnectionBroadcastReceiver == null) {
                try {
                    this.mConnectionBroadcastReceiver = new ConnectionChangeBroadcastReceiver(this);
                    Context context = (Context)this.mContext.get();
                    if (context != null && this.mConnectionBroadcastReceiver != null) {
                        context.registerReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
                    }
                }
                catch (Exception e) {
                    Logging.e(TAG, "Unable to create ConnectionChangeBroadcastReceiver, ", e);
                }
            }
        } else {
            try {
                Context context = (Context)this.mContext.get();
                if (context != null && this.mConnectionBroadcastReceiver != null) {
                    context.unregisterReceiver((BroadcastReceiver)this.mConnectionBroadcastReceiver);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mConnectionBroadcastReceiver = null;
        }
    }

    private static boolean checkAccessNetworkState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkPermission("android.permission.ACCESS_NETWORK_STATE", Process.myPid(), Process.myUid());
        return res == 0;
    }

    private RtmClientMessage.MediaNetworkInfo doGetNetworkInfo(Context context) {
        if (context == null || !this.mAccessible) {
            return null;
        }
        RtmClientMessage.MediaNetworkInfo ni = new RtmClientMessage.MediaNetworkInfo();
        if (!CommonUtility.checkAccessNetworkState(context)) {
            ni.ssid = "";
            ni.bssid = "";
            ni.rssi = 0;
            ni.signalLevel = 0;
            ni.frequency = 0;
            ni.linkspeed = 0;
            return ni;
        }
        if (this.shouldGetIp) {
            String lhv6;
            String lh = CommonUtility.getLocalHost(true);
            if (lh != null) {
                ni.localIp4 = lh;
            }
            if ((lhv6 = CommonUtility.getLocalHost(false)) != null) {
                ni.localIp6 = lhv6;
            }
            this.localIpv4 = lh;
            this.localIpv6 = lhv6;
            this.shouldGetIp = false;
        } else {
            if (this.localIpv4 != null) {
                ni.localIp4 = this.localIpv4;
            }
            if (this.localIpv6 != null) {
                ni.localIp6 = this.localIpv6;
            }
        }
        NetworkInfo networkInfo = Connectivity.getNetworkInfo(context);
        ni.networkType = Connectivity.getNetworkType(networkInfo);
        if (networkInfo != null) {
            ni.networkSubtype = networkInfo.getSubtype();
        }
        ni.dnsList = Connectivity.getDnsList();
        if (ni.dnsList.isEmpty()) {
            ni.dnsList = Connectivity.getDnsFromConnectionManager(context);
        }
        if (ni.networkType == 2) {
            WifiInfo wifiInfo;
            InetAddress addr;
            if (!CommonUtility.checkAccessWifiState(context)) {
                ni.ssid = "";
                ni.bssid = "";
                ni.rssi = 0;
                ni.signalLevel = 0;
                ni.frequency = 0;
                ni.linkspeed = 0;
                return ni;
            }
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            DhcpInfo dhcp = wifiManager.getDhcpInfo();
            if (dhcp != null && (addr = CommonUtility.intToInetAddress(dhcp.gateway)) != null) {
                ni.gatewayIp4 = addr.getHostAddress();
            }
            if ((wifiInfo = wifiManager.getConnectionInfo()) != null) {
                ni.ssid = "";
                ni.bssid = "";
                ni.rssi = wifiInfo.getRssi();
                ni.signalLevel = WifiManager.calculateSignalLevel((int)ni.rssi, (int)5);
                ni.linkspeed = wifiInfo.getLinkSpeed();
                if (Build.VERSION.SDK_INT >= 21) {
                    int freq;
                    ni.frequency = freq = wifiInfo.getFrequency();
                    if (freq >= 5000) {
                        ni.networkSubtype = 101;
                    } else if (freq >= 2400) {
                        ni.networkSubtype = 100;
                    }
                }
            }
        } else if (this.mPhoneStateListener != null) {
            try {
                ni.rssi = this.mPhoneStateListener.getRssi();
                ni.signalLevel = this.mPhoneStateListener.getLevel();
                ni.asu = this.mPhoneStateListener.getAsuLevel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ni;
    }

    private static String inetAddressToIpAddress(InetAddress address, boolean is_ipv4) {
        if (!address.isLoopbackAddress()) {
            if (is_ipv4 && address instanceof Inet4Address) {
                Inet4Address address4 = (Inet4Address)address;
                return address4.getHostAddress();
            }
            if (!is_ipv4 && address instanceof Inet6Address && !address.isLinkLocalAddress()) {
                Inet6Address address6 = (Inet6Address)address;
                return address6.getHostAddress();
            }
        }
        return null;
    }

    private static boolean checkAccessWifiState(Context context) {
        if (context == null) {
            return false;
        }
        int res = context.checkPermission("android.permission.ACCESS_WIFI_STATE", Process.myPid(), Process.myUid());
        return res == 0;
    }

    private static InetAddress intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssetsCacheFile(Context context, String pathOrUri) {
        Logging.i(TAG, "getAssetsCacheFile filePath: " + pathOrUri);
        boolean isUri = pathOrUri.startsWith(PREFIX_URI);
        try {
            String fileName = "wm_image_cache";
            File cacheFile = new File(context.getCacheDir(), fileName);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
            InputStream inputStream = null;
            if (isUri) {
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(Uri.parse((String)pathOrUri), "r");
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                inputStream = new FileInputStream(fileDescriptor);
            } else {
                inputStream = context.getAssets().open(pathOrUri);
            }
            try (FileOutputStream outputStream = new FileOutputStream(cacheFile);){
                int len;
                byte[] buf = new byte[1024];
                while ((len = inputStream.read(buf)) > 0) {
                    outputStream.write(buf, 0, len);
                }
            }
            finally {
                inputStream.close();
            }
            return cacheFile.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private class AgoraPhoneStateListener
    extends PhoneStateListener {
        private SignalStrength mSignalStrenth;
        private boolean phoneStatusNeedResume = false;

        public int getRssi() {
            int rssi = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                rssi = this.invokeMethod("getDbm");
            }
            return rssi;
        }

        public int getLevel() {
            return this.invokeMethod("getLevel");
        }

        public int getAsuLevel() {
            int asuLevel = 0;
            if (Build.VERSION.SDK_INT <= 28) {
                asuLevel = this.invokeMethod("getAsuLevel");
            }
            return asuLevel;
        }

        private int invokeMethod(String methodName) {
            try {
                Method method;
                if (this.mSignalStrenth != null && (method = this.mSignalStrenth.getClass().getDeclaredMethod(methodName, new Class[0])) != null) {
                    return (Integer)method.invoke((Object)this.mSignalStrenth, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            Context context = (Context)CommonUtility.this.mContext.get();
            if (context == null || !CommonUtility.this.mAccessible) {
                return;
            }
            super.onSignalStrengthsChanged(signalStrength);
            this.mSignalStrenth = signalStrength;
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            Context context = (Context)CommonUtility.this.mContext.get();
            if (context == null || !CommonUtility.this.mAccessible) {
                return;
            }
            super.onCallStateChanged(state, incomingNumber);
            switch (state) {
                case 0: {
                    if (!this.phoneStatusNeedResume) break;
                    this.phoneStatusNeedResume = false;
                    Logging.i(TAG, "system phone call end delay 1000ms");
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                        }
                    }, 1000L);
                    break;
                }
                case 1: {
                    Logging.i(TAG, "system phone call ring");
                    this.phoneStatusNeedResume = true;
                    break;
                }
                case 2: {
                    Logging.i(TAG, "system phone call start");
                    this.phoneStatusNeedResume = true;
                    break;
                }
            }
        }
    }

    public static class MobileType {
        public static final int Unknown = -1;
        public static final int Gsm = 0;
        public static final int Cdma = 1;
        public static final int Wcdma = 2;
        public static final int Lte = 3;
    }
}

