/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import io.agora.common.Logging;
import io.agora.common.LruCache;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.ErrorInfo;
import io.agora.rtm.LocalInvitation;
import io.agora.rtm.RemoteInvitation;
import io.agora.rtm.ResultCallback;
import io.agora.rtm.RtmCallEventListener;
import io.agora.rtm.RtmCallManager;
import io.agora.rtm.internal.LocalInvitationWrapper;
import io.agora.rtm.internal.RemoteInvitationWrapper;
import io.agora.rtm.internal.RtmClientImpl;
import io.agora.rtm.jni.AgoraRtmServiceJNI;
import io.agora.rtm.jni.ILocalCallInvitation;
import io.agora.rtm.jni.INVITATION_API_CALL_ERR_CODE;
import io.agora.rtm.jni.IRemoteCallInvitation;
import io.agora.rtm.jni.IRtmCallEventHandler;
import io.agora.rtm.jni.IRtmCallManager;
import io.agora.rtm.jni.LOCAL_INVITATION_ERR_CODE;
import io.agora.rtm.jni.REMOTE_INVITATION_ERR_CODE;
import java.util.concurrent.atomic.AtomicReference;

class RtmCallManagerImpl
extends RtmCallManager {
    private static final String TAG = RtmCallManagerImpl.class.getSimpleName();
    private RtmClientImpl rtmClient;
    private AtomicReference<RtmCallEventListener> eventListenerAtomic = new AtomicReference();
    private IRtmCallManager callManagerNative;
    private CallEventHandlerNative callEventListenerNative;
    final byte[] lock = new byte[0];
    boolean isNativeAttached = false;
    private LruCache<Long, LocalInvitationWrapper> localInvitationLruCache = new LruCache(50);
    private LruCache<Long, RemoteInvitationWrapper> remoteInvitationLruCache = new LruCache(50);

    RtmCallManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean attach(RtmClientImpl rtmClient) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.rtmClient = rtmClient;
            this.callEventListenerNative = new CallEventHandlerNative();
            this.callManagerNative = rtmClient.mRtmServiceNative.getRtmCallManager(this.callEventListenerNative);
            this.isNativeAttached = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.callManagerNative != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.callManagerNative != null) {
                this.callManagerNative.release();
                this.callManagerNative = null;
            }
            if (this.callEventListenerNative != null) {
                this.callEventListenerNative.delete();
                this.callEventListenerNative = null;
            }
            this.rtmClient = null;
            this.isNativeAttached = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setEventListener(RtmCallEventListener eventListener) {
        this.eventListenerAtomic.set(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalInvitation createLocalInvitation(String calleeId) {
        Logging.i(TAG, "create call invitation, callee: " + Logging.desensetize(calleeId));
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.nativeNotInitialized()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            LocalInvitationWrapper invitationWrapper = LocalInvitationWrapper.create(this.callManagerNative, calleeId);
            if (invitationWrapper == null) {
                Logging.e(TAG, "failed to create invitation");
            } else {
                this.localInvitationLruCache.put(AgoraRtmServiceJNI.getLocalInvitationKey(invitationWrapper.invitationNative), invitationWrapper);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return invitationWrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void sendLocalInvitation(LocalInvitation invitation, ResultCallback<Void> resultCallback) {
        INVITATION_API_CALL_ERR_CODE apiErr;
        Logging.i(TAG, "send invite");
        if (!(invitation instanceof LocalInvitationWrapper)) {
            Logging.e(TAG, "[send] invalid invitation: " + invitation);
            apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            LocalInvitationWrapper invitationWrapper = (LocalInvitationWrapper)invitation;
            byte[] byArray = this.lock;
            // MONITORENTER : this.lock
            if (this.nativeNotInitialized()) {
                apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int ret = this.callManagerNative.sendLocalInvitation(invitationWrapper.invitationNative);
                Logging.i(TAG, "send invite to " + Logging.desensetize(invitationWrapper.getCalleeId()) + " ret: " + ret);
                apiErr = RtmCallManagerImpl.valueToApiCallErrEnumSafe(ret);
            }
            // MONITOREXIT : byArray
        }
        RtmCallManagerImpl.handleApiCallResult(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void acceptRemoteInvitation(RemoteInvitation invitation, ResultCallback<Void> resultCallback) {
        INVITATION_API_CALL_ERR_CODE apiErr;
        Logging.i(TAG, "accept invitation");
        if (!(invitation instanceof RemoteInvitationWrapper)) {
            Logging.e(TAG, "invalid invitation: " + invitation);
            apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            byte[] byArray = this.lock;
            // MONITORENTER : this.lock
            RemoteInvitationWrapper invitationWrapper = (RemoteInvitationWrapper)invitation;
            if (this.nativeNotInitialized()) {
                apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int ret = this.callManagerNative.acceptRemoteInvitation(invitationWrapper.invitationNative);
                Logging.i(TAG, "accept invite from " + Logging.desensetize(invitationWrapper.getCallerId()) + " ret: " + ret);
                apiErr = RtmCallManagerImpl.valueToApiCallErrEnumSafe(ret);
            }
            // MONITOREXIT : byArray
        }
        RtmCallManagerImpl.handleApiCallResult(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void refuseRemoteInvitation(RemoteInvitation invitation, ResultCallback<Void> resultCallback) {
        INVITATION_API_CALL_ERR_CODE apiErr;
        Logging.i(TAG, "refuse invitation");
        if (!(invitation instanceof RemoteInvitationWrapper)) {
            Logging.e(TAG, "refuse invalid invitation: " + invitation);
            apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            byte[] byArray = this.lock;
            // MONITORENTER : this.lock
            RemoteInvitationWrapper invitationWrapper = (RemoteInvitationWrapper)invitation;
            if (this.nativeNotInitialized()) {
                apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int ret = this.callManagerNative.refuseRemoteInvitation(invitationWrapper.invitationNative);
                Logging.i(TAG, "refuse invite from " + Logging.desensetize(invitationWrapper.getCallerId()) + " ret: " + ret);
                apiErr = RtmCallManagerImpl.valueToApiCallErrEnumSafe(ret);
            }
            // MONITOREXIT : byArray
        }
        RtmCallManagerImpl.handleApiCallResult(apiErr, resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void cancelLocalInvitation(LocalInvitation invitation, ResultCallback<Void> resultCallback) {
        INVITATION_API_CALL_ERR_CODE apiErr;
        Logging.i(TAG, "cancel invitation");
        if (!(invitation instanceof LocalInvitationWrapper)) {
            Logging.e(TAG, "invalid invitation: " + invitation);
            apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        } else {
            byte[] byArray = this.lock;
            // MONITORENTER : this.lock
            LocalInvitationWrapper invitationWrapper = (LocalInvitationWrapper)invitation;
            if (this.nativeNotInitialized()) {
                apiErr = INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_NOT_STARTED;
            } else {
                int ret = this.callManagerNative.cancelLocalInvitation(invitationWrapper.invitationNative);
                Logging.i(TAG, "cancel invite to " + Logging.desensetize(invitationWrapper.getCalleeId()) + " ret: " + ret);
                apiErr = RtmCallManagerImpl.valueToApiCallErrEnumSafe(ret);
            }
            // MONITOREXIT : byArray
        }
        RtmCallManagerImpl.handleApiCallResult(apiErr, resultCallback);
    }

    private static void handleApiCallResult(@NonNull INVITATION_API_CALL_ERR_CODE apiCallError, ResultCallback<Void> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (apiCallError == INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_OK) {
            resultCallback.onSuccess(null);
        } else {
            resultCallback.onFailure(new ErrorInfo(apiCallError.swigValue(), apiCallError.toString()));
        }
    }

    private boolean nativeNotInitialized() {
        if (this.callManagerNative == null || this.rtmClient == null || this.rtmClient.mRtmServiceNative == null) {
            Logging.w(TAG, "rtm native not ready");
            return true;
        }
        return false;
    }

    @NonNull
    private static INVITATION_API_CALL_ERR_CODE valueToApiCallErrEnumSafe(int value) {
        try {
            return INVITATION_API_CALL_ERR_CODE.swigToEnum(value);
        }
        catch (IllegalArgumentException e) {
            Logging.e("RTM_EXCEPTION", e.getMessage());
            return INVITATION_API_CALL_ERR_CODE.INVITATION_API_CALL_ERR_INVALID_ARGUMENT;
        }
    }

    private class CallEventHandlerNative
    extends IRtmCallEventHandler {
        private CallEventHandlerNative() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationReceivedByPeer(ILocalCallInvitation localInvitation) {
            Logging.i(TAG, "local invite received by peer");
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                LocalInvitationWrapper localInvitationWrapper = (LocalInvitationWrapper)RtmCallManagerImpl.this.localInvitationLruCache.get(AgoraRtmServiceJNI.getLocalInvitationKey(localInvitation));
                // ** MonitorExit[var3_2] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (localInvitationWrapper != null && currentListener != null) {
                    currentListener.onLocalInvitationReceivedByPeer(localInvitationWrapper);
                } else {
                    Logging.e(TAG, "received by peer but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationAccepted(ILocalCallInvitation localInvitation, String response) {
            Logging.i(TAG, "local invite accepted, response: " + Logging.desensetize(response));
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                LocalInvitationWrapper invitationWrapper = (LocalInvitationWrapper)RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey(localInvitation));
                // ** MonitorExit[var4_3] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (invitationWrapper != null && currentListener != null) {
                    currentListener.onLocalInvitationAccepted(invitationWrapper, response);
                } else {
                    Logging.e(TAG, "accepted but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationRefused(ILocalCallInvitation localInvitation, String response) {
            Logging.i(TAG, "local invite refused, response: " + Logging.desensetize(response));
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                LocalInvitationWrapper invitationWrapper = (LocalInvitationWrapper)RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey(localInvitation));
                // ** MonitorExit[var4_3] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (invitationWrapper != null && currentListener != null) {
                    currentListener.onLocalInvitationRefused(invitationWrapper, response);
                } else {
                    Logging.e(TAG, "refused but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationCanceled(ILocalCallInvitation localInvitation) {
            Logging.i(TAG, "local invite canceled");
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                LocalInvitationWrapper localInvitationWrapper = (LocalInvitationWrapper)RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey(localInvitation));
                // ** MonitorExit[var3_2] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (localInvitationWrapper != null && currentListener != null) {
                    currentListener.onLocalInvitationCanceled(localInvitationWrapper);
                } else {
                    Logging.e(TAG, "canceled but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocalInvitationFailure(ILocalCallInvitation localInvitation, LOCAL_INVITATION_ERR_CODE errorCode) {
            Logging.i(TAG, "local invite failure: " + errorCode);
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                LocalInvitationWrapper localInvitationWrapper = (LocalInvitationWrapper)RtmCallManagerImpl.this.localInvitationLruCache.remove(AgoraRtmServiceJNI.getLocalInvitationKey(localInvitation));
                // ** MonitorExit[var4_3] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (localInvitationWrapper != null && currentListener != null) {
                    currentListener.onLocalInvitationFailure(localInvitationWrapper, errorCode.swigValue());
                } else {
                    Logging.e(TAG, "failure but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationReceived(IRemoteCallInvitation remoteInvitation) {
            Logging.i(TAG, "remote invite received, caller: " + Logging.desensetize(remoteInvitation.getCallerId()));
            RemoteInvitationWrapper invitationWrapper = new RemoteInvitationWrapper(remoteInvitation);
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                RtmCallManagerImpl.this.remoteInvitationLruCache.put(AgoraRtmServiceJNI.getRemoteInvitationKey(remoteInvitation), invitationWrapper);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (currentListener != null) {
                    currentListener.onRemoteInvitationReceived(invitationWrapper);
                } else {
                    Logging.e(TAG, "remote received but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationAccepted(IRemoteCallInvitation remoteInvitation) {
            Logging.i(TAG, "remote invite accepted");
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                RemoteInvitationWrapper invitationWrapper = (RemoteInvitationWrapper)RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey(remoteInvitation));
                // ** MonitorExit[var3_2] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (invitationWrapper != null && currentListener != null) {
                    currentListener.onRemoteInvitationAccepted(invitationWrapper);
                } else {
                    Logging.e(TAG, "remote accepted but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationRefused(IRemoteCallInvitation remoteInvitation) {
            Logging.i(TAG, "remote invite refused");
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                RemoteInvitationWrapper invitationWrapper = (RemoteInvitationWrapper)RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey(remoteInvitation));
                // ** MonitorExit[var3_2] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (invitationWrapper != null && currentListener != null) {
                    currentListener.onRemoteInvitationRefused(invitationWrapper);
                } else {
                    Logging.e(TAG, "remote refused but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationCanceled(IRemoteCallInvitation remoteInvitation) {
            Logging.i(TAG, "remote invitation canceled");
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                RemoteInvitationWrapper invitationWrapper = (RemoteInvitationWrapper)RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey(remoteInvitation));
                // ** MonitorExit[var3_2] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (invitationWrapper != null && currentListener != null) {
                    currentListener.onRemoteInvitationCanceled(invitationWrapper);
                } else {
                    Logging.e(TAG, "remote canceled but callback target lost!");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteInvitationFailure(IRemoteCallInvitation remoteInvitation, REMOTE_INVITATION_ERR_CODE errorCode) {
            Logging.i(TAG, "remote invite failure: " + errorCode);
            byte[] byArray = RtmCallManagerImpl.this.lock;
            synchronized (RtmCallManagerImpl.this.lock) {
                RemoteInvitationWrapper invitationWrapper = (RemoteInvitationWrapper)RtmCallManagerImpl.this.remoteInvitationLruCache.remove(AgoraRtmServiceJNI.getRemoteInvitationKey(remoteInvitation));
                // ** MonitorExit[var4_3] (shouldn't be in output)
                RtmCallEventListener currentListener = (RtmCallEventListener)RtmCallManagerImpl.this.eventListenerAtomic.get();
                if (invitationWrapper != null && currentListener != null) {
                    currentListener.onRemoteInvitationFailure(invitationWrapper, errorCode.swigValue());
                } else {
                    Logging.e(TAG, "remote failure but callback target lost!");
                }
                return;
            }
        }
    }
}

