/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.mediaio.AgoraSurfaceView;
import io.agora.rtc.mediaio.MediaIO;
import io.agora.rtc.video.VideoCapture;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class AgoraVideoDebugger {
    public static final String TAG = AgoraVideoDebugger.class.getSimpleName();
    public static final boolean ENABLE_DEBUG = false;
    public static final boolean VERBOSE = false;
    public static final boolean VERBOSE_DETAIL = false;
    public static final boolean DIRECT_OES = false;
    static DebugViewHolder capturePreviewHolder;
    static DebugViewHolder observerPreviewHolder;
    static DebugViewHolder i420BufferPreviewHolder;
    static DebugViewHolder textureBufferPreviewHolder;
    static boolean yuvRender;
    static int textureFrameCnt;
    static int droppedTextureFrameCnt;

    public static AgoraSurfaceView exampleUsage(Activity activity) {
        AgoraSurfaceView agoraSurfaceView = new AgoraSurfaceView((Context)activity);
        ViewGroup viewGroup = (ViewGroup)activity.findViewById(0x1020002);
        viewGroup.addView((View)agoraSurfaceView, 360, 640);
        agoraSurfaceView.setZOrderOnTop(true);
        AgoraVideoDebugger.setCapturePreview(agoraSurfaceView, false, true, true, false);
        return agoraSurfaceView;
    }

    public static void setCapturePreview(AgoraSurfaceView agoraSurfaceView) {
        AgoraVideoDebugger.setCapturePreview(agoraSurfaceView, true, true, true, false);
    }

    public static void setCapturePreview(AgoraSurfaceView agoraSurfaceView, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
    }

    static void reset() {
    }

    static void onTextureBufferAvailable(VideoCapture videoCapture, EglBase.Context context, VideoFrame.TextureBuffer textureBuffer, int n2, long l2) {
    }

    static void onRawBufferAvailable(VideoCapture videoCapture, byte[] byArray, int n2, int n3, int n4, int n5) {
    }

    static void onTextureAndRawBufferAvailable(VideoCapture videoCapture, VideoFrame.TextureBuffer textureBuffer, int n2, long l2, byte[] byArray, int n3) {
    }

    static void onDropTextureBuffer(long l2) {
    }

    public static void setObserverPreview(AgoraSurfaceView agoraSurfaceView) {
    }

    public static void onCaptureVideoFrame(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
    }

    public static void setI420BufferPreview(AgoraSurfaceView agoraSurfaceView) {
    }

    public static void onI420Buffer(VideoFrame.I420Buffer i420Buffer, int n2, long l2) {
    }

    public static void setTextureBufferPreview(AgoraSurfaceView agoraSurfaceView) {
    }

    public static void onTextureBuffer(VideoFrame.TextureBuffer textureBuffer, int n2, long l2) {
    }

    public static ByteBuffer convertI420ToCompactByteBuffer(VideoFrame.I420Buffer i420Buffer) {
        int n2;
        int n3;
        int n4 = i420Buffer.getWidth();
        int n5 = i420Buffer.getHeight();
        int n6 = (n5 + 1) / 2;
        int n7 = (n4 + 1) / 2;
        int n8 = 0;
        int n9 = n8 + n4 * n5;
        int n10 = n9 + n7 * n6;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n4 * n5 + 2 * n7 * n6);
        byteBuffer.position(n8);
        byteBuffer.limit(n9);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n9);
        byteBuffer.limit(n10);
        ByteBuffer byteBuffer3 = byteBuffer.slice();
        byteBuffer.position(n10);
        byteBuffer.limit(n10 + n7 * n6);
        ByteBuffer byteBuffer4 = byteBuffer.slice();
        ByteBuffer byteBuffer5 = i420Buffer.getDataY();
        for (int i2 = 0; i2 < n5; ++i2) {
            n3 = i2 * i420Buffer.getStrideY();
            byteBuffer5.limit(n3 + n4);
            byteBuffer5.position(n3);
            byteBuffer2.put(byteBuffer5.slice());
        }
        ByteBuffer byteBuffer6 = i420Buffer.getDataU();
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = n3 * i420Buffer.getStrideU();
            byteBuffer6.limit(n2 + n7);
            byteBuffer6.position(n2);
            byteBuffer3.put(byteBuffer6.slice());
        }
        ByteBuffer byteBuffer7 = i420Buffer.getDataV();
        for (n2 = 0; n2 < n6; ++n2) {
            int n11 = n2 * i420Buffer.getStrideV();
            byteBuffer7.limit(n11 + n7);
            byteBuffer7.position(n11);
            byteBuffer4.put(byteBuffer7.slice());
        }
        byteBuffer.position(n8);
        return byteBuffer;
    }

    public static byte[] convertYv12ToCompactI420(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2 + 15 >> 4 << 4;
        int n6 = n5 * n3;
        int n7 = n5 >> 1 >> 4 << 4;
        int n8 = n7 * n3 >> 1;
        int n9 = n6;
        int n10 = n6 + n8;
        int n11 = n2 * n3;
        int n12 = n2 / 2;
        int n13 = n3 / 2;
        int n14 = n11;
        int n15 = n11 * 5 / 4;
        byte[] byArray2 = new byte[n11 * 3 / 2];
        for (n4 = 0; n4 < n3; ++n4) {
            System.arraycopy(byArray, n5 * n4, byArray2, n2 * n4, n2);
        }
        for (n4 = 0; n4 < n13; ++n4) {
            System.arraycopy(byArray, n10 + n7 * n4, byArray2, n14 + n12 * n4, n12);
        }
        for (n4 = 0; n4 < n13; ++n4) {
            System.arraycopy(byArray, n9 + n7 * n4, byArray2, n15 + n12 * n4, n12);
        }
        return byArray2;
    }

    public static byte[] convertNv21ToCompactI420(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n2;
        int n7 = n6 * n3;
        int n8 = 2;
        int n9 = n7;
        int n10 = n7 + 1;
        int n11 = n2 * n3;
        int n12 = n2 / 2;
        int n13 = n3 / 2;
        int n14 = n11;
        int n15 = n11 * 5 / 4;
        byte[] byArray2 = new byte[n11 * 3 / 2];
        for (n5 = 0; n5 < n3; ++n5) {
            System.arraycopy(byArray, n6 * n5, byArray2, n2 * n5, n2);
        }
        for (n5 = 0; n5 < n13; ++n5) {
            for (n4 = 0; n4 < n12; ++n4) {
                byArray2[n14 + n12 * n5 + n4] = byArray[n10 + n6 * n5 + n8 * n4];
            }
        }
        for (n5 = 0; n5 < n13; ++n5) {
            for (n4 = 0; n4 < n12; ++n4) {
                byArray2[n15 + n12 * n5 + n4] = byArray[n9 + n6 * n5 + n8 * n4];
            }
        }
        return byArray2;
    }

    public static void textureDump(VideoFrame.TextureBuffer textureBuffer, FileOutputStream fileOutputStream) {
        if (textureBuffer == null || fileOutputStream == null) {
            return;
        }
        VideoFrame.I420Buffer i420Buffer = textureBuffer.toI420();
        if (i420Buffer == null) {
            return;
        }
        try {
            ByteBuffer byteBuffer = AgoraVideoDebugger.convertI420ToCompactByteBuffer(i420Buffer);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.write(byteBuffer);
            fileChannel.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void rawDataDump(byte[] byArray, FileOutputStream fileOutputStream) {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static MediaIO.PixelFormat getMediaIOPixelFormat(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.getType() == VideoFrame.TextureBuffer.Type.OES ? MediaIO.PixelFormat.TEXTURE_OES : MediaIO.PixelFormat.TEXTURE_2D;
    }

    public static int getAgoraVideoFrameFormat(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.getType() == VideoFrame.TextureBuffer.Type.OES ? 11 : 10;
    }

    static {
        yuvRender = false;
        textureFrameCnt = 0;
        droppedTextureFrameCnt = 0;
    }

    static class DebugViewHolder {
        AgoraSurfaceView agoraSurfaceView;
        boolean followSourceDimension;
        boolean mirror;
        boolean applyRotation;
        boolean isInitialized = false;
        int lastSourceWidth = 0;
        int lastSourceHeight = 0;

        public DebugViewHolder(AgoraSurfaceView agoraSurfaceView, boolean bl, boolean bl2, boolean bl3) {
            this.agoraSurfaceView = agoraSurfaceView;
            this.followSourceDimension = bl;
            this.mirror = bl2;
            this.applyRotation = bl3;
        }

        void init(EglBase.Context context, MediaIO.BufferType bufferType, MediaIO.PixelFormat pixelFormat) {
            if (this.isInitialized) {
                return;
            }
            this.agoraSurfaceView.init(context);
            this.agoraSurfaceView.setBufferType(bufferType);
            this.agoraSurfaceView.setPixelFormat(pixelFormat);
            this.agoraSurfaceView.setMirror(this.mirror);
            this.agoraSurfaceView.onInitialize();
            this.agoraSurfaceView.onStart();
            this.isInitialized = true;
        }

        void setupViewUI(final int n2, final int n3, final int n4) {
            if (this.followSourceDimension && (this.lastSourceWidth != n3 || this.lastSourceHeight != n4)) {
                this.agoraSurfaceView.post(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl = DebugViewHolder.this.applyRotation && (n2 == 90 || n2 == 270);
                        DebugViewHolder.this.agoraSurfaceView.getLayoutParams().width = bl ? n4 : n3;
                        DebugViewHolder.this.agoraSurfaceView.getLayoutParams().height = bl ? n3 : n4;
                    }
                });
                this.lastSourceWidth = n3;
                this.lastSourceHeight = n4;
            }
        }

        void reset() {
            if (this.agoraSurfaceView != null) {
                if (this.isInitialized) {
                    this.agoraSurfaceView.onStop();
                    this.agoraSurfaceView.onDispose();
                }
                this.agoraSurfaceView = null;
            }
            this.followSourceDimension = false;
            this.mirror = false;
            this.applyRotation = false;
            this.lastSourceWidth = 0;
            this.lastSourceHeight = 0;
            this.isInitialized = false;
        }
    }
}

