/*
 * Decompiled with CFR 0.152.
 */
package com.coloros.ocs.base.task;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.coloros.ocs.base.task.Continuation;
import com.coloros.ocs.base.task.OnCanceledListener;
import com.coloros.ocs.base.task.OnCompleteListener;
import com.coloros.ocs.base.task.OnFailureListener;
import com.coloros.ocs.base.task.OnSuccessListener;
import com.coloros.ocs.base.task.SuccessContinuation;
import java.util.concurrent.Executor;

public abstract class Task<TResult> {
    public abstract boolean isComplete();

    public abstract boolean isSuccessful();

    public abstract boolean isCanceled();

    @Nullable
    public abstract TResult getResult();

    @Nullable
    public abstract <X extends Throwable> TResult getResult(@NonNull Class<X> var1) throws X, Throwable;

    @Nullable
    public abstract Exception getException();

    @NonNull
    public abstract Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> var1);

    @NonNull
    public abstract Task<TResult> addOnSuccessListener(@NonNull Executor var1, @NonNull OnSuccessListener<? super TResult> var2);

    @NonNull
    public abstract Task<TResult> addOnFailureListener(@NonNull OnFailureListener var1);

    @NonNull
    public abstract Task<TResult> addOnFailureListener(@NonNull Executor var1, @NonNull OnFailureListener var2);

    @NonNull
    public abstract Task<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> var1);

    @NonNull
    public abstract Task<TResult> addOnCompleteListener(@NonNull Executor var1, @NonNull OnCompleteListener<TResult> var2);

    @NonNull
    public abstract Task<TResult> addOnCanceledListener(@NonNull OnCanceledListener var1);

    @NonNull
    public abstract Task<TResult> addOnCanceledListener(@NonNull Executor var1, @NonNull OnCanceledListener var2);

    @NonNull
    public abstract <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> var1);

    @NonNull
    public abstract <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor var1, @NonNull Continuation<TResult, TContinuationResult> var2);

    @NonNull
    public abstract <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> var1);

    @NonNull
    public abstract <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor var1, @NonNull Continuation<TResult, Task<TContinuationResult>> var2);

    @NonNull
    public abstract <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull SuccessContinuation<TResult, TContinuationResult> var1);

    @NonNull
    public abstract <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull Executor var1, @NonNull SuccessContinuation<TResult, TContinuationResult> var2);
}

