/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.RtcEngine;
import io.agora.rtc.internal.Logging;
import io.agora.rtc.internal.RtcEngineImpl;
import java.lang.ref.WeakReference;

public class AgoraMediaRecorder {
    public static final int RECORDER_STATE_ERROR = -1;
    public static final int RECORDER_STATE_START = 2;
    public static final int RECORDER_STATE_STOP = 3;
    public static final int RECORDER_ERROR_NONE = 0;
    public static final int RECORDER_ERROR_WRITE_FAILED = 1;
    public static final int RECORDER_ERROR_NO_STREAM = 2;
    public static final int RECORDER_ERROR_OVER_MAX_DURATION = 3;
    public static final int RECORDER_ERROR_CONFIG_CHANGED = 4;
    public static final int RECORDER_ERROR_CUSTOM_STREAM_DETECTED = 5;
    public static final int STREAM_TYPE_AUDIO = 1;
    public static final int STREAM_TYPE_VIDEO = 2;
    public static final int STREAM_TYPE_BOTH = 3;
    public static final int CONTAINER_MP4 = 1;
    private static volatile AgoraMediaRecorder mRecorder = null;
    WeakReference<RtcEngineImpl> mEngineReference;

    private AgoraMediaRecorder(RtcEngineImpl rtcEngineImpl) {
        this.mEngineReference = new WeakReference<RtcEngineImpl>(rtcEngineImpl);
    }

    private void setEngine(RtcEngineImpl rtcEngineImpl) {
        this.mEngineReference = new WeakReference<RtcEngineImpl>(rtcEngineImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgoraMediaRecorder getMediaRecorder(RtcEngine rtcEngine, IMediaRecorderCallback iMediaRecorderCallback) {
        RtcEngineImpl rtcEngineImpl = (RtcEngineImpl)rtcEngine;
        int n2 = rtcEngineImpl.getMediaRecorder(iMediaRecorderCallback);
        if (n2 != 0) {
            Logging.e("getMediaRecorder failed, please ensure the RtcEngine has been initialized and already join the channel");
            return null;
        }
        if (mRecorder == null) {
            Class<AgoraMediaRecorder> clazz = AgoraMediaRecorder.class;
            synchronized (AgoraMediaRecorder.class) {
                if (mRecorder == null) {
                    mRecorder = new AgoraMediaRecorder(rtcEngineImpl);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        } else {
            mRecorder.setEngine(rtcEngineImpl);
        }
        return mRecorder;
    }

    public int startRecording(MediaRecorderConfiguration mediaRecorderConfiguration) {
        RtcEngineImpl rtcEngineImpl = null;
        if (this.mEngineReference == null || (rtcEngineImpl = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return rtcEngineImpl.startRecording(mediaRecorderConfiguration.storagePath, mediaRecorderConfiguration.containerFormat, mediaRecorderConfiguration.streamType, mediaRecorderConfiguration.maxDurationMs, mediaRecorderConfiguration.recorderInfoUpdateInterval);
    }

    public int stopRecording() {
        RtcEngineImpl rtcEngineImpl = null;
        if (this.mEngineReference == null || (rtcEngineImpl = (RtcEngineImpl)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return rtcEngineImpl.stopRecording();
    }

    public void release() {
        RtcEngineImpl rtcEngineImpl = null;
        if (this.mEngineReference != null && (rtcEngineImpl = (RtcEngineImpl)this.mEngineReference.get()) != null) {
            rtcEngineImpl.releaseRecorder();
        }
        this.mEngineReference = null;
    }

    public static interface IMediaRecorderCallback {
        public void onRecorderStateChanged(int var1, int var2);

        public void onRecorderInfoUpdated(RecorderInfo var1);
    }

    public static class RecorderInfo {
        public String fileName;
        public int durationMs;
        public int fileSize;

        public RecorderInfo(String string, int n2, int n3) {
            this.fileName = string;
            this.durationMs = n2;
            this.fileSize = n3;
        }
    }

    public static class MediaRecorderConfiguration {
        public String storagePath;
        public int containerFormat = 1;
        public int streamType = 3;
        public int maxDurationMs = 120000;
        public int recorderInfoUpdateInterval = 0;

        public MediaRecorderConfiguration(String string, int n2, int n3, int n4, int n5) {
            this.storagePath = string;
            this.containerFormat = n2;
            this.streamType = n3;
            this.maxDurationMs = n4;
            this.recorderInfoUpdateInterval = n5;
        }
    }
}

