/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.video;

import android.content.Context;
import android.hardware.Camera;
import android.view.Display;
import android.view.WindowManager;
import io.agora.rtc.internal.Logging;

public class CameraUtil {
    private static final String TAG = "CAMERA_UTIL";

    public static int getCameraDisplayOrientation(Context context, int n2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
        int n3 = 90;
        if (context != null && context.getSystemService("window") != null) {
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            if (display == null) {
                Logging.e(TAG, "display is null");
                return n3;
            }
            int n4 = display.getRotation();
            int n5 = 0;
            switch (n4) {
                case 0: {
                    n5 = 0;
                    break;
                }
                case 1: {
                    n5 = 90;
                    break;
                }
                case 2: {
                    n5 = 180;
                    break;
                }
                case 3: {
                    n5 = 270;
                }
            }
            if (cameraInfo.facing == 1) {
                n3 = (cameraInfo.orientation + n5) % 360;
                n3 = (360 - n3) % 360;
            } else {
                n3 = (cameraInfo.orientation - n5 + 360) % 360;
            }
        }
        return n3;
    }
}

