/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.mediaio;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLException;
import android.util.Log;
import io.agora.rtc.mediaio.IVideoFrameConsumer;
import java.nio.ByteBuffer;

public class VideoFrameConsumerImpl
implements IVideoFrameConsumer {
    private long mCaptureHandle;

    public VideoFrameConsumerImpl(long l2) {
        this.mCaptureHandle = l2;
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, long l2) {
        if (n5 % 90 != 0) {
            Log.e((String)"IVideoFrameConsumer", (String)"consumeByteArrayFrame rotation is not times of 90, set rotation to 0!");
            n5 = 0;
        }
        this.provideByteBufferFrame(this.mCaptureHandle, byteBuffer, n2, n3, n4, n5, l2);
    }

    @Override
    public void consumeByteArrayFrame(byte[] byArray, int n2, int n3, int n4, int n5, long l2) {
        int n6 = -1;
        if (n2 == 8 || n2 == 3 || n2 == 1) {
            int n7 = n3 + 1 >> 1;
            int n8 = n4 + 1 >> 1;
            n6 = n3 * n4 + n7 * n8 * 2;
        } else if (n2 == 4 || n2 == 2 || n2 == 7) {
            n6 = n3 * n4 * 4;
        }
        if (n5 % 90 != 0) {
            Log.e((String)"IVideoFrameConsumer", (String)"consumeByteArrayFrame rotation is not times of 90, set rotation to 0!");
            n5 = 0;
        }
        if (n6 == 0 || n6 > 0 && byArray.length < n6) {
            Log.e((String)"IVideoFrameConsumer", (String)("The size of consumeByteArrayFrame is illegal, format " + n2));
        } else {
            this.provideByteArrayFrame(this.mCaptureHandle, byArray, n2, n3, n4, n5, l2);
        }
    }

    @Override
    public void consumeTextureFrame(int n2, int n3, int n4, int n5, int n6, long l2, float[] fArray) {
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        int n7 = EGL14.eglGetError();
        if (n7 != 12288) {
            String string = "eglError: " + n7;
            throw new GLException(n7, string);
        }
        if (n6 % 90 != 0) {
            Log.e((String)"IVideoFrameConsumer", (String)"consumeByteArrayFrame rotation is not times of 90, set rotation to 0!");
            n6 = 0;
        }
        this.provideTextureFrame(this.mCaptureHandle, eGLContext, n2, n3, n4, n5, n6, l2, fArray);
    }

    public native void provideByteArrayFrame(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

    public native void provideTextureFrame(long var1, Object var3, int var4, int var5, int var6, int var7, int var8, long var9, float[] var11);

    public native void provideByteBufferFrame(long var1, ByteBuffer var3, int var4, int var5, int var6, int var7, long var8);
}

