/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import io.agora.rtc.gl.EglBase;
import io.agora.rtc.gl.RendererCommon;
import io.agora.rtc.gl.VideoFrame;
import io.agora.rtc.gl.VideoFrameDrawer;
import io.agora.rtc.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class EglRenderer {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    private static final int MAX_SURFACE_CLEAR_COUNT = 3;
    private final String name;
    private final Object handlerLock = new Object();
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    private EglBase eglBase;
    private final VideoFrameDrawer frameDrawer = new VideoFrameDrawer();
    private RendererCommon.GlDrawer drawer;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    private VideoFrame pendingFrame;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean mirror;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            EglRenderer.this.logStatistics();
            Object object = EglRenderer.this.handlerLock;
            synchronized (object) {
                if (EglRenderer.this.renderThreadHandler != null) {
                    EglRenderer.this.renderThreadHandler.removeCallbacks(EglRenderer.this.logStatisticsRunnable);
                    EglRenderer.this.renderThreadHandler.postDelayed(EglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    public EglRenderer(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(final EglBase.Context context, final int[] nArray, RendererCommon.GlDrawer glDrawer) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = glDrawer;
            HandlerThread handlerThread = new HandlerThread(this.name + TAG);
            handlerThread.start();
            this.renderThreadHandler = new Handler(handlerThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    if (context == null) {
                        EglRenderer.this.logD("EglBase.create context");
                        EglRenderer.this.eglBase = EglBase.create(context, nArray);
                    } else {
                        EglRenderer.this.logD("EglBase.create shared context");
                        EglRenderer.this.eglBase = EglBase.create(context, nArray);
                    }
                }
            });
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long l2 = System.nanoTime();
            this.resetStatistics(l2);
        }
    }

    public EglBase.Context getEglContext() {
        return this.eglBase.getEglBaseContext();
    }

    public void createEglSurface(Surface surface) {
        this.createEglSurfaceInternal(surface);
    }

    public void createEglSurface(SurfaceTexture surfaceTexture) {
        this.createEglSurfaceInternal(surfaceTexture);
    }

    private void createEglSurfaceInternal(Object object) {
        this.eglSurfaceCreationRunnable.setSurface(object);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    if (EglRenderer.this.drawer != null) {
                        EglRenderer.this.drawer.release();
                        EglRenderer.this.drawer = null;
                    }
                    EglRenderer.this.frameDrawer.release();
                    if (EglRenderer.this.eglBase != null) {
                        EglRenderer.this.logD("eglBase detach and release.");
                        EglRenderer.this.eglBase.detachCurrent();
                        EglRenderer.this.eglBase.release();
                        EglRenderer.this.eglBase = null;
                    }
                }
            });
            final Looper looper = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    EglRenderer.this.logD("Quitting render thread.");
                    looper.quit();
                    countDownLatch.countDown();
                }
            });
            ThreadUtils.awaitUninterruptibly(countDownLatch);
            this.renderThreadHandler = null;
        }
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long l2) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = l2;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread;
            Thread thread2 = thread = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
                this.logD("EglRenderer stack trace:");
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    this.logD(stackTraceElement.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        this.logD("setMirror: " + bl);
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float f2) {
        this.logD("setLayoutAspectRatio: " + f2);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = f2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float f2) {
        this.logD("setFpsReduction: " + f2);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long l2 = this.minRenderPeriodNs;
            this.minRenderPeriodNs = f2 <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / f2);
            if (this.minRenderPeriodNs != l2) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener frameListener, float f2) {
        this.addFrameListener(frameListener, f2, null, false);
    }

    public void addFrameListener(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.addFrameListener(frameListener, f2, glDrawer, false);
    }

    public void addFrameListener(final FrameListener frameListener, final float f2, final RendererCommon.GlDrawer glDrawer, final boolean bl) {
        this.postToRenderThread(new Runnable(){

            @Override
            public void run() {
                RendererCommon.GlDrawer glDrawer2 = glDrawer == null ? EglRenderer.this.drawer : glDrawer;
                EglRenderer.this.frameListeners.add(new FrameListenerAndParams(frameListener, f2, glDrawer2, bl));
            }
        });
    }

    public void removeFrameListener(final FrameListener frameListener) {
        if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
            throw new RuntimeException("removeFrameListener must not be called on the render thread.");
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.postToRenderThread(new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
                Iterator iterator = EglRenderer.this.frameListeners.iterator();
                while (iterator.hasNext()) {
                    if (((FrameListenerAndParams)iterator.next()).listener != frameListener) continue;
                    iterator.remove();
                }
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    public void renderFrame(VideoFrame videoFrame) {
        this.onFrame(videoFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrame(VideoFrame videoFrame) {
        boolean bl;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                boolean bl2 = bl = this.pendingFrame != null;
                if (bl) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = videoFrame;
                this.pendingFrame.retain();
            }
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    EglRenderer.this.renderFrameOnRenderThread();
                }
            });
        }
        if (bl) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface(final Runnable runnable) {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                    @Override
                    public void run() {
                        if (EglRenderer.this.eglBase != null) {
                            EglRenderer.this.eglBase.detachCurrent();
                            EglRenderer.this.eglBase.releaseSurface();
                        }
                        runnable.run();
                    }
                });
                return;
            }
        }
        runnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float f2, float f3, float f4, float f5) {
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)f2, (float)f3, (float)f4, (float)f5);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(final float f2, final float f3, final float f4, final float f5) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    EglRenderer.this.clearSurfaceOnRenderThread(f2, f3, f4, f5);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread() {
        float f2;
        float f3;
        float f4;
        boolean bl;
        VideoFrame videoFrame;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame == null) {
                return;
            }
            videoFrame = this.pendingFrame;
            this.pendingFrame = null;
        }
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            this.logD("Dropping frame - No surface");
            videoFrame.release();
            return;
        }
        Object object2 = this.fpsReductionLock;
        synchronized (object2) {
            if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                bl = false;
            } else if (this.minRenderPeriodNs <= 0L) {
                bl = true;
            } else {
                long l2 = System.nanoTime();
                if (l2 < this.nextFrameTimeNs) {
                    this.logD("Skipping frame rendering - fps reduction is active.");
                    bl = false;
                } else {
                    this.nextFrameTimeNs += this.minRenderPeriodNs;
                    this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, l2);
                    bl = true;
                }
            }
        }
        long l3 = System.nanoTime();
        float f5 = (float)videoFrame.getRotatedWidth() / (float)videoFrame.getRotatedHeight();
        Object object3 = this.layoutLock;
        synchronized (object3) {
            f4 = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : f5;
        }
        if (f5 > f4) {
            f3 = f4 / f5;
            f2 = 1.0f;
        } else {
            f3 = 1.0f;
            f2 = f5 / f4;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        if (this.mirror) {
            this.drawMatrix.preScale(-1.0f, 1.0f);
        }
        this.drawMatrix.preScale(f3, f2);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        if (bl) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.frameDrawer.drawFrame(videoFrame, this.drawer, this.drawMatrix, 0, 0, this.eglBase.surfaceWidth(), this.eglBase.surfaceHeight());
            long l4 = System.nanoTime();
            this.eglBase.swapBuffers();
            long l5 = System.nanoTime();
            Object object4 = this.statisticsLock;
            synchronized (object4) {
                ++this.framesRendered;
                this.renderTimeNs += l5 - l3;
                this.renderSwapBufferTimeNs += l5 - l4;
            }
        }
        videoFrame.release();
    }

    private String averageTimeAsString(long l2, int n2) {
        return n2 <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(l2 / (long)n2) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        long l2 = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long l3 = l2 - this.statisticsStartTimeNs;
            if (l3 <= 0L) {
                return;
            }
            float f2 = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)l3;
            this.logD("Duration: " + TimeUnit.NANOSECONDS.toMillis(l3) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". Render fps: " + String.format(Locale.US, "%.1f", Float.valueOf(f2)) + ". Average render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered) + ".");
            this.resetStatistics(l2);
        }
    }

    private void logD(String string) {
        Log.d((String)TAG, (String)(this.name + string));
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object object) {
            this.surface = object;
        }

        @Override
        public synchronized void run() {
            if (this.surface != null && EglRenderer.this.eglBase != null && !EglRenderer.this.eglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    EglRenderer.this.eglBase.createSurface((Surface)this.surface);
                } else if (this.surface instanceof SurfaceTexture) {
                    EglRenderer.this.eglBase.createSurface((SurfaceTexture)this.surface);
                } else {
                    throw new IllegalStateException("Invalid surface: " + this.surface);
                }
                EglRenderer.this.eglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final RendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer, boolean bl) {
            this.listener = frameListener;
            this.scale = f2;
            this.drawer = glDrawer;
            this.applyFpsReduction = bl;
        }
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }
}

