/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gdp;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.opengl.GLES20;
import android.os.BatteryManager;
import android.os.Build;
import android.util.Log;
import io.agora.rtc.gdp.EglCore;
import io.agora.rtc.gdp.OffscreenSurface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;

public class GDPAndroid {
    private static String TAG = "GDPAndroid";
    private static final int DEVICEINFO_UNKNOWN = -1;
    private Context mAppContext = null;
    private String mGpuVendor = "unkown";
    private String mGpuRenderer = "unkown";
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.startsWith("cpu")) {
                for (int i2 = 3; i2 < string.length(); ++i2) {
                    if (Character.isDigit(string.charAt(i2))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final List<String> CPU_TEMP_FILE_PATHS = Arrays.asList("/sys/devices/system/cpu/cpu0/cpufreq/cpu_temp", "/sys/devices/system/cpu/cpu0/cpufreq/FakeShmoo_cpu_temp", "/sys/class/thermal/thermal_zone0/temp", "/sys/class/i2c-adapter/i2c-4/4-004c/temperature", "/sys/devices/platform/tegra-i2c.3/i2c-4/4-004c/temperature", "/sys/devices/platform/omap/omap_temp_sensor.0/temperature", "/sys/devices/platform/tegra_tmon/temp1_input", "/sys/kernel/debug/tegra_thermal/temp_tj", "/sys/devices/platform/s5p-tmu/temperature", "/sys/class/thermal/thermal_zone1/temp", "/sys/class/hwmon/hwmon0/device/temp1_input", "/sys/devices/virtual/thermal/thermal_zone1/temp", "/sys/devices/virtual/thermal/thermal_zone0/temp", "/sys/class/thermal/thermal_zone3/temp", "/sys/class/thermal/thermal_zone4/temp", "/sys/class/hwmon/hwmonX/temp1_input", "/sys/devices/platform/s5p-tmu/curr_temp");

    public boolean initGDP(Context context) {
        this.mAppContext = context;
        if (this.isEGL14SupportedHere()) {
            this.gatherGlInfo();
        }
        return true;
    }

    public int getCpuCores() {
        return GDPAndroid.getNumberOfCPUCores();
    }

    public int getCpuClock() {
        return GDPAndroid.getCPUMaxFreqKHz();
    }

    public String getCpuVendor() {
        return Build.HARDWARE;
    }

    public int getRam() {
        int n2 = (int)(GDPAndroid.getTotalMemory(this.mAppContext) / 1024L);
        return n2;
    }

    public String getGpuVendor() {
        return this.mGpuVendor;
    }

    public String getGpuRenderer() {
        return this.mGpuRenderer;
    }

    public int getOsVersion() {
        return Build.VERSION.SDK_INT;
    }

    public String getDeviceName() {
        return Build.MODEL;
    }

    public int getBattery() {
        return this.getBatteryLevel();
    }

    private boolean isEGL14SupportedHere() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void gatherGlInfo() {
        EglCore eglCore = new EglCore(null, 2);
        OffscreenSurface offscreenSurface = new OffscreenSurface(eglCore, 1, 1);
        offscreenSurface.makeCurrent();
        this.mGpuVendor = GLES20.glGetString((int)7936);
        this.mGpuRenderer = GLES20.glGetString((int)7937);
        offscreenSurface.release();
        eglCore.release();
    }

    private int getBatteryLevel() {
        if (Build.VERSION.SDK_INT >= 21) {
            BatteryManager batteryManager = (BatteryManager)this.mAppContext.getSystemService("batterymanager");
            return batteryManager.getIntProperty(4);
        }
        Intent intent = new ContextWrapper(this.mAppContext).registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        return intent.getIntExtra("level", -1) * 100 / intent.getIntExtra("scale", -1);
    }

    private static int getNumberOfCPUCores() {
        int n2;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            n2 = GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (n2 == -1) {
                n2 = GDPAndroid.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (n2 == -1) {
                n2 = GDPAndroid.getCoresFromCPUFileList();
            }
        }
        catch (SecurityException securityException) {
            n2 = -1;
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        Log.i((String)TAG, (String)("cores:" + n2));
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            int n2 = GDPAndroid.getCoresFromFileString(string2);
            return n2;
        }
        catch (IOException iOException) {
            int n3 = -1;
            return n3;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int getCoresFromFileString(String string) {
        if (string == null || !string.matches("0-[\\d]+$")) {
            return -1;
        }
        int n2 = Integer.valueOf(string.substring(2)) + 1;
        return n2;
    }

    private static int getCoresFromCPUFileList() {
        return new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCPUMaxFreqKHz() {
        int n2;
        block13: {
            n2 = -1;
            try {
                for (int i2 = 0; i2 < GDPAndroid.getNumberOfCPUCores(); ++i2) {
                    String string = "/sys/devices/system/cpu/cpu" + i2 + "/cpufreq/cpuinfo_max_freq";
                    File file = new File(string);
                    if (!file.exists() || !file.canRead()) continue;
                    byte[] byArray = new byte[128];
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        int n3;
                        fileInputStream.read(byArray);
                        for (n3 = 0; Character.isDigit(byArray[n3]) && n3 < byArray.length; ++n3) {
                        }
                        String string2 = new String(byArray, 0, n3);
                        Integer n4 = Integer.parseInt(string2);
                        if (n4 <= n2) continue;
                        n2 = n4;
                        continue;
                    }
                }
                if (n2 != -1) break block13;
                try (FileInputStream fileInputStream = new FileInputStream("/proc/cpuinfo");){
                    int n5 = GDPAndroid.parseFileForValue("cpu MHz", fileInputStream);
                    if ((n5 *= 1000) > n2) {
                        n2 = n5;
                    }
                }
            }
            catch (IOException iOException) {
                n2 = -1;
            }
        }
        Log.i((String)TAG, (String)("max freq:" + n2));
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            activityManager.getMemoryInfo(memoryInfo);
            if (memoryInfo != null) {
                Log.i((String)TAG, (String)("total mem:" + memoryInfo.totalMem));
                return memoryInfo.totalMem;
            }
            return -1L;
        }
        long l2 = -1L;
        try (FileInputStream fileInputStream = new FileInputStream("/proc/meminfo");){
            l2 = GDPAndroid.parseFileForValue("MemTotal", fileInputStream);
            l2 *= 1024L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Log.i((String)TAG, (String)("total mem:" + l2));
        return l2;
    }

    private static int parseFileForValue(String string, FileInputStream fileInputStream) {
        byte[] byArray = new byte[1024];
        try {
            int n2 = fileInputStream.read(byArray);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                if (byArray[i2] != 10 && i2 != 0) continue;
                if (byArray[i2] == 10) {
                    // empty if block
                }
                for (int i3 = ++i2; i3 < n2 && byArray[i3] == string.charAt(n3 = i3 - i2); ++i3) {
                    if (n3 != string.length() - 1) continue;
                    return GDPAndroid.extractValue(byArray, i3);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static int extractValue(byte[] byArray, int n2) {
        while (n2 < byArray.length && byArray[n2] != 10) {
            if (Character.isDigit(byArray[n2])) {
                int n3 = n2++;
                while (n2 < byArray.length && Character.isDigit(byArray[n2])) {
                    ++n2;
                }
                String string = new String(byArray, 0, n3, n2 - n3);
                return Integer.parseInt(string);
            }
            ++n2;
        }
        return -1;
    }

    public boolean checkBackground() {
        ActivityManager activityManager = (ActivityManager)this.mAppContext.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 21) {
            List list = activityManager.getRunningAppProcesses();
            if (!list.isEmpty()) {
                for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                    if (runningAppProcessInfo.importance != 100) continue;
                    return false;
                }
            }
        } else {
            ComponentName componentName;
            String string = this.mAppContext.getPackageName();
            List list = activityManager.getRunningTasks(1);
            if (!list.isEmpty() && null != (componentName = ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity)) {
                return !string.equals(componentName.getPackageName());
            }
        }
        return true;
    }

    public int getCpuTemperature() {
        String string = null;
        double d2 = 0.0;
        for (int i2 = 0; i2 < CPU_TEMP_FILE_PATHS.size(); ++i2) {
            string = CPU_TEMP_FILE_PATHS.get(i2);
            Double d3 = this.readOneLine(new File(string));
            if (this.isTemperatureValid(d3)) {
                d2 = d3;
                Log.i((String)TAG, (String)("getCpuTemperature valid path:" + string));
                break;
            }
            if (!this.isTemperatureValid(d3 / 1000.0)) continue;
            d2 = d3 / 1000.0;
            Log.i((String)TAG, (String)("getCpuTemperature valid path:" + string));
            break;
        }
        return (int)(d2 * 1000.0);
    }

    private double readOneLine(File file) {
        FileInputStream fileInputStream = null;
        String string = "";
        if (!file.exists() || !file.canRead()) {
            return -100000.0;
        }
        try {
            fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            fileInputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        double d2 = -100000.0;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d2;
    }

    private boolean isTemperatureValid(double d2) {
        return d2 >= -30.0 && d2 <= 250.0;
    }
}

