/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.gl;

import android.opengl.GLES20;
import io.agora.rtc.gl.GlShader;
import io.agora.rtc.gl.GlUtil;
import io.agora.rtc.gl.RendererCommon;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;
import java.util.Map;

public class GlRectDrawer
implements RendererCommon.GlDrawer {
    private static final String VERTEX_SHADER_STRING = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String YUV_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\n\nvoid main() {\n  float y = texture2D(y_tex, interp_tc).r;\n  float u = texture2D(u_tex, interp_tc).r - 0.5;\n  float v = texture2D(v_tex, interp_tc).r - 0.5;\n  gl_FragColor = vec4(y + 1.403 * v,                       y - 0.344 * u - 0.714 * v,                       y + 1.77 * u, 1);\n}\n";
    private static final String RGB_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D rgb_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(rgb_tex, interp_tc);\n}\n";
    private static final String OES_FRAGMENT_SHADER_STRING = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oes_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(oes_tex, interp_tc);\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUF = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mTexCoordinate = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer mPosCoordinate = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private final Map<String, Shader> shaders = new IdentityHashMap<String, Shader>();

    @Override
    public void drawOes(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, fArray);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n2);
        this.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    @Override
    public void drawRgb(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, fArray);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        this.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    @Override
    public void drawYuv(int[] nArray, float[] fArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        this.prepareShader(YUV_FRAGMENT_SHADER_STRING, fArray);
        for (n8 = 0; n8 < 3; ++n8) {
            GLES20.glActiveTexture((int)(33984 + n8));
            GLES20.glBindTexture((int)3553, (int)nArray[n8]);
        }
        this.drawRectangle(n4, n5, n6, n7);
        for (n8 = 0; n8 < 3; ++n8) {
            GLES20.glActiveTexture((int)(33984 + n8));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    private void drawRectangle(int n2, int n3, int n4, int n5) {
        GLES20.glViewport((int)n2, (int)n3, (int)n4, (int)n5);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    private void prepareShader(String string, float[] fArray) {
        Shader shader;
        if (this.shaders.containsKey(string)) {
            shader = this.shaders.get(string);
        } else {
            shader = new Shader(string);
            this.shaders.put(string, shader);
            shader.glShader.useProgram();
            if (YUV_FRAGMENT_SHADER_STRING.equals(string)) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (RGB_FRAGMENT_SHADER_STRING.equals(string)) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else if (OES_FRAGMENT_SHADER_STRING.equals(string)) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("oes_tex"), (int)0);
            } else {
                throw new IllegalStateException("Unknown fragment shader: " + string);
            }
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        }
        shader.glShader.setVertexAttribArray("in_pos", 2, FULL_RECTANGLE_BUF);
        shader.glShader.setVertexAttribArray("in_tc", 2, FULL_RECTANGLE_TEX_BUF);
        shader.glShader.useProgram();
        GLES20.glUniformMatrix4fv((int)shader.texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
    }

    private void prepareShader(String string, float[] fArray, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        Shader shader;
        if (this.shaders.containsKey(string)) {
            shader = this.shaders.get(string);
        } else {
            shader = new Shader(string);
            this.shaders.put(string, shader);
            shader.glShader.useProgram();
            if (string == YUV_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("y_tex"), (int)0);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("u_tex"), (int)1);
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("v_tex"), (int)2);
            } else if (string == RGB_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("rgb_tex"), (int)0);
            } else if (string == OES_FRAGMENT_SHADER_STRING) {
                GLES20.glUniform1i((int)shader.glShader.getUniformLocation("oes_tex"), (int)0);
            } else {
                throw new IllegalStateException("Unknown fragment shader: " + string);
            }
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        }
        shader.glShader.setVertexAttribArray("in_pos", 2, floatBuffer2);
        shader.glShader.setVertexAttribArray("in_tc", 2, floatBuffer);
        shader.glShader.useProgram();
        GLES20.glUniformMatrix4fv((int)shader.texMatrixLocation, (int)1, (boolean)false, (float[])fArray, (int)0);
    }

    public void drawOes(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        float[] fArray2 = this.ComputeVertexAttribArray(n3, n4, n9, n10);
        this.mTexCoordinate = GlUtil.createFloatBuffer(fArray2);
        if (n9 != n7 || n10 != n8) {
            float[] fArray3 = this.ComputePosVertexAttribArray(n7, n8, n9, n10);
            this.mPosCoordinate = GlUtil.createFloatBuffer(fArray3);
        } else {
            this.mPosCoordinate = FULL_RECTANGLE_BUF;
        }
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, fArray, this.mTexCoordinate, this.mPosCoordinate);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)n2);
        this.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    public void drawRgb(int n2, float[] fArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        float[] fArray2 = this.ComputeVertexAttribArray(n3, n4, n9, n10);
        if (n9 != n7 || n10 != n8) {
            float[] fArray3 = this.ComputePosVertexAttribArray(n7, n8, n9, n10);
            this.mPosCoordinate = GlUtil.createFloatBuffer(fArray3);
        } else {
            this.mPosCoordinate = FULL_RECTANGLE_BUF;
        }
        this.mTexCoordinate = GlUtil.createFloatBuffer(fArray2);
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, fArray, this.mTexCoordinate, this.mPosCoordinate);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        this.drawRectangle(n5, n6, n7, n8);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    private float[] ComputeVertexAttribArray(int n2, int n3, int n4, int n5) {
        float f2 = (float)n2 / (float)n3;
        float f3 = (float)n4 / (float)n5;
        if (f2 >= f3) {
            float f4 = (float)n3 * f3;
            float f5 = ((float)n2 - f4) / 2.0f / (float)n2;
            return new float[]{f5, 0.0f, 1.0f - f5, 0.0f, f5, 1.0f, 1.0f - f5, 1.0f};
        }
        float f6 = (float)n2 / f3;
        float f7 = 0.0f;
        float f8 = ((float)n3 - f6) / 2.0f / (float)n3;
        return new float[]{0.0f, f8, 1.0f, f8, 0.0f, 1.0f - f8, 1.0f, 1.0f - f8};
    }

    private float[] ComputePosVertexAttribArray(int n2, int n3, int n4, int n5) {
        float f2 = n3 == n5 ? -1.0f : 2.0f * (float)(n3 - n5) / (float)n3 - 1.0f;
        float f3 = n2 == n4 ? 1.0f : 2.0f * (float)n4 / (float)n2 - 1.0f;
        return new float[]{-1.0f, f2, f3, f2, -1.0f, 1.0f, f3, 1.0f};
    }

    @Override
    public void release() {
        for (Shader shader : this.shaders.values()) {
            shader.glShader.release();
        }
        this.shaders.clear();
    }

    private static class Shader {
        public final GlShader glShader;
        public final int texMatrixLocation;

        public Shader(String string) {
            this.glShader = new GlShader(GlRectDrawer.VERTEX_SHADER_STRING, string);
            this.texMatrixLocation = this.glShader.getUniformLocation("texMatrix");
        }
    }
}

