/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.internal;

import android.text.TextUtils;
import io.agora.rtc.IRtcEngineEventHandler;
import io.agora.rtc.internal.Marshallable;
import io.agora.rtc.live.LiveInjectStreamConfig;
import io.agora.rtc.live.LiveTranscoding;
import io.agora.rtc.models.ContentInspectConfig;
import io.agora.rtc.video.AgoraImage;
import io.agora.rtc.video.ChannelMediaInfo;
import io.agora.rtc.video.ChannelMediaRelayConfiguration;
import java.util.ArrayList;
import java.util.Map;

public class RtcEngineMessage {
    public static short AGORA_UI_SERVER = 0;

    public static class PUploadLogResult
    extends Marshallable {
        public String requestId;
        public boolean success;
        public int reason;

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.requestId = this.popString16();
            this.success = this.popBool();
            this.reason = this.popInt();
        }
    }

    public static class PUserAccountInfo
    extends Marshallable {
        public int uid;
        public String userAccount;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushBytes(this.userAccount.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.userAccount = this.popString16UTF8();
        }
    }

    public static class PNetworkTypeChanged
    extends Marshallable {
        public int type;

        @Override
        public byte[] marshall() {
            this.pushInt(this.type);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.type = this.popInt();
        }
    }

    public static class PConnectionState
    extends Marshallable {
        public int state;
        public int reason;

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            this.pushInt(this.reason);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.state = this.popInt();
            this.reason = this.popInt();
        }
    }

    public static class PLocalAudioEnabled
    extends Marshallable {
        boolean enabled;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.enabled = this.popBool();
        }
    }

    public static class PLocalFallbackStatus
    extends Marshallable {
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.state = this.popBool();
        }
    }

    public static class PUserTransportStat
    extends Marshallable {
        public boolean isAudio;
        public int peer_uid;
        public int delay;
        public int lost;
        public int rxKBitRate;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.isAudio = this.popBool();
            this.peer_uid = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
            this.rxKBitRate = this.popShort();
        }
    }

    public static class PCrossChannelEvent
    extends Marshallable {
        public int code;

        @Override
        public byte[] marshall() {
            this.pushInt(this.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.code = this.popInt();
        }
    }

    public static class PCrossChannelState
    extends Marshallable {
        public int state;
        public int code;

        @Override
        public byte[] marshall() {
            this.pushInt(this.state);
            this.pushInt(this.code);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.state = this.popInt();
            this.code = this.popInt();
        }
    }

    public static class PAndroidContextInfo
    extends Marshallable {
        public String device;
        public String deviceInfo;
        public String systemInfo;
        public String configDir;
        public String dataDir;
        public String pluginDir;
        public String androidID;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.device.getBytes());
            this.pushBytes(this.deviceInfo.getBytes());
            this.pushBytes(this.systemInfo.getBytes());
            this.pushBytes(this.configDir.getBytes());
            this.pushBytes(this.dataDir.getBytes());
            this.pushBytes(this.pluginDir.getBytes());
            this.pushBytes(this.androidID.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.device = this.popString16UTF8();
            this.deviceInfo = this.popString16UTF8();
            this.systemInfo = this.popString16UTF8();
            this.configDir = this.popString16UTF8();
            this.dataDir = this.popString16UTF8();
            this.pluginDir = this.popString16UTF8();
            this.androidID = this.popString16UTF8();
        }
    }

    static class PAudioRoutingChanged
    extends Marshallable {
        int routing;

        PAudioRoutingChanged() {
        }

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.routing = this.popInt();
        }
    }

    public static class PRemoteVideoStateExt
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.state);
            this.pushInt(this.reason);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.state = this.popByte();
            this.reason = this.popByte();
            this.elapsed = this.popInt();
        }
    }

    public static class PRemoteAudioState
    extends Marshallable {
        public int uid;
        public int state;
        public int reason;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.state);
            this.pushInt(this.reason);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.state = this.popInt();
            this.reason = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PSnapshotTaken
    extends Marshallable {
        public String channel;
        public int uid;
        public String filepath;
        public int width;
        public int height;
        public int errCode;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.channel.getBytes());
            this.pushInt(this.uid);
            this.pushBytes(this.filepath.getBytes());
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.errCode);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.channel = this.popString16UTF8();
            this.uid = this.popInt();
            this.filepath = this.popString16UTF8();
            this.width = this.popInt();
            this.height = this.popInt();
            this.errCode = this.popInt();
        }
    }

    public static class PContentInspectResult
    extends Marshallable {
        public int result;

        @Override
        public byte[] marshall() {
            this.pushInt(this.result);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.result = this.popInt();
        }
    }

    public static class PUserSuperResolutionEnabled
    extends Marshallable {
        public int uid;
        public boolean enabled;
        public int reason;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushBool(this.enabled);
            this.pushInt(this.reason);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.enabled = this.popBool();
            this.reason = this.popInt();
        }
    }

    public static class PSubscribeVideoState
    extends Marshallable {
        public String channel;
        public int uid;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.channel.getBytes());
            this.pushInt(this.uid);
            this.pushInt(this.oldstate);
            this.pushInt(this.newstate);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.channel = this.popString16UTF8();
            this.uid = this.popInt();
            this.oldstate = this.popInt();
            this.newstate = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PSubscribeAudioState
    extends Marshallable {
        public String channel;
        public int uid;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.channel.getBytes());
            this.pushInt(this.uid);
            this.pushInt(this.oldstate);
            this.pushInt(this.newstate);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.channel = this.popString16UTF8();
            this.uid = this.popInt();
            this.oldstate = this.popInt();
            this.newstate = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PPublishVideoState
    extends Marshallable {
        public String channel;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.channel.getBytes());
            this.pushInt(this.oldstate);
            this.pushInt(this.newstate);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.channel = this.popString16UTF8();
            this.oldstate = this.popInt();
            this.newstate = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PPublishAudioState
    extends Marshallable {
        public String channel;
        public int oldstate;
        public int newstate;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.channel.getBytes());
            this.pushInt(this.oldstate);
            this.pushInt(this.newstate);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.channel = this.popString16UTF8();
            this.oldstate = this.popInt();
            this.newstate = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PPrivilegeWillExpire
    extends Marshallable {
        public String token;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.token.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.token = this.popString16UTF8();
        }
    }

    public static class PStreamInjectedStatus
    extends Marshallable {
        public String url;
        public int uid;
        public int status;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.url.getBytes());
            this.pushInt(this.uid);
            this.pushInt(this.status);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.url = this.popString16UTF8();
            this.uid = this.popInt();
            this.status = this.popInt();
        }
    }

    public static class PHostInStopped
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
        }
    }

    public static class PHostInRequest
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
        }
    }

    public static class PHostInResponse
    extends Marshallable {
        public int ownerUid;
        public boolean accepted;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.ownerUid = this.popInt();
            this.accepted = this.popBool();
            this.error = this.popInt();
        }
    }

    public static class PInjectStreamConfig
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 25;

        private void marshall(Marshallable marshallable, LiveInjectStreamConfig liveInjectStreamConfig) {
            marshallable.pushShort((short)0);
            marshallable.pushShort((short)25);
            marshallable.pushInt(liveInjectStreamConfig.width);
            marshallable.pushInt(liveInjectStreamConfig.height);
            marshallable.pushInt(liveInjectStreamConfig.videoGop);
            marshallable.pushInt(liveInjectStreamConfig.videoFramerate);
            marshallable.pushInt(liveInjectStreamConfig.videoBitrate);
            marshallable.pushInt(LiveInjectStreamConfig.AudioSampleRateType.getValue(liveInjectStreamConfig.audioSampleRate));
            marshallable.pushInt(liveInjectStreamConfig.audioBitrate);
            marshallable.pushInt(liveInjectStreamConfig.audioChannels);
        }

        public byte[] marshall(LiveInjectStreamConfig liveInjectStreamConfig) {
            this.marshall(this, liveInjectStreamConfig);
            return super.marshall();
        }
    }

    public static class PChannelMediaRelayConfiguration
    extends Marshallable {
        private void marshallChannelInfo(Marshallable marshallable, ChannelMediaInfo channelMediaInfo) {
            marshallable.pushString16(channelMediaInfo.channelName);
            marshallable.pushString16(channelMediaInfo.token);
            marshallable.pushInt(channelMediaInfo.uid);
        }

        private void marshall(Marshallable marshallable, ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
            this.marshallChannelInfo(marshallable, channelMediaRelayConfiguration.getSrcChannelMediaInfo());
            int n2 = channelMediaRelayConfiguration.getDestChannelMediaInfos().size();
            this.pushShort((short)n2);
            for (String string : channelMediaRelayConfiguration.getDestChannelMediaInfos().keySet()) {
                ChannelMediaInfo channelMediaInfo = channelMediaRelayConfiguration.getDestChannelMediaInfos().get(string);
                this.marshallChannelInfo(marshallable, channelMediaInfo);
            }
        }

        public byte[] marshall(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
            this.marshall(this, channelMediaRelayConfiguration);
            return super.marshall();
        }
    }

    public static class PLiveTranscoding
    extends Marshallable {
        private static final short SERVER_TYPE = 0;
        private static final short URI = 23;

        private void marshallUserConfig(Marshallable marshallable, LiveTranscoding.TranscodingUser transcodingUser) {
            marshallable.pushInt(transcodingUser.uid);
            marshallable.pushInt(transcodingUser.x);
            marshallable.pushInt(transcodingUser.y);
            marshallable.pushInt(transcodingUser.width);
            marshallable.pushInt(transcodingUser.height);
            marshallable.pushInt(transcodingUser.zOrder);
            marshallable.pushDouble(transcodingUser.alpha);
            marshallable.pushInt(transcodingUser.audioChannel);
        }

        private void marshallImage(Marshallable marshallable, AgoraImage agoraImage) {
            marshallable.pushString16(agoraImage.url);
            marshallable.pushInt(agoraImage.x);
            marshallable.pushInt(agoraImage.y);
            marshallable.pushInt(agoraImage.width);
            marshallable.pushInt(agoraImage.height);
        }

        private void marshall(Marshallable marshallable, LiveTranscoding liveTranscoding) {
            marshallable.pushShort((short)0);
            marshallable.pushShort((short)23);
            marshallable.pushInt(liveTranscoding.width);
            marshallable.pushInt(liveTranscoding.height);
            marshallable.pushInt(liveTranscoding.videoGop);
            marshallable.pushInt(liveTranscoding.videoFramerate);
            marshallable.pushInt(LiveTranscoding.VideoCodecProfileType.getValue(liveTranscoding.videoCodecProfile));
            marshallable.pushInt(LiveTranscoding.VideoCodecType.getValue(liveTranscoding.videoCodecType));
            marshallable.pushInt(liveTranscoding.videoBitrate);
            if (liveTranscoding.watermark == null) {
                liveTranscoding.watermark = new AgoraImage();
            }
            this.marshallImage(marshallable, liveTranscoding.watermark);
            if (liveTranscoding.backgroundImage == null) {
                liveTranscoding.backgroundImage = new AgoraImage();
            }
            this.marshallImage(marshallable, liveTranscoding.backgroundImage);
            marshallable.pushBool(liveTranscoding.lowLatency);
            marshallable.pushInt(LiveTranscoding.AudioSampleRateType.getValue(liveTranscoding.audioSampleRate));
            marshallable.pushInt(liveTranscoding.audioBitrate);
            marshallable.pushInt(liveTranscoding.audioChannels);
            marshallable.pushInt(LiveTranscoding.AudioCodecProfileType.getValue(liveTranscoding.audioCodecProfile));
            marshallable.pushInt(liveTranscoding.backgroundColor & 0xFFFFFF);
            if (TextUtils.isEmpty((CharSequence)liveTranscoding.userConfigExtraInfo)) {
                liveTranscoding.userConfigExtraInfo = "";
            }
            marshallable.pushString16(liveTranscoding.userConfigExtraInfo);
            if (TextUtils.isEmpty((CharSequence)liveTranscoding.metadata)) {
                liveTranscoding.metadata = "";
            }
            marshallable.pushString16(liveTranscoding.metadata);
            int n2 = 0;
            if (liveTranscoding.getUsers() != null && liveTranscoding.getUsers().size() > 0) {
                n2 = liveTranscoding.getUserCount();
                this.pushShort((short)n2);
                for (LiveTranscoding.TranscodingUser object : liveTranscoding.getUsers()) {
                    this.marshallUserConfig(marshallable, object);
                }
            } else {
                this.pushShort((short)n2);
            }
            this.pushShort((short)liveTranscoding.getAdvancedFeatures().size());
            for (Map.Entry entry : liveTranscoding.getAdvancedFeatures().entrySet()) {
                marshallable.pushString16((String)entry.getKey());
                marshallable.pushBool((Boolean)entry.getValue());
            }
        }

        public byte[] marshall(LiveTranscoding liveTranscoding) {
            this.marshall(this, liveTranscoding);
            return super.marshall();
        }
    }

    public static class PContentInspectConfig
    extends Marshallable {
        private void marshall(Marshallable marshallable, ContentInspectConfig contentInspectConfig) {
            if (contentInspectConfig == null || contentInspectConfig.moduleCount <= 0 || contentInspectConfig.moduleCount > 32) {
                return;
            }
            marshallable.pushString16(contentInspectConfig.extraInfo);
            this.pushShort((short)contentInspectConfig.moduleCount);
            for (int i2 = 0; i2 < contentInspectConfig.moduleCount; ++i2) {
                marshallable.pushInt(contentInspectConfig.modules[i2].type);
                marshallable.pushInt(contentInspectConfig.modules[i2].frequency);
            }
        }

        public byte[] marshall(ContentInspectConfig contentInspectConfig) {
            this.marshall(this, contentInspectConfig);
            return super.marshall();
        }
    }

    public static class PStreamUnPublished
    extends Marshallable {
        public String url;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.url = this.popString16UTF8();
        }
    }

    public static class PStreamEvent
    extends Marshallable {
        public String url;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.url = this.popString16UTF8();
            this.error = this.popInt();
        }
    }

    public static class PStreamPublished
    extends Marshallable {
        public String url;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.url = this.popString16UTF8();
            this.error = this.popInt();
        }
    }

    public static class PRtmpStreamingState
    extends Marshallable {
        public String url;
        public int state;
        public int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.url = this.popString16UTF8();
            this.state = this.popInt();
            this.error = this.popInt();
        }
    }

    public static class PClientRoleChanged
    extends Marshallable {
        int oldRole;
        int newRole;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.oldRole = this.popInt();
            this.newRole = this.popInt();
        }
    }

    public static class PActiveSpeaker
    extends Marshallable {
        public int uid;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
        }
    }

    public static class PFirstLocalAudioFramePublished
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstLocalAudioFrame
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstRemoteAudioFrame
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PStreamMessageError
    extends Marshallable {
        int uid;
        int streamId;
        int error;
        int missed;
        int cached;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.streamId = this.popInt();
            this.error = this.popInt();
            this.missed = this.popInt();
            this.cached = this.popInt();
        }
    }

    public static class PStreamMessage
    extends Marshallable {
        int uid;
        int streamId;
        byte[] payload;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.streamId = this.popInt();
            this.payload = this.popBytes();
        }
    }

    public static class PApiCallExecuted
    extends Marshallable {
        public int error;
        public String api;
        public String result;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.error = this.popInt();
            this.api = this.popString16UTF8();
            this.result = this.popString16UTF8();
        }
    }

    public static class PError
    extends Marshallable {
        public int err;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.err = this.popInt();
        }
    }

    public static class PMediaEngineEvent
    extends Marshallable {
        int code;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.code = this.popInt();
        }
    }

    public static class PVideoSizeChanged
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int rotation;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.rotation);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.rotation = this.popInt();
        }
    }

    public static class PFaceDetectValue
    extends Marshallable {
        public int imageWidth;
        public int imageHeight;
        FaceRect[] rectArr = null;
        int[] disArr = null;
        public int num;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            int n2;
            super.unmarshall(byArray);
            this.imageWidth = this.popInt();
            this.imageHeight = this.popInt();
            int n3 = this.popShort();
            if (n3 > 0) {
                this.rectArr = new FaceRect[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.rectArr[n2] = new FaceRect();
                    this.rectArr[n2].x = this.popInt();
                    this.rectArr[n2].y = this.popInt();
                    this.rectArr[n2].width = this.popInt();
                    this.rectArr[n2].height = this.popInt();
                }
            }
            if ((n2 = this.popShort()) > 0) {
                this.disArr = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.disArr[i2] = this.popInt();
                }
            }
        }

        public static class FaceRect {
            public int x;
            public int y;
            public int width;
            public int height;
        }
    }

    public static class PCameraExposureAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            this.pushInt(this.x);
            this.pushInt(this.y);
            this.pushInt(this.width);
            this.pushInt(this.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.x = this.popInt();
            this.y = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
        }
    }

    public static class PCameraFocusAreaChanged
    extends Marshallable {
        public int x;
        public int y;
        public int width;
        public int height;

        @Override
        public byte[] marshall() {
            this.pushInt(this.x);
            this.pushInt(this.y);
            this.pushInt(this.width);
            this.pushInt(this.height);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.x = this.popInt();
            this.y = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
        }
    }

    public static class PFirstRemoteVideoDecoded
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstLocalVideoFramePublished
    extends Marshallable {
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstLocalVideoFrame
    extends Marshallable {
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PFirstRemoteVideoFrame
    extends Marshallable {
        public int uid;
        public int width;
        public int height;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.width);
            this.pushInt(this.height);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.width = this.popInt();
            this.height = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PLocalVideoStat
    extends Marshallable {
        public IRtcEngineEventHandler.LocalVideoStats stats = new IRtcEngineEventHandler.LocalVideoStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.sentBitrate);
            this.pushInt(this.stats.sentFrameRate);
            this.pushInt(this.stats.encoderOutputFrameRate);
            this.pushInt(this.stats.rendererOutputFrameRate);
            this.pushInt(this.stats.targetBitrate);
            this.pushInt(this.stats.targetFrameRate);
            this.pushInt(this.stats.qualityAdaptIndication);
            this.pushInt(this.stats.encodedBitrate);
            this.pushInt(this.stats.encodedFrameWidth);
            this.pushInt(this.stats.encodedFrameHeight);
            this.pushInt(this.stats.encodedFrameCount);
            this.pushByte((byte)this.stats.codecType);
            this.pushShort((short)this.stats.txPacketLossRate);
            this.pushInt(this.stats.captureFrameRate);
            this.pushByte((byte)this.stats.captureBrightnessLevel);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.sentBitrate = this.popInt();
            this.stats.sentFrameRate = this.popInt();
            this.stats.encoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.targetBitrate = this.popInt();
            this.stats.targetFrameRate = this.popInt();
            this.stats.qualityAdaptIndication = this.popInt();
            this.stats.encodedBitrate = this.popInt();
            this.stats.encodedFrameWidth = this.popInt();
            this.stats.encodedFrameHeight = this.popInt();
            this.stats.encodedFrameCount = this.popInt();
            this.stats.codecType = this.popByte();
            this.stats.txPacketLossRate = this.popShort();
            this.stats.captureFrameRate = this.popInt();
            this.stats.captureBrightnessLevel = this.popByte();
        }
    }

    public static class PLocalAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.LocalAudioStats stats = new IRtcEngineEventHandler.LocalAudioStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.numChannels);
            this.pushInt(this.stats.sentSampleRate);
            this.pushInt(this.stats.sentBitrate);
            this.pushShort((short)this.stats.txPacketLossRate);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.numChannels = this.popInt();
            this.stats.sentSampleRate = this.popInt();
            this.stats.sentBitrate = this.popInt();
            this.stats.txPacketLossRate = this.popShort();
        }
    }

    public static class PRemoteAudioStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteAudioStats stats = new IRtcEngineEventHandler.RemoteAudioStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.uid);
            this.pushInt(this.stats.quality);
            this.pushInt(this.stats.networkTransportDelay);
            this.pushInt(this.stats.jitterBufferDelay);
            this.pushInt(this.stats.audioLossRate);
            this.pushInt(this.stats.numChannels);
            this.pushInt(this.stats.receivedSampleRate);
            this.pushInt(this.stats.receivedBitrate);
            this.pushInt(this.stats.totalFrozenTime);
            this.pushInt(this.stats.frozenRate);
            this.pushInt(this.stats.totalActiveTime);
            this.pushInt(this.stats.publishDuration);
            this.pushInt(this.stats.qoeQuality);
            this.pushInt(this.stats.qualityChangedReason);
            this.pushInt(this.stats.mosValue);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.uid = this.popInt();
            this.stats.quality = this.popInt();
            this.stats.networkTransportDelay = this.popInt();
            this.stats.jitterBufferDelay = this.popInt();
            this.stats.audioLossRate = this.popInt();
            this.stats.numChannels = this.popInt();
            this.stats.receivedSampleRate = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
            this.stats.totalActiveTime = this.popInt();
            this.stats.publishDuration = this.popInt();
            this.stats.qoeQuality = this.popInt();
            this.stats.qualityChangedReason = this.popInt();
            this.stats.mosValue = this.popInt();
        }
    }

    public static class PRemoteVideoStat
    extends Marshallable {
        public IRtcEngineEventHandler.RemoteVideoStats stats = new IRtcEngineEventHandler.RemoteVideoStats();

        @Override
        public byte[] marshall() {
            this.pushInt(this.stats.uid);
            this.pushInt(this.stats.delay);
            this.pushInt(this.stats.width);
            this.pushInt(this.stats.height);
            this.pushInt(this.stats.receivedBitrate);
            this.pushInt(this.stats.decoderOutputFrameRate);
            this.pushInt(this.stats.rendererOutputFrameRate);
            this.pushInt(this.stats.packetLossRate);
            this.pushInt(this.stats.rxStreamType);
            this.pushInt(this.stats.totalFrozenTime);
            this.pushInt(this.stats.frozenRate);
            this.pushInt(this.stats.totalActiveTime);
            this.pushInt(this.stats.publishDuration);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.stats.uid = this.popInt();
            this.stats.delay = this.popInt();
            this.stats.width = this.popInt();
            this.stats.height = this.popInt();
            this.stats.receivedBitrate = this.popInt();
            this.stats.decoderOutputFrameRate = this.popInt();
            this.stats.rendererOutputFrameRate = this.popInt();
            this.stats.packetLossRate = this.popInt();
            this.stats.rxStreamType = this.popInt();
            this.stats.totalFrozenTime = this.popInt();
            this.stats.frozenRate = this.popInt();
            this.stats.totalActiveTime = this.popInt();
            this.stats.publishDuration = this.popInt();
        }
    }

    public static class PVideoNetOptions
    extends Marshallable {
        short width;
        short height;
        short frameRate;
        short bitrate;

        public void marshall(Marshallable marshallable) {
            marshallable.pushShort(this.width);
            marshallable.pushShort(this.height);
            marshallable.pushShort(this.frameRate);
            marshallable.pushShort(this.bitrate);
        }

        @Override
        public byte[] marshall() {
            this.marshall(this);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.width = this.popShort();
            this.height = this.popShort();
            this.frameRate = this.popShort();
            this.bitrate = this.popShort();
        }
    }

    public static class MediaNetworkInfo
    extends Marshallable {
        String localIp4 = "";
        String gatewayIp4 = "";
        String localIp6 = "";
        String gatewayIp6 = "";
        int networkType;
        int networkSubtype;
        int signalLevel;
        int rssi;
        int asu;
        int frequency;
        int linkspeed;
        String ssid = "";
        String bssid = "";
        ArrayList<String> dnsList = null;

        public void marshall(Marshallable marshallable) {
            marshallable.pushBytes(this.localIp4.getBytes());
            marshallable.pushBytes(this.gatewayIp4.getBytes());
            marshallable.pushBytes(this.localIp6.getBytes());
            marshallable.pushBytes(this.gatewayIp6.getBytes());
            marshallable.pushInt(this.networkType);
            marshallable.pushInt(this.networkSubtype);
            marshallable.pushInt(this.signalLevel);
            marshallable.pushInt(this.rssi);
            marshallable.pushInt(this.asu);
            marshallable.pushInt(this.frequency);
            marshallable.pushInt(this.linkspeed);
            if (this.ssid != null && this.ssid instanceof String) {
                marshallable.pushBytes(this.ssid.getBytes());
            } else {
                marshallable.pushBytes("".getBytes());
            }
            if (this.bssid != null) {
                marshallable.pushBytes(this.bssid.getBytes());
            } else {
                marshallable.pushBytes("".getBytes());
            }
            if (this.dnsList != null) {
                marshallable.pushStringArray(this.dnsList);
            } else {
                marshallable.pushStringArray(new ArrayList<String>());
            }
        }

        @Override
        public byte[] marshall() {
            this.marshall(this);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class MediaAppContext
    extends Marshallable {
        MediaNetworkInfo networkInfo;

        @Override
        public byte[] marshall() {
            if (this.networkInfo != null) {
                this.networkInfo.marshall(this);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaResSpeakersReport
    extends Marshallable {
        int mixVolume;
        Speaker[] speakers;

        @Override
        public byte[] marshall() {
            this.pushInt(this.mixVolume);
            int n2 = this.speakers.length;
            this.pushShort((short)n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pushInt(this.speakers[i2].uid);
                this.pushInt(this.speakers[i2].volume);
                this.pushInt(this.speakers[i2].vad);
                this.pushString16(this.speakers[i2].channelId);
            }
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.mixVolume = this.popInt();
            int n2 = this.popShort();
            if (n2 > 0) {
                this.speakers = new Speaker[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.speakers[i2] = new Speaker();
                    this.speakers[i2].uid = this.popInt();
                    this.speakers[i2].volume = this.popInt();
                    this.speakers[i2].vad = this.popInt();
                    this.speakers[i2].channelId = this.popString16UTF8();
                }
            }
        }

        public static class Speaker {
            public int uid;
            public int volume;
            public int vad;
            public String channelId;
        }
    }

    public static class MediaResSetupTime
    extends Marshallable {
        int elapsed;
        boolean firstSuccess;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.elapsed = this.popInt();
            this.firstSuccess = this.popBool();
        }
    }

    public static class PMediaResFirstRemoteAudioDecoded
    extends Marshallable {
        public int uid;
        public int elapsed;

        @Override
        public byte[] marshall() {
            this.pushInt(this.uid);
            this.pushInt(this.elapsed);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PMediaResLocalAudioStateChanged
    extends Marshallable {
        int state;
        int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.state = this.popInt();
            this.error = this.popInt();
        }
    }

    public static class PMediaResLocalVideoStateChanged
    extends Marshallable {
        int localVideoState;
        int error;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.localVideoState = this.popInt();
            this.error = this.popInt();
        }
    }

    public static class PMediaResAudioEffectFinished
    extends Marshallable {
        int soundId;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.soundId = this.popInt();
        }
    }

    public static class PMediaResLastmileProbeResult
    extends Marshallable {
        short state;
        int rtt;
        LastmileProbeOneWayResult uplinkReport;
        LastmileProbeOneWayResult downlinkReport;

        @Override
        public byte[] marshall() {
            this.pushShort(this.state);
            this.pushInt(this.uplinkReport.packetLossRate);
            this.pushInt(this.uplinkReport.jitter);
            this.pushInt(this.uplinkReport.availableBandwidth);
            this.pushInt(this.downlinkReport.packetLossRate);
            this.pushInt(this.downlinkReport.jitter);
            this.pushInt(this.downlinkReport.availableBandwidth);
            this.pushInt(this.rtt);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.state = this.popShort();
            this.uplinkReport = new LastmileProbeOneWayResult();
            this.downlinkReport = new LastmileProbeOneWayResult();
            this.uplinkReport.packetLossRate = this.popInt();
            this.uplinkReport.jitter = this.popInt();
            this.uplinkReport.availableBandwidth = this.popInt();
            this.downlinkReport.packetLossRate = this.popInt();
            this.downlinkReport.jitter = this.popInt();
            this.downlinkReport.availableBandwidth = this.popInt();
            this.rtt = this.popInt();
        }

        public static class LastmileProbeOneWayResult {
            public int packetLossRate;
            public int jitter;
            public int availableBandwidth;
        }
    }

    public static class PMediaResLastmileQuality
    extends Marshallable {
        int quality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.quality = this.popInt();
        }
    }

    public static class PMediaResNetworkQuality
    extends Marshallable {
        int uid;
        int txQuality;
        int rxQuality;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.txQuality = this.popInt();
            this.rxQuality = this.popInt();
        }
    }

    public static class PMediaResUserState
    extends Marshallable {
        int uid;
        boolean state;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.state = this.popBool();
        }
    }

    public static class PMediaResUserOfflineEvent
    extends Marshallable {
        int uid;
        int reason;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.reason = this.popInt();
        }
    }

    public static class PMediaResUserJoinedEvent
    extends Marshallable {
        int uid;
        int elapsed;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.uid = this.popInt();
            this.elapsed = this.popInt();
        }
    }

    public static class PMediaResJoinMedia
    extends Marshallable {
        public String channel;
        public int uid;
        public int elapsed;
        public boolean firstSuccess;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.channel = this.popString16UTF8();
            this.uid = this.popInt();
            this.elapsed = this.popInt();
            this.firstSuccess = this.popBool();
        }
    }

    public static class PMediaResRtcStats
    extends Marshallable {
        int totalDuration;
        int totalTxBytes;
        int totalRxBytes;
        int txAudioBytes;
        int txVideoBytes;
        int rxAudioBytes;
        int rxVideoBytes;
        int txKBitRate;
        int rxKBitRate;
        int txAudioKBitRate;
        int rxAudioKBitRate;
        int txVideoKBitRate;
        int rxVideoKBitRate;
        int lastmileDelay;
        int txPacketLossRate;
        int rxPacketLossRate;
        int cpuTotalUsage;
        int cpuAppUsage;
        int users;
        int gatewayRtt;
        int memoryTotalUsageRatio;
        int memoryAppUsageRatio;
        int memoryAppUsageInKbytes;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.totalDuration = this.popInt();
            this.totalTxBytes = this.popInt();
            this.totalRxBytes = this.popInt();
            this.txAudioBytes = this.popInt();
            this.rxAudioBytes = this.popInt();
            this.txVideoBytes = this.popInt();
            this.rxVideoBytes = this.popInt();
            this.txKBitRate = this.popShort();
            this.rxKBitRate = this.popShort();
            this.txAudioKBitRate = this.popShort();
            this.rxAudioKBitRate = this.popShort();
            this.txVideoKBitRate = this.popShort();
            this.rxVideoKBitRate = this.popShort();
            this.lastmileDelay = this.popShort();
            this.txPacketLossRate = this.popShort();
            this.rxPacketLossRate = this.popShort();
            this.cpuTotalUsage = this.popInt();
            this.cpuAppUsage = this.popInt();
            this.users = this.popInt();
            this.gatewayRtt = this.popInt();
            this.memoryTotalUsageRatio = this.popInt();
            this.memoryAppUsageRatio = this.popInt();
            this.memoryAppUsageInKbytes = this.popInt();
        }
    }

    public static class PMediaResTransportQuality
    extends Marshallable {
        public boolean isAudio;
        public int peer_uid;
        public int bitrate;
        public short delay;
        public short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.isAudio = this.popBool();
            this.peer_uid = this.popInt();
            this.bitrate = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
        }
    }

    public static class PMediaResAudioQuality
    extends Marshallable {
        int peer_uid;
        int quality;
        short delay;
        short lost;

        @Override
        public byte[] marshall() {
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
            super.unmarshall(byArray);
            this.peer_uid = this.popInt();
            this.quality = this.popInt();
            this.delay = this.popShort();
            this.lost = this.popShort();
        }
    }

    public static class PMediaReqConnectMedia2
    extends Marshallable {
        public static final int uri = 0x3F60000 | AGORA_UI_SERVER;
        String connInfo;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.connInfo.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqLeaveChannel
    extends Marshallable {
        public static final int uri = 0x60000 | AGORA_UI_SERVER;
        int sid;

        @Override
        public byte[] marshall() {
            this.pushInt(this.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqUserData
    extends Marshallable {
        public static final int uri = 0x50000 | AGORA_UI_SERVER;
        String key;
        String username;
        String mobileinfo;
        int uid;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.key.getBytes());
            this.pushBytes(this.username.getBytes());
            this.pushBytes(this.mobileinfo.getBytes());
            this.pushInt(this.uid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqLeaveLinkd
    extends Marshallable {
        public static final int uri = 0x40000 | AGORA_UI_SERVER;
        int sid;

        @Override
        public byte[] marshall() {
            this.pushInt(this.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqJoinMeida
    extends Marshallable {
        public static final int uri = 0x30000 | AGORA_UI_SERVER;
        int sid;

        @Override
        public byte[] marshall() {
            this.pushInt(this.sid);
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }

    public static class PMediaReqCreateChannel
    extends Marshallable {
        public static final int uri = 0x20000 | AGORA_UI_SERVER;
        String key;

        @Override
        public byte[] marshall() {
            this.pushBytes(this.key.getBytes());
            return super.marshall();
        }

        @Override
        public void unmarshall(byte[] byArray) {
        }
    }
}

