/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import io.agora.rtc.audio.HardwareEarbackController;

class AudioManagerAndroid {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;
    private AudioManager audioManager;
    private Context mcontext;

    private AudioManagerAndroid(Context context) {
        this.mcontext = context;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String string;
            String string2 = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (string2 != null) {
                this.mNativeOutputSampleRate = Integer.parseInt(string2);
            }
            if ((string = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(string);
            }
        }
        this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    private int QuerySpeakerStatus() {
        if (this.audioManager.isBluetoothScoOn()) {
            return 5;
        }
        if (this.audioManager.isWiredHeadsetOn()) {
            return 0;
        }
        if (this.audioManager.isSpeakerphoneOn()) {
            return 3;
        }
        return 1;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        this.audioManager.setSpeakerphoneOn(bl);
        return 0;
    }

    private int SetAudioMode(int n2) {
        switch (n2) {
            case 0: {
                this.audioManager.setMode(0);
                break;
            }
            case 1: {
                this.audioManager.setMode(1);
                break;
            }
            case 2: {
                this.audioManager.setMode(2);
                break;
            }
            case 3: {
                this.audioManager.setMode(3);
                break;
            }
            default: {
                this.audioManager.setMode(0);
            }
        }
        return 0;
    }

    private int GetAudioMode(int n2) {
        return this.audioManager.getMode();
    }

    private boolean isHardwareEarbackSupported() {
        boolean bl = false;
        if (this.mcontext != null) {
            bl = HardwareEarbackController.getInstance(this.mcontext).isHardwareEarbackSupported();
        }
        return bl;
    }

    private int enableHardwareEarback(boolean bl) {
        int n2 = -1;
        if (this.mcontext != null) {
            n2 = HardwareEarbackController.getInstance(this.mcontext).enableHardwareEarback(bl);
        }
        return n2;
    }

    private int setHardwareEarbackVolume(int n2) {
        int n3 = -1;
        if (this.mcontext != null) {
            n3 = HardwareEarbackController.getInstance(this.mcontext).setHardwareEarbackVolume(n2);
        }
        return n3;
    }

    private boolean checkAudioPermission() {
        return this.mcontext != null && this.mcontext.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0 && this.mcontext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0;
    }
}

