/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc;

import io.agora.rtc.RtcEngine;
import io.agora.rtc.internal.Logging;
import java.lang.ref.WeakReference;

public class AgoraMediaRecorder {
    public static final int RECORDER_STATE_ERROR = -1;
    public static final int RECORDER_STATE_START = 2;
    public static final int RECORDER_STATE_STOP = 3;
    public static final int RECORDER_EEROR_NONE = 0;
    public static final int RECORDER_EEROR_WRITE_FAILED = 1;
    public static final int RECORDER_EEROR_NO_STREAM = 2;
    public static final int RECORDER_EEROR_OVER_MAX_DURATION = 3;
    public static final int RECORDER_ERROR_CONFIG_CHANGED = 4;
    public static final int RECORDER_ERROR_CUSTOM_STREAM_DETECTED = 5;
    public static final int STREAM_TYPE_AUDIO = 1;
    public static final int STREAM_TYPE_VIDEO = 2;
    public static final int STREAM_TYPE_BOTH = 3;
    public static final int CONTAINER_MP4 = 1;
    private static volatile AgoraMediaRecorder mRecorder = null;
    WeakReference<RtcEngine> mEngineReference;

    private AgoraMediaRecorder(RtcEngine rtcEngine) {
        this.mEngineReference = new WeakReference<RtcEngine>(rtcEngine);
    }

    private void setEngine(RtcEngine rtcEngine) {
        this.mEngineReference = new WeakReference<RtcEngine>(rtcEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgoraMediaRecorder getMediaRecorder(RtcEngine rtcEngine, IMediaRecorderCallback iMediaRecorderCallback) {
        int n2 = rtcEngine.getMediaRecorder(iMediaRecorderCallback);
        if (n2 != 0) {
            Logging.e("getMediaRecorder failed, please ensure the RtcEngine has been initialized and already join the channel");
            return null;
        }
        if (mRecorder == null) {
            Class<AgoraMediaRecorder> clazz = AgoraMediaRecorder.class;
            synchronized (AgoraMediaRecorder.class) {
                if (mRecorder == null) {
                    mRecorder = new AgoraMediaRecorder(rtcEngine);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            mRecorder.setEngine(rtcEngine);
        }
        return mRecorder;
    }

    public int startRecording(MediaRecorderConfiguration mediaRecorderConfiguration) {
        RtcEngine rtcEngine = null;
        if (this.mEngineReference == null || (rtcEngine = (RtcEngine)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return rtcEngine.startRecording(mediaRecorderConfiguration.storagePath, mediaRecorderConfiguration.containerFormat, mediaRecorderConfiguration.streamType, mediaRecorderConfiguration.maxDurationMs, mediaRecorderConfiguration.recorderInfoUpdateInterval);
    }

    public int stopRecording() {
        RtcEngine rtcEngine = null;
        if (this.mEngineReference == null || (rtcEngine = (RtcEngine)this.mEngineReference.get()) == null) {
            this.mEngineReference = null;
            return -7;
        }
        return rtcEngine.stopRecording();
    }

    public void release() {
        RtcEngine rtcEngine = null;
        if (this.mEngineReference != null && (rtcEngine = (RtcEngine)this.mEngineReference.get()) != null) {
            rtcEngine.releaseRecorder();
        }
        this.mEngineReference = null;
    }

    public static interface IMediaRecorderCallback {
        public void onRecorderStateChanged(int var1, int var2);

        public void onRecorderInfoUpdated(Object var1);
    }

    public static class RecorderInfo {
        public String fileName;
        public int durationMs;
        public int fileSize;

        public RecorderInfo(String string, int n2, int n3) {
            this.fileName = string;
            this.durationMs = n2;
            this.fileSize = n3;
        }
    }

    public static class MediaRecorderConfiguration {
        public String storagePath;
        public int containerFormat = 1;
        public int streamType = 3;
        public int maxDurationMs = 120000;
        public int recorderInfoUpdateInterval = 0;

        public MediaRecorderConfiguration(String string, int n2, int n3, int n4, int n5) {
            this.storagePath = string;
            this.containerFormat = n2;
            this.streamType = n3;
            this.maxDurationMs = n4;
            this.recorderInfoUpdateInterval = n5;
        }
    }
}

