/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.prefs;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.MultiSelectListPreference;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.prefs.PrefUtil;
import java.util.ArrayList;
import java.util.HashSet;

@TargetApi(value=11)
public class MaterialMultiSelectListPreference
extends MultiSelectListPreference {
    private Context context;
    private MaterialDialog mDialog;

    public MaterialMultiSelectListPreference(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialMultiSelectListPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialMultiSelectListPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialMultiSelectListPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public void setEntries(CharSequence[] entries) {
        super.setEntries(entries);
        if (this.mDialog != null) {
            this.mDialog.setItems(entries);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        PrefUtil.setLayoutResource(context, (Preference)this, attrs);
        if (Build.VERSION.SDK_INT <= 10) {
            this.setWidgetLayoutResource(0);
        }
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    protected void showDialog(Bundle state) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String s : this.getValues()) {
            int index = this.findIndexOfValue(s);
            if (index < 0) continue;
            indices.add(this.findIndexOfValue(s));
        }
        MaterialDialog.Builder builder = new MaterialDialog.Builder(this.context).title(this.getDialogTitle()).icon(this.getDialogIcon()).negativeText(this.getNegativeButtonText()).positiveText(this.getPositiveButtonText()).onAny(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                switch (which) {
                    default: {
                        MaterialMultiSelectListPreference.this.onClick((DialogInterface)dialog, -1);
                        break;
                    }
                    case NEUTRAL: {
                        MaterialMultiSelectListPreference.this.onClick((DialogInterface)dialog, -3);
                        break;
                    }
                    case NEGATIVE: {
                        MaterialMultiSelectListPreference.this.onClick((DialogInterface)dialog, -2);
                    }
                }
            }
        }).items(this.getEntries()).itemsCallbackMultiChoice(indices.toArray(new Integer[indices.size()]), new MaterialDialog.ListCallbackMultiChoice(){

            public boolean onSelection(MaterialDialog dialog, Integer[] which, CharSequence[] text) {
                MaterialMultiSelectListPreference.this.onClick(null, -1);
                dialog.dismiss();
                HashSet<String> values = new HashSet<String>();
                Integer[] integerArray = which;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2 = integerArray[i];
                    values.add(MaterialMultiSelectListPreference.this.getEntryValues()[i2].toString());
                }
                if (MaterialMultiSelectListPreference.this.callChangeListener(values)) {
                    MaterialMultiSelectListPreference.this.setValues(values);
                }
                return true;
            }
        }).dismissListener((DialogInterface.OnDismissListener)this);
        View contentView = this.onCreateDialogView();
        if (contentView != null) {
            this.onBindDialogView(contentView);
            builder.customView(contentView, false);
        } else {
            builder.content(this.getDialogMessage());
        }
        PrefUtil.registerOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
        this.mDialog = builder.build();
        if (state != null) {
            this.mDialog.onRestoreInstanceState(state);
        }
        this.mDialog.show();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        PrefUtil.unregisterOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Dialog dialog = this.getDialog();
        if (dialog == null || !dialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = dialog.onSaveInstanceState();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        boolean isDialogShowing;
        Bundle dialogBundle;

        SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }
    }
}

