/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.prefs;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ListView;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.prefs.PrefUtil;
import java.lang.reflect.Field;

public class MaterialListPreference
extends ListPreference {
    private Context context;
    private MaterialDialog mDialog;

    public MaterialListPreference(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaterialListPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialListPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MaterialListPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        PrefUtil.setLayoutResource(context, (Preference)this, attrs);
        if (Build.VERSION.SDK_INT <= 10) {
            this.setWidgetLayoutResource(0);
        }
    }

    public void setEntries(CharSequence[] entries) {
        super.setEntries(entries);
        if (this.mDialog != null) {
            this.mDialog.setItems(entries);
        }
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public ListView getListView() {
        if (this.getDialog() == null) {
            return null;
        }
        return ((MaterialDialog)this.getDialog()).getListView();
    }

    protected void showDialog(Bundle state) {
        if (this.getEntries() == null || this.getEntryValues() == null) {
            throw new IllegalStateException("ListPreference requires an entries array and an entryValues array.");
        }
        int preselect = this.findIndexOfValue(this.getValue());
        MaterialDialog.Builder builder = new MaterialDialog.Builder(this.context).title(this.getDialogTitle()).icon(this.getDialogIcon()).dismissListener((DialogInterface.OnDismissListener)this).onAny(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                switch (which) {
                    default: {
                        MaterialListPreference.this.onClick((DialogInterface)dialog, -1);
                        break;
                    }
                    case NEUTRAL: {
                        MaterialListPreference.this.onClick((DialogInterface)dialog, -3);
                        break;
                    }
                    case NEGATIVE: {
                        MaterialListPreference.this.onClick((DialogInterface)dialog, -2);
                    }
                }
            }
        }).negativeText(this.getNegativeButtonText()).items(this.getEntries()).autoDismiss(true).itemsCallbackSingleChoice(preselect, new MaterialDialog.ListCallbackSingleChoice(){

            public boolean onSelection(MaterialDialog dialog, View itemView, int which, CharSequence text) {
                MaterialListPreference.this.onClick(null, -1);
                if (which >= 0 && MaterialListPreference.this.getEntryValues() != null) {
                    try {
                        Field clickedIndex = ListPreference.class.getDeclaredField("mClickedDialogEntryIndex");
                        clickedIndex.setAccessible(true);
                        clickedIndex.set((Object)MaterialListPreference.this, which);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
        });
        View contentView = this.onCreateDialogView();
        if (contentView != null) {
            this.onBindDialogView(contentView);
            builder.customView(contentView, false);
        } else {
            builder.content(this.getDialogMessage());
        }
        PrefUtil.registerOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
        this.mDialog = builder.build();
        if (state != null) {
            this.mDialog.onRestoreInstanceState(state);
        }
        this.onClick((DialogInterface)this.mDialog, -2);
        this.mDialog.show();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        PrefUtil.unregisterOnActivityDestroyListener((Preference)this, (PreferenceManager.OnActivityDestroyListener)this);
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Dialog dialog = this.getDialog();
        if (dialog == null || !dialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = dialog.onSaveInstanceState();
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        boolean isDialogShowing;
        Bundle dialogBundle;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

