package codetail.graphics.drawables;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class AnimatorsCompat {

    private static List<WeakReference<ObjectAnimator>> sRunningAnimators = new ArrayList<>();

    @SuppressWarnings("WeakerAccess")
    static void start(ObjectAnimator animator) {
        sRunningAnimators.add(new WeakReference<>(animator));

        animator.start();
    }

    static void startWithAutoCancel(ObjectAnimator animator) {
        for (WeakReference<ObjectAnimator> wa : sRunningAnimators) {
            ObjectAnimator a = wa.get();
            if (a == null) {
                continue;
            }

            if (hasSameTargetAndProperties(animator, a)) {
                a.cancel();
            }
        }

        start(animator);
    }

    private static boolean hasSameTargetAndProperties(ObjectAnimator self, @Nullable Animator anim) {
        if (anim instanceof ObjectAnimator) {
            PropertyValuesHolder[] theirValues = ((ObjectAnimator) anim).getValues();
            PropertyValuesHolder[] selfValues = self.getValues();
            if (((ObjectAnimator) anim).getTarget() == self.getTarget() && selfValues.length == theirValues.length) {

                final int length = selfValues.length;
                for (int i = 0; i < length; ++i) {
                    PropertyValuesHolder pvhMine = selfValues[i];
                    PropertyValuesHolder pvhTheirs = theirValues[i];
                    if (pvhMine.getPropertyName() == null || !pvhMine.getPropertyName()
                            .equals(pvhTheirs.getPropertyName())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

}
