/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.support.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class AnimatorsCompat {
    static List<WeakReference<ObjectAnimator>> sRunningAnimators = new ArrayList<WeakReference<ObjectAnimator>>();

    AnimatorsCompat() {
    }

    public static void start(ObjectAnimator animator) {
        sRunningAnimators.add(new WeakReference<ObjectAnimator>(animator));
        animator.start();
    }

    public static void startWithAutoCancel(ObjectAnimator animator) {
        for (WeakReference<ObjectAnimator> wa : sRunningAnimators) {
            ObjectAnimator a = (ObjectAnimator)wa.get();
            if (a == null || !AnimatorsCompat.hasSameTargetAndProperties(animator, (Animator)a)) continue;
            a.cancel();
        }
        AnimatorsCompat.start(animator);
    }

    private static boolean hasSameTargetAndProperties(ObjectAnimator self, @Nullable Animator anim) {
        if (anim instanceof ObjectAnimator) {
            PropertyValuesHolder[] theirValues = ((ObjectAnimator)anim).getValues();
            PropertyValuesHolder[] selfValues = self.getValues();
            if (((ObjectAnimator)anim).getTarget() == self.getTarget() && selfValues.length == theirValues.length) {
                int length = selfValues.length;
                for (int i = 0; i < length; ++i) {
                    PropertyValuesHolder pvhMine = selfValues[i];
                    PropertyValuesHolder pvhTheirs = theirValues[i];
                    if (pvhMine.getPropertyName() != null && pvhMine.getPropertyName().equals(pvhTheirs.getPropertyName())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

