/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import codetail.graphics.drawables.Android;
import codetail.graphics.drawables.LollipopDrawablesCompat;

class TypedArrayCompat {
    private static final int[] TEMP_ARRAY = new int[1];
    private static final ITypedArray IMPL = Android.isLollipop() ? new TypedArrayLollipop() : new BaseTypedArray();

    TypedArrayCompat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList getColorStateList(Resources.Theme theme, TypedArray a, TypedValue[] values, int index) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    ColorStateList colorStateList = tmp.getColorStateList(0);
                    return colorStateList;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return a.getColorStateList(index);
        }
        return null;
    }

    public static int getChangingConfigurations(TypedArray array) {
        return IMPL.getChangingConfigurations(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawable(Resources.Theme theme, TypedArray a, TypedValue[] values, int index) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    Drawable drawable = tmp.getDrawable(0);
                    return drawable;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return LollipopDrawablesCompat.getDrawable(a, index, theme);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getResourceId(Resources.Theme theme, TypedArray a, TypedValue[] values, int index, int def) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    int n = tmp.getResourceId(0, def);
                    return n;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return a.getResourceId(index, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDimensionPixelOffset(Resources.Theme theme, TypedArray a, TypedValue[] values, int index, int def) {
        if (values != null && theme != null) {
            TypedValue v = values[index];
            if (v.type == 2) {
                TypedArrayCompat.TEMP_ARRAY[0] = v.data;
                TypedArray tmp = theme.obtainStyledAttributes(null, TEMP_ARRAY, 0, 0);
                try {
                    int n = tmp.getDimensionPixelOffset(0, def);
                    return n;
                }
                finally {
                    tmp.recycle();
                }
            }
        }
        if (a != null) {
            return a.getDimensionPixelOffset(index, def);
        }
        return def;
    }

    public static TypedValue[] extractThemeAttrs(TypedArray array) {
        int N = array.length();
        TypedValue[] values = null;
        for (int index = 0; index < N; ++index) {
            int attr;
            TypedValue value = array.peekValue(index);
            if (value == null || value.type != 2 || (attr = value.data) == 0) continue;
            if (values == null) {
                values = new TypedValue[N];
            }
            values[index] = value;
        }
        return values;
    }

    @TargetApi(value=21)
    static class TypedArrayLollipop
    extends BaseTypedArray {
        TypedArrayLollipop() {
        }

        @Override
        public int getChangingConfigurations(TypedArray array) {
            return array.getChangingConfigurations();
        }
    }

    static class BaseTypedArray
    implements ITypedArray {
        BaseTypedArray() {
        }

        @Override
        public int getChangingConfigurations(TypedArray array) {
            return 0;
        }
    }

    static interface ITypedArray {
        public int getChangingConfigurations(TypedArray var1);
    }
}

