/*
 * Decompiled with CFR 0.152.
 */
package codetail.graphics.drawables;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.util.LongSparseArray;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import codetail.graphics.drawables.Android;
import codetail.graphics.drawables.LollipopDrawable;
import codetail.graphics.drawables.RippleDrawable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LollipopDrawablesCompat {
    private static final Object mAccessLock = new Object();
    private static final Map<String, Class<? extends Drawable>> CLASS_MAP = new HashMap<String, Class<? extends Drawable>>();
    private static final LongSparseArray<WeakReference<Drawable.ConstantState>> sDrawableCache = new LongSparseArray();
    private static final LongSparseArray<WeakReference<Drawable.ConstantState>> sColorDrawableCache = new LongSparseArray();
    private static final IDrawable IMPL;

    public static void registerDrawable(Class<? extends Drawable> clazz, String name) {
        if (name == null || clazz == null) {
            throw new NullPointerException("Class: " + clazz + ". Name: " + name);
        }
        CLASS_MAP.put(name, clazz);
    }

    public static void unregisterDrawable(String name) {
        CLASS_MAP.remove(name);
    }

    public static void applyTheme(Drawable d, Resources.Theme t) {
        IMPL.applyTheme(d, t);
    }

    public static boolean canApplyTheme(Drawable d) {
        return IMPL.canApplyTheme(d);
    }

    public static Drawable createFromStream(InputStream is, String srcName) {
        return LollipopDrawablesCompat.createFromResourceStream(null, null, is, srcName);
    }

    public static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName) {
        return LollipopDrawablesCompat.createFromResourceStream(res, value, is, srcName, null);
    }

    public static Drawable createFromResourceStream(Resources res, TypedValue value, InputStream is, String srcName, BitmapFactory.Options opts) {
        return Drawable.createFromResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (String)srcName, (BitmapFactory.Options)opts);
    }

    public static Drawable createFromXml(Resources r, XmlPullParser parser) throws XmlPullParserException, IOException {
        return LollipopDrawablesCompat.createFromXml(r, parser, null);
    }

    public static Drawable createFromXml(Resources r, XmlPullParser parser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        Drawable drawable = LollipopDrawablesCompat.createFromXmlInner(r, parser, attrs, theme);
        if (drawable == null) {
            throw new RuntimeException("Unknown initial tag: " + parser.getName());
        }
        return drawable;
    }

    public static Drawable createFromXmlInner(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        Drawable drawable = null;
        String name = parser.getName();
        try {
            Class<? extends Drawable> clazz = CLASS_MAP.get(name);
            if (clazz != null) {
                drawable = clazz.newInstance();
            } else if (name.indexOf(46) > 0) {
                drawable = (Drawable)Class.forName(name).newInstance();
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("Error while inflating drawable resource", parser, (Throwable)e);
        }
        if (drawable == null) {
            if (Android.isLollipop()) {
                return Drawable.createFromXmlInner((Resources)r, (XmlPullParser)parser, (AttributeSet)attrs, (Resources.Theme)theme);
            }
            return Drawable.createFromXmlInner((Resources)r, (XmlPullParser)parser, (AttributeSet)attrs);
        }
        IMPL.inflate(drawable, r, parser, attrs, theme);
        return drawable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Drawable getCachedDrawable(LongSparseArray<WeakReference<Drawable.ConstantState>> cache, long key, Resources res) {
        Object object = mAccessLock;
        synchronized (object) {
            WeakReference wr = (WeakReference)cache.get(key);
            if (wr != null) {
                Drawable.ConstantState entry = (Drawable.ConstantState)wr.get();
                if (entry != null) {
                    return entry.newDrawable(res);
                }
                cache.delete(key);
            }
        }
        return null;
    }

    public static Drawable getDrawable(Resources res, int resid, Resources.Theme theme) {
        TypedValue value = new TypedValue();
        res.getValue(resid, value, true);
        return LollipopDrawablesCompat.loadDrawable(res, value, theme);
    }

    public static Drawable getDrawable(Resources res, int resid) {
        return LollipopDrawablesCompat.getDrawable(res, resid, null);
    }

    public static Drawable getDrawable(TypedArray array, int index, Resources.Theme theme) {
        TypedValue value = new TypedValue();
        array.getValue(index, value);
        return LollipopDrawablesCompat.loadDrawable(array.getResources(), value, theme);
    }

    public static Drawable getDrawable(TypedArray array, int index) {
        return LollipopDrawablesCompat.getDrawable(array, index, null);
    }

    public static Drawable loadDrawable(Resources res, TypedValue value, Resources.Theme theme) throws Resources.NotFoundException {
        long key;
        LongSparseArray<WeakReference<Drawable.ConstantState>> cache;
        boolean isColorDrawable;
        if (value == null || value.resourceId == 0) {
            return null;
        }
        if (value.type >= 28 && value.type <= 31) {
            isColorDrawable = true;
            cache = sColorDrawableCache;
            key = value.data;
        } else {
            isColorDrawable = false;
            cache = sDrawableCache;
            key = (long)value.assetCookie << 32 | (long)value.data;
        }
        Object dr = LollipopDrawablesCompat.getCachedDrawable(cache, key, res);
        if (dr != null) {
            return dr;
        }
        Object cs = null;
        if (cs != null) {
            Drawable cloneDr = cs.newDrawable(res);
            if (theme != null) {
                dr = cloneDr.mutate();
                LollipopDrawablesCompat.applyTheme(dr, theme);
            } else {
                dr = cloneDr;
            }
        } else {
            dr = isColorDrawable ? new ColorDrawable(value.data) : LollipopDrawablesCompat.loadDrawableForCookie(value, value.resourceId, res, theme);
        }
        if (dr != null) {
            dr.setChangingConfigurations(value.changingConfigurations);
            LollipopDrawablesCompat.cacheDrawable(value, res, theme, isColorDrawable, key, dr, cache);
        }
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheDrawable(TypedValue value, Resources resources, Resources.Theme theme, boolean isColorDrawable, long key, Drawable drawable, LongSparseArray<WeakReference<Drawable.ConstantState>> caches) {
        Drawable.ConstantState cs = drawable.getConstantState();
        if (cs == null) {
            return;
        }
        Object object = mAccessLock;
        synchronized (object) {
            caches.put(key, new WeakReference<Drawable.ConstantState>(cs));
        }
    }

    private static Drawable loadDrawableForCookie(TypedValue value, int id, Resources res, Resources.Theme theme) {
        Drawable dr;
        if (value.string == null) {
            throw new Resources.NotFoundException("Resource \"" + res.getResourceName(id) + "\" (" + Integer.toHexString(id) + ")  is not a Drawable (color or path): " + value);
        }
        String file = value.string.toString();
        if (file.endsWith(".xml")) {
            try {
                XmlResourceParser rp = res.getAssets().openXmlResourceParser(value.assetCookie, file);
                dr = LollipopDrawablesCompat.createFromXml(res, (XmlPullParser)rp, theme);
                rp.close();
            }
            catch (Exception e) {
                Log.w((String)LollipopDrawablesCompat.class.getSimpleName(), (String)"Failed to load drawable resource, using a fallback...", (Throwable)e);
                return res.getDrawable(value.resourceId);
            }
        }
        try {
            FileInputStream is = res.getAssets().openNonAssetFd(value.assetCookie, file).createInputStream();
            dr = LollipopDrawablesCompat.createFromResourceStream(res, value, is, file, null);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            Log.w((String)LollipopDrawablesCompat.class.getSimpleName(), (String)"Failed to load drawable resource, using a fallback...", (Throwable)e);
            return res.getDrawable(value.resourceId);
        }
        return dr;
    }

    public static Drawable createFromPath(String pathName) {
        return Drawable.createFromPath((String)pathName);
    }

    static {
        LollipopDrawablesCompat.registerDrawable(RippleDrawable.class, "ripple");
        IMPL = Android.isLollipop() ? new LollipopDrawableImpl() : new BaseDrawableImpl();
    }

    @TargetApi(value=21)
    static class LollipopDrawableImpl
    extends BaseDrawableImpl {
        LollipopDrawableImpl() {
        }

        @Override
        public void applyTheme(Drawable drawable, Resources.Theme t) {
            drawable.applyTheme(t);
        }

        @Override
        public boolean canApplyTheme(Drawable drawable) {
            return drawable.canApplyTheme();
        }

        @Override
        public void inflate(Drawable drawable, Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
            drawable.inflate(r, parser, attrs, theme);
        }
    }

    static class BaseDrawableImpl
    implements IDrawable {
        BaseDrawableImpl() {
        }

        @Override
        public void applyTheme(Drawable drawable, Resources.Theme t) {
            if (drawable instanceof LollipopDrawable) {
                ((LollipopDrawable)drawable).applyTheme(t);
            }
        }

        @Override
        public boolean canApplyTheme(Drawable drawable) {
            return drawable instanceof LollipopDrawable && ((LollipopDrawable)drawable).canApplyTheme();
        }

        @Override
        public void inflate(Drawable drawable, Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
            if (drawable instanceof LollipopDrawable) {
                ((LollipopDrawable)drawable).inflate(r, parser, attrs, theme);
                return;
            }
            drawable.inflate(r, parser, attrs);
        }
    }

    private static interface IDrawable {
        public void applyTheme(Drawable var1, Resources.Theme var2);

        public boolean canApplyTheme(Drawable var1);

        public void inflate(Drawable var1, Resources var2, XmlPullParser var3, AttributeSet var4, Resources.Theme var5) throws XmlPullParserException, IOException;
    }
}

