/*
 * Decompiled with CFR 0.152.
 */
package cn.addapp.pickers.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.addapp.pickers.adapter.ArrayWheelAdapter;
import cn.addapp.pickers.common.LineConfig;
import cn.addapp.pickers.listeners.OnItemPickListener;
import cn.addapp.pickers.listeners.OnSingleWheelListener;
import cn.addapp.pickers.picker.WheelPicker;
import cn.addapp.pickers.util.ConvertUtils;
import cn.addapp.pickers.widget.WheelListView;
import cn.addapp.pickers.widget.WheelView;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SinglePicker<T>
extends WheelPicker {
    private static final int ITEM_WIDTH_UNKNOWN = -99;
    private List<T> items = new ArrayList<T>();
    private List<String> itemStrings = new ArrayList<String>();
    private WheelListView wheelListView;
    private WheelView wheelView;
    private float weightWidth = 0.0f;
    private OnSingleWheelListener onSingleWheelListener;
    private OnItemPickListener<T> onItemPickListener;
    private int selectedItemIndex = 0;
    private String selectedItem = "";
    private String label = "";
    private int itemWidth = -99;

    public SinglePicker(Activity activity, T[] items) {
        this(activity, Arrays.asList(items));
    }

    public SinglePicker(Activity activity, List<T> items) {
        super(activity);
        this.setItems(items);
    }

    public void addItem(T item) {
        this.items.add(item);
        this.itemStrings.add(this.formatToString(item));
    }

    public void removeItem(T item) {
        this.items.remove(item);
        this.itemStrings.remove(this.formatToString(item));
    }

    public void setItems(T[] items) {
        this.setItems(Arrays.asList(items));
    }

    public void setItems(List<T> items) {
        if (null == items || items.size() == 0) {
            return;
        }
        this.items = items;
        for (T item : items) {
            this.itemStrings.add(this.formatToString(item));
        }
        if (this.wheelModeEnable) {
            if (null != this.wheelView) {
                this.wheelView.setAdapter(new ArrayWheelAdapter<String>(this.itemStrings));
                this.wheelView.setCurrentItem(this.selectedItemIndex);
            }
        } else if (null != this.wheelListView) {
            this.wheelListView.setItems(this.itemStrings, this.selectedItemIndex);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.items.size()) {
            this.selectedItemIndex = index;
        }
    }

    public void setSelectedItem(@NonNull T item) {
        this.setSelectedIndex(this.itemStrings.indexOf(this.formatToString(item)));
    }

    public void setWeightWidth(@FloatRange(from=0.0, to=1.0) float weightWidth) {
        if (weightWidth < 0.0f) {
            weightWidth = 0.0f;
        }
        if (!TextUtils.isEmpty((CharSequence)this.label) && weightWidth >= 1.0f) {
            weightWidth = 0.5f;
        }
        this.weightWidth = weightWidth;
    }

    public void setItemWidth(int itemWidth) {
        if (this.wheelModeEnable) {
            if (null != this.wheelView) {
                int width = ConvertUtils.toPx((Context)this.activity, itemWidth);
                this.wheelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, this.wheelListView.getLayoutParams().height));
            } else {
                this.itemWidth = itemWidth;
            }
        } else if (null != this.wheelListView) {
            int width = ConvertUtils.toPx((Context)this.activity, itemWidth);
            this.wheelListView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, this.wheelListView.getLayoutParams().height));
        } else {
            this.itemWidth = itemWidth;
        }
    }

    public void setOnSingleWheelListener(OnSingleWheelListener onSingleWheelListener) {
        this.onSingleWheelListener = onSingleWheelListener;
    }

    public void setOnItemPickListener(OnItemPickListener<T> listener) {
        this.onItemPickListener = listener;
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        if (this.items.size() == 0) {
            throw new IllegalArgumentException("please initial items at first, can't be empty");
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        layout.setOrientation(0);
        layout.setGravity(17);
        LinearLayout.LayoutParams wheelParams = new LinearLayout.LayoutParams(-2, -2);
        if (this.weightEnable) {
            layout.setWeightSum(1.0f);
            wheelParams.weight = this.weightWidth;
        }
        if (this.wheelModeEnable) {
            this.wheelView = new WheelView((Context)this.activity);
            this.wheelView.setAdapter(new ArrayWheelAdapter<String>(this.itemStrings));
            this.wheelView.setCurrentItem(this.selectedItemIndex);
            this.wheelView.setCanLoop(this.canLoop);
            this.wheelView.setTextSize(this.textSize);
            this.wheelView.setSelectedTextColor(this.textColorFocus);
            this.wheelView.setUnSelectedTextColor(this.textColorNormal);
            this.wheelView.setLineConfig(this.lineConfig);
            this.wheelView.setDividerType(LineConfig.DividerType.FILL);
            this.wheelView.setOnItemPickListener(new OnItemPickListener<String>(){

                @Override
                public void onItemPicked(int i, String item) {
                    SinglePicker.this.selectedItem = item;
                    SinglePicker.this.selectedItemIndex = i;
                    if (SinglePicker.this.onSingleWheelListener != null) {
                        SinglePicker.this.onSingleWheelListener.onWheeled(SinglePicker.this.selectedItemIndex, SinglePicker.this.selectedItem);
                    }
                }
            });
            wheelParams.gravity = 0x800003;
            if (TextUtils.isEmpty((CharSequence)this.label)) {
                this.wheelView.setLayoutParams((ViewGroup.LayoutParams)wheelParams);
                layout.addView((View)this.wheelView);
            } else {
                this.wheelView.setLayoutParams((ViewGroup.LayoutParams)wheelParams);
                layout.addView((View)this.wheelView);
                TextView labelView = new TextView((Context)this.activity);
                labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                labelView.setTextColor(this.textColorFocus);
                labelView.setTextSize((float)this.textSize);
                labelView.setText((CharSequence)this.label);
                layout.addView((View)labelView);
            }
            if (this.itemWidth != -99) {
                int width = ConvertUtils.toPx((Context)this.activity, this.itemWidth);
                this.wheelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, this.wheelView.getLayoutParams().height));
            }
        } else {
            this.wheelListView = new WheelListView((Context)this.activity);
            this.wheelListView.setTextSize(this.textSize);
            this.wheelListView.setSelectedTextColor(this.textColorFocus);
            this.wheelListView.setUnSelectedTextColor(this.textColorNormal);
            this.wheelListView.setLineConfig(this.lineConfig);
            this.wheelListView.setOffset(this.offset);
            this.wheelListView.setCanLoop(this.canLoop);
            this.wheelListView.setItems(this.itemStrings, this.selectedItemIndex);
            this.wheelListView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                @Override
                public void onItemSelected(int index, String item) {
                    SinglePicker.this.selectedItemIndex = index;
                    SinglePicker.this.selectedItem = item;
                    if (SinglePicker.this.onSingleWheelListener != null) {
                        SinglePicker.this.onSingleWheelListener.onWheeled(SinglePicker.this.selectedItemIndex, item);
                    }
                }
            });
            if (TextUtils.isEmpty((CharSequence)this.label)) {
                this.wheelListView.setLayoutParams((ViewGroup.LayoutParams)wheelParams);
                layout.addView((View)this.wheelListView);
            } else {
                this.wheelListView.setLayoutParams((ViewGroup.LayoutParams)wheelParams);
                layout.addView((View)this.wheelListView);
                TextView labelView = new TextView((Context)this.activity);
                labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                labelView.setTextColor(this.textColorFocus);
                labelView.setTextSize((float)this.textSize);
                labelView.setText((CharSequence)this.label);
                layout.addView((View)labelView);
            }
            if (this.itemWidth != -99) {
                int width = ConvertUtils.toPx((Context)this.activity, this.itemWidth);
                this.wheelListView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, this.wheelListView.getLayoutParams().height));
            }
        }
        return layout;
    }

    private String formatToString(T item) {
        if (item instanceof Float || item instanceof Double) {
            return new DecimalFormat("0.00").format(item);
        }
        return item.toString();
    }

    @Override
    public void onSubmit() {
        if (this.onItemPickListener != null) {
            this.onItemPickListener.onItemPicked(this.getSelectedIndex(), this.getSelectedItem());
        }
    }

    private T getSelectedItem() {
        return this.items.get(this.selectedItemIndex);
    }

    public int getSelectedIndex() {
        return this.selectedItemIndex;
    }
}

