/*
 * Decompiled with CFR 0.152.
 */
package cn.addapp.pickers.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.addapp.pickers.adapter.ArrayWheelAdapter;
import cn.addapp.pickers.common.LineConfig;
import cn.addapp.pickers.listeners.OnItemPickListener;
import cn.addapp.pickers.listeners.OnMoreItemPickListener;
import cn.addapp.pickers.listeners.OnMoreWheelListener;
import cn.addapp.pickers.picker.WheelPicker;
import cn.addapp.pickers.util.LogUtils;
import cn.addapp.pickers.widget.WheelListView;
import cn.addapp.pickers.widget.WheelView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LinkagePicker
extends WheelPicker {
    protected String selectedFirstItem = "";
    protected String selectedSecondItem = "";
    protected String selectedThirdItem = "";
    protected String firstLabel = "";
    protected String secondLabel = "";
    protected String thirdLabel = "";
    protected int selectedFirstIndex = 0;
    protected int selectedSecondIndex = 0;
    protected int selectedThirdIndex = 0;
    protected DataProvider provider;
    private OnMoreItemPickListener onMoreItemPickListener;
    private float firstColumnWeight = 0.0f;
    private float secondColumnWeight = 0.0f;
    private float thirdColumnWeight = 0.0f;
    private OnMoreWheelListener onMoreWheelListener;

    public LinkagePicker(Activity activity) {
        super(activity);
    }

    public LinkagePicker(Activity activity, DataProvider provider) {
        super(activity);
        this.provider = provider;
    }

    protected void setProvider(DataProvider provider) {
        this.provider = provider;
    }

    public void setSelectedIndex(int firstIndex, int secondIndex) {
        this.setSelectedIndex(firstIndex, secondIndex, 0);
    }

    public void setSelectedIndex(int firstIndex, int secondIndex, int thirdIndex) {
        this.selectedFirstIndex = firstIndex;
        this.selectedSecondIndex = secondIndex;
        this.selectedThirdIndex = thirdIndex;
    }

    public void setSelectedItem(String firstText, String secondText) {
        this.setSelectedItem(firstText, secondText, "");
    }

    public void setSelectedItem(String firstText, String secondText, String thirdText) {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set data provider at first");
        }
        List<String> firstData = this.provider.provideFirstData();
        for (int i = 0; i < firstData.size(); ++i) {
            String ft = firstData.get(i);
            if (!ft.contains(firstText)) continue;
            this.selectedFirstIndex = i;
            LogUtils.verbose("init select first text: " + ft + ", index:" + this.selectedFirstIndex);
            break;
        }
        List<String> secondData = this.provider.provideSecondData(this.selectedFirstIndex);
        for (int j = 0; j < secondData.size(); ++j) {
            String st = secondData.get(j);
            if (!st.contains(secondText)) continue;
            this.selectedSecondIndex = j;
            LogUtils.verbose("init select second text: " + st + ", index:" + this.selectedSecondIndex);
            break;
        }
        if (this.provider.isOnlyTwo()) {
            return;
        }
        List<String> thirdData = this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex);
        for (int k = 0; k < thirdData.size(); ++k) {
            String tt = thirdData.get(k);
            if (!tt.contains(thirdText)) continue;
            this.selectedThirdIndex = k;
            LogUtils.verbose("init select third text: " + tt + ", index:" + this.selectedThirdIndex);
            break;
        }
    }

    public void setLabel(String firstLabel, String secondLabel) {
        this.setLabel(firstLabel, secondLabel, "");
    }

    public void setLabel(String firstLabel, String secondLabel, String thirdLabel) {
        this.firstLabel = firstLabel;
        this.secondLabel = secondLabel;
        this.thirdLabel = thirdLabel;
    }

    public String getSelectedFirstItem() {
        this.selectedFirstItem = this.provider.provideFirstData().get(this.selectedFirstIndex);
        return this.selectedFirstItem;
    }

    public String getSelectedSecondItem() {
        this.selectedSecondItem = this.provider.provideSecondData(this.selectedFirstIndex).get(this.selectedSecondIndex);
        return this.selectedSecondItem;
    }

    public String getSelectedThirdItem() {
        this.selectedThirdItem = this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex).get(this.selectedThirdIndex);
        return this.selectedThirdItem;
    }

    public int getSelectedFirstIndex() {
        return this.selectedFirstIndex;
    }

    public int getSelectedSecondIndex() {
        return this.selectedSecondIndex;
    }

    public int getSelectedThirdIndex() {
        return this.selectedThirdIndex;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) float firstColumnWeight, @FloatRange(from=0.0, to=1.0) float secondColumnWeight, @FloatRange(from=0.0, to=1.0) float thirdColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = thirdColumnWeight;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) float firstColumnWeight, @FloatRange(from=0.0, to=1.0) float secondColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = 0.0f;
    }

    public void setOnMoreWheelListener(OnMoreWheelListener onMoreWheelListener) {
        this.onMoreWheelListener = onMoreWheelListener;
    }

    public void setOnMoreItemPickListener(OnMoreItemPickListener onMoreItemPickListener) {
        this.onMoreItemPickListener = onMoreItemPickListener;
    }

    @Size(value=3L)
    protected int[] getColumnWidths(boolean onlyTwoColumn) {
        LogUtils.verbose(this, String.format(Locale.CHINA, "column weight is: %f-%f-%f", Float.valueOf(this.firstColumnWeight), Float.valueOf(this.secondColumnWeight), Float.valueOf(this.thirdColumnWeight)));
        int[] widths = new int[3];
        if ((int)this.firstColumnWeight == 0 && (int)this.secondColumnWeight == 0 && (int)this.thirdColumnWeight == 0) {
            if (onlyTwoColumn) {
                widths[0] = this.screenWidthPixels / 2;
                widths[1] = widths[0];
                widths[2] = 0;
            } else {
                widths[0] = this.screenWidthPixels / 3;
                widths[1] = widths[0];
                widths[2] = widths[0];
            }
        } else {
            widths[0] = (int)((float)this.screenWidthPixels * this.firstColumnWeight);
            widths[1] = (int)((float)this.screenWidthPixels * this.secondColumnWeight);
            widths[2] = (int)((float)this.screenWidthPixels * this.thirdColumnWeight);
        }
        return widths;
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set data provider before make view");
        }
        int[] widths = this.getColumnWidths(this.provider.isOnlyTwo());
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        layout.setWeightSum(3.0f);
        LinearLayout.LayoutParams wheelParams = new LinearLayout.LayoutParams(widths[0], -2);
        LinearLayout.LayoutParams wheelParams1 = new LinearLayout.LayoutParams(widths[1], -2);
        LinearLayout.LayoutParams wheelParams2 = new LinearLayout.LayoutParams(widths[2], -2);
        if (this.weightEnable) {
            wheelParams.weight = this.firstColumnWeight;
            wheelParams1.weight = this.secondColumnWeight;
            wheelParams2.weight = this.thirdColumnWeight;
        }
        if (this.wheelModeEnable) {
            WheelView firstView = new WheelView((Context)this.activity);
            firstView.setCanLoop(this.canLoop);
            firstView.setTextSize(this.textSize);
            firstView.setSelectedTextColor(this.textColorFocus);
            firstView.setUnSelectedTextColor(this.textColorNormal);
            firstView.setLineConfig(this.lineConfig);
            firstView.setDividerType(LineConfig.DividerType.WRAP);
            firstView.setAdapter(new ArrayWheelAdapter<String>(this.provider.provideFirstData()));
            firstView.setCurrentItem(this.selectedFirstIndex);
            if (TextUtils.isEmpty((CharSequence)this.firstLabel)) {
                firstView.setLayoutParams((ViewGroup.LayoutParams)wheelParams);
            } else {
                firstView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                TextView labelView = new TextView((Context)this.activity);
                labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                labelView.setTextSize((float)this.textSize);
                labelView.setTextColor(this.textColorFocus);
                labelView.setText((CharSequence)this.firstLabel);
                layout.addView((View)labelView);
            }
            layout.addView((View)firstView);
            final WheelView secondView = new WheelView((Context)this.activity);
            secondView.setCanLoop(this.canLoop);
            secondView.setTextSize(this.textSize);
            secondView.setSelectedTextColor(this.textColorFocus);
            secondView.setUnSelectedTextColor(this.textColorNormal);
            secondView.setLineConfig(this.lineConfig);
            secondView.setDividerType(LineConfig.DividerType.WRAP);
            secondView.setAdapter(new ArrayWheelAdapter<String>(this.provider.provideSecondData(this.selectedFirstIndex)));
            secondView.setCurrentItem(this.selectedSecondIndex);
            if (TextUtils.isEmpty((CharSequence)this.secondLabel)) {
                secondView.setLayoutParams((ViewGroup.LayoutParams)wheelParams1);
            } else {
                secondView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                TextView labelView = new TextView((Context)this.activity);
                labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                labelView.setTextSize((float)this.textSize);
                labelView.setTextColor(this.textColorFocus);
                labelView.setText((CharSequence)this.secondLabel);
                layout.addView((View)labelView);
            }
            layout.addView((View)secondView);
            final WheelView thirdView = new WheelView((Context)this.activity);
            if (!this.provider.isOnlyTwo()) {
                thirdView.setCanLoop(this.canLoop);
                thirdView.setTextSize(this.textSize);
                thirdView.setSelectedTextColor(this.textColorFocus);
                thirdView.setUnSelectedTextColor(this.textColorNormal);
                thirdView.setLineConfig(this.lineConfig);
                thirdView.setDividerType(LineConfig.DividerType.WRAP);
                thirdView.setAdapter(new ArrayWheelAdapter<String>(this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex)));
                thirdView.setCurrentItem(this.selectedThirdIndex);
                if (TextUtils.isEmpty((CharSequence)this.thirdLabel)) {
                    thirdView.setLayoutParams((ViewGroup.LayoutParams)wheelParams2);
                } else {
                    thirdView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                    TextView labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                    labelView.setTextSize((float)this.textSize);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setText((CharSequence)this.thirdLabel);
                    layout.addView((View)labelView);
                }
                layout.addView((View)thirdView);
            }
            firstView.setOnItemPickListener(new OnItemPickListener<String>(){

                @Override
                public void onItemPicked(int i, String item) {
                    LinkagePicker.this.selectedFirstIndex = i;
                    LinkagePicker.this.selectedFirstItem = item;
                    LinkagePicker.this.selectedSecondIndex = 0;
                    LinkagePicker.this.selectedThirdIndex = 0;
                    if (LinkagePicker.this.onMoreWheelListener != null) {
                        LinkagePicker.this.onMoreWheelListener.onFirstWheeled(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedFirstItem);
                    }
                    LogUtils.error((Object)this, "change second data after first wheeled");
                    List<String> secondData = LinkagePicker.this.provider.provideSecondData(LinkagePicker.this.selectedFirstIndex);
                    secondView.setAdapter(new ArrayWheelAdapter<String>(secondData));
                    secondView.setCurrentItem(LinkagePicker.this.selectedSecondIndex);
                    if (LinkagePicker.this.provider.isOnlyTwo()) {
                        return;
                    }
                    List<String> thirdData = LinkagePicker.this.provider.provideThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex);
                    thirdView.setAdapter(new ArrayWheelAdapter<String>(thirdData));
                    thirdView.setCurrentItem(LinkagePicker.this.selectedThirdIndex);
                }
            });
            secondView.setOnItemPickListener(new OnItemPickListener<String>(){

                @Override
                public void onItemPicked(int i, String item) {
                    LinkagePicker.this.selectedSecondItem = item;
                    LinkagePicker.this.selectedSecondIndex = i;
                    LinkagePicker.this.selectedThirdIndex = 0;
                    if (LinkagePicker.this.onMoreWheelListener != null) {
                        LinkagePicker.this.onMoreWheelListener.onSecondWheeled(LinkagePicker.this.selectedSecondIndex, LinkagePicker.this.selectedSecondItem);
                    }
                    if (LinkagePicker.this.provider.isOnlyTwo()) {
                        return;
                    }
                    LogUtils.error((Object)this, "change third data after second wheeled");
                    List<String> thirdData = LinkagePicker.this.provider.provideThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex);
                    thirdView.setAdapter(new ArrayWheelAdapter<String>(thirdData));
                    thirdView.setCurrentItem(LinkagePicker.this.selectedThirdIndex);
                }
            });
            if (this.provider.isOnlyTwo()) {
                return layout;
            }
            thirdView.setOnItemPickListener(new OnItemPickListener<String>(){

                @Override
                public void onItemPicked(int i, String item) {
                    LinkagePicker.this.selectedThirdItem = item;
                    LinkagePicker.this.selectedThirdIndex = i;
                    if (LinkagePicker.this.onMoreWheelListener != null) {
                        LinkagePicker.this.onMoreWheelListener.onThirdWheeled(LinkagePicker.this.selectedThirdIndex, LinkagePicker.this.selectedThirdItem);
                    }
                }
            });
            return layout;
        }
        WheelListView firstView = new WheelListView((Context)this.activity);
        firstView.setTextSize(this.textSize);
        firstView.setSelectedTextColor(this.textColorFocus);
        firstView.setUnSelectedTextColor(this.textColorNormal);
        firstView.setLineConfig(this.lineConfig);
        firstView.setOffset(this.offset);
        firstView.setCanLoop(this.canLoop);
        layout.addView((View)firstView);
        if (TextUtils.isEmpty((CharSequence)this.firstLabel)) {
            firstView.setLayoutParams((ViewGroup.LayoutParams)wheelParams);
        } else {
            firstView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            TextView labelView = new TextView((Context)this.activity);
            labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            labelView.setTextSize((float)this.textSize);
            labelView.setTextColor(this.textColorFocus);
            labelView.setText((CharSequence)this.firstLabel);
            layout.addView((View)labelView);
        }
        final WheelListView secondView = new WheelListView((Context)this.activity);
        secondView.setTextSize(this.textSize);
        secondView.setSelectedTextColor(this.textColorFocus);
        secondView.setUnSelectedTextColor(this.textColorNormal);
        secondView.setLineConfig(this.lineConfig);
        secondView.setOffset(this.offset);
        secondView.setCanLoop(this.canLoop);
        layout.addView((View)secondView);
        if (TextUtils.isEmpty((CharSequence)this.secondLabel)) {
            secondView.setLayoutParams((ViewGroup.LayoutParams)wheelParams1);
        } else {
            secondView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            TextView labelView = new TextView((Context)this.activity);
            labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            labelView.setTextSize((float)this.textSize);
            labelView.setTextColor(this.textColorFocus);
            labelView.setText((CharSequence)this.secondLabel);
            layout.addView((View)labelView);
        }
        final WheelListView thirdView = new WheelListView((Context)this.activity);
        if (!this.provider.isOnlyTwo()) {
            thirdView.setTextSize(this.textSize);
            thirdView.setSelectedTextColor(this.textColorFocus);
            thirdView.setUnSelectedTextColor(this.textColorNormal);
            thirdView.setLineConfig(this.lineConfig);
            thirdView.setOffset(this.offset);
            thirdView.setCanLoop(this.canLoop);
            layout.addView((View)thirdView);
            if (TextUtils.isEmpty((CharSequence)this.thirdLabel)) {
                thirdView.setLayoutParams((ViewGroup.LayoutParams)wheelParams2);
            } else {
                thirdView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                TextView labelView = new TextView((Context)this.activity);
                labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                labelView.setTextSize((float)this.textSize);
                labelView.setTextColor(this.textColorFocus);
                labelView.setText((CharSequence)this.thirdLabel);
                layout.addView((View)labelView);
            }
        }
        firstView.setItems(this.provider.provideFirstData(), this.selectedFirstIndex);
        firstView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

            @Override
            public void onItemSelected(int index, String item) {
                LinkagePicker.this.selectedFirstItem = item;
                LinkagePicker.this.selectedFirstIndex = index;
                LinkagePicker.this.selectedSecondIndex = 0;
                LinkagePicker.this.selectedThirdIndex = 0;
                if (LinkagePicker.this.onMoreWheelListener != null) {
                    LinkagePicker.this.onMoreWheelListener.onFirstWheeled(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedFirstItem);
                }
                List<String> secondData = LinkagePicker.this.provider.provideSecondData(LinkagePicker.this.selectedFirstIndex);
                secondView.setItems(secondData, LinkagePicker.this.selectedSecondIndex);
                if (LinkagePicker.this.provider.isOnlyTwo()) {
                    return;
                }
                List<String> thirdData = LinkagePicker.this.provider.provideThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex);
                thirdView.setItems(thirdData, LinkagePicker.this.selectedThirdIndex);
            }
        });
        secondView.setItems(this.provider.provideSecondData(this.selectedFirstIndex), this.selectedSecondIndex);
        secondView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

            @Override
            public void onItemSelected(int index, String item) {
                LinkagePicker.this.selectedSecondItem = item;
                LinkagePicker.this.selectedSecondIndex = index;
                LinkagePicker.this.selectedThirdIndex = 0;
                if (LinkagePicker.this.onMoreWheelListener != null) {
                    LinkagePicker.this.onMoreWheelListener.onSecondWheeled(LinkagePicker.this.selectedSecondIndex, LinkagePicker.this.selectedSecondItem);
                }
                if (LinkagePicker.this.provider.isOnlyTwo()) {
                    return;
                }
                List<String> thirdData = LinkagePicker.this.provider.provideThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex);
                thirdView.setItems(thirdData, LinkagePicker.this.selectedThirdIndex);
            }
        });
        if (this.provider.isOnlyTwo()) {
            return layout;
        }
        thirdView.setItems(this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex), this.selectedThirdIndex);
        thirdView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

            @Override
            public void onItemSelected(int index, String item) {
                LinkagePicker.this.selectedThirdItem = item;
                LinkagePicker.this.selectedThirdIndex = index;
                if (LinkagePicker.this.onMoreWheelListener != null) {
                    LinkagePicker.this.onMoreWheelListener.onThirdWheeled(LinkagePicker.this.selectedThirdIndex, LinkagePicker.this.selectedThirdItem);
                }
            }
        });
        return layout;
    }

    @Override
    public void onSubmit() {
        if (this.onMoreItemPickListener == null) {
            return;
        }
        this.selectedFirstItem = this.provider.provideFirstData().get(this.selectedFirstIndex);
        this.selectedSecondItem = this.provider.provideSecondData(this.selectedFirstIndex).get(this.selectedSecondIndex);
        if (this.provider.isOnlyTwo()) {
            this.onMoreItemPickListener.onItemPicked(this.selectedFirstItem, this.selectedSecondItem, null);
        } else {
            this.selectedThirdItem = this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex).get(this.selectedThirdIndex);
            this.onMoreItemPickListener.onItemPicked(this.selectedFirstItem, this.selectedSecondItem, this.selectedThirdItem);
        }
    }

    public static class DefaultDataProvider
    implements DataProvider {
        private List<String> firstList = new ArrayList<String>();
        private List<List<String>> secondList = new ArrayList<List<String>>();
        private List<List<List<String>>> thirdList = new ArrayList<List<List<String>>>();
        private boolean onlyTwo = false;

        public DefaultDataProvider(List<String> firstList, List<List<String>> secondList, List<List<List<String>>> thirdList) {
            this.firstList = firstList;
            this.secondList = secondList;
            if (thirdList == null || thirdList.size() == 0) {
                this.onlyTwo = true;
            } else {
                this.thirdList = thirdList;
            }
        }

        @Override
        public boolean isOnlyTwo() {
            return this.onlyTwo;
        }

        @Override
        public List<String> provideFirstData() {
            return this.firstList;
        }

        @Override
        public List<String> provideSecondData(int firstIndex) {
            return this.secondList.get(firstIndex);
        }

        @Override
        public List<String> provideThirdData(int firstIndex, int secondIndex) {
            if (this.onlyTwo) {
                return new ArrayList<String>();
            }
            return this.thirdList.get(firstIndex).get(secondIndex);
        }
    }

    public static interface DataProvider {
        public boolean isOnlyTwo();

        public List<String> provideFirstData();

        public List<String> provideSecondData(int var1);

        public List<String> provideThirdData(int var1, int var2);
    }
}

