/*
 * Decompiled with CFR 0.152.
 */
package cn.addapp.pickers.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.addapp.pickers.adapter.ArrayWheelAdapter;
import cn.addapp.pickers.common.LineConfig;
import cn.addapp.pickers.listeners.OnItemPickListener;
import cn.addapp.pickers.picker.WheelPicker;
import cn.addapp.pickers.util.DateUtils;
import cn.addapp.pickers.util.LogUtils;
import cn.addapp.pickers.widget.WheelListView;
import cn.addapp.pickers.widget.WheelView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class DateTimePicker
extends WheelPicker {
    public static final int NONE = -1;
    public static final int YEAR_MONTH_DAY = 0;
    public static final int YEAR_MONTH = 1;
    public static final int MONTH_DAY = 2;
    public static final int HOUR_24 = 3;
    public static final int HOUR_12 = 4;
    private ArrayList<String> years = new ArrayList();
    private ArrayList<String> months = new ArrayList();
    private ArrayList<String> days = new ArrayList();
    private ArrayList<String> hours = new ArrayList();
    private ArrayList<String> minutes = new ArrayList();
    private String yearLabel = "\u5e74";
    private String monthLabel = "\u6708";
    private String dayLabel = "\u65e5";
    private String hourLabel = "\u65f6";
    private String minuteLabel = "\u5206";
    private int selectedYearIndex = 0;
    private int selectedMonthIndex = 0;
    private int selectedDayIndex = 0;
    private int selectedHourIndex = 0;
    private int selectedMinuteIndex = 0;
    private String selectedHour = "";
    private String selectedMinute = "";
    private OnWheelListener onWheelListener;
    private OnDateTimePickListener onDateTimePickListener;
    private int dateMode = 0;
    private int timeMode = 3;
    private int startYear = 2010;
    private int startMonth = 1;
    private int startDay = 1;
    private int endYear = 2020;
    private int endMonth = 12;
    private int endDay = 31;
    private int startHour;
    private int startMinute = 0;
    private int endHour;
    private int endMinute = 59;
    private int stepMinute = 1;
    private int stepHour = 1;

    public DateTimePicker(Activity activity, int timeMode) {
        this(activity, 0, timeMode);
    }

    public DateTimePicker(Activity activity, int dateMode, int timeMode) {
        super(activity);
        if (dateMode == -1 && timeMode == -1) {
            throw new IllegalArgumentException("The modes are NONE at the same time");
        }
        if (dateMode == 0 && timeMode != -1) {
            if (this.screenWidthPixels < 720) {
                this.textSize = 14;
            } else if (this.screenWidthPixels < 480) {
                this.textSize = 12;
            }
        }
        this.dateMode = dateMode;
        if (timeMode == 4) {
            this.startHour = 1;
            this.endHour = 12;
        } else {
            this.startHour = 0;
            this.endHour = 23;
        }
        this.timeMode = timeMode;
    }

    public void setDateRangeStart(int startYear, int startMonth, int startDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        this.startYear = startYear;
        this.startMonth = startMonth;
        this.startDay = startDay;
    }

    public void setDateRangeEnd(int endYear, int endMonth, int endDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        this.endYear = endYear;
        this.endMonth = endMonth;
        this.endDay = endDay;
        this.initYearData();
    }

    public void setDateRangeStart(int startYearOrMonth, int startMonthOrDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        if (this.dateMode == 0) {
            throw new IllegalArgumentException("Not support year/month/day mode");
        }
        if (this.dateMode == 1) {
            this.startYear = startYearOrMonth;
            this.startMonth = startMonthOrDay;
        } else if (this.dateMode == 2) {
            int year;
            this.startYear = this.endYear = (year = Calendar.getInstance(Locale.CHINA).get(1));
            this.startMonth = startYearOrMonth;
            this.startDay = startMonthOrDay;
        }
    }

    public void setDateRangeEnd(int endYearOrMonth, int endMonthOrDay) {
        if (this.dateMode == -1) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        if (this.dateMode == 0) {
            throw new IllegalArgumentException("Not support year/month/day mode");
        }
        if (this.dateMode == 1) {
            this.endYear = endYearOrMonth;
            this.endMonth = endMonthOrDay;
        } else if (this.dateMode == 2) {
            this.endMonth = endYearOrMonth;
            this.endDay = endMonthOrDay;
        }
        this.initYearData();
    }

    public void setTimeRangeStart(int startHour, int startMinute) {
        if (this.timeMode == -1) {
            throw new IllegalArgumentException("Time mode invalid");
        }
        boolean illegal = false;
        if (startHour < 0 || startMinute < 0 || startMinute > 59) {
            illegal = true;
        }
        if (this.timeMode == 4 && (startHour == 0 || startHour > 12)) {
            illegal = true;
        }
        if (this.timeMode == 3 && startHour >= 24) {
            illegal = true;
        }
        if (illegal) {
            throw new IllegalArgumentException("Time out of range");
        }
        this.startHour = startHour;
        this.startMinute = startMinute;
    }

    public void setTimeRangeEnd(int endHour, int endMinute) {
        if (this.timeMode == -1) {
            throw new IllegalArgumentException("Time mode invalid");
        }
        boolean illegal = false;
        if (endHour < 0 || endMinute < 0 || endMinute > 59) {
            illegal = true;
        }
        if (this.timeMode == 4 && (endHour == 0 || endHour > 12)) {
            illegal = true;
        }
        if (this.timeMode == 3 && endHour >= 24) {
            illegal = true;
        }
        if (illegal) {
            throw new IllegalArgumentException("Time out of range");
        }
        this.endHour = endHour;
        this.endMinute = endMinute;
        this.initHourData();
    }

    public void setLabel(String yearLabel, String monthLabel, String dayLabel, String hourLabel, String minuteLabel) {
        this.yearLabel = yearLabel;
        this.monthLabel = monthLabel;
        this.dayLabel = dayLabel;
        this.hourLabel = hourLabel;
        this.minuteLabel = minuteLabel;
    }

    public void setSelectedItem(int year, int month, int day, int hour, int minute) {
        if (this.dateMode != 0) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        LogUtils.verbose(this, "change months and days while set selected");
        this.changeMonthData(year);
        this.changeDayData(year, month);
        this.selectedYearIndex = this.findItemIndex(this.years, year);
        this.selectedMonthIndex = this.findItemIndex(this.months, month);
        this.selectedDayIndex = this.findItemIndex(this.days, day);
        if (this.timeMode != -1) {
            this.selectedHour = DateUtils.fillZero(hour);
            this.selectedMinute = DateUtils.fillZero(minute);
            if (this.hours.size() == 0) {
                LogUtils.verbose(this, "init hours before make view");
                this.initHourData();
            }
            this.selectedHourIndex = this.findItemIndex(this.hours, hour);
            this.changeMinuteData(hour);
            this.selectedMinuteIndex = this.findItemIndex(this.minutes, minute);
        }
    }

    public void setSelectedItem(int yearOrMonth, int monthOrDay, int hour, int minute) {
        if (this.dateMode == 0) {
            throw new IllegalArgumentException("Date mode invalid");
        }
        if (this.dateMode == 2) {
            int year;
            LogUtils.verbose(this, "change months and days while set selected");
            this.startYear = this.endYear = (year = Calendar.getInstance(Locale.CHINA).get(1));
            this.changeMonthData(year);
            this.changeDayData(year, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, yearOrMonth);
            this.selectedDayIndex = this.findItemIndex(this.days, monthOrDay);
        } else if (this.dateMode == 1) {
            LogUtils.verbose(this, "change months while set selected");
            this.changeMonthData(yearOrMonth);
            this.selectedYearIndex = this.findItemIndex(this.years, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, monthOrDay);
        }
        if (this.timeMode != -1) {
            this.selectedHour = DateUtils.fillZero(hour);
            this.selectedMinute = DateUtils.fillZero(minute);
        }
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnDateTimePickListener(OnDateTimePickListener listener) {
        this.onDateTimePickListener = listener;
    }

    public String getSelectedYear() {
        if (this.dateMode == 0 || this.dateMode == 1) {
            if (this.years.size() <= this.selectedYearIndex) {
                this.selectedYearIndex = this.years.size() - 1;
            }
            return this.years.get(this.selectedYearIndex);
        }
        return "";
    }

    public String getSelectedMonth() {
        if (this.dateMode != -1) {
            if (this.months.size() <= this.selectedMonthIndex) {
                this.selectedMonthIndex = this.months.size() - 1;
            }
            return this.months.get(this.selectedMonthIndex);
        }
        return "";
    }

    public String getSelectedDay() {
        if (this.dateMode == 0 || this.dateMode == 2) {
            if (this.days.size() <= this.selectedDayIndex) {
                this.selectedDayIndex = this.days.size() - 1;
            }
            return this.days.get(this.selectedDayIndex);
        }
        return "";
    }

    public String getSelectedHour() {
        if (this.timeMode != -1) {
            return this.selectedHour;
        }
        return "";
    }

    public String getSelectedMinute() {
        if (this.timeMode != -1) {
            return this.selectedMinute;
        }
        return "";
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        LinearLayout.LayoutParams wheelViewParams;
        int selectedYear;
        if ((this.dateMode == 0 || this.dateMode == 1) && this.years.size() == 0) {
            LogUtils.verbose(this, "init years before make view");
            this.initYearData();
        }
        if (this.dateMode != -1 && this.months.size() == 0) {
            LogUtils.verbose(this, "init months before make view");
            selectedYear = DateUtils.trimZero(this.getSelectedYear());
            this.changeMonthData(selectedYear);
        }
        if ((this.dateMode == 0 || this.dateMode == 2) && this.days.size() == 0) {
            LogUtils.verbose(this, "init days before make view");
            selectedYear = this.dateMode == 0 ? DateUtils.trimZero(this.getSelectedYear()) : Calendar.getInstance(Locale.CHINA).get(1);
            int selectedMonth = DateUtils.trimZero(this.getSelectedMonth());
            this.changeDayData(selectedYear, selectedMonth);
        }
        if (this.timeMode != -1 && this.hours.size() == 0) {
            LogUtils.verbose(this, "init hours before make view");
            this.initHourData();
        }
        if (this.timeMode != -1 && this.minutes.size() == 0) {
            LogUtils.verbose(this, "init minutes before make view");
            this.changeMinuteData(DateUtils.trimZero(this.selectedHour));
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        if (this.dateMode != -1 && this.timeMode != -1) {
            layout.setWeightSum(5.0f);
        } else if (this.dateMode == 0) {
            layout.setWeightSum(3.0f);
        } else {
            layout.setWeightSum(2.0f);
        }
        if (this.weightEnable) {
            wheelViewParams = new LinearLayout.LayoutParams(0, -2);
            wheelViewParams.weight = 1.0f;
        } else {
            wheelViewParams = new LinearLayout.LayoutParams(-2, -2);
        }
        LinearLayout.LayoutParams labelViewParams = new LinearLayout.LayoutParams(-2, -2);
        if (this.wheelModeEnable) {
            TextView labelView;
            WheelView yearView = new WheelView((Context)this.activity);
            final WheelView monthView = new WheelView((Context)this.activity);
            final WheelView dayView = new WheelView((Context)this.activity);
            WheelView hourView = new WheelView((Context)this.activity);
            final WheelView minuteView = new WheelView((Context)this.activity);
            if (this.dateMode == 0 || this.dateMode == 1) {
                yearView.setCanLoop(this.canLoop);
                yearView.setTextSize(this.textSize);
                yearView.setSelectedTextColor(this.textColorFocus);
                yearView.setUnSelectedTextColor(this.textColorNormal);
                yearView.setLineConfig(this.lineConfig);
                yearView.setAdapter(new ArrayWheelAdapter<String>(this.years));
                yearView.setCurrentItem(this.selectedYearIndex);
                yearView.setDividerType(LineConfig.DividerType.FILL);
                yearView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                yearView.setOnItemPickListener(new OnItemPickListener<String>(){

                    @Override
                    public void onItemPicked(int index, String item) {
                        DateTimePicker.this.selectedYearIndex = index;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onYearWheeled(DateTimePicker.this.selectedYearIndex, item);
                        }
                        if (!DateTimePicker.this.canLinkage) {
                            return;
                        }
                        LogUtils.verbose(this, "change months after year wheeled");
                        DateTimePicker.this.selectedMonthIndex = 0;
                        DateTimePicker.this.selectedDayIndex = 0;
                        int selectedYear = DateUtils.trimZero(item);
                        DateTimePicker.this.changeMonthData(selectedYear);
                        monthView.setAdapter(new ArrayWheelAdapter(DateTimePicker.this.months));
                        monthView.setCurrentItem(DateTimePicker.this.selectedMonthIndex);
                        DateTimePicker.this.changeDayData(selectedYear, DateUtils.trimZero((String)DateTimePicker.this.months.get(DateTimePicker.this.selectedMonthIndex)));
                        dayView.setAdapter(new ArrayWheelAdapter(DateTimePicker.this.days));
                        dayView.setCurrentItem(DateTimePicker.this.selectedDayIndex);
                    }
                });
                layout.addView((View)yearView);
                if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setText((CharSequence)this.yearLabel);
                    layout.addView((View)labelView);
                }
            }
            if (this.dateMode != -1) {
                monthView.setCanLoop(this.canLoop);
                monthView.setTextSize(this.textSize);
                monthView.setSelectedTextColor(this.textColorFocus);
                monthView.setUnSelectedTextColor(this.textColorNormal);
                monthView.setAdapter(new ArrayWheelAdapter<String>(this.months));
                monthView.setLineConfig(this.lineConfig);
                monthView.setCurrentItem(this.selectedMonthIndex);
                monthView.setDividerType(LineConfig.DividerType.FILL);
                monthView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                monthView.setOnItemPickListener(new OnItemPickListener<String>(){

                    @Override
                    public void onItemPicked(int index, String item) {
                        DateTimePicker.this.selectedMonthIndex = index;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onMonthWheeled(DateTimePicker.this.selectedMonthIndex, item);
                        }
                        if (DateTimePicker.this.dateMode == 0 || DateTimePicker.this.dateMode == 2) {
                            LogUtils.verbose(this, "change days after month wheeled");
                            DateTimePicker.this.selectedDayIndex = 0;
                            int selectedYear = DateTimePicker.this.dateMode == 0 ? DateUtils.trimZero(DateTimePicker.this.getSelectedYear()) : Calendar.getInstance(Locale.CHINA).get(1);
                            DateTimePicker.this.changeDayData(selectedYear, DateUtils.trimZero(item));
                            dayView.setAdapter(new ArrayWheelAdapter(DateTimePicker.this.days));
                            dayView.setCurrentItem(DateTimePicker.this.selectedDayIndex);
                        }
                    }
                });
                layout.addView((View)monthView);
                if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setText((CharSequence)this.monthLabel);
                    layout.addView((View)labelView);
                }
            }
            if (this.dateMode == 0 || this.dateMode == 2) {
                dayView.setCanLoop(this.canLoop);
                dayView.setTextSize(this.textSize);
                dayView.setSelectedTextColor(this.textColorFocus);
                dayView.setUnSelectedTextColor(this.textColorNormal);
                dayView.setAdapter(new ArrayWheelAdapter<String>(this.days));
                dayView.setCurrentItem(this.selectedDayIndex);
                dayView.setLineConfig(this.lineConfig);
                dayView.setDividerType(LineConfig.DividerType.FILL);
                dayView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                dayView.setOnItemPickListener(new OnItemPickListener<String>(){

                    @Override
                    public void onItemPicked(int index, String item) {
                        DateTimePicker.this.selectedDayIndex = index;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onDayWheeled(index, item);
                        }
                    }
                });
                layout.addView((View)dayView);
                if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setText((CharSequence)this.dayLabel);
                    layout.addView((View)labelView);
                }
            }
            if (this.timeMode != -1) {
                hourView.setCanLoop(this.canLoop);
                hourView.setTextSize(this.textSize);
                hourView.setSelectedTextColor(this.textColorFocus);
                hourView.setUnSelectedTextColor(this.textColorNormal);
                hourView.setDividerType(LineConfig.DividerType.FILL);
                hourView.setAdapter(new ArrayWheelAdapter<String>(this.hours));
                hourView.setCurrentItem(this.selectedHourIndex);
                hourView.setLineConfig(this.lineConfig);
                hourView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                hourView.setOnItemPickListener(new OnItemPickListener<String>(){

                    @Override
                    public void onItemPicked(int index, String item) {
                        DateTimePicker.this.selectedHourIndex = index;
                        DateTimePicker.this.selectedMinuteIndex = 0;
                        DateTimePicker.this.selectedHour = item;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onHourWheeled(index, item);
                        }
                        if (!DateTimePicker.this.canLinkage) {
                            return;
                        }
                        DateTimePicker.this.changeMinuteData(DateUtils.trimZero(item));
                        minuteView.setAdapter(new ArrayWheelAdapter(DateTimePicker.this.minutes));
                        minuteView.setCurrentItem(DateTimePicker.this.selectedMinuteIndex);
                    }
                });
                layout.addView((View)hourView);
                if (!TextUtils.isEmpty((CharSequence)this.hourLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setText((CharSequence)this.hourLabel);
                    layout.addView((View)labelView);
                }
                minuteView.setCanLoop(this.canLoop);
                minuteView.setTextSize(this.textSize);
                minuteView.setSelectedTextColor(this.textColorFocus);
                minuteView.setUnSelectedTextColor(this.textColorNormal);
                minuteView.setAdapter(new ArrayWheelAdapter<String>(this.minutes));
                minuteView.setCurrentItem(this.selectedMinuteIndex);
                minuteView.setDividerType(LineConfig.DividerType.FILL);
                minuteView.setLineConfig(this.lineConfig);
                minuteView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                layout.addView((View)minuteView);
                minuteView.setOnItemPickListener(new OnItemPickListener<String>(){

                    @Override
                    public void onItemPicked(int index, String item) {
                        DateTimePicker.this.selectedMinuteIndex = index;
                        DateTimePicker.this.selectedMinute = item;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onMinuteWheeled(index, item);
                        }
                    }
                });
                if (!TextUtils.isEmpty((CharSequence)this.minuteLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setText((CharSequence)this.minuteLabel);
                    layout.addView((View)labelView);
                }
            }
        } else {
            TextView labelView;
            WheelListView yearView = new WheelListView((Context)this.activity);
            final WheelListView monthView = new WheelListView((Context)this.activity);
            final WheelListView dayView = new WheelListView((Context)this.activity);
            WheelListView hourView = new WheelListView((Context)this.activity);
            final WheelListView minuteView = new WheelListView((Context)this.activity);
            if (this.dateMode == 0 || this.dateMode == 1) {
                yearView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                yearView.setTextSize(this.textSize);
                yearView.setSelectedTextColor(this.textColorFocus);
                yearView.setUnSelectedTextColor(this.textColorNormal);
                yearView.setLineConfig(this.lineConfig);
                yearView.setOffset(this.offset);
                yearView.setCanLoop(this.canLoop);
                yearView.setItems(this.years, this.selectedYearIndex);
                yearView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                    @Override
                    public void onItemSelected(int index, String item) {
                        DateTimePicker.this.selectedYearIndex = index;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onYearWheeled(DateTimePicker.this.selectedYearIndex, item);
                        }
                        if (!DateTimePicker.this.canLinkage) {
                            return;
                        }
                        DateTimePicker.this.selectedMonthIndex = 0;
                        DateTimePicker.this.selectedDayIndex = 0;
                        int selectedYear = DateUtils.trimZero(item);
                        DateTimePicker.this.changeMonthData(selectedYear);
                        monthView.setItems((List<String>)DateTimePicker.this.months, DateTimePicker.this.selectedMonthIndex);
                        DateTimePicker.this.changeDayData(selectedYear, DateUtils.trimZero((String)DateTimePicker.this.months.get(DateTimePicker.this.selectedMonthIndex)));
                        dayView.setItems((List<String>)DateTimePicker.this.days, DateTimePicker.this.selectedDayIndex);
                    }
                });
                layout.addView((View)yearView);
                if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setText((CharSequence)this.yearLabel);
                    layout.addView((View)labelView);
                }
            }
            if (this.dateMode != -1) {
                monthView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                monthView.setTextSize(this.textSize);
                monthView.setSelectedTextColor(this.textColorFocus);
                monthView.setUnSelectedTextColor(this.textColorNormal);
                monthView.setLineConfig(this.lineConfig);
                monthView.setOffset(this.offset);
                monthView.setCanLoop(this.canLoop);
                monthView.setItems(this.months, this.selectedMonthIndex);
                monthView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                    @Override
                    public void onItemSelected(int index, String item) {
                        DateTimePicker.this.selectedMonthIndex = index;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onMonthWheeled(DateTimePicker.this.selectedMonthIndex, item);
                        }
                        if (DateTimePicker.this.dateMode == 0 || DateTimePicker.this.dateMode == 2) {
                            LogUtils.verbose(this, "change days after month wheeled");
                            DateTimePicker.this.selectedDayIndex = 0;
                            int selectedYear = DateTimePicker.this.dateMode == 0 ? DateUtils.trimZero(DateTimePicker.this.getSelectedYear()) : Calendar.getInstance(Locale.CHINA).get(1);
                            DateTimePicker.this.changeDayData(selectedYear, DateUtils.trimZero(item));
                            dayView.setItems((List<String>)DateTimePicker.this.days, DateTimePicker.this.selectedDayIndex);
                        }
                    }
                });
                layout.addView((View)monthView);
                if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setText((CharSequence)this.monthLabel);
                    layout.addView((View)labelView);
                }
            }
            if (this.dateMode == 0 || this.dateMode == 2) {
                dayView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                dayView.setTextSize(this.textSize);
                dayView.setSelectedTextColor(this.textColorFocus);
                dayView.setUnSelectedTextColor(this.textColorNormal);
                dayView.setLineConfig(this.lineConfig);
                dayView.setOffset(this.offset);
                dayView.setCanLoop(this.canLoop);
                dayView.setItems(this.days, this.selectedDayIndex);
                dayView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                    @Override
                    public void onItemSelected(int index, String item) {
                        DateTimePicker.this.selectedDayIndex = index;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onDayWheeled(DateTimePicker.this.selectedDayIndex, item);
                        }
                    }
                });
                layout.addView((View)dayView);
                if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setText((CharSequence)this.dayLabel);
                    layout.addView((View)labelView);
                }
            }
            if (this.timeMode != -1) {
                hourView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                hourView.setTextSize(this.textSize);
                hourView.setSelectedTextColor(this.textColorFocus);
                hourView.setUnSelectedTextColor(this.textColorNormal);
                hourView.setLineConfig(this.lineConfig);
                hourView.setCanLoop(this.canLoop);
                hourView.setItems(this.hours, this.selectedHour);
                hourView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                    @Override
                    public void onItemSelected(int index, String item) {
                        DateTimePicker.this.selectedHourIndex = index;
                        DateTimePicker.this.selectedMinuteIndex = 0;
                        DateTimePicker.this.selectedHour = item;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onHourWheeled(index, item);
                        }
                        if (!DateTimePicker.this.canLinkage) {
                            return;
                        }
                        DateTimePicker.this.changeMinuteData(DateUtils.trimZero(item));
                        minuteView.setItems((List<String>)DateTimePicker.this.minutes, DateTimePicker.this.selectedMinuteIndex);
                    }
                });
                layout.addView((View)hourView);
                if (!TextUtils.isEmpty((CharSequence)this.hourLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setText((CharSequence)this.hourLabel);
                    layout.addView((View)labelView);
                }
                minuteView.setLayoutParams((ViewGroup.LayoutParams)wheelViewParams);
                minuteView.setTextSize(this.textSize);
                minuteView.setSelectedTextColor(this.textColorFocus);
                minuteView.setUnSelectedTextColor(this.textColorNormal);
                minuteView.setLineConfig(this.lineConfig);
                minuteView.setOffset(this.offset);
                minuteView.setCanLoop(this.canLoop);
                minuteView.setItems(this.minutes, this.selectedMinute);
                minuteView.setOnWheelChangeListener(new WheelListView.OnWheelChangeListener(){

                    @Override
                    public void onItemSelected(int index, String item) {
                        DateTimePicker.this.selectedMinuteIndex = index;
                        DateTimePicker.this.selectedMinute = item;
                        if (DateTimePicker.this.onWheelListener != null) {
                            DateTimePicker.this.onWheelListener.onMinuteWheeled(index, item);
                        }
                    }
                });
                layout.addView((View)minuteView);
                if (!TextUtils.isEmpty((CharSequence)this.minuteLabel)) {
                    labelView = new TextView((Context)this.activity);
                    labelView.setLayoutParams((ViewGroup.LayoutParams)labelViewParams);
                    labelView.setTextSize((float)this.textSize);
                    labelView.setTextColor(this.textColorFocus);
                    labelView.setText((CharSequence)this.minuteLabel);
                    layout.addView((View)labelView);
                }
            }
        }
        return layout;
    }

    @Override
    protected void onSubmit() {
        if (this.onDateTimePickListener == null) {
            return;
        }
        String year = this.getSelectedYear();
        String month = this.getSelectedMonth();
        String day = this.getSelectedDay();
        String hour = this.getSelectedHour();
        String minute = this.getSelectedMinute();
        switch (this.dateMode) {
            case 0: {
                ((OnYearMonthDayTimePickListener)this.onDateTimePickListener).onDateTimePicked(year, month, day, hour, minute);
                break;
            }
            case 1: {
                ((OnYearMonthTimePickListener)this.onDateTimePickListener).onDateTimePicked(year, month, hour, minute);
                break;
            }
            case 2: {
                ((OnMonthDayTimePickListener)this.onDateTimePickListener).onDateTimePicked(month, day, hour, minute);
                break;
            }
            case -1: {
                ((OnTimePickListener)this.onDateTimePickListener).onDateTimePicked(hour, minute);
            }
        }
    }

    private int findItemIndex(ArrayList<String> items, int item) {
        int index = Collections.binarySearch(items, item, new Comparator<Object>(){

            @Override
            public int compare(Object lhs, Object rhs) {
                String lhsStr = lhs.toString();
                String rhsStr = rhs.toString();
                lhsStr = lhsStr.startsWith("0") ? lhsStr.substring(1) : lhsStr;
                rhsStr = rhsStr.startsWith("0") ? rhsStr.substring(1) : rhsStr;
                return Integer.parseInt(lhsStr) - Integer.parseInt(rhsStr);
            }
        });
        if (index < 0) {
            throw new IllegalArgumentException("Item[" + item + "] out of range");
        }
        return index;
    }

    private void initYearData() {
        this.years.clear();
        if (this.startYear == this.endYear) {
            this.years.add(String.valueOf(this.startYear));
        } else if (this.startYear < this.endYear) {
            for (int i = this.startYear; i <= this.endYear; ++i) {
                this.years.add(String.valueOf(i));
            }
        } else {
            for (int i = this.startYear; i >= this.endYear; --i) {
                this.years.add(String.valueOf(i));
            }
        }
    }

    private void changeMonthData(int selectedYear) {
        this.months.clear();
        if (this.startMonth < 1 || this.endMonth < 1 || this.startMonth > 12 || this.endMonth > 12) {
            throw new IllegalArgumentException("Month out of range [1-12]");
        }
        if (this.startYear == this.endYear) {
            if (this.startMonth > this.endMonth) {
                for (int i = this.endMonth; i >= this.startMonth; --i) {
                    this.months.add(DateUtils.fillZero(i));
                }
            } else {
                for (int i = this.startMonth; i <= this.endMonth; ++i) {
                    this.months.add(DateUtils.fillZero(i));
                }
            }
        } else if (selectedYear == this.startYear) {
            for (int i = this.startMonth; i <= 12; ++i) {
                this.months.add(DateUtils.fillZero(i));
            }
        } else if (selectedYear == this.endYear) {
            for (int i = 1; i <= this.endMonth; ++i) {
                this.months.add(DateUtils.fillZero(i));
            }
        } else {
            for (int i = 1; i <= 12; ++i) {
                this.months.add(DateUtils.fillZero(i));
            }
        }
    }

    private void changeDayData(int selectedYear, int selectedMonth) {
        int maxDays = DateUtils.calculateDaysInMonth(selectedYear, selectedMonth);
        this.days.clear();
        if (selectedYear == this.startYear && selectedMonth == this.startMonth && selectedYear == this.endYear && selectedMonth == this.endMonth) {
            for (int i = this.startDay; i <= this.endDay; ++i) {
                this.days.add(DateUtils.fillZero(i));
            }
        } else if (selectedYear == this.startYear && selectedMonth == this.startMonth) {
            for (int i = this.startDay; i <= maxDays; ++i) {
                this.days.add(DateUtils.fillZero(i));
            }
        } else if (selectedYear == this.endYear && selectedMonth == this.endMonth) {
            for (int i = 1; i <= this.endDay; ++i) {
                this.days.add(DateUtils.fillZero(i));
            }
        } else {
            for (int i = 1; i <= maxDays; ++i) {
                this.days.add(DateUtils.fillZero(i));
            }
        }
    }

    private void initHourData() {
        for (int i = this.startHour; i <= this.endHour; i += this.stepHour) {
            String hour = DateUtils.fillZero(i);
            this.hours.add(hour);
        }
        if (this.hours.indexOf(this.selectedHour) == -1) {
            this.selectedHour = this.hours.get(0);
        }
    }

    private void changeMinuteData(int selectedHour) {
        if (this.startHour == this.endHour) {
            if (this.startMinute > this.endMinute) {
                int temp = this.startMinute;
                this.startMinute = this.endMinute;
                this.endMinute = temp;
            }
            for (int i = this.startMinute; i <= this.endMinute; i += this.stepMinute) {
                this.minutes.add(DateUtils.fillZero(i));
            }
        } else if (selectedHour == this.startHour) {
            for (int i = this.startMinute; i <= 59; i += this.stepMinute) {
                this.minutes.add(DateUtils.fillZero(i));
            }
        } else if (selectedHour == this.endHour) {
            for (int i = 0; i <= this.endMinute; i += this.stepMinute) {
                this.minutes.add(DateUtils.fillZero(i));
            }
        } else {
            for (int i = 0; i <= 59; i += this.stepMinute) {
                this.minutes.add(DateUtils.fillZero(i));
            }
        }
        if (this.minutes.indexOf(this.selectedMinute) == -1) {
            this.selectedMinute = this.minutes.get(0);
        }
    }

    public static interface OnTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2);
    }

    public static interface OnMonthDayTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4);
    }

    public static interface OnYearMonthTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4);
    }

    public static interface OnYearMonthDayTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4, String var5);
    }

    protected static interface OnDateTimePickListener {
    }

    public static interface OnWheelListener {
        public void onYearWheeled(int var1, String var2);

        public void onMonthWheeled(int var1, String var2);

        public void onDayWheeled(int var1, String var2);

        public void onHourWheeled(int var1, String var2);

        public void onMinuteWheeled(int var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimeMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DateMode {
    }
}

